package ai.systema.constants

import kotlin.time.Duration
import kotlin.time.ExperimentalTime

public object SystemaConstants {
    public const val Version: String = "0.1.0-alpha2"
    public const val UserAgentName: String = "Systema SDK/${SystemaConstants.Version}"
    public const val MaxKeyLen: Int = 256
    public const val SystemaCacheFileName: String = "systema.json"
    public const val SystemaTagMapping: String = "TAG_MAPPING"

    @OptIn(ExperimentalTime::class)
    public val MaxSessionDuration: Duration = Duration.hours(2)
}