package ai.systema.connection.internal

import ai.systema.configuration.Credentials
import ai.systema.connection.RequestOptions
import ai.systema.enums.EnvironmentType
import ai.systema.model.APIKey
import ai.systema.model.ClientID
import ai.systema.serialize.Keys
import io.ktor.client.request.*

internal fun HttpRequestBuilder.setCredentials(credentials: Credentials?) {
    setClientId(credentials?.clientID)
    setApiKey(credentials?.apiKey)
    setEnvironment(credentials?.environment)
}

internal fun HttpRequestBuilder.setClientId(clientID: ClientID?) {
    header(Keys.SystemaClientID, clientID?.raw)
}

internal fun HttpRequestBuilder.setApiKey(apiKey: APIKey?) {
    header(Keys.SystemaAPIKey, apiKey?.raw)
}

internal fun HttpRequestBuilder.setEnvironment(env: EnvironmentType?) {
    header(Keys.SystemaEnvironment, env?.value)
}

internal fun HttpRequestBuilder.setRequestOptions(requestOptions: RequestOptions?) {
    requestOptions?.headers?.forEach { header(it.key, it.value) }
    requestOptions?.urlParameters?.forEach { parameter(it.key, it.value) }
    requestOptions?.body?.let { body = it }
}
