package ai.systema.configuration

import ai.systema.enums.CallType
import io.ktor.http.*
import kotlinx.datetime.Clock

/**
 * @param url The url to target.
 * @param callType Whether this host should be used for [CallType.Read] or [CallType.Write] requests.
 */
public data class RetryableHost(
    val url: Url,
    val callType: CallType = CallType.Read
) {

    internal var isUp: Boolean = true
    internal var lastUpdated: Long = Clock.System.now().toEpochMilliseconds() //Time.getCurrentTimeMillis()
    internal var retryCount: Int = 0
}
