package ai.systema.client.internal

import ai.systema.client.*
import ai.systema.configuration.Configuration
import ai.systema.configuration.Credentials
import ai.systema.connection.internal.Connector

internal open class SystemaImpl(
    internal val connector: Connector,
    override val meta: Map<String, Any>,
) : SystemaAI,
    Configuration by connector,
    Credentials by connector.credentials,
    Tracker by Tracker(connector),
    Recommender by Recommender(connector),
    SmartSearch by SmartSearch(connector),
    SmartSuggest by SmartSuggest(connector) {

    override suspend fun initialize() {
        connector.initialize()
    }

}