package ai.systema.client

import ai.systema.client.internal.TrackerImpl
import ai.systema.connection.internal.Connector
import ai.systema.endpoint.EndpointTracker
import ai.systema.model.tracker.cart.CartItem
import ai.systema.model.tracker.cart.OrderItem
import ai.systema.model.tracker.cart.PurchaseOrder
import ai.systema.model.tracker.view.ItemContainer
import ai.systema.model.tracker.wishlist.WishlistItem
import io.ktor.client.statement.*

public interface Tracker {
    public suspend fun trackPageViewed(
        productId: String,
        url: String = "",
        recId: String = "",
        referrer: String = ""
    ): HttpResponse

    public suspend fun trackItemClicked(
        productId: String,
        url: String = "",
        recId: String = "",
        referrer: String = ""
    ): HttpResponse

    public suspend fun trackContainerShown(
        containers: List<ItemContainer>,
        url: String? = "",
        referrer: String? = ""
    ): HttpResponse

    public suspend fun trackItemAcquired(
        items: List<CartItem>,
        url: String,
        referrer: String? = ""
    ): HttpResponse

    public suspend fun trackItemRelinquished(
        item: CartItem,
        url: String,
        referrer: String? = ""
    ): HttpResponse

    public suspend fun trackAcquisitionComplete(
        order: PurchaseOrder,
        url: String,
        referrer: String? = ""
    ): HttpResponse

    public suspend fun trackWishlistAcquired(
        items: List<WishlistItem>,
        url: String,
        referrer: String? = ""
    ): HttpResponse

    public suspend fun trackWishlistRelinquished(
        item: WishlistItem,
        url: String,
        referrer: String? = ""
    ): HttpResponse
}

internal fun Tracker(
    connector: Connector
): Tracker = TrackerImpl(
    connector,
    EndpointTracker(connector)
)
