package ai.systema.android.listener

import ai.systema.client.SystemaAI
import android.view.View


public class SystemaOnClickListener(
    private val systema: SystemaAI,
    private val tagMapping: Map<String, Int>,
) : View.OnClickListener {

    private val clickListeners: MutableList<View.OnClickListener> = mutableListOf(
        SystemaEventListener(systema, tagMapping)
    )

    public fun addOnClickListener(listener: View.OnClickListener?): SystemaOnClickListener {
        if (listener != null) {
            clickListeners.add(listener)
        }

        return this
    }

    override fun onClick(v: View?) {
        for (listener in clickListeners) {
            listener.onClick(v)
        }
    }
}

