/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphql.graphqlJava.graphQlSchemaGenerator;

import ai.stapi.graphql.graphqlJava.graphQlSchemaGenerator.GraphQlFilterInputGenerator;
import ai.stapi.graphql.graphqlJava.graphQlSchemaGenerator.GraphQlJavaSchemaGenerator;
import ai.stapi.graphql.graphqlJava.graphQlSchemaGenerator.GraphQlSortInputGenerator;
import ai.stapi.schema.structureSchema.AbstractStructureType;
import ai.stapi.schema.structureSchema.ComplexStructureType;
import ai.stapi.schema.structureSchema.FieldDefinition;
import ai.stapi.schema.structureSchema.FieldType;
import ai.stapi.schema.structureSchema.PrimitiveStructureType;
import ai.stapi.schema.structureSchema.StructureSchema;
import graphql.Scalars;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLUnionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class GraphQlObjectTypeGenerator {
    public static final Integer THE_ANSWER_TO_THE_ULTIMATE_QUESTION_OF_LIFE_THE_UNIVERSE_AND_EVERYTHING = 42;
    protected static final Map<String, GraphQLType> FIELD_TYPE_SPECIAL_CASES = Map.of("string", Scalars.GraphQLString, "boolean", Scalars.GraphQLBoolean, "id", Scalars.GraphQLID, "integer", Scalars.GraphQLInt, "decimal", Scalars.GraphQLFloat);
    private final GraphQlSortInputGenerator graphQLSortInputGenerator;
    private final GraphQlFilterInputGenerator graphQlFilterInputGenerator;

    public GraphQlObjectTypeGenerator(GraphQlSortInputGenerator graphQLSortInputGenerator, GraphQlFilterInputGenerator graphQlFilterInputGenerator) {
        this.graphQLSortInputGenerator = graphQLSortInputGenerator;
        this.graphQlFilterInputGenerator = graphQlFilterInputGenerator;
    }

    protected List<GraphQLType> generateObjectType(AbstractStructureType structureType, StructureSchema structureSchema, Map<String, GraphQLInputObjectType> sortInputTypes, Map<String, GraphQLInputObjectType> filterInputTypes) {
        FieldsInterfacesSubtypes fieldsInterfacesAndSubTypes = this.createFieldsInterfacesAndSubTypes(structureType, structureSchema, sortInputTypes, filterInputTypes);
        String name = structureType.getDefinitionType();
        if (structureType.isAbstract()) {
            GraphQLInterfaceType.Builder builder = new GraphQLInterfaceType.Builder().name(name).description(structureType.getDescription().replace("\r", "").replace("\n+", "\n")).typeResolver(env -> null);
            fieldsInterfacesAndSubTypes.fields().forEach(arg_0 -> ((GraphQLInterfaceType.Builder)builder).field(arg_0));
            fieldsInterfacesAndSubTypes.interfaces().forEach(interfaceType -> builder.withInterface((GraphQLTypeReference)interfaceType));
            ArrayList<GraphQLType> finalTypes = new ArrayList<GraphQLType>();
            finalTypes.add((GraphQLType)builder.build());
            finalTypes.addAll(fieldsInterfacesAndSubTypes.subtypes);
            return finalTypes;
        }
        GraphQLObjectType.Builder builder = new GraphQLObjectType.Builder().name(name).description(structureType.getDescription());
        fieldsInterfacesAndSubTypes.fields().forEach(arg_0 -> ((GraphQLObjectType.Builder)builder).field(arg_0));
        fieldsInterfacesAndSubTypes.interfaces().forEach(interfaceType -> builder.withInterface((GraphQLTypeReference)interfaceType));
        ArrayList<GraphQLType> finalTypes = new ArrayList<GraphQLType>();
        finalTypes.add((GraphQLType)builder.build());
        finalTypes.addAll(fieldsInterfacesAndSubTypes.subtypes);
        return finalTypes;
    }

    protected FieldsInterfacesSubtypes createFieldsInterfacesAndSubTypes(AbstractStructureType structureType, StructureSchema structureSchema, Map<String, GraphQLInputObjectType> sortInputTypes, Map<String, GraphQLInputObjectType> filterInputTypes) {
        ArrayList<GraphQLFieldDefinition.Builder> graphQlFields = new ArrayList<GraphQLFieldDefinition.Builder>();
        List<GraphQLType> interfaces = this.createInterfaces(structureType, structureSchema);
        ArrayList<GraphQLType> subtypes = new ArrayList<GraphQLType>();
        Map fields = new HashMap();
        if (structureType instanceof ComplexStructureType) {
            ComplexStructureType complexStructureType = (ComplexStructureType)structureType;
            fields = complexStructureType.getAllFields();
        }
        fields.values().forEach(definition -> {
            FieldAndSubtypes fieldAndSubtypes = this.createFieldAndSubtypes((FieldDefinition)definition, structureType, structureSchema, sortInputTypes, filterInputTypes);
            graphQlFields.add(fieldAndSubtypes.field());
            subtypes.addAll(fieldAndSubtypes.subtypes());
        });
        return new FieldsInterfacesSubtypes(graphQlFields, interfaces, subtypes);
    }

    private List<GraphQLType> createInterfaces(AbstractStructureType structureType, StructureSchema structureSchema) {
        ComplexStructureType complexStructureType;
        ArrayList<GraphQLType> interfaces = new ArrayList<GraphQLType>();
        if (structureType instanceof ComplexStructureType && !(complexStructureType = (ComplexStructureType)structureType).getParent().isBlank()) {
            AbstractStructureType parentStructureType = structureSchema.getDefinition(complexStructureType.getParent());
            if (parentStructureType.isAbstract()) {
                interfaces.add((GraphQLType)new GraphQLTypeReference(parentStructureType.getDefinitionType()));
            }
            List<GraphQLType> restOfInterfaces = this.createInterfaces(parentStructureType, structureSchema);
            interfaces.addAll(restOfInterfaces);
        }
        return interfaces;
    }

    private FieldAndSubtypes createFieldAndSubtypes(FieldDefinition fieldDefinition, AbstractStructureType structureType, StructureSchema structureSchema, Map<String, GraphQLInputObjectType> sortInputTypes, Map<String, GraphQLInputObjectType> filterInputTypes) {
        Object typeName;
        GraphQLTypeReference type;
        List<String> types = fieldDefinition.getTypes().stream().map(FieldType::getType).toList();
        ArrayList<GraphQLType> subtypes = new ArrayList<GraphQLType>();
        if (types.isEmpty() || types.size() > THE_ANSWER_TO_THE_ULTIMATE_QUESTION_OF_LIFE_THE_UNIVERSE_AND_EVERYTHING) {
            type = new GraphQLTypeReference("AnyNode");
            typeName = "AnyNode";
        } else if (types.size() == 1) {
            typeName = types.get(0);
            type = FIELD_TYPE_SPECIAL_CASES.getOrDefault(typeName, (GraphQLType)new GraphQLTypeReference((String)typeName));
        } else {
            typeName = structureType.getDefinitionType() + StringUtils.capitalize((String)fieldDefinition.getName());
            type = new GraphQLTypeReference((String)typeName);
            GraphQLUnionType.Builder unionTypeBuilder = new GraphQLUnionType.Builder().name((String)typeName).description("Type for union type field contained in " + structureType.getDefinitionType()).typeResolver(env -> null);
            List<String> allObjectTypes = this.getAllConcreteTypes(types, structureSchema);
            allObjectTypes.forEach(typeInUnion -> unionTypeBuilder.possibleType(new GraphQLTypeReference(typeInUnion)));
            subtypes.add((GraphQLType)unionTypeBuilder.build());
        }
        AbstractStructureType typeStructureDefinition = structureSchema.getDefinition((String)typeName);
        if (type instanceof GraphQLScalarType || typeStructureDefinition instanceof PrimitiveStructureType) {
            return new FieldAndSubtypes(this.createField(fieldDefinition, fieldDefinition.getName(), (GraphQLType)type, (String)typeName, sortInputTypes, filterInputTypes, true), subtypes);
        }
        return new FieldAndSubtypes(this.createField(fieldDefinition, fieldDefinition.getName(), (GraphQLType)type, (String)typeName, sortInputTypes, filterInputTypes, false), subtypes);
    }

    private List<String> getAllConcreteTypes(List<String> types, StructureSchema structureSchema) {
        return types.stream().map(type -> this.getConcreteTypes((String)type, structureSchema)).flatMap(Collection::stream).collect(Collectors.toSet()).stream().toList();
    }

    private List<String> getConcreteTypes(String type, StructureSchema structureSchema) {
        AbstractStructureType structureType = structureSchema.getDefinition(type);
        if (!structureType.isAbstract()) {
            return List.of(type);
        }
        List children = structureSchema.getChildDefinitions(type);
        List<String> childTypes = children.stream().map(AbstractStructureType::getDefinitionType).toList();
        return this.getAllConcreteTypes(childTypes, structureSchema);
    }

    private GraphQLFieldDefinition.Builder createField(FieldDefinition fieldDefinition, String fieldName, GraphQLType graphQLType, String typeName, Map<String, GraphQLInputObjectType> sortInputTypes, Map<String, GraphQLInputObjectType> filterInputTypes, boolean isScalar) {
        if (fieldDefinition.getMax().equals("*") || Integer.parseInt(fieldDefinition.getMax()) > 1) {
            graphQLType = GraphQLNonNull.nonNull((GraphQLType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)graphQLType)));
        } else if (fieldDefinition.getMin() == 1) {
            graphQLType = GraphQLNonNull.nonNull((GraphQLType)graphQLType);
        }
        GraphQLFieldDefinition.Builder elementBuilder = GraphQLFieldDefinition.newFieldDefinition().name(fieldName).type((GraphQLOutputType)graphQLType);
        if (!fieldDefinition.getMax().equals("1")) {
            GraphQLInputObjectType sortInputType = sortInputTypes.get(this.graphQLSortInputGenerator.createSortInputTypeName(typeName));
            GraphQLInputObjectType filterInputType = filterInputTypes.get(this.graphQlFilterInputGenerator.createLogicalFilterInputTypeName(typeName));
            if (sortInputType != null) {
                elementBuilder.argument(GraphQLArgument.newArgument().name("sort").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)sortInputType))));
            }
            if (filterInputType != null) {
                elementBuilder.argument(GraphQLArgument.newArgument().name("filter").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)filterInputType))));
            }
            if (!isScalar) {
                elementBuilder.argument(GraphQLArgument.newArgument().name("pagination").type((GraphQLInputType)GraphQlJavaSchemaGenerator.OFFSET_PAGINATION));
            }
        }
        if (fieldDefinition.getDescription() != null) {
            elementBuilder.description(fieldDefinition.getDescription().replace("\r", "").replace("\n+", "\n"));
        }
        return elementBuilder;
    }

    protected record FieldsInterfacesSubtypes(List<GraphQLFieldDefinition.Builder> fields, List<GraphQLType> interfaces, List<GraphQLType> subtypes) {
    }

    private record FieldAndSubtypes(GraphQLFieldDefinition.Builder field, List<GraphQLType> subtypes) {
    }
}

