/*
 * Decompiled with CFR 0.152.
 */
package ai.stapi.graphql.graphqlJava.graphQlSchemaGenerator;

import ai.stapi.graphql.graphqlJava.graphQlSchemaGenerator.GraphQlObjectTypeGenerator;
import ai.stapi.schema.structureSchema.AbstractStructureType;
import ai.stapi.schema.structureSchema.ComplexStructureType;
import ai.stapi.schema.structureSchema.FieldDefinition;
import ai.stapi.schema.structureSchema.FieldType;
import ai.stapi.schema.structureSchema.StructureSchema;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLTypeReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class GraphQlSortInputGenerator {
    protected static final GraphQLEnumType SORT_DIRECTION_ENUM = GraphQLEnumType.newEnum().name("SortDirection").value("ASC").value("DESC").build();

    public Map<String, GraphQLInputObjectType> generateSortInputs(StructureSchema structureSchema) {
        HashMap<String, GraphQLInputObjectType> sortInputTypeMap = new HashMap<String, GraphQLInputObjectType>();
        structureSchema.getStructureTypes().values().stream().filter(ComplexStructureType.class::isInstance).map(ComplexStructureType.class::cast).flatMap(definition -> this.generate((ComplexStructureType)definition, structureSchema).stream()).forEach(sortInput -> sortInputTypeMap.put(sortInput.getName(), (GraphQLInputObjectType)sortInput));
        return sortInputTypeMap;
    }

    private List<GraphQLInputObjectType> generate(ComplexStructureType structureType, StructureSchema structureSchema) {
        SortFieldsAndSubtypes fieldsAndSubTypes = this.createFieldsAndSubTypes(structureType, structureSchema);
        String name = structureType.getDefinitionType();
        ArrayList<GraphQLInputObjectType> types = new ArrayList<GraphQLInputObjectType>();
        GraphQLInputObjectType.Builder builder = new GraphQLInputObjectType.Builder().name(this.createSortInputTypeName(name));
        fieldsAndSubTypes.fields().forEach(arg_0 -> ((GraphQLInputObjectType.Builder)builder).field(arg_0));
        if (!fieldsAndSubTypes.fields().isEmpty()) {
            types.add(builder.build());
        }
        types.addAll(fieldsAndSubTypes.subtypes());
        return types;
    }

    private SortFieldsAndSubtypes createFieldsAndSubTypes(ComplexStructureType structureType, StructureSchema structureSchema) {
        ArrayList<GraphQLInputObjectField> fields = new ArrayList<GraphQLInputObjectField>();
        ArrayList<GraphQLInputObjectType> subtypes = new ArrayList<GraphQLInputObjectType>();
        structureType.getAllFields().values().forEach(fieldDefinition -> {
            SortFieldAndSubtypes fieldAndSubtypes = this.createFieldAndSubtypes((FieldDefinition)fieldDefinition, structureSchema);
            if (fieldAndSubtypes != null) {
                fields.add(fieldAndSubtypes.field());
                subtypes.addAll(fieldAndSubtypes.subtypes());
            }
        });
        return new SortFieldsAndSubtypes(fields, subtypes);
    }

    @Nullable
    private SortFieldAndSubtypes createFieldAndSubtypes(FieldDefinition fieldDefinition, StructureSchema structureSchema) {
        List<String> types = fieldDefinition.getTypes().stream().map(FieldType::getType).toList();
        ArrayList<GraphQLInputObjectType> subtypes = new ArrayList<GraphQLInputObjectType>();
        if (types.isEmpty()) {
            return new SortFieldAndSubtypes(GraphQLInputObjectField.newInputObjectField().name(fieldDefinition.getName()).type((GraphQLInputType)SORT_DIRECTION_ENUM).build(), subtypes);
        }
        int size = types.size();
        if (size > GraphQlObjectTypeGenerator.THE_ANSWER_TO_THE_ULTIMATE_QUESTION_OF_LIFE_THE_UNIVERSE_AND_EVERYTHING) {
            return new SortFieldAndSubtypes(GraphQLInputObjectField.newInputObjectField().name(fieldDefinition.getName()).type((GraphQLInputType)SORT_DIRECTION_ENUM).build(), subtypes);
        }
        List<AbstractStructureType> typeGraphDefinitions = types.stream().map(type -> {
            AbstractStructureType definition = structureSchema.getDefinition(type);
            if (definition == null) {
                throw new RuntimeException("Definition for type '" + type + "' does not exist in schema.");
            }
            return definition;
        }).toList();
        if (typeGraphDefinitions.stream().allMatch(definition -> definition.getKind().equals("primitive-type"))) {
            return new SortFieldAndSubtypes(GraphQLInputObjectField.newInputObjectField().name(fieldDefinition.getName()).type((GraphQLInputType)SORT_DIRECTION_ENUM).build(), subtypes);
        }
        if (size > 1) {
            return null;
        }
        String typeName = types.get(0);
        return new SortFieldAndSubtypes(GraphQLInputObjectField.newInputObjectField().name(fieldDefinition.getName()).type((GraphQLInputType)new GraphQLTypeReference(this.createSortInputTypeName(typeName))).build(), subtypes);
    }

    public String createSortInputTypeName(String originalTypeName) {
        return originalTypeName + "SortOption";
    }

    protected record SortFieldsAndSubtypes(List<GraphQLInputObjectField> fields, List<GraphQLInputObjectType> subtypes) {
    }

    protected record SortFieldAndSubtypes(GraphQLInputObjectField field, List<GraphQLInputObjectType> subtypes) {
    }
}

