/*
 * Decompiled with CFR 0.152.
 */
package ai.optfor.springopenaiapi.model;

import ai.optfor.springopenaiapi.enums.EmbedModel;
import ai.optfor.springopenaiapi.model.EmbeddingData;
import ai.optfor.springopenaiapi.model.Usage;
import io.micrometer.common.util.StringUtils;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.List;

public record EmbeddingResponse(String model, List<EmbeddingData> data, Usage usage) {
    public EmbeddingData getFirstCompletion() {
        return this.data.get(0);
    }

    public BigDecimal getCost() {
        int length = this.usage.total_tokens();
        if (StringUtils.isBlank((String)this.model)) {
            return BigDecimal.ZERO;
        }
        EmbedModel modelEnum = EmbedModel.apiValueOf(this.model);
        return this.computeCost(length, modelEnum.getCost());
    }

    private BigDecimal computeCost(int length, String costPer1000) {
        return new BigDecimal(costPer1000).multiply(new BigDecimal(length).divide(new BigDecimal(1000), MathContext.DECIMAL32));
    }
}

