/*
 * Decompiled with CFR 0.152.
 */
package ai.optfor.springopenaiapi.model;

import ai.optfor.springopenaiapi.model.EmbeddingData;
import ai.optfor.springopenaiapi.model.Usage;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.List;

public record EmbeddingResponse(String model, List<EmbeddingData> data, Usage usage) {
    public EmbeddingData getFirstCompletion() {
        return this.data.get(0);
    }

    public BigDecimal getCost() {
        int length = this.usage.total_tokens();
        if (this.model.startsWith("text-embedding-ada-002")) {
            return this.computeCost(length, "0.0001");
        }
        return null;
    }

    private BigDecimal computeCost(int promptLength, String costPer1000) {
        return new BigDecimal(costPer1000).multiply(new BigDecimal(promptLength).divide(new BigDecimal(1000), MathContext.DECIMAL32));
    }
}

