/*
 * Decompiled with CFR 0.152.
 */
package ai.kognition.pilecv4j.python;

import ai.kognition.pilecv4j.image.CvMat;
import ai.kognition.pilecv4j.python.PythonException;
import ai.kognition.pilecv4j.python.internal.PythonAPI;
import com.sun.jna.Pointer;
import java.nio.file.FileSystems;
import java.util.Map;
import net.dempsy.util.QuietCloseable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KogSys
implements QuietCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(KogSys.class);
    public ImageSource imageSource = null;
    private long nativeObj = 0L;
    private final PythonAPI.get_image_source callback = new PythonAPI.get_image_source(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long image_source(long ptRef) {
            KogSys kogSys = KogSys.this;
            synchronized (kogSys) {
                if (KogSys.this.imageSource == null) {
                    KogSys.this.imageSource = new ImageSource(PythonAPI.pilecv4j_python_makeImageSource(ptRef));
                }
                return KogSys.this.imageSource.imageSourceRef;
            }
        }
    };

    public KogSys() throws PythonException {
        this.nativeObj = PythonAPI.pilecv4j_python_initKogSys(this.callback);
        if (this.nativeObj == 0L) {
            throw new PythonException("Failed to instantiate native PyTorch instance.");
        }
    }

    public void runPythonFunction(String module, String function, Map<String, Object> kwds) throws PythonException {
        try (ParamCloser q = new ParamCloser(PythonAPI.pilecv4j_python_newParamDict());){
            long dict;
            if (kwds != null && kwds.size() > 0) {
                dict = q.dict;
                kwds.entrySet().forEach(e -> {
                    Object val = e.getValue();
                    if (val instanceof KogSys) {
                        KogSys.throwIfNecessary(PythonAPI.pilecv4j_python_putPytorchParamDict(dict, (String)e.getKey(), ((KogSys)val).nativeObj));
                        return;
                    } else if (val instanceof Boolean) {
                        KogSys.throwIfNecessary(PythonAPI.pilecv4j_python_putBooleanParamDict(dict, (String)e.getKey(), (Boolean)val != false ? 1 : 0));
                        return;
                    } else if (val instanceof Number) {
                        if (val instanceof Integer || val instanceof Byte || val instanceof Long) {
                            KogSys.throwIfNecessary(PythonAPI.pilecv4j_python_putIntParamDict(dict, (String)e.getKey(), ((Number)val).longValue()));
                            return;
                        } else {
                            if (!(val instanceof Float) && !(val instanceof Double)) throw new PythonException("Unknown number type:" + val.getClass().getName());
                            KogSys.throwIfNecessary(PythonAPI.pilecv4j_python_putFloatParamDict(dict, (String)e.getKey(), ((Number)val).doubleValue()));
                        }
                        return;
                    } else {
                        KogSys.throwIfNecessary(PythonAPI.pilecv4j_python_putStringParamDict(dict, (String)e.getKey(), val.toString()));
                    }
                });
            } else {
                dict = 0L;
            }
            int statusCode = PythonAPI.pilecv4j_python_runPythonFunction(module, function, dict);
            KogSys.throwIfNecessary(statusCode);
        }
    }

    public void addModulePath(String dir) {
        String absDir = FileSystems.getDefault().getPath(dir, new String[0]).normalize().toAbsolutePath().toString();
        PythonAPI.pilecv4j_python_addModulePath(absDir);
    }

    public KogMatResults sendMat(CvMat mat, boolean isRgb) {
        if (this.imageSource != null) {
            return this.imageSource.send(mat, isRgb);
        }
        throw new IllegalStateException("There's no current image source");
    }

    public void eos() {
        this.sendMat(null, false);
    }

    public boolean sourceIsInitialized() {
        return this.imageSource != null;
    }

    public void close() {
        if (this.imageSource != null) {
            this.imageSource.close();
        }
    }

    private static void throwIfNecessary(int status) throws PythonException {
        if (status != 0) {
            Pointer p = PythonAPI.pilecv4j_python_statusMessage(status);
            QuietCloseable qc = () -> PythonAPI.pilecv4j_python_freeStatusMessage(p);
            try {
                if (Pointer.nativeValue((Pointer)p) == 0L) {
                    throw new PythonException("Null status message. Status code:" + status);
                }
                String message = p.getString(0L);
                throw new PythonException(message);
            }
            catch (Throwable throwable) {
                if (qc != null) {
                    try {
                        qc.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    public int numModelLabels() {
        return PythonAPI.pilecv4j_python_kogSys_numModelLabels(this.nativeObj);
    }

    public String getModelLabel(int i) {
        Pointer ml = PythonAPI.pilecv4j_python_kogSys_modelLabel(this.nativeObj, i);
        if (Pointer.nativeValue((Pointer)ml) == 0L) {
            return null;
        }
        return ml.getString(0L);
    }

    static {
        int logLevelSet = LOGGER.isTraceEnabled() ? 0 : (LOGGER.isDebugEnabled() ? 1 : (LOGGER.isInfoEnabled() ? 2 : (LOGGER.isWarnEnabled() ? 3 : (LOGGER.isErrorEnabled() ? 4 : 5))));
        KogSys.throwIfNecessary(PythonAPI.pilecv4j_python_setLogLevel(logLevelSet));
        KogSys.throwIfNecessary(PythonAPI.pilecv4j_python_initPython());
    }

    public static class ImageSource
    implements QuietCloseable {
        private final long imageSourceRef;

        ImageSource(long imageSourceRef) {
            this.imageSourceRef = imageSourceRef;
        }

        public KogMatResults send(CvMat mat, boolean isRgb) {
            long result = mat != null ? PythonAPI.pilecv4j_python_imageSourceSend(this.imageSourceRef, mat.nativeObj, isRgb ? 1 : 0) : PythonAPI.pilecv4j_python_imageSourceSend(this.imageSourceRef, 0L, 0);
            return result == 0L ? null : new KogMatResults(result);
        }

        public long peek() {
            return PythonAPI.pilecv4j_python_imageSourcePeek(this.imageSourceRef);
        }

        public void close() {
            PythonAPI.pilecv4j_python_imageSourceClose(this.imageSourceRef);
        }
    }

    public static class KogMatResults
    implements QuietCloseable {
        private final long nativeObj;

        KogMatResults(long nativeObj) {
            this.nativeObj = nativeObj;
        }

        public CvMat getResultMat() {
            if (this.nativeObj != 0L) {
                long resRef = PythonAPI.pilecv4j_python_kogMatResults_getResults(this.nativeObj);
                if (resRef != 0L) {
                    return CvMat.wrapNative((long)resRef);
                }
                return null;
            }
            throw new NullPointerException("Illegal KogMatResults. Null underlying reference.");
        }

        public void close() {
            if (this.nativeObj != 0L) {
                PythonAPI.pilecv4j_python_kogMatResults_close(this.nativeObj);
            }
        }

        public boolean hasResult() {
            if (this.nativeObj != 0L) {
                return PythonAPI.pilecv4j_python_kogMatResults_hasResult(this.nativeObj) != 0;
            }
            throw new NullPointerException("Illegal KogMatResults. Null underlying reference.");
        }

        public boolean isAbandoned() {
            if (this.nativeObj != 0L) {
                return PythonAPI.pilecv4j_python_kogMatResults_isAbandoned(this.nativeObj) != 0;
            }
            throw new NullPointerException("Illegal KogMatResults. Null underlying reference.");
        }
    }

    private static class ParamCloser
    implements QuietCloseable {
        public final long dict;

        ParamCloser(long dict) {
            this.dict = dict;
        }

        public void close() {
            if (this.dict != 0L) {
                PythonAPI.pilecv4j_python_closeParamDict(this.dict);
            }
        }
    }
}

