/*
 * Decompiled with CFR 0.152.
 */
package ai.idylnlp.nlp.recognizer;

import ai.idylnlp.model.entity.Entity;
import ai.idylnlp.model.entity.Span;
import ai.idylnlp.model.exceptions.EntityFinderException;
import ai.idylnlp.model.nlp.ner.EntityExtractionRequest;
import ai.idylnlp.model.nlp.ner.EntityExtractionResponse;
import ai.idylnlp.model.nlp.ner.EntityRecognizer;
import ai.idylnlp.nlp.utils.ngrams.NgramUtils;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import com.neovisionaries.i18n.LanguageCode;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DictionaryEntityRecognizer
implements EntityRecognizer {
    private static final Logger LOGGER = LogManager.getLogger(DictionaryEntityRecognizer.class);
    private LanguageCode languageCode;
    private Set<String> dictionary;
    private String type;
    private double fpp = 0.1;
    private boolean caseSensitive;

    public DictionaryEntityRecognizer(LanguageCode languageCode, Set<String> dictionary, String type, double fpp, boolean caseSensitive) {
        this.languageCode = languageCode;
        this.dictionary = dictionary;
        this.type = type;
        this.fpp = fpp;
        this.caseSensitive = caseSensitive;
    }

    public DictionaryEntityRecognizer(LanguageCode languageCode, File dictionaryFile, String type, double fpp, boolean caseSensitive) throws IOException {
        this.languageCode = languageCode;
        this.type = type;
        this.fpp = fpp;
        this.caseSensitive = caseSensitive;
        try (BufferedReader br = Files.newBufferedReader(dictionaryFile.toPath(), StandardCharsets.UTF_8);){
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                if (!caseSensitive) {
                    this.dictionary.add(line.toLowerCase());
                    continue;
                }
                this.dictionary.add(line);
            }
        }
    }

    public EntityExtractionResponse extractEntities(EntityExtractionRequest request) throws EntityFinderException {
        LinkedHashSet<Entity> entities = new LinkedHashSet<Entity>();
        long startTime = System.currentTimeMillis();
        String[] tokens = request.getText();
        try {
            String[] ngrams;
            BloomFilter filter = BloomFilter.create((Funnel)Funnels.stringFunnel((Charset)Charset.defaultCharset()), (int)this.dictionary.size(), (double)this.fpp);
            for (String string : this.dictionary) {
                if (!this.caseSensitive) {
                    filter.put((Object)string.toLowerCase());
                    continue;
                }
                filter.put((Object)string);
            }
            for (String ngram : ngrams = NgramUtils.getNgrams((String[])tokens)) {
                boolean contains;
                boolean mightContain = !this.caseSensitive ? filter.mightContain((Object)ngram.toLowerCase()) : filter.mightContain((Object)ngram);
                if (!mightContain || !(contains = !this.caseSensitive ? this.dictionary.contains(ngram.toLowerCase()) : this.dictionary.contains(ngram))) continue;
                String[] d = ngram.split(" ");
                int start = Collections.indexOfSubList(Arrays.asList(ngrams), Arrays.asList(d));
                Entity entity = new Entity(ngram, 100.0, this.type, this.languageCode.getAlpha3().toString());
                entity.setSpan(new Span(start, start + d.length - 1));
                entity.setContext(request.getContext());
                entity.setExtractionDate(System.currentTimeMillis());
                LOGGER.debug("Found entity with text: {}", (Object)ngram);
                entities.add(entity);
            }
            long l = System.currentTimeMillis() - startTime;
            return new EntityExtractionResponse(entities, l, true);
        }
        catch (Exception ex) {
            LOGGER.error("Unable to find entities with the DictionaryEntityRecognizer.", (Throwable)ex);
            throw new EntityFinderException("Unable to find entities with the DictionaryEntityRecognizer.", ex);
        }
    }
}

