package ai.h2o.mojos.runtime.h2o3;

import ai.h2o.mojos.runtime.AbstractPipelineLoader;
import ai.h2o.mojos.runtime.MojoPipeline;
import ai.h2o.mojos.runtime.MojoPipelineMeta;
import ai.h2o.mojos.runtime.MojoPipelineProtoImpl;
import ai.h2o.mojos.runtime.api.MojoColumnMeta;
import ai.h2o.mojos.runtime.api.MojoTransformMeta;
import ai.h2o.mojos.runtime.api.PipelineConfig;
import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import ai.h2o.mojos.runtime.frame.MojoColumn;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.transforms.MojoTransform;
import ai.h2o.mojos.runtime.transforms.MojoTransformExecPipeBuilder;
import hex.genmodel.GenModel;
import hex.genmodel.MojoModel;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.easy.EasyPredictModelWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.joda.time.DateTime;

import static ai.h2o.mojos.runtime.h2o3.H2O3PipelineLoader.wrapModelForPrediction;

class KLimePipelineLoader extends AbstractPipelineLoader {
    private final List<MojoColumnMeta> globalColumns;
    private final MojoTransformExecPipeBuilder root;

    public KLimePipelineLoader(ReaderBackend backend, PipelineConfig config) throws IOException {
        super(backend, config);
        final MojoReaderBackend mojoReader = new H2O3BackendAdapter(backend);
        final MojoModel model = MojoModel.load(mojoReader);
        final EasyPredictModelWrapper easyPredictModelWrapper = wrapModelForPrediction(model);

        final String name = "klime:" + model.getModelCategory().toString();
        this.globalColumns = new ArrayList<>();
        final int[] inputIndices = readInputIndices(globalColumns, model);
        final int[] outputIndices = readOutputIndices(globalColumns, model);
        final MojoFrameMeta globalMeta = new MojoFrameMeta(globalColumns);

        final MojoTransform transform = new KlimeTransform(globalMeta, inputIndices, outputIndices, easyPredictModelWrapper);
        transform.setId("klime-main");
        transform.setName(name);
        final DateTime creationTime = new DateTime(1970, 1, 1, 0, 0); //TODO
        final MojoPipelineMeta pipelineMeta = new MojoPipelineMeta(
            model.getUUID(), creationTime);
        pipelineMeta.license = "H2O-3 Opensource";
        this.root = new MojoTransformExecPipeBuilder(inputIndices, outputIndices, transform, pipelineMeta);
        this.root.transforms.add(transform);
    }

    @Override
    public List<MojoColumnMeta> getColumns() {
        return globalColumns;
    }

    @Override
    public List<MojoTransformMeta> getTransformations() {
        return root.metaTransforms;
    }

    @Override
    protected final MojoPipeline internalLoad() {
        return new MojoPipelineProtoImpl(globalColumns, root, PipelineConfig.DEFAULT);
    }

    static int[] readInputIndices(final List<MojoColumnMeta> columns, final GenModel genModel) {
        final int[] inputIndices = new int[genModel.getNumCols()];
        for (int i = 0; i < genModel.getNumCols(); i += 1) {
            final String columnName = genModel.getNames()[i];
            final MojoColumn.Type columnType = (genModel.getDomainValues(i) == null) ? MojoColumn.Type.Float64 : MojoColumn.Type.Str;
            inputIndices[i] = columns.size();
            columns.add(MojoColumnMeta.create(columnName, columnType));
        }
        return inputIndices;
    }

    private static int[] readOutputIndices(final List<MojoColumnMeta> columns, final GenModel genModel) {
        // TODO following is a bit strange exercise, let's check with MM and/or Navdeep why is that
        final List<String> mypredictorsList = new ArrayList<>(Arrays.asList(genModel.getNames()));
        mypredictorsList.remove(genModel.getResponseName());
        final String[] predictors = mypredictorsList.toArray(new String[0]);

        final int predsSize = genModel.getPredsSize();
        final int[] outputIndices = new int[predsSize];
        outputIndices[0] = columns.size();
        columns.add(MojoColumnMeta.create(genModel.getResponseName(), MojoColumn.Type.Float64));
        outputIndices[1] = columns.size();
        columns.add(MojoColumnMeta.create("cluster", MojoColumn.Type.Float64));
        for (int i = 2; i < predsSize; i += 1) {
            outputIndices[i] = columns.size();
            final String outputColumnName = "rc_" + predictors[i - 2]; // "rc" stands for Reason Code
            columns.add(MojoColumnMeta.create(outputColumnName, MojoColumn.Type.Float64));
        }
        return outputIndices;
    }

}
