package ai.h2o.mojos.runtime.h2o3;

import ai.h2o.mojos.runtime.AbstractPipelineLoader;
import ai.h2o.mojos.runtime.MojoPipeline;
import ai.h2o.mojos.runtime.api.MojoTransformMeta;
import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import hex.genmodel.MojoModel;
import hex.genmodel.MojoReaderBackend;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

class KLimePipelineLoader extends AbstractPipelineLoader {
    private final MojoModel model;

    public KLimePipelineLoader(ReaderBackend backend) throws IOException {
        super(backend);
        final MojoReaderBackend mojoReader = new H2O3BackendAdapter(backend);
        this.model = MojoModel.load(mojoReader);
    }

    @Override
    public List<MojoTransformMeta> getTransformations() {
        final String name = "klime:" + model.getModelCategory().toString();
        final int[] inputIndices = new int[0]; // TODO
        final int[] outputIndices = new int[0]; // TODO
        final MojoTransformMeta mtm = new MojoTransformMeta(name, model._algoName, inputIndices, outputIndices, 0, null);
        return Collections.singletonList(mtm);
    }

    @Override
    protected final MojoPipeline internalLoad() {
        return new MojoPipelineKlimeImpl(model);
    }

}
