package ai.h2o.mojos.runtime.h2o3;

import ai.h2o.mojos.runtime.api.PipelineLoader;
import ai.h2o.mojos.runtime.api.PipelineLoaderFactory;
import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import java.io.IOException;

public class H2O3PipelineLoaderFactory implements PipelineLoaderFactory {
    @Override
    public PipelineLoader createLoader(ReaderBackend backend, String optionalMainFile) throws IOException {
        if (optionalMainFile == null || optionalMainFile.equals(getRootResource())) {
            return new H2O3PipelineLoader(backend);
        }
        throw new UnsupportedOperationException(optionalMainFile);
    }

    @Override
    public String getName() {
        return "h2o3";
    }

    @Override
    public String getRootResource() {
        return "model.ini";
    }

}
