package ai.h2o.mojos.runtime.h2o3;

import ai.h2o.mojos.runtime.AbstractPipelineLoader;
import ai.h2o.mojos.runtime.MojoPipeline;
import ai.h2o.mojos.runtime.api.MojoTransformMeta;
import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import hex.genmodel.MojoModel;
import hex.genmodel.MojoReaderBackend;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

class H2O3PipelineLoader extends AbstractPipelineLoader {
    private final MojoModel model;

    public H2O3PipelineLoader(ReaderBackend backend) throws IOException {
        super(backend);
        final MojoReaderBackend mojoReader = new H2O3BackendAdapter(backend);
        this.model = MojoModel.load(mojoReader);
    }

    @Override
    public List<MojoTransformMeta> getTransformations() {
        final String name = "h2o3:" + model.getModelCategory().toString();
        final MojoTransformMeta mtm = new MojoTransformMeta(name, model._algoName, new int[0], new int[0], 0, null);
        return Collections.singletonList(mtm);
    }

    @Override
    protected final MojoPipeline internalLoad() {
        return new MojoPipelineH2O3Impl(model);
    }

}
