package ai.h2o.mojos.runtime.h2o3;

import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import ai.h2o.mojos.runtime.api.backend.ReaderBackendUtils;
import hex.genmodel.MojoReaderBackend;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

/**
 * Wraps our own {@link ReaderBackend} into the H2O3 interfacce {@link MojoReaderBackend} that can be passed to H2O3 methods.
 */
class H2O3BackendAdapter implements MojoReaderBackend {
    private final ReaderBackend backend;

    public H2O3BackendAdapter(ReaderBackend backend) {
        this.backend = backend;
    }

    @Override
    public BufferedReader getTextFile(String filename) throws IOException {
        final InputStream is = backend.getInputStream(filename);
        return new BufferedReader(new InputStreamReader(is));
    }

    @Override
    public byte[] getBinaryFile(String filename) throws IOException {
        try (final InputStream is = backend.getInputStream(filename);
             final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ) {
            ReaderBackendUtils.copy(is, baos, 8192);
            return baos.toByteArray();
        }
    }

    @Override
    public boolean exists(String filename) {
        return backend.exists(filename);
    }
}
