/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.api;

import ai.h2o.mojos.runtime.frame.MojoColumn;
import java.util.ArrayList;
import java.util.List;

public class MojoColumnMeta {
    private final String columnName;
    private final MojoColumn.Type columnType;
    private final MojoColumn.Kind kind;

    public MojoColumnMeta(String columnName, MojoColumn.Type columnType, MojoColumn.Kind kind) {
        this.columnName = columnName;
        this.columnType = columnType;
        if (kind == MojoColumn.Kind.Response) {
            throw new IllegalArgumentException(String.format("Column '%s':%s cannot be created, invalid kind used: '%s'", new Object[]{columnName, columnType, kind}));
        }
        this.kind = kind;
    }

    public static MojoColumnMeta newInput(String columnName, MojoColumn.Type columnType) {
        return new MojoColumnMeta(columnName, columnType, MojoColumn.Kind.Feature);
    }

    public static MojoColumnMeta newOutput(String name, MojoColumn.Type columnType) {
        return new MojoColumnMeta(name, columnType, MojoColumn.Kind.Output);
    }

    public static MojoColumnMeta newInterim(String name, MojoColumn.Type colType) {
        return new MojoColumnMeta(name, colType, MojoColumn.Kind.Interim);
    }

    public static List<MojoColumnMeta> toColumns(String[] columnNames, MojoColumn.Type[] columnTypes, MojoColumn.Kind kind) {
        if (columnNames.length != columnTypes.length) {
            throw new IllegalArgumentException("columnNames and columnTypes arguments must have the same length");
        }
        ArrayList<MojoColumnMeta> cols = new ArrayList<MojoColumnMeta>();
        for (int i = 0; i < columnNames.length; ++i) {
            MojoColumnMeta col = new MojoColumnMeta(columnNames[i], columnTypes[i], kind);
            cols.add(col);
        }
        return cols;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public MojoColumn.Type getColumnType() {
        return this.columnType;
    }

    public boolean isInputFeature() {
        return this.kind == MojoColumn.Kind.Feature;
    }

    public boolean isOutputColumn() {
        return this.kind == MojoColumn.Kind.Output;
    }

    public String toString() {
        return String.format("%s{name:'%s',type=%s}", new Object[]{this.kind.toString(), this.columnName, this.columnType});
    }
}

