package ai.h2o.mojos.runtime.lic;

/**
 * The exception reports that MOJO runtime was not able to find a license.
 */
public class LicenseNotFoundException extends LicenseException {

  static final String MESSAGE = "\nMake sure that license is available for MOJO runtime!\n\n"
                                + "The license can be specified in the following ways:\n"
                                + "  * Environment variable: \n"
                                + "    - '" + LicenseConsts.ENV_PROP_LICENSE_FILE + "' : A location of file with a license\n"
                                + "    - '" + LicenseConsts.ENV_PROP_LICENSE_KEY + "' : A license key\n"
                                + "  * System properties of JVM (-D option): \n"
                                + "    - '" + LicenseConsts.SYS_PROP_LICENSE_FILE + "' : A location of license file.\n"
                                + "    - '" + LicenseConsts.SYS_PROP_LICENSE_KEY + "' : A  license key.\n"
                                + "  * Classpath\n"
                                + "    - The license is loaded from resource called '/" + LicenseConsts.LICENSE_FILENAME + "'\n"
                                + "    - The default resource name can be changed via system property '"+ LicenseConsts.SYS_PROP_LICENSE_FILENAME+"'\n";

  public LicenseNotFoundException() {
    super("License could not be found!\n" + MESSAGE, null);
  }
}
