package ai.h2o.mojos.runtime.frame;

/**
 * `StringConverter` is an interface for converting `String` values into a {@link MojoColumn.Type}.
 */
public interface StringConverter {

  /**
   * Convert a `String` into the designated output type.
   * @param s The `String` to convert
   * @param outputType The type into which `s` should be converted
   * @return The converted Object with a type corresponding to `outputType`
   */
  Object convert(String s, MojoColumn.Type outputType);
}
