package ai.h2o.mojos.runtime.api.backend;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * This reader operates on a subtree of another {@link ReaderBackend}.
 */
public class SubtreeReaderBackend implements ReaderBackend {
    private final ReaderBackend parent;
    private final String prefix;

    private SubtreeReaderBackend(ReaderBackend parent, String subdir) {
        this.parent = parent;
        this.prefix = subdir.endsWith("/") ? subdir : subdir + "/";
    }
    public static SubtreeReaderBackend from(ReaderBackend parent, String subdir) {
        return new SubtreeReaderBackend(parent, subdir);
    }

    @Override
    public InputStream getInputStream(String resourceName) throws IOException {
        return parent.getInputStream(prefix + resourceName);
    }

    @Override
    public boolean exists(String resourceName) {
        return parent.exists(prefix + resourceName);
    }

    @Override
    public Collection<String> list() {
        final List<String> result = new ArrayList<>();
        for (String name : parent.list()) {
            if (name.startsWith(prefix)) {
                result.add(name.substring(prefix.length()));
            }
        }
        return result;
    }

    @Override
    public void close() {}

    @Override
    public String toString() {
        return String.format("%s.%s[%s]", parent.toString(), getClass().getSimpleName(), prefix);
    }

}
