package ai.h2o.mojos.runtime.transforms;

import ai.h2o.mojos.runtime.frame.MojoColumn;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;

/**
 * Builder interface to create frame transformation.
 */
public abstract class MojoTransformBuilder {

  public final int[] iindices;
  public final int[] oindices;
  public final MojoFrameMeta meta;

  public MojoTransformBuilder(MojoFrameMeta meta, int[] iindices, int[] oindices) {
    assert meta != null;
    assert iindices != null;
    assert oindices != null;
    this.meta = meta;
    this.iindices = iindices;
    this.oindices = oindices;
  }

  public MojoTransformBuilder(MojoFrameMeta meta, int iindex, int[] oindices) {
    this(meta, new int[] {iindex}, oindices);
  }

  public MojoTransformBuilder(MojoFrameMeta meta, int[] iindices, int oindex) {
    this(meta, iindices, new int[] {oindex});
  }

  public MojoTransformBuilder(MojoFrameMeta meta, int iindex, int oindex) {
    this(meta, new int[]{iindex}, new int[]{oindex});
  }


  public MojoColumn.Type[] getInputTypes() {
    MojoColumn.Type[] types = new MojoColumn.Type[iindices.length];
    for (int i = 0; i < types.length; i += 1) {
      types[i] = meta.getColumnType(iindices[i]);
    }
    return types;
  }

  public MojoColumn.Type getInputType(int idx) {
    return meta.getColumnType(iindices[idx]);
  }

  public MojoColumn.Type[] getOutputTypes() {
    MojoColumn.Type[] types = new MojoColumn.Type[oindices.length];
    for (int i = 0; i < types.length; i += 1) {
      types[i] = meta.getColumnType(oindices[i]);
    }
    return types;
  }

  public MojoColumn.Type getOutputType(int idx) {
    return meta.getColumnType(oindices[idx]);
  }

  public abstract MojoTransform build();
}
