package ai.h2o.mojos.runtime.readers;

import ai.h2o.mojos.runtime.api.backend.DirReaderBackend;
import ai.h2o.mojos.runtime.api.backend.MemoryReaderBackend;
import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import java.io.File;
import java.io.IOException;
import java.util.Collections;

/**
 * The backend serves MOJO content from a folder.
 *
 * @deprecated use {@link DirReaderBackend} instead
 */
@Deprecated
public class FolderMojoReaderBackend extends MojoReaderBackend {

    public FolderMojoReaderBackend(String folder) {
        this(folder, null);
    }

    public FolderMojoReaderBackend(String folder, String pipelineFile) {
        super(nonthrowingDirReaderBackend(new File(folder)), folder, File.separator, pipelineFile);
    }

    /**
     * Helper allowing to keep strict API compatibility on above constructors.
     * Probably an overkill, as adding exception would not be much pain, and moreover, this class is essentially unused.
     * But strict compatibility is the goal for now.
     */
    private static ReaderBackend nonthrowingDirReaderBackend(File dir) {
        try {
            return DirReaderBackend.open(dir);
        } catch (IOException e) {
            e.printStackTrace();
            // supply empty fileset if anything failed
            return MemoryReaderBackend.open(Collections.<String, byte[]>emptyMap());
        }
    }
}
