package ai.h2o.mojos.runtime.api;

/** Uniform representation of a transformer */
public class MojoTransformMeta {
    private final String name;
    private final Object desc;
    private final int[] inputIndices;
    private final int[] outputIndices;
    private final int transformationIndex;

    public MojoTransformMeta(String name, Object desc, int[] inputIndices, int[] outputIndices, int transformationIndex) {
        this.name = name;
        this.desc = desc;
        this.inputIndices = inputIndices;
        this.outputIndices = outputIndices;
        this.transformationIndex = transformationIndex;
    }
    // todo maybe also input, output, params - later

    public String getName() {
        return name;
    }

    /**
     * Description, can be multi-line.
     * @return object whose {@link #toString()} has the description
     */
    public Object getDesc() {
        return desc;
    }

    public int[] getInputIndices() {
        return inputIndices;
    }

    public int[] getOutputIndices() {
        return outputIndices;
    }

    /**
     * @return index of transformation operation in the pipeline, before removing unused part
     */
    public int getTransformationIndex() {
        return transformationIndex;
    }
}
