/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.utils;

import ai.h2o.mojos.runtime.utils.ArrayUtils;
import ai.h2o.mojos.runtime.utils.Consts;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;

public class DateParser {
    static String[] USER_DEFINED_FORMATS;
    public static final String[] SUPPORTED_FORMATS;
    public static DateTimeFormatter DTF;

    static DateTimeParser[] toFormatter(String[] formats) {
        List<String> expandedFormats = DateParser.expandFormats(formats);
        DateTimeParser[] result = new DateTimeParser[expandedFormats.size()];
        int i = 0;
        for (String f : expandedFormats) {
            result[i++] = DateTimeFormat.forPattern((String)f).getParser();
        }
        return result;
    }

    static List<String> expandFormats(String[] formats) {
        ArrayList<String> expandedFormats = new ArrayList<String>();
        for (String format : formats) {
            DateParser.expandFormat(new StringBuilder(format), 0, expandedFormats);
        }
        return expandedFormats;
    }

    static List<String> expandFormat(StringBuilder format, int startIdx, List<String> result) {
        StringBuilder prefix = new StringBuilder();
        String suffix = null;
        int openGroupIdx = -1;
        int closeGroupIdx = -1;
        int openingCnt = 0;
        for (int i = startIdx; i < format.length(); ++i) {
            char c = format.charAt(i);
            switch (c) {
                case '[': {
                    if (openGroupIdx < 0) {
                        openGroupIdx = i;
                        prefix.append(format, 0, i);
                    }
                    ++openingCnt;
                    break;
                }
                case ']': {
                    if (openGroupIdx >= 0) {
                        --openingCnt;
                    }
                    if (openingCnt != 0) break;
                    closeGroupIdx = i;
                    suffix = format.substring(i + 1);
                    break;
                }
            }
            if (closeGroupIdx > 0) break;
        }
        if (openGroupIdx >= 0) {
            String[] groups;
            for (String group : groups = format.substring(openGroupIdx + 1, closeGroupIdx).split(",")) {
                DateParser.expandFormat(new StringBuilder(prefix).append(group).append(suffix), openGroupIdx, result);
            }
            DateParser.expandFormat(format.delete(openGroupIdx, closeGroupIdx + 1), closeGroupIdx - (closeGroupIdx - openGroupIdx), result);
            return result;
        }
        if (format.length() > 0) {
            result.add(format.toString());
        }
        return result;
    }

    static {
        DateTimeZone.setDefault((DateTimeZone)DateTimeZone.UTC);
        USER_DEFINED_FORMATS = Consts.getSysProp("date.formats", "").split(",");
        SUPPORTED_FORMATS = new String[]{"M[M]/d[d]/yyyy[' ']['T'][' ']h[h]:mm:ss[' ']a", "M[M]/d[d]/yyyy[' ']['T'][' ']h[h]:mm:ss.SSS[' ']a", "M[M]/d[d]/yyyy[' ']['T'][' ']H[H]:mm:ss", "M[M]/d[d]/yyyy[' ']['T'][' ']H[H]:mm:ss.SSS", "M[M]/d[d]/yyyy", "M[M]-d[d]-yyyy[' ']['T'][' ']h[h]:mm:ss[' ']a", "M[M]-d[d]-yyyy[' ']['T'][' ']h[h]:mm:ss.SSS[' ']a", "M[M]-d[d]-yyyy[' ']['T'][' ']H[H]:mm:ss", "M[M]-d[d]-yyyy[' ']['T'][' ']H[H]:mm:ss.SSS", "M[M]-d[d]-yyyy", "d[d].M[M].yyyy[' ']['T'][' ']h[h]:mm:ss[' ']a", "d[d].M[M].yyyy[' ']['T'][' ']h[h]:mm:ss.SSS[' ']a", "d[d].M[M].yyyy[' ']['T'][' ']H[H]:mm:ss", "d[d].M[M].yyyy[' ']['T'][' ']H[H]:mm:ss.SSS", "d[d].M[M].yyyy", "yyyy/M[M]/d[d]' 'HH:mm:ss", "yyyy/M[M]/d[d]' 'HH:mm:ss.SSS", "yyyy/M[M]/d[d]", "yyyy-M[M]-d[d]' 'HH:mm:ss", "yyyy-M[M]-d[d]' 'HH:mm:ss.SSS", "yyyy-M[M]-d[d]'T'HH:mm:ss.SSSSSSSSS", "yyyy-M[M]-d[d]", "h[h]:mm:ss[' ']a", "h[h]:mm:ss.SSS[' ']a", "H[H]:mm:ss", "H[H]:mm:ss.SSS", "h[h]:mm[' ']a", "H[H]:mm"};
        DTF = new DateTimeFormatterBuilder().append(null, DateParser.toFormatter(ArrayUtils.join(SUPPORTED_FORMATS, USER_DEFINED_FORMATS, new String[0][]))).toFormatter();
    }
}

