/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.targetencoding.strategy;

import ai.h2o.targetencoding.TargetEncoderFrameHelper;
import ai.h2o.targetencoding.strategy.ThresholdTEApplicationStrategy;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.Key;
import water.Scope;
import water.TestUtil;
import water.fvec.Frame;

public class ThresholdTEApplicationStrategyTest
extends TestUtil {
    @BeforeClass
    public static void setup() {
        ThresholdTEApplicationStrategyTest.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldReturnCatColumnsWithCardinalityHigherThanThresholdTest() {
        Scope.enter();
        try {
            Frame fr = ThresholdTEApplicationStrategyTest.parse_test_file((String)"./smalldata/gbm_test/titanic.csv");
            Scope.track((Frame[])new Frame[]{fr});
            String responseColumnName = "survived";
            ThresholdTEApplicationStrategy strategy = new ThresholdTEApplicationStrategy(fr, 4L, new String[]{responseColumnName});
            Assert.assertArrayEquals((Object[])new String[]{"cabin", "home.dest"}, (Object[])strategy.getColumnsToEncode());
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void thresholdValueIsIncludedTest() {
        Scope.enter();
        try {
            Frame fr = ThresholdTEApplicationStrategyTest.parse_test_file((String)"./smalldata/gbm_test/titanic.csv");
            Scope.track((Frame[])new Frame[]{fr});
            Assert.assertEquals((long)186L, (long)fr.vec("cabin").cardinality());
            String responseColumnName = "survived";
            ThresholdTEApplicationStrategy strategy = new ThresholdTEApplicationStrategy(fr, 186L, new String[]{responseColumnName});
            Assert.assertArrayEquals((Object[])new String[]{"cabin", "home.dest"}, (Object[])strategy.getColumnsToEncode());
            ThresholdTEApplicationStrategy strategy2 = new ThresholdTEApplicationStrategy(fr, 187L, new String[]{responseColumnName});
            Assert.assertArrayEquals((Object[])new String[]{"home.dest"}, (Object[])strategy2.getColumnsToEncode());
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void foldColumnShouldBeExcludedTest() {
        Scope.enter();
        try {
            Frame fr = ThresholdTEApplicationStrategyTest.parse_test_file((String)"./smalldata/gbm_test/titanic.csv");
            String foldColumnName = "fold";
            int threshold = 187;
            int nfoldsHigherThanThreshold = 200;
            TargetEncoderFrameHelper.addKFoldColumn((Frame)fr, (String)foldColumnName, (int)nfoldsHigherThanThreshold, (long)1234L);
            fr.replace(fr.find(foldColumnName), fr.vec(foldColumnName).toCategoricalVec());
            Scope.track((Frame[])new Frame[]{fr});
            String responseColumnName = "survived";
            ThresholdTEApplicationStrategy strategy = new ThresholdTEApplicationStrategy(fr, (long)threshold, new String[]{responseColumnName});
            Assert.assertArrayEquals((Object[])new String[]{"home.dest", foldColumnName}, (Object[])strategy.getColumnsToEncode());
            ThresholdTEApplicationStrategy strategy2 = new ThresholdTEApplicationStrategy(fr, (long)threshold, new String[]{responseColumnName, foldColumnName});
            Assert.assertArrayEquals((Object[])new String[]{"home.dest"}, (Object[])strategy2.getColumnsToEncode());
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }
}

