/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.targetencoding.strategy;

import ai.h2o.targetencoding.strategy.AllCategoricalTEApplicationStrategy;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.Key;
import water.Scope;
import water.TestUtil;
import water.fvec.Frame;

public class AllCategoricalTEApplicationStrategyTest
extends TestUtil {
    @BeforeClass
    public static void setup() {
        AllCategoricalTEApplicationStrategyTest.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldReturnAllCategoricalColumnTest() {
        Scope.enter();
        try {
            Frame fr = AllCategoricalTEApplicationStrategyTest.parse_test_file((String)"./smalldata/gbm_test/titanic.csv");
            Scope.track((Frame[])new Frame[]{fr});
            String responseColumnName = "survived";
            AllCategoricalTEApplicationStrategy strategy = new AllCategoricalTEApplicationStrategy(fr, new String[]{responseColumnName});
            Assert.assertArrayEquals((Object[])new String[]{"sex", "cabin", "embarked", "home.dest"}, (Object[])strategy.getColumnsToEncode());
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void emptyIfNoCategoricalColumns() {
        Scope.enter();
        try {
            Frame fr = AllCategoricalTEApplicationStrategyTest.parse_test_file((String)"./smalldata/gbm_test/titanic.csv");
            Scope.track((Frame[])new Frame[]{fr});
            String responseColumnName = "survived";
            List<String> alpha = Arrays.asList("sex", "cabin", "embarked", "home.dest");
            alpha.forEach(item -> fr.remove(item));
            AllCategoricalTEApplicationStrategy strategy = new AllCategoricalTEApplicationStrategy(fr, new String[]{responseColumnName});
            Assert.assertArrayEquals((Object[])new String[0], (Object[])strategy.getColumnsToEncode());
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }
}

