/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.targetencoding;

import ai.h2o.targetencoding.BlendingParams;
import ai.h2o.targetencoding.TargetEncoder;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import water.DKV;
import water.Iced;
import water.Job;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.Scope;
import water.TestUtil;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.TestFrameBuilder;
import water.fvec.Vec;
import water.rapids.Rapids;
import water.rapids.Val;
import water.util.IcedHashMapGeneric;

public class TargetEncodingTest
extends TestUtil {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @BeforeClass
    public static void setup() {
        TargetEncodingTest.stall_till_cloudsize((int)1);
    }

    @Test(expected=IllegalStateException.class)
    public void targetEncoderPrepareEncodingFrameValidationDataIsNotNullTest() {
        String[] teColumns = new String[]{"ColA"};
        TargetEncoder tec = new TargetEncoder(teColumns);
        tec.prepareEncodingMap(null, "ColB", null, true);
    }

    @Test(expected=IllegalStateException.class)
    public void targetEncoderPrepareEncodingFrameValidationTEColumnsIsNotEmptyTest() {
        String[] teColumns = new String[]{};
        TargetEncoder tec = new TargetEncoder(teColumns);
        tec.prepareEncodingMap(null, "2", null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void teColumnExistsTest() {
        try {
            Scope.enter();
            Frame fr = new TestFrameBuilder().withColNames(new String[]{"ColA", "ColB"}).withVecTypes(new byte[]{4, 4}).withDataForCol(0, TargetEncodingTest.ar((String[])new String[]{"a", "b"})).withDataForCol(1, TargetEncodingTest.ar((String[])new String[]{"yes", "no"})).build();
            Scope.track((Frame[])new Frame[]{fr});
            String teColumnName = "ColThatNotExist";
            String[] teColumns = new String[]{teColumnName};
            TargetEncoder tec = new TargetEncoder(teColumns);
            try {
                tec.prepareEncodingMap(fr, "ColB", null, true);
                Assert.fail();
            }
            catch (AssertionError ex) {
                Assert.assertEquals((Object)("Column name `" + teColumnName + "` was not found in the provided data frame"), (Object)((Throwable)((Object)ex)).getMessage());
            }
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void changeKeyFrameTest() {
        try {
            Scope.enter();
            Frame fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"ColA"}).withVecTypes(new byte[]{3}).withDataForCol(0, TargetEncodingTest.ard((double[])new double[]{1.0, 2.0})).build();
            Scope.track((Frame[])new Frame[]{fr});
            String tree = "( append testFrame 42 'appended' )";
            Val val = Rapids.exec((String)tree);
            Frame res = val.getFrame();
            res._key = fr._key;
            DKV.put((Key)fr._key, (Iced)res);
            Scope.track((Frame[])new Frame[]{res});
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void imputationWorksForBinaryCategoricalColumnsTest() {
        long seed = 42L;
        try {
            Scope.enter();
            Frame fr = new TestFrameBuilder().withColNames(new String[]{"ColA"}).withVecTypes(new byte[]{4}).withRandomBinaryDataForCol(0, 1000, seed).withChunkLayout(new long[]{500L, 500L}).build();
            Scope.track((Frame[])new Frame[]{fr});
            String nullStr = null;
            fr.vec(0).set(2L, nullStr);
            String[] teColumns = new String[]{""};
            TargetEncoder tec = new TargetEncoder(teColumns);
            Assert.assertTrue((boolean)fr.vec("ColA").isCategorical());
            Assert.assertEquals((long)2L, (long)fr.vec("ColA").cardinality());
            Frame res = tec.imputeNAsForColumn(fr, "ColA", "ColA_NA");
            Vec colA = res.vec("ColA");
            Assert.assertTrue((boolean)colA.isCategorical());
            Assert.assertEquals((long)3L, (long)colA.cardinality());
            Assert.assertEquals((double)2.0, (double)colA.at(2L), (double)1.0E-5);
            Assert.assertEquals((Object)"ColA_NA", (Object)colA.domain()[2]);
            res.delete();
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void imputationWorksForMultiCategoricalColumnsTest() {
        try {
            Scope.enter();
            Frame fr = new TestFrameBuilder().withColNames(new String[]{"ColA"}).withVecTypes(new byte[]{4}).withDataForCol(0, TargetEncodingTest.ar((String[])new String[]{"a", "b", "c", "d", null, null, null})).withChunkLayout(new long[]{2L, 2L, 2L, 1L}).build();
            Scope.track((Frame[])new Frame[]{fr});
            String[] teColumns = new String[]{""};
            TargetEncoder tec = new TargetEncoder(teColumns);
            Assert.assertTrue((boolean)fr.vec("ColA").isCategorical());
            Assert.assertEquals((long)4L, (long)fr.vec("ColA").cardinality());
            Frame res = tec.imputeNAsForColumn(fr, "ColA", "ColA_NA");
            Vec colA = res.vec("ColA");
            Assert.assertTrue((boolean)colA.isCategorical());
            Assert.assertEquals((long)5L, (long)colA.cardinality());
            Assert.assertEquals((double)4.0, (double)colA.at(4L), (double)1.0E-5);
            Assert.assertEquals((Object)"ColA_NA", (Object)colA.domain()[4]);
            res.delete();
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void allTEColumnsAreCategoricalTest() {
        try {
            Scope.enter();
            TestFrameBuilder baseBuilder = new TestFrameBuilder().withColNames(new String[]{"ColA", "ColB", "ColC"}).withDataForCol(0, TargetEncodingTest.ar((String[])new String[]{"1", "0"})).withDataForCol(2, TargetEncodingTest.ar((String[])new String[]{"1", "6"}));
            String[] teColumns = new String[]{"ColA", "ColB"};
            String targetColumnName = "ColC";
            TargetEncoder tec = new TargetEncoder(teColumns);
            IcedHashMapGeneric encodingMap = null;
            Frame fr = baseBuilder.withDataForCol(1, TargetEncodingTest.ar((long[])new long[]{0L, 1L})).withVecTypes(new byte[]{4, 3, 4}).build();
            Scope.track((Frame[])new Frame[]{fr});
            try {
                tec.prepareEncodingMap(fr, targetColumnName, null);
                Assert.fail();
            }
            catch (IllegalStateException ex) {
                Assert.assertEquals((Object)"Argument 'columnsToEncode' should contain only names of categorical columns", (Object)ex.getMessage());
            }
            Frame fr2 = baseBuilder.withDataForCol(1, TargetEncodingTest.ar((String[])new String[]{"a", "b"})).withVecTypes(new byte[]{4, 4, 4}).build();
            Scope.track((Frame[])new Frame[]{fr2});
            try {
                encodingMap = tec.prepareEncodingMap(fr2, targetColumnName, null);
            }
            catch (IllegalStateException ex) {
                Assert.fail((String)String.format("All columns were categorical but something else went wrong: %s", ex.getMessage()));
            }
            this.encodingMapCleanUp((Map<String, Frame>)encodingMap);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void checkAllTEColumnsExistAndAreCategoricalTest() {
        try {
            Scope.enter();
            Frame fr = new TestFrameBuilder().withColNames(new String[]{"ColA"}).withDataForCol(0, TargetEncodingTest.ar((String[])new String[]{"1", "0"})).withVecTypes(new byte[]{4}).build();
            Scope.track((Frame[])new Frame[]{fr});
            String[] teColumns = new String[]{"ColA", "ColNonExist"};
            String targetColumnName = "ColC";
            TargetEncoder tec = new TargetEncoder(teColumns);
            try {
                tec.prepareEncodingMap(fr, targetColumnName, null);
                Assert.fail();
            }
            catch (AssertionError ex) {
                Assert.assertEquals((Object)"Column name `ColNonExist` was not found in the provided data frame", (Object)((Throwable)((Object)ex)).getMessage());
            }
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void prepareEncodingMapWithoutFoldColumnCaseTest() {
        try {
            Scope.enter();
            Frame fr = new TestFrameBuilder().withColNames(new String[]{"ColA", "ColB", "ColC"}).withVecTypes(new byte[]{4, 3, 4}).withDataForCol(0, TargetEncodingTest.ar((String[])new String[]{"a", "b", "b", "b"})).withDataForCol(1, TargetEncodingTest.ard((double[])new double[]{1.0, 1.0, 4.0, 7.0})).withDataForCol(2, TargetEncodingTest.ar((String[])new String[]{"2", "6", "6", "6"})).build();
            Scope.track((Frame[])new Frame[]{fr});
            String[] teColumns = new String[]{"ColA"};
            String targetColumnName = "ColC";
            TargetEncoder tec = new TargetEncoder(teColumns);
            IcedHashMapGeneric targetEncodingMap = tec.prepareEncodingMap(fr, targetColumnName, null);
            Frame colAEncoding = (Frame)targetEncodingMap.get("ColA");
            Scope.track((Frame[])new Frame[]{colAEncoding});
            TargetEncodingTest.assertVecEquals((Vec)TargetEncodingTest.vec((int[])new int[]{0, 3}), (Vec)colAEncoding.vec(1), (double)1.0E-5);
            TargetEncodingTest.assertVecEquals((Vec)TargetEncodingTest.vec((int[])new int[]{1, 3}), (Vec)colAEncoding.vec(2), (double)1.0E-5);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void ifStatementsWithFramesTest() {
        Scope.enter();
        try {
            Frame fr = new TestFrameBuilder().withColNames(new String[]{"ColA", "ColB"}).withVecTypes(new byte[]{4, 4}).withDataForCol(0, TargetEncodingTest.ar((String[])new String[]{"a", "b"})).withDataForCol(1, TargetEncodingTest.ar((String[])new String[]{"yes", "no"})).build();
            Scope.track((Frame[])new Frame[]{fr});
            boolean flag = false;
            String[] teColumns = new String[]{""};
            TargetEncoder tec = new TargetEncoder(teColumns);
            Frame dataWithAllEncodings = null;
            dataWithAllEncodings = fr;
            dataWithAllEncodings.delete();
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void imputeWithMeanTest() {
        try {
            Scope.enter();
            Frame fr = new TestFrameBuilder().withColNames(new String[]{"ColA"}).withVecTypes(new byte[]{2}).withDataForCol(0, TargetEncodingTest.ar((String[])new String[]{"1", "2", null})).build();
            Scope.track((Frame[])new Frame[]{fr});
            String[] teColumns = new String[]{""};
            TargetEncoder tec = new TargetEncoder(teColumns);
            Vec strVec = fr.vec("ColA");
            Vec numericVec = strVec.toNumericVec();
            fr.replace(0, numericVec);
            Frame withImputed = tec.imputeWithMean(fr, 0, 1.5);
            Scope.track((Frame[])new Frame[]{withImputed});
            Vec expected = TargetEncodingTest.dvec((double[])new double[]{1.0, 2.0, 1.5});
            Vec resultVec = withImputed.vec(0);
            TargetEncodingTest.assertVecEquals((Vec)expected, (Vec)resultVec, (double)1.0E-5);
            expected.remove();
            strVec.remove();
            resultVec.remove();
            withImputed.delete();
            numericVec.remove();
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void rbindTest() {
        try {
            Scope.enter();
            Frame fr = new TestFrameBuilder().withColNames(new String[]{"ColA"}).withVecTypes(new byte[]{3}).withDataForCol(0, TargetEncodingTest.ar((long[])new long[]{1L})).build();
            String[] teColumns = new String[]{""};
            TargetEncoder tec = new TargetEncoder(teColumns);
            Frame result = tec.rBind(null, fr);
            Scope.track((Frame[])new Frame[]{result});
            Assert.assertEquals((Object)fr._key, (Object)result._key);
            Frame fr2 = new TestFrameBuilder().withColNames(new String[]{"ColA"}).withVecTypes(new byte[]{3}).withDataForCol(0, TargetEncodingTest.ar((long[])new long[]{42L})).build();
            Scope.track((Frame[])new Frame[]{fr2});
            Frame result2 = tec.rBind(fr, fr2);
            Scope.track((Frame[])new Frame[]{result2});
            Assert.assertEquals((double)1.0, (double)result2.vec("ColA").at(0L), (double)1.0E-5);
            Assert.assertEquals((double)42.0, (double)result2.vec("ColA").at(1L), (double)1.0E-5);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void calculateSingleNumberResultTest() {
        try {
            Scope.enter();
            Frame fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"ColA"}).withVecTypes(new byte[]{3}).withDataForCol(0, TargetEncodingTest.ard((double[])new double[]{1.0, 2.0, 3.0})).build();
            Scope.track((Frame[])new Frame[]{fr});
            String tree = "(sum (cols testFrame [0.0] ))";
            Val val = Rapids.exec((String)tree);
            Assert.assertEquals((double)val.getNum(), (double)6.0, (double)1.0E-5);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void calculateGlobalMeanTest() {
        try {
            Scope.enter();
            Frame fr = new TestFrameBuilder().withColNames(new String[]{"numerator", "denominator"}).withVecTypes(new byte[]{3, 3}).withDataForCol(0, TargetEncodingTest.ard((double[])new double[]{1.0, 2.0, 3.0})).withDataForCol(1, TargetEncodingTest.ard((double[])new double[]{3.0, 4.0, 5.0})).build();
            Scope.track((Frame[])new Frame[]{fr});
            String[] teColumns = new String[]{""};
            TargetEncoder tec = new TargetEncoder(teColumns);
            double result = tec.calculatePriorMean(fr);
            Assert.assertEquals((double)result, (double)0.5, (double)1.0E-5);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void groupByTEColumnAndAggregateTest() {
        try {
            Scope.enter();
            Frame fr = new TestFrameBuilder().withColNames(new String[]{"teColumn", "numerator", "denominator"}).withVecTypes(new byte[]{4, 3, 3}).withDataForCol(0, TargetEncodingTest.ar((String[])new String[]{"a", "a", "b"})).withDataForCol(1, TargetEncodingTest.ard((double[])new double[]{1.0, 2.0, 3.0})).withDataForCol(2, TargetEncodingTest.ard((double[])new double[]{3.0, 4.0, 5.0})).build();
            Scope.track((Frame[])new Frame[]{fr});
            String[] teColumns = new String[]{""};
            TargetEncoder tec = new TargetEncoder(teColumns);
            Frame result = TargetEncoder.groupByTEColumnAndAggregate((Frame)fr, (int)0);
            Scope.track((Frame[])new Frame[]{result});
            Vec expectedNum = TargetEncodingTest.vec((int[])new int[]{3, 3});
            TargetEncodingTest.assertVecEquals((Vec)expectedNum, (Vec)result.vec("sum_numerator"), (double)1.0E-5);
            Vec expectedDen = TargetEncodingTest.vec((int[])new int[]{7, 5});
            TargetEncodingTest.assertVecEquals((Vec)expectedDen, (Vec)result.vec("sum_denominator"), (double)1.0E-5);
            result.delete();
            expectedNum.remove();
            expectedDen.remove();
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void mapOverTheFrameWithImmutableApproachTest() {
        try {
            Scope.enter();
            Frame fr = new TestFrameBuilder().withColNames(new String[]{"ColA", "ColB", "ColC"}).withVecTypes(new byte[]{4, 3, 3}).withDataForCol(0, TargetEncodingTest.ar((String[])new String[]{"a", "b", "c"})).withDataForCol(1, TargetEncodingTest.ar((long[])new long[]{1L, 2L, 3L})).withDataForCol(2, TargetEncodingTest.ar((long[])new long[]{4L, 5L, 6L})).build();
            Scope.track((Frame[])new Frame[]{fr});
            Frame oneColumnMultipliedOnly = ((CalculatedColumnTask)new CalculatedColumnTask(1L).doAll((byte)3, fr)).outputFrame();
            Scope.track((Frame[])new Frame[]{oneColumnMultipliedOnly});
            Assert.assertEquals((long)1L, (long)oneColumnMultipliedOnly.numCols());
            Vec expectedVec = TargetEncodingTest.vec((int[])new int[]{2, 4, 6});
            Vec outcomeVec = oneColumnMultipliedOnly.vec(0);
            TargetEncodingTest.assertVecEquals((Vec)expectedVec, (Vec)outcomeVec, (double)1.0E-5);
            expectedVec.remove();
            outcomeVec.remove();
            oneColumnMultipliedOnly.delete();
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    @Test
    public void mutateOnlyParticularColumnsOfTheFrameTest() {
        try {
            Scope.enter();
            Frame fr = new TestFrameBuilder().withColNames(new String[]{"ColA", "ColB", "ColC"}).withVecTypes(new byte[]{4, 3, 3}).withDataForCol(0, TargetEncodingTest.ar((String[])new String[]{"a", "b", "c"})).withDataForCol(1, TargetEncodingTest.ar((long[])new long[]{1L, 2L, 3L})).withDataForCol(2, TargetEncodingTest.ar((long[])new long[]{4L, 5L, 6L})).build();
            Scope.track((Frame[])new Frame[]{fr});
            new TestMutableTask(1L).doAll(fr);
            Assert.assertEquals((long)3L, (long)fr.numCols());
            Vec expected = TargetEncodingTest.vec((int[])new int[]{2, 4, 6});
            TargetEncodingTest.assertVecEquals((Vec)expected, (Vec)fr.vec(1), (double)1.0E-5);
            expected.remove();
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void calculateAndAppendBlendedTEEncodingTest() throws Exception {
        File tmpFile = this.temporaryFolder.newFile();
        IcedHashMapGeneric targetEncodingMap = null;
        try {
            Scope.enter();
            Frame fr = new TestFrameBuilder().withColNames(new String[]{"ColA", "ColB"}).withVecTypes(new byte[]{4, 4}).withDataForCol(0, TargetEncodingTest.ar((String[])new String[]{"a", "b", "a"})).withDataForCol(1, TargetEncodingTest.ar((String[])new String[]{"yes", "no", "yes"})).withChunkLayout(new long[]{1L, 1L, 1L}).build();
            Scope.track((Frame[])new Frame[]{fr});
            Job export = Frame.export((Frame)fr, (String)tmpFile.getAbsolutePath(), (String)fr._key.toString(), (boolean)true, (int)1);
            export.get();
            Frame reimportedFrame = this.parse_test_file(Key.make((String)"parsed"), tmpFile.getAbsolutePath(), true);
            Scope.track((Frame[])new Frame[]{reimportedFrame});
            String[] teColumns = new String[]{"ColA"};
            String targetColumnName = "ColB";
            TargetEncoder tec = new TargetEncoder(teColumns);
            targetEncodingMap = tec.prepareEncodingMap(reimportedFrame, targetColumnName, null);
            Frame merged = tec.mergeByTEColumn(reimportedFrame, (Frame)targetEncodingMap.get("ColA"), 0, 0);
            Scope.track((Frame[])new Frame[]{merged});
            Frame resultWithEncoding = tec.calculateAndAppendBlendedTEEncoding(merged, (Frame)targetEncodingMap.get("ColA"), "ColB_te", TargetEncoder.DEFAULT_BLENDING_PARAMS);
            Scope.track((Frame[])new Frame[]{resultWithEncoding});
            double globalMean = 0.6666666666666666;
            double k = 10.0;
            int f = 20;
            double lambda1 = 1.0 / (1.0 + Math.exp((k - 2.0) / (double)f));
            double te1 = (1.0 - lambda1) * globalMean + lambda1 * 2.0 / 2.0;
            double lambda2 = 1.0 / (1.0 + Math.exp((k - 1.0) / (double)f));
            double te2 = (1.0 - lambda2) * globalMean + lambda2 * 0.0 / 1.0;
            double lambda3 = 1.0 / (1.0 + Math.exp((k - 2.0) / (double)f));
            double te3 = (1.0 - lambda3) * globalMean + lambda3 * 2.0 / 2.0;
            Assert.assertEquals((double)te1, (double)resultWithEncoding.vec(4).at(0L), (double)1.0E-5);
            Assert.assertEquals((double)te2, (double)resultWithEncoding.vec(4).at(1L), (double)1.0E-5);
            Assert.assertEquals((double)te3, (double)resultWithEncoding.vec(4).at(2L), (double)1.0E-5);
        }
        catch (Throwable throwable) {
            Scope.exit((Key[])new Key[0]);
            this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
            throw throwable;
        }
        Scope.exit((Key[])new Key[0]);
        this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void calculateAndAppendEncodingsOrderIsPreservedWhenWeUseAddMethodTest() {
        int sizeOfDataset = 1000000;
        long seed = 42L;
        double[] arr = new double[sizeOfDataset];
        Arrays.fill(arr, 0.5);
        try {
            Scope.enter();
            Frame fr = new TestFrameBuilder().withColNames(new String[]{"numerator", "denominator", "target", "encodings_to_compare_with"}).withVecTypes(new byte[]{3, 3, 4, 3}).withRandomDoubleDataForCol(0, sizeOfDataset, 1, 1, seed).withRandomDoubleDataForCol(1, sizeOfDataset, 2, 2, seed + 1L).withRandomBinaryDataForCol(2, sizeOfDataset, seed + 2L).withDataForCol(3, arr).withChunkLayout(new long[]{100L, 200L, 300L, sizeOfDataset - 600}).build();
            Scope.track((Frame[])new Frame[]{fr});
            Vec zeroVec = Vec.makeZero((long)sizeOfDataset);
            fr.add("placeholder_for_encodings", zeroVec);
            int changedIndex = new Random().nextInt(sizeOfDataset);
            fr.vec(0).set((long)changedIndex, 0L);
            fr.vec(3).set((long)changedIndex, 0L);
            new TargetEncoder.CalcEncodings(0, 1, 42.0, 4).doAll(fr);
            zeroVec.remove();
            Assert.assertEquals((double)0.0, (double)fr.vec("placeholder_for_encodings").at((long)changedIndex), (double)1.0E-5);
            TargetEncodingTest.assertVecEquals((Vec)fr.vec(3), (Vec)fr.vec("placeholder_for_encodings"), (double)1.0E-5);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void calculateAndAppendBlendedTEEncodingPerformanceTest() {
        long startTimeEncoding = System.currentTimeMillis();
        int numberOfRuns = 10;
        long seed = 42L;
        for (int i = 0; i < numberOfRuns; ++i) {
            try {
                Scope.enter();
                int dataframeSize = 1000000;
                Frame fr = new TestFrameBuilder().withColNames(new String[]{"numerator", "denominator", "target"}).withVecTypes(new byte[]{3, 3, 4}).withRandomDoubleDataForCol(0, dataframeSize, 0, 50, seed).withRandomDoubleDataForCol(1, dataframeSize, 1, 100, seed + 1L).withRandomBinaryDataForCol(2, dataframeSize, seed + 2L).build();
                Scope.track((Frame[])new Frame[]{fr});
                BlendingParams blendingParams = new BlendingParams(20.0, 10.0);
                Vec zeroVec = Vec.makeZero((long)dataframeSize);
                fr.add("placeholder_for_encodings", zeroVec);
                int indexOfEncodingsColumn = 3;
                new TargetEncoder.CalcEncodingsWithBlending(0, 1, 42.0, blendingParams, indexOfEncodingsColumn).doAll(fr);
                zeroVec.remove();
                continue;
            }
            finally {
                Scope.exit((Key[])new Key[0]);
            }
        }
        long finishTimeEncoding = System.currentTimeMillis();
        System.out.println("Calculation of encodings took(ms): " + (finishTimeEncoding - startTimeEncoding));
        System.out.println("Avg calculation of encodings took(ms): " + (double)(finishTimeEncoding - startTimeEncoding) / (double)numberOfRuns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void calculateAndAppendTEEncodingPerformanceTest() {
        long startTimeEncoding = System.currentTimeMillis();
        int numberOfRuns = 10;
        long seed = 42L;
        for (int i = 0; i < numberOfRuns; ++i) {
            try {
                Scope.enter();
                int dataframeSize = 1000000;
                Frame fr = new TestFrameBuilder().withColNames(new String[]{"numerator", "denominator", "target"}).withVecTypes(new byte[]{3, 3, 4}).withRandomDoubleDataForCol(0, dataframeSize, 0, 50, seed).withRandomDoubleDataForCol(1, dataframeSize, 1, 100, seed + 1L).withRandomBinaryDataForCol(2, dataframeSize, seed + 2L).build();
                Scope.track((Frame[])new Frame[]{fr});
                Vec zeroVec = Vec.makeZero((long)dataframeSize);
                fr.add("placeholder_for_encodings", zeroVec);
                new TargetEncoder.CalcEncodings(0, 1, 42.0, 3).doAll(fr);
                zeroVec.remove();
                continue;
            }
            finally {
                Scope.exit((Key[])new Key[0]);
            }
        }
        long finishTimeEncoding = System.currentTimeMillis();
        System.out.println("Calculation of encodings took(ms): " + (finishTimeEncoding - startTimeEncoding));
        System.out.println("Avg calculation of encodings took(ms): " + (double)(finishTimeEncoding - startTimeEncoding) / (double)numberOfRuns);
    }

    @Test
    public void vecESPCTest() {
        Vec vecOfALengthTwo = TargetEncodingTest.vec((int[])new int[]{1, 0});
        long[] espcForLengthTwo = new long[]{0L, 2L};
        Assert.assertArrayEquals((long[])espcForLengthTwo, (long[])Vec.ESPC.espc((Vec)vecOfALengthTwo));
        Vec vecOfALengthThree = TargetEncodingTest.vec((int[])new int[]{1, 0, 3});
        long[] espcForVecOfALengthThree = new long[]{0L, 3L};
        Assert.assertArrayEquals((long[])espcForVecOfALengthThree, (long[])Vec.ESPC.espc((Vec)vecOfALengthThree));
        vecOfALengthTwo.remove();
        vecOfALengthThree.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void mergingByTEAndFoldTest() {
        try {
            Scope.enter();
            Frame fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"ColA", "fold"}).withVecTypes(new byte[]{4, 3}).withDataForCol(0, TargetEncodingTest.ar((String[])new String[]{"a", "b", "a"})).withDataForCol(1, TargetEncodingTest.ar((long[])new long[]{1L, 1L, 2L})).build();
            Scope.track((Frame[])new Frame[]{fr});
            Frame holdoutEncodingMap = new TestFrameBuilder().withName("holdoutEncodingMap").withColNames(new String[]{"ColA", "foldValueForMerge", "numerator", "denominator"}).withVecTypes(new byte[]{4, 3, 3, 3}).withDataForCol(0, TargetEncodingTest.ar((String[])new String[]{"a", "b", "a"})).withDataForCol(1, TargetEncodingTest.ar((long[])new long[]{1L, 2L, 2L})).withDataForCol(2, TargetEncodingTest.ar((long[])new long[]{22L, 55L, 88L})).withDataForCol(3, TargetEncodingTest.ar((long[])new long[]{33L, 66L, 99L})).build();
            Scope.track((Frame[])new Frame[]{holdoutEncodingMap});
            String[] teColumns = new String[]{""};
            TargetEncoder tec = new TargetEncoder(teColumns);
            Frame merged = tec.mergeByTEAndFoldColumns(fr, holdoutEncodingMap, 0, 1, 0, 2);
            Scope.track((Frame[])new Frame[]{merged});
            Vec expectedStr = TargetEncodingTest.svec((String[])new String[]{"22", null, "88"});
            Vec expected = expectedStr.toNumericVec();
            Vec actualNumerator = merged.vec("numerator");
            TargetEncodingTest.assertVecEquals((Vec)expected, (Vec)actualNumerator, (double)1.0E-5);
            expectedStr.remove();
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void AddNoiseLevelTest() {
        try {
            Scope.enter();
            Frame fr = new TestFrameBuilder().withColNames(new String[]{"ColA", "ColB", "ColC"}).withVecTypes(new byte[]{3, 3, 3}).withDataForCol(0, TargetEncodingTest.ard((double[])new double[]{1.0, 2.0, 3.0})).withDataForCol(1, TargetEncodingTest.ard((double[])new double[]{1.0, 2.0, 3.0})).withDataForCol(2, TargetEncodingTest.ard((double[])new double[]{1.0, 2.0, 3.0})).build();
            Scope.track((Frame[])new Frame[]{fr});
            double noiseLevel = 0.01;
            String[] teColumns = new String[]{""};
            TargetEncoder tec = new TargetEncoder(teColumns);
            tec.addNoise(fr, "ColA", noiseLevel, 1234L);
            tec.addNoise(fr, "ColB", noiseLevel, 5678L);
            tec.addNoise(fr, "ColC", noiseLevel, 1234L);
            Vec expected = TargetEncodingTest.vec((int[])new int[]{1, 2, 3});
            TargetEncodingTest.assertVecEquals((Vec)expected, (Vec)fr.vec(0), (double)0.01);
            try {
                TargetEncodingTest.assertVecEquals((Vec)fr.vec(0), (Vec)fr.vec(1), (double)0.0);
                Assert.fail();
            }
            catch (AssertionError assertionError) {
                // empty catch block
            }
            TargetEncodingTest.assertVecEquals((Vec)fr.vec(0), (Vec)fr.vec(2), (double)0.0);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getColumnNamesByIndexesTest() {
        try {
            Scope.enter();
            Frame fr = new TestFrameBuilder().withColNames(new String[]{"ColA", "ColB", "ColC"}).withVecTypes(new byte[]{4, 3, 4}).withDataForCol(0, TargetEncodingTest.ar((String[])new String[]{"a", "b"})).withDataForCol(1, TargetEncodingTest.ard((double[])new double[]{1.0, 1.0})).withDataForCol(2, TargetEncodingTest.ar((String[])new String[]{"2", "6"})).build();
            Scope.track((Frame[])new Frame[]{fr});
            String[] teColumns = new String[]{""};
            TargetEncoder tec = new TargetEncoder(teColumns);
            int[] columns = TargetEncodingTest.ari((int[])new int[]{0, 2});
            String[] columnNames = tec.getColumnNamesBy(fr, columns);
            Assert.assertEquals((Object)"ColA", (Object)columnNames[0]);
            Assert.assertEquals((Object)"ColC", (Object)columnNames[1]);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void ensureTargetColumnIsNumericOrBinaryCategoricalTest() {
        try {
            Scope.enter();
            Frame fr = new TestFrameBuilder().withColNames(new String[]{"ColA", "ColB", "ColC", "ColD"}).withVecTypes(new byte[]{4, 3, 2, 4}).withDataForCol(0, TargetEncodingTest.ar((String[])new String[]{"a", "b", "c", "d"})).withDataForCol(1, TargetEncodingTest.ard((double[])new double[]{1.0, 2.0, 3.0, 4.0})).withDataForCol(2, TargetEncodingTest.ar((String[])new String[]{"2", "6", "6", "6"})).withDataForCol(3, TargetEncodingTest.ar((String[])new String[]{"2", "6", "6", null})).build();
            Scope.track((Frame[])new Frame[]{fr});
            String[] teColumns = new String[]{""};
            TargetEncoder tec = new TargetEncoder(teColumns);
            try {
                tec.ensureTargetColumnIsBinaryCategorical(fr, "ColA");
                Assert.fail();
            }
            catch (Exception ex) {
                Assert.assertEquals((Object)"`target` must be a binary vector. We do not support multi-class target case for now", (Object)ex.getMessage());
            }
            try {
                tec.ensureTargetColumnIsBinaryCategorical(fr, "ColC");
                Assert.fail();
            }
            catch (Exception ex) {
                Assert.assertEquals((Object)"`target` must be a binary categorical vector. We do not support multi-class and continuos target case for now", (Object)ex.getMessage());
            }
            try {
                tec.ensureTargetColumnIsBinaryCategorical(fr, "ColB");
                Assert.fail();
            }
            catch (Exception ex) {
                Assert.assertEquals((Object)"`target` must be a binary categorical vector. We do not support multi-class and continuos target case for now", (Object)ex.getMessage());
            }
            Frame tmp4 = tec.ensureTargetColumnIsBinaryCategorical(fr, "ColD");
            Scope.track((Frame[])new Frame[]{tmp4});
            Assert.assertTrue((boolean)tmp4.vec(3).isNA(3L));
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void ensureTargetEncodingAndRemovingNAsWorkingTogetherTest() {
        String targetColumnName = "ColA";
        try {
            Scope.enter();
            Frame fr = new TestFrameBuilder().withColNames(new String[]{targetColumnName}).withVecTypes(new byte[]{4}).withDataForCol(0, TargetEncodingTest.ar((String[])new String[]{"2", "6", "6", null})).build();
            Scope.track((Frame[])new Frame[]{fr});
            String[] teColumns = new String[]{""};
            TargetEncoder tec = new TargetEncoder(teColumns);
            Frame tmp1 = tec.filterOutNAsFromTargetColumn(fr, 0);
            Scope.track((Frame[])new Frame[]{tmp1});
            Frame tmp2 = tec.ensureTargetColumnIsBinaryCategorical(tmp1, targetColumnName);
            Scope.track((Frame[])new Frame[]{tmp2});
            Vec expected = TargetEncodingTest.vec((int[])new int[]{0, 1, 1});
            TargetEncodingTest.assertVecEquals((Vec)expected, (Vec)tmp2.vec(0), (double)1.0E-5);
            expected.remove();
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    @Test
    public void isBinaryTest() {
        try {
            Scope.enter();
            Frame fr = new TestFrameBuilder().withColNames(new String[]{"ColA", "ColB"}).withVecTypes(new byte[]{4, 3}).withDataForCol(0, TargetEncodingTest.ar((String[])new String[]{"NO", "YES", "NO"})).withDataForCol(1, TargetEncodingTest.ard((double[])new double[]{0.0, 0.5, 1.0})).build();
            Scope.track((Frame[])new Frame[]{fr});
            Assert.assertTrue((boolean)fr.vec(0).isBinary());
            Assert.assertFalse((boolean)fr.vec(1).isBinary());
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void appendingColumnsInTheLoopTest() {
        try {
            Scope.enter();
            Frame fr = new TestFrameBuilder().withColNames(new String[]{"ColA"}).withVecTypes(new byte[]{3}).withDataForCol(0, TargetEncodingTest.ar((long[])new long[]{1L, 2L})).build();
            Scope.track((Frame[])new Frame[]{fr});
            Frame accFrame = fr.deepCopy(Key.make().toString());
            DKV.put((Keyed)accFrame);
            Scope.track((Frame[])new Frame[]{accFrame});
            for (int i = 0; i < 3; ++i) {
                String tree = String.format("( append %s %d 'col_%d' )", accFrame._key, i, i);
                Frame withAppendedFrame = Rapids.exec((String)tree).getFrame();
                withAppendedFrame._key = Key.make();
                DKV.put((Keyed)withAppendedFrame);
                Scope.track((Frame[])new Frame[]{withAppendedFrame});
                Frame accFrame2 = withAppendedFrame.deepCopy(Key.make().toString());
                DKV.put((Keyed)accFrame2);
                Scope.track((Frame[])new Frame[]{accFrame2});
            }
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void referentialTransparencyTest() {
        try {
            Scope.enter();
            Frame fr = new TestFrameBuilder().withColNames(new String[]{"ColA"}).withVecTypes(new byte[]{3}).withDataForCol(0, TargetEncodingTest.ar((long[])new long[]{1L, 2L})).build();
            Scope.track((Frame[])new Frame[]{fr});
            Frame fr2 = new TestFrameBuilder().withColNames(new String[]{"ColA"}).withVecTypes(new byte[]{3}).withDataForCol(0, TargetEncodingTest.ar((long[])new long[]{3L, 4L})).build();
            Scope.track((Frame[])new Frame[]{fr2});
            Frame newReferenceFrame = fr;
            Assert.assertEquals((double)1.0, (double)newReferenceFrame.vec(0).at(0L), (double)1.0E-5);
            newReferenceFrame = fr2;
            Assert.assertEquals((double)3.0, (double)newReferenceFrame.vec(0).at(0L), (double)1.0E-5);
            newReferenceFrame.delete();
            Assert.assertEquals((double)1.0, (double)fr.vec(0).at(0L), (double)1.0E-5);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void transformFrameWithoutResponseColumn() {
        try {
            Scope.enter();
            String teColumnName = "ColA";
            Frame fr = new TestFrameBuilder().withColNames(new String[]{teColumnName, "y"}).withVecTypes(new byte[]{4, 4}).withDataForCol(0, TargetEncodingTest.ar((String[])new String[]{"a", "b", "b", "b"})).withDataForCol(1, TargetEncodingTest.ar((String[])new String[]{"2", "6", "6", "2"})).build();
            Scope.track((Frame[])new Frame[]{fr});
            Frame frameWithoutResponse = new TestFrameBuilder().withColNames(new String[]{teColumnName}).withVecTypes(new byte[]{4}).withDataForCol(0, TargetEncodingTest.ar((String[])new String[]{"a", "b", "b", "b"})).build();
            Scope.track((Frame[])new Frame[]{frameWithoutResponse});
            String[] teColumns = new String[]{teColumnName};
            TargetEncoder tec = new TargetEncoder(teColumns);
            IcedHashMapGeneric encodingMap = tec.prepareEncodingMap(fr, "y", null);
            Scope.track((Frame[])new Frame[]{(Frame)encodingMap.get(teColumnName)});
            Frame encoded = tec.applyTargetEncoding(frameWithoutResponse, "y", (Map)encodingMap, TargetEncoder.DataLeakageHandlingStrategy.None, false, true, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
            Scope.track((Frame[])new Frame[]{encoded});
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void imputeNAsForColumnDistributedTest() {
        Scope.enter();
        try {
            String teColumnName = "ColA";
            String targetColumnName = "ColB";
            Frame fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{teColumnName, targetColumnName}).withVecTypes(new byte[]{4, 4}).withDataForCol(0, TargetEncodingTest.ar((String[])new String[]{"a", "b", null, null, null})).withDataForCol(1, TargetEncodingTest.ar((String[])new String[]{"2", "6", "6", "2", "6"})).withChunkLayout(new long[]{3L, 2L}).build();
            String nullStr = null;
            fr.vec(0).set(2L, nullStr);
            String[] teColumns = new String[]{""};
            TargetEncoder tec = new TargetEncoder(teColumns);
            Assert.assertTrue((boolean)fr.vec("ColA").isCategorical());
            Assert.assertEquals((long)2L, (long)fr.vec("ColA").cardinality());
            Frame res = tec.imputeNAsForColumn(fr, "ColA", "ColA_NA");
            Scope.track((Frame[])new Frame[]{res});
            new ImputeNATestMRTask().doAll(res);
            Assert.assertEquals((long)3L, (long)res.vec("ColA").cardinality());
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void emptyStringsAndNAsAreTreatedAsDifferentCategoriesTest() {
        Scope.enter();
        IcedHashMapGeneric targetEncodingMap = null;
        try {
            String teColumnName = "ColA";
            String targetColumnName = "ColB";
            Frame fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{teColumnName, targetColumnName}).withVecTypes(new byte[]{4, 4}).withDataForCol(0, TargetEncodingTest.ar((String[])new String[]{"a", "b", "", "", null})).withDataForCol(1, TargetEncodingTest.ar((String[])new String[]{"2", "6", "6", "2", "6"})).withChunkLayout(new long[]{3L, 2L}).build();
            String[] teColumns = new String[]{teColumnName};
            TargetEncoder tec = new TargetEncoder(teColumns);
            targetEncodingMap = tec.prepareEncodingMap(fr, targetColumnName, null);
            Frame resultWithEncoding = tec.applyTargetEncoding(fr, targetColumnName, (Map)targetEncodingMap, TargetEncoder.DataLeakageHandlingStrategy.LeaveOneOut, false, 0.0, false, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
            Scope.track((Frame[])new Frame[]{resultWithEncoding});
            Assert.assertEquals((long)4L, (long)resultWithEncoding.vec("ColA").cardinality());
            if (targetEncodingMap != null) {
                this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
            }
        }
        catch (Throwable throwable) {
            if (targetEncodingMap != null) {
                this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
            }
            Scope.exit((Key[])new Key[0]);
            throw throwable;
        }
        Scope.exit((Key[])new Key[0]);
    }

    private void encodingMapCleanUp(Map<String, Frame> encodingMap) {
        for (Map.Entry<String, Frame> map : encodingMap.entrySet()) {
            map.getValue().delete();
        }
    }

    public static class ImputeNATestMRTask
    extends MRTask<ImputeNATestMRTask> {
        public void map(Chunk[] cs) {
            for (int i = 0; i < cs[0].len(); ++i) {
                cs[0].vec().factor(2L);
            }
        }
    }

    public static class TestMutableTask
    extends MRTask<TestMutableTask> {
        long columnIndex;

        public TestMutableTask(long columnIndex) {
            this.columnIndex = columnIndex;
        }

        public void map(Chunk[] cs) {
            for (int col = 0; col < cs.length; ++col) {
                if ((long)col != this.columnIndex) continue;
                for (int i = 0; i < cs[col]._len; ++i) {
                    long value = cs[col].at8(i);
                    cs[col].set(i, value * 2L);
                }
            }
        }
    }

    public static class CalculatedColumnTask
    extends MRTask<CalculatedColumnTask> {
        long columnIndex;

        public CalculatedColumnTask(long columnIndex) {
            this.columnIndex = columnIndex;
        }

        public void map(Chunk[] cs, NewChunk[] ncs) {
            for (int col = 0; col < cs.length; ++col) {
                if ((long)col != this.columnIndex) continue;
                Chunk c = cs[col];
                NewChunk nc = ncs[0];
                for (int i = 0; i < c._len; ++i) {
                    nc.addNum((double)(c.at8(i) * 2L));
                }
            }
        }
    }
}

