/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.targetencoding;

import ai.h2o.targetencoding.TargetEncoder;
import java.util.Arrays;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import water.TestUtil;
import water.fvec.Frame;
import water.fvec.TestFrameBuilder;
import water.fvec.Vec;
import water.util.IcedHashMapGeneric;
import water.util.TwoDimTable;

public class TargetEncodingKFoldStrategyTest
extends TestUtil {
    private Frame fr = null;

    @BeforeClass
    public static void setup() {
        TargetEncodingKFoldStrategyTest.stall_till_cloudsize((int)1);
    }

    @Test
    public void prepareEncodingMapForKFoldCaseTest() {
        this.fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"ColA", "ColB", "ColC", "fold_column"}).withVecTypes(new byte[]{4, 3, 4, 3}).withDataForCol(0, TargetEncodingKFoldStrategyTest.ar((String[])new String[]{"a", "b", "b", "b"})).withDataForCol(1, TargetEncodingKFoldStrategyTest.ard((double[])new double[]{1.0, 1.0, 4.0, 7.0})).withDataForCol(2, TargetEncodingKFoldStrategyTest.ar((String[])new String[]{"2", "6", "6", "6"})).withDataForCol(3, TargetEncodingKFoldStrategyTest.ar((long[])new long[]{1L, 2L, 2L, 3L})).build();
        String[] teColumns = new String[]{"ColA"};
        String targetColumnName = "ColC";
        String foldColumnName = "fold_column";
        TargetEncoder tec = new TargetEncoder(teColumns);
        IcedHashMapGeneric targetEncodingMap = tec.prepareEncodingMap(this.fr, targetColumnName, foldColumnName);
        Frame colAEncoding = (Frame)targetEncodingMap.get("ColA");
        Vec vec1 = TargetEncodingKFoldStrategyTest.vec((int[])new int[]{0, 2, 1});
        TargetEncodingKFoldStrategyTest.assertVecEquals((Vec)vec1, (Vec)colAEncoding.vec(2), (double)1.0E-5);
        Vec vec2 = TargetEncodingKFoldStrategyTest.vec((int[])new int[]{1, 2, 1});
        TargetEncodingKFoldStrategyTest.assertVecEquals((Vec)vec2, (Vec)colAEncoding.vec(3), (double)1.0E-5);
        vec1.remove();
        vec2.remove();
        this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
    }

    @Test
    public void prepareEncodingMapForKFoldCaseWithSomeOfTheTEValuesRepresentedOnlyInOneFold_Test() {
    }

    @Test
    public void targetEncoderKFoldHoldoutApplyingTest() {
        String teColumnName = "ColA";
        String foldColumnName = "fold_column";
        String targetColumnName = "ColC";
        this.fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{teColumnName, "ColB", targetColumnName, foldColumnName}).withVecTypes(new byte[]{4, 3, 4, 3}).withDataForCol(0, TargetEncodingKFoldStrategyTest.ar((String[])new String[]{"a", "b", "b", "b", "a"})).withDataForCol(1, TargetEncodingKFoldStrategyTest.ard((double[])new double[]{1.0, 1.0, 4.0, 7.0, 4.0})).withDataForCol(2, TargetEncodingKFoldStrategyTest.ar((String[])new String[]{"2", "6", "6", "6", "6"})).withDataForCol(3, TargetEncodingKFoldStrategyTest.ar((long[])new long[]{1L, 2L, 2L, 3L, 2L})).build();
        String[] teColumns = new String[]{teColumnName};
        TargetEncoder tec = new TargetEncoder(teColumns);
        IcedHashMapGeneric targetEncodingMap = tec.prepareEncodingMap(this.fr, targetColumnName, foldColumnName);
        Frame resultWithEncoding = tec.applyTargetEncoding(this.fr, targetColumnName, (Map)targetEncodingMap, TargetEncoder.DataLeakageHandlingStrategy.KFold, foldColumnName, false, 0.0, false, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
        Vec expected = TargetEncodingKFoldStrategyTest.vec((int[])new int[]{1, 1, 1, 1, 0});
        TargetEncodingKFoldStrategyTest.assertVecEquals((Vec)expected, (Vec)resultWithEncoding.vec(4), (double)1.0E-5);
        expected.remove();
        resultWithEncoding.delete();
        this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
    }

    @Test
    public void getUniqueValuesOfTheFoldColumnTest() {
        this.fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"fold_column"}).withVecTypes(new byte[]{3}).withDataForCol(0, TargetEncodingKFoldStrategyTest.ar((long[])new long[]{1L, 2L, 2L, 3L, 2L})).build();
        String[] teColumns = new String[]{""};
        TargetEncoder tec = new TargetEncoder(teColumns);
        long[] result = tec.getUniqueValuesOfTheFoldColumn(this.fr, 0);
        Arrays.sort(result);
        Assert.assertArrayEquals((long[])TargetEncodingKFoldStrategyTest.ar((long[])new long[]{1L, 2L, 3L}), (long[])result);
    }

    @Test
    public void targetEncoderKFoldHoldout_WithNonFirstColumnToEncode_ApplyingTest() {
        String targetColumnName = "ColC";
        String teColumnName = "ColA2";
        String foldColumnName = "fold_column";
        this.fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"ColA", teColumnName, "ColB", targetColumnName, foldColumnName}).withVecTypes(new byte[]{4, 4, 3, 4, 3}).withDataForCol(0, TargetEncodingKFoldStrategyTest.ar((String[])new String[]{"a", "b", "b", "b", "a"})).withDataForCol(1, TargetEncodingKFoldStrategyTest.ar((String[])new String[]{"a", "b", "b", "b", "a"})).withDataForCol(2, TargetEncodingKFoldStrategyTest.ard((double[])new double[]{1.0, 1.0, 4.0, 7.0, 4.0})).withDataForCol(3, TargetEncodingKFoldStrategyTest.ar((String[])new String[]{"2", "6", "6", "6", "6"})).withDataForCol(4, TargetEncodingKFoldStrategyTest.ar((long[])new long[]{1L, 2L, 2L, 3L, 2L})).build();
        String[] teColumns = new String[]{teColumnName};
        TargetEncoder tec = new TargetEncoder(teColumns);
        IcedHashMapGeneric targetEncodingMap = tec.prepareEncodingMap(this.fr, targetColumnName, foldColumnName);
        Frame resultWithEncoding = tec.applyTargetEncoding(this.fr, targetColumnName, (Map)targetEncodingMap, TargetEncoder.DataLeakageHandlingStrategy.KFold, foldColumnName, false, 0.0, false, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
        Vec expected = TargetEncodingKFoldStrategyTest.vec((int[])new int[]{1, 1, 1, 1, 0});
        TargetEncodingKFoldStrategyTest.assertVecEquals((Vec)expected, (Vec)resultWithEncoding.vec(5), (double)1.0E-5);
        expected.remove();
        this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
        resultWithEncoding.delete();
    }

    @Test
    public void targetEncoderKFoldHoldoutApplyingWithoutFoldColumnTest() {
    }

    @Test
    public void encodingWasCreatedWithFoldsCheckTest() {
    }

    @Test
    public void targetEncoderKFoldHoldoutApplyingWithNoiseTest() {
        String teColumnName = "ColA";
        String targetColumnName = "ColC";
        String foldColumnName = "fold_column";
        this.fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{teColumnName, "ColB", targetColumnName, foldColumnName}).withVecTypes(new byte[]{4, 3, 4, 3}).withDataForCol(0, TargetEncodingKFoldStrategyTest.ar((String[])new String[]{"a", "b", "b", "b", "a"})).withDataForCol(1, TargetEncodingKFoldStrategyTest.ard((double[])new double[]{1.0, 1.0, 4.0, 7.0, 4.0})).withDataForCol(2, TargetEncodingKFoldStrategyTest.ar((String[])new String[]{"2", "6", "6", "6", "6"})).withDataForCol(3, TargetEncodingKFoldStrategyTest.ar((long[])new long[]{1L, 2L, 2L, 3L, 2L})).build();
        Frame fr2 = new TestFrameBuilder().withName("testFrame2").withColNames(new String[]{teColumnName, "ColB", targetColumnName, foldColumnName}).withVecTypes(new byte[]{4, 3, 4, 3}).withDataForCol(0, TargetEncodingKFoldStrategyTest.ar((String[])new String[]{"a", "b", "c", "b", "a"})).withDataForCol(1, TargetEncodingKFoldStrategyTest.ard((double[])new double[]{1.0, 1.0, 4.0, 7.0, 4.0})).withDataForCol(2, TargetEncodingKFoldStrategyTest.ar((String[])new String[]{"2", "6", "6", "6", "6"})).withDataForCol(3, TargetEncodingKFoldStrategyTest.ar((long[])new long[]{1L, 2L, 2L, 3L, 2L})).build();
        String[] teColumns = new String[]{teColumnName};
        TargetEncoder tec = new TargetEncoder(teColumns);
        IcedHashMapGeneric targetEncodingMap = tec.prepareEncodingMap(this.fr, targetColumnName, foldColumnName);
        Frame resultWithEncoding = tec.applyTargetEncoding(fr2, targetColumnName, (Map)targetEncodingMap, TargetEncoder.DataLeakageHandlingStrategy.KFold, foldColumnName, false, false, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
        TargetEncodingKFoldStrategyTest.printOutFrameAsTable((Frame)resultWithEncoding, (boolean)false, (long)resultWithEncoding.numRows());
        Vec expected = TargetEncodingKFoldStrategyTest.dvec((double[])new double[]{1.0, 1.0, 0.8, 1.0, 0.0});
        TargetEncodingKFoldStrategyTest.assertVecEquals((Vec)expected, (Vec)resultWithEncoding.vec(4), (double)0.01);
        expected.remove();
        this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
        resultWithEncoding.delete();
        fr2.delete();
    }

    @Test
    public void targetEncoderKFoldHoldoutApplyingWithCustomNoiseTest() {
        String teColumnName = "ColA";
        String targetColumnName = "ColC";
        String foldColumnName = "fold_column";
        this.fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{teColumnName, "ColB", targetColumnName, foldColumnName}).withVecTypes(new byte[]{4, 3, 4, 3}).withDataForCol(0, TargetEncodingKFoldStrategyTest.ar((String[])new String[]{"a", "b", "b", "b", "a"})).withDataForCol(1, TargetEncodingKFoldStrategyTest.ard((double[])new double[]{1.0, 1.0, 4.0, 7.0, 4.0})).withDataForCol(2, TargetEncodingKFoldStrategyTest.ar((String[])new String[]{"2", "6", "6", "6", "6"})).withDataForCol(3, TargetEncodingKFoldStrategyTest.ar((long[])new long[]{1L, 2L, 2L, 3L, 2L})).build();
        String[] teColumns = new String[]{teColumnName};
        TargetEncoder tec = new TargetEncoder(teColumns);
        IcedHashMapGeneric targetEncodingMap = tec.prepareEncodingMap(this.fr, targetColumnName, foldColumnName);
        Frame resultWithEncoding = tec.applyTargetEncoding(this.fr, targetColumnName, (Map)targetEncodingMap, TargetEncoder.DataLeakageHandlingStrategy.KFold, foldColumnName, false, 0.02, false, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
        TwoDimTable resultTable = resultWithEncoding.toTwoDimTable();
        System.out.println("Result table" + resultTable.toString());
        Vec expected = TargetEncodingKFoldStrategyTest.vec((int[])new int[]{1, 1, 1, 1, 0});
        TargetEncodingKFoldStrategyTest.assertVecEquals((Vec)expected, (Vec)resultWithEncoding.vec(4), (double)0.02);
        expected.remove();
        this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
        resultWithEncoding.delete();
    }

    @Ignore
    @Test
    public void targetEncoderKFoldHoldoutApplyingWithBlendedAvgTest() {
        String teColumnName = "ColA";
        String targetColumnName = "ColC";
        String foldColumnName = "fold_column";
        this.fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{teColumnName, "ColB", targetColumnName, foldColumnName}).withVecTypes(new byte[]{4, 3, 4, 3}).withDataForCol(0, TargetEncodingKFoldStrategyTest.ar((String[])new String[]{"a", "b", "b", "b", "a", "c"})).withDataForCol(1, TargetEncodingKFoldStrategyTest.ard((double[])new double[]{1.0, 1.0, 4.0, 7.0, 4.0, 9.0})).withDataForCol(2, TargetEncodingKFoldStrategyTest.ar((String[])new String[]{"2", "6", "6", "6", "6", "2"})).withDataForCol(3, TargetEncodingKFoldStrategyTest.ar((long[])new long[]{1L, 2L, 2L, 3L, 2L, 2L})).build();
        String[] teColumns = new String[]{teColumnName};
        TargetEncoder tec = new TargetEncoder(teColumns);
        IcedHashMapGeneric targetEncodingMap = tec.prepareEncodingMap(this.fr, targetColumnName, foldColumnName);
        Frame resultWithEncoding = tec.applyTargetEncoding(this.fr, targetColumnName, (Map)targetEncodingMap, TargetEncoder.DataLeakageHandlingStrategy.KFold, foldColumnName, true, 0.0, true, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
        Vec encodedVec = resultWithEncoding.vec(4);
        Assert.assertEquals((double)0.855, (double)encodedVec.at(0L), (double)0.001);
        Assert.assertEquals((double)0.724, (double)encodedVec.at(1L), (double)0.001);
        Assert.assertEquals((double)0.855, (double)encodedVec.at(2L), (double)0.001);
        Assert.assertEquals((double)0.856, (double)encodedVec.at(4L), (double)0.001);
        encodedVec.remove();
        this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
        resultWithEncoding.delete();
    }

    @Test
    public void manualHighCardinalityKFoldTest() {
        String teColumnName = "ColA";
        String targetColumnName = "ColB";
        String foldColumn = "fold_column";
        this.fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{teColumnName, targetColumnName, foldColumn}).withVecTypes(new byte[]{4, 4, 3}).withDataForCol(0, TargetEncodingKFoldStrategyTest.ar((String[])new String[]{"a", "b", "b", "c", "c", "a", "d", "d", "d", "d", "e", "e", "a", "f", "f"})).withDataForCol(1, TargetEncodingKFoldStrategyTest.ar((String[])new String[]{"2", "6", "6", "6", "6", "6", "2", "6", "6", "6", "6", "2", "2", "2", "2"})).withDataForCol(2, TargetEncodingKFoldStrategyTest.ar((long[])new long[]{1L, 2L, 1L, 2L, 1L, 3L, 2L, 2L, 1L, 3L, 1L, 2L, 3L, 3L, 2L})).build();
        String[] teColumns = new String[]{teColumnName};
        TargetEncoder tec = new TargetEncoder(teColumns);
        IcedHashMapGeneric targetEncodingMap = tec.prepareEncodingMap(this.fr, targetColumnName, foldColumn);
        Frame resultWithEncoding = tec.applyTargetEncoding(this.fr, targetColumnName, (Map)targetEncodingMap, TargetEncoder.DataLeakageHandlingStrategy.KFold, foldColumn, false, 0.0, false, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
        TargetEncodingKFoldStrategyTest.printOutFrameAsTable((Frame)resultWithEncoding, (boolean)false, (long)100L);
        double expectedDifferenceDueToNoise = 1.0E-5;
        Vec actualEncodings = resultWithEncoding.vec(3);
        Vec expectedEncodings = TargetEncodingKFoldStrategyTest.dvec((double[])new double[]{0.5, 1.0, 1.0, 1.0, 1.0, 0.0, 1.0, 1.0, 0.66666, 0.66666, 0.0, 1.0, 0.0, 0.0, 0.0});
        TargetEncodingKFoldStrategyTest.assertVecEquals((Vec)expectedEncodings, (Vec)actualEncodings, (double)expectedDifferenceDueToNoise);
        expectedEncodings.remove();
        this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
        resultWithEncoding.delete();
    }

    @Test
    public void endToEndTest() {
        String teColumnName = "ColA";
        String targetColumnName = "ColC";
        String foldColumn = "fold_column";
        Frame training = new TestFrameBuilder().withName("trainingFrame").withColNames(new String[]{teColumnName, targetColumnName, foldColumn}).withVecTypes(new byte[]{4, 4, 3}).withDataForCol(0, TargetEncodingKFoldStrategyTest.ar((String[])new String[]{"a", "b", "c", "d", "e", "b", "b"})).withDataForCol(1, TargetEncodingKFoldStrategyTest.ar((String[])new String[]{"2", "6", "6", "6", "6", "2", "2"})).withDataForCol(2, TargetEncodingKFoldStrategyTest.ar((long[])new long[]{1L, 2L, 2L, 3L, 1L, 2L, 1L})).build();
        Frame valid = new TestFrameBuilder().withName("validFrame").withColNames(new String[]{teColumnName, targetColumnName, foldColumn}).withVecTypes(new byte[]{4, 4, 3}).withDataForCol(0, TargetEncodingKFoldStrategyTest.ar((String[])new String[]{"a", "b", "b", "b", "a"})).withDataForCol(1, TargetEncodingKFoldStrategyTest.ar((String[])new String[]{"2", "6", "6", "6", "6"})).withDataForCol(2, TargetEncodingKFoldStrategyTest.ar((long[])new long[]{1L, 2L, 1L, 2L, 1L})).build();
        String[] teColumns = new String[]{teColumnName};
        TargetEncoder tec = new TargetEncoder(teColumns);
        IcedHashMapGeneric targetEncodingMap = tec.prepareEncodingMap(training, targetColumnName, foldColumn);
        Frame resultWithEncoding = tec.applyTargetEncoding(valid, targetColumnName, (Map)targetEncodingMap, TargetEncoder.DataLeakageHandlingStrategy.KFold, foldColumn, false, 0.0, false, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
        TargetEncodingKFoldStrategyTest.printOutFrameAsTable((Frame)resultWithEncoding, (boolean)false, (long)100L);
        Vec actualEncodings = resultWithEncoding.vec(3);
        Vec expected = TargetEncodingKFoldStrategyTest.dvec((double[])new double[]{0.5714285, 0.0, 0.5, 0.0, 0.5714285});
        TargetEncodingKFoldStrategyTest.assertVecEquals((Vec)expected, (Vec)actualEncodings, (double)1.0E-5);
        training.delete();
        valid.delete();
        expected.remove();
        this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
        resultWithEncoding.delete();
    }

    @Test
    public void KFoldHoldoutMultipleTEColumnsWithFoldColumnTest() {
        String targetColumnName = "ColC";
        String foldColumn = "fold_column";
        TestFrameBuilder frameBuilder = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"ColA", "ColB", targetColumnName, foldColumn}).withVecTypes(new byte[]{4, 4, 4, 3}).withDataForCol(0, TargetEncodingKFoldStrategyTest.ar((String[])new String[]{"a", "b", "b", "b", "a"})).withDataForCol(1, TargetEncodingKFoldStrategyTest.ar((String[])new String[]{"d", "e", "d", "e", "e"})).withDataForCol(2, TargetEncodingKFoldStrategyTest.ar((String[])new String[]{"2", "6", "6", "6", "6"})).withDataForCol(3, TargetEncodingKFoldStrategyTest.ar((long[])new long[]{1L, 2L, 2L, 3L, 2L}));
        String[] teColumns = new String[]{"ColA", "ColB"};
        TargetEncoder tec = new TargetEncoder(teColumns);
        this.fr = frameBuilder.withName("testFrame").build();
        IcedHashMapGeneric targetEncodingMap = tec.prepareEncodingMap(this.fr, targetColumnName, foldColumn);
        Frame resultWithEncoding = tec.applyTargetEncoding(this.fr, targetColumnName, (Map)targetEncodingMap, TargetEncoder.DataLeakageHandlingStrategy.KFold, foldColumn, false, 0.0, false, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
        Frame sortedBy2 = resultWithEncoding.sort(new int[]{2});
        Vec encodingForColumnA_Multiple = sortedBy2.vec(4);
        Frame sortedBy0 = resultWithEncoding.sort(new int[]{0});
        Vec encodingForColumnB_Multiple = sortedBy0.vec(5);
        Frame frA = frameBuilder.withName("testFrameA").build();
        String[] indexForColumnA = new String[]{"ColA"};
        TargetEncoder tecA = new TargetEncoder(indexForColumnA);
        IcedHashMapGeneric targetEncodingMapForColumnA = tecA.prepareEncodingMap(frA, targetColumnName, foldColumn);
        Frame resultWithEncodingForColumnA = tecA.applyTargetEncoding(frA, targetColumnName, (Map)targetEncodingMapForColumnA, TargetEncoder.DataLeakageHandlingStrategy.KFold, foldColumn, false, 0.0, false, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
        Vec encodingForColumnA_Single = resultWithEncodingForColumnA.vec(4);
        TargetEncodingKFoldStrategyTest.assertVecEquals((Vec)encodingForColumnA_Single, (Vec)encodingForColumnA_Multiple, (double)1.0E-5);
        Frame frB = frameBuilder.withName("testFrameB").build();
        String[] indexForColumnB = new String[]{"ColB"};
        TargetEncoder tecB = new TargetEncoder(indexForColumnB);
        IcedHashMapGeneric targetEncodingMapForColumnB = tecB.prepareEncodingMap(frB, targetColumnName, foldColumn);
        Frame resultWithEncodingForColumnB = tecB.applyTargetEncoding(frB, targetColumnName, (Map)targetEncodingMapForColumnB, TargetEncoder.DataLeakageHandlingStrategy.KFold, foldColumn, false, 0.0, false, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
        Frame sortedByColA = resultWithEncodingForColumnB.sort(new int[]{0});
        Vec encodingForColumnB_Single = sortedByColA.vec("ColB_te");
        TargetEncodingKFoldStrategyTest.assertVecEquals((Vec)encodingForColumnB_Single, (Vec)encodingForColumnB_Multiple, (double)1.0E-5);
        sortedBy0.delete();
        sortedBy2.delete();
        sortedByColA.delete();
        this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
        this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMapForColumnA);
        this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMapForColumnB);
        frA.delete();
        frB.delete();
        resultWithEncoding.delete();
        resultWithEncodingForColumnA.delete();
        resultWithEncodingForColumnB.delete();
    }

    @Test
    public void targetEncoderGetOutOfFoldDataTest() {
        this.fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"ColA", "ColB"}).withVecTypes(new byte[]{3, 3}).withDataForCol(0, TargetEncodingKFoldStrategyTest.ard((double[])new double[]{5.0, 6.0, 7.0, 9.0})).withDataForCol(1, TargetEncodingKFoldStrategyTest.ard((double[])new double[]{1.0, 2.0, 3.0, 1.0})).build();
        String[] teColumns = new String[]{""};
        TargetEncoder tec = new TargetEncoder(teColumns);
        Frame outOfFoldData = tec.getOutOfFoldData(this.fr, "ColB", 1L);
        TwoDimTable twoDimTable = outOfFoldData.toTwoDimTable();
        Assert.assertEquals((long)outOfFoldData.numRows(), (long)2L);
        Assert.assertEquals((Object)6L, (Object)twoDimTable.get(5, 0));
        Assert.assertEquals((Object)7L, (Object)twoDimTable.get(6, 0));
        Frame outOfFoldData2 = tec.getOutOfFoldData(this.fr, "ColB", 2L);
        TwoDimTable twoDimTable2 = outOfFoldData2.toTwoDimTable();
        Assert.assertEquals((Object)5L, (Object)twoDimTable2.get(5, 0));
        Assert.assertEquals((Object)7L, (Object)twoDimTable2.get(6, 0));
        Assert.assertEquals((Object)9L, (Object)twoDimTable2.get(7, 0));
        outOfFoldData.delete();
        outOfFoldData2.delete();
    }

    @After
    public void afterEach() {
        if (this.fr != null) {
            this.fr.delete();
        }
    }

    private void encodingMapCleanUp(Map<String, Frame> encodingMap) {
        for (Map.Entry<String, Frame> map : encodingMap.entrySet()) {
            map.getValue().delete();
        }
    }
}

