/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.targetencoding;

import ai.h2o.targetencoding.TargetEncoder;
import java.util.Map;
import org.junit.After;
import org.junit.BeforeClass;
import org.junit.Test;
import water.DKV;
import water.Key;
import water.Keyed;
import water.TestUtil;
import water.fvec.Frame;
import water.fvec.TestFrameBuilder;
import water.util.IcedHashMapGeneric;

public class TargetEncodingImmutabilityTest
extends TestUtil {
    private Frame fr = null;

    @BeforeClass
    public static void setup() {
        TargetEncodingImmutabilityTest.stall_till_cloudsize((int)1);
    }

    @Test
    public void deepCopyTest() {
        this.fr = new TestFrameBuilder().withName("trainingFrame").withColNames(new String[]{"colA"}).withVecTypes(new byte[]{2}).withDataForCol(0, TargetEncodingImmutabilityTest.ar((String[])new String[]{"a", "b", "c"})).build();
        Frame trainCopy = this.fr.deepCopy(Key.make().toString());
        DKV.put((Keyed)trainCopy);
        TargetEncodingImmutabilityTest.assertBitIdentical((Frame)this.fr, (Frame)trainCopy);
        trainCopy.vec(0).set(0L, "d");
        TargetEncodingImmutabilityTest.assertIdenticalUpToRelTolerance((Frame)this.fr, (Frame)trainCopy, (double)0.0, (boolean)false);
        trainCopy.delete();
    }

    @Test
    public void ensureImmutabilityOfTheOriginalDatasetDuringApplicationOfTE() {
        String teColumnName = "ColA";
        String targetColumnName = "ColC";
        String foldColumn = "fold_column";
        Frame training = new TestFrameBuilder().withName("trainingFrame").withColNames(new String[]{teColumnName, targetColumnName, foldColumn}).withVecTypes(new byte[]{4, 4, 3}).withDataForCol(0, TargetEncodingImmutabilityTest.ar((String[])new String[]{"a", "b", "c", "d", "e", "b", "b"})).withDataForCol(1, TargetEncodingImmutabilityTest.ar((String[])new String[]{"2", "6", "6", "6", "6", "2", "2"})).withDataForCol(2, TargetEncodingImmutabilityTest.ar((long[])new long[]{1L, 2L, 2L, 3L, 1L, 2L, 1L})).build();
        String[] teColumns = new String[]{teColumnName};
        TargetEncoder tec = new TargetEncoder(teColumns);
        IcedHashMapGeneric targetEncodingMap = tec.prepareEncodingMap(training, targetColumnName, foldColumn);
        Frame trainCopy = training.deepCopy(Key.make().toString());
        DKV.put((Keyed)trainCopy);
        Frame resultWithEncoding = tec.applyTargetEncoding(training, targetColumnName, (Map)targetEncodingMap, TargetEncoder.DataLeakageHandlingStrategy.KFold, foldColumn, false, 0.0, false, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
        TargetEncodingImmutabilityTest.assertBitIdentical((Frame)training, (Frame)trainCopy);
        training.delete();
        trainCopy.delete();
        this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
        resultWithEncoding.delete();
    }

    @After
    public void afterEach() {
        if (this.fr != null) {
            this.fr.delete();
        }
    }

    private void encodingMapCleanUp(Map<String, Frame> encodingMap) {
        for (Map.Entry<String, Frame> map : encodingMap.entrySet()) {
            map.getValue().delete();
        }
    }
}

