/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.targetencoding;

import ai.h2o.targetencoding.FrameToTETableTask;
import ai.h2o.targetencoding.TargetEncoder;
import ai.h2o.targetencoding.TargetEncoderFrameHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import water.DKV;
import water.Key;
import water.Scope;
import water.TestUtil;
import water.fvec.Frame;
import water.fvec.TestFrameBuilder;
import water.fvec.Vec;
import water.util.IcedHashMap;
import water.util.IcedHashMapGeneric;
import water.util.Log;

public class TargetEncodingFrameHelperTest
extends TestUtil {
    @BeforeClass
    public static void setup() {
        TargetEncodingFrameHelperTest.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addVecToFrameTest() {
        Scope.enter();
        try {
            Frame fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"ColA"}).withVecTypes(new byte[]{4}).withDataForCol(0, TargetEncodingFrameHelperTest.ar((String[])new String[]{"a", "b"})).build();
            Vec vec = TargetEncodingFrameHelperTest.vec((int[])new int[]{1, 2});
            fr.add("ColB", vec);
            Scope.track((Vec)vec);
            TargetEncodingFrameHelperTest.assertVecEquals((Vec)vec, (Vec)fr.vec("ColB"), (double)1.0E-5);
            Frame tmp = TargetEncoderFrameHelper.addCon((Frame)fr, (String)"ColC", (long)42L);
            Vec expectedConstVec = TargetEncodingFrameHelperTest.vec((int[])new int[]{42, 42});
            TargetEncodingFrameHelperTest.assertVecEquals((Vec)expectedConstVec, (Vec)tmp.vec("ColC"), (double)1.0E-5);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    @Test
    public void filterOutNAsTest() {
        Scope.enter();
        try {
            Frame fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"ColA", "ColB"}).withVecTypes(new byte[]{3, 2}).withDataForCol(0, TargetEncodingFrameHelperTest.ard((double[])new double[]{1.0, 42.0, 33.0})).withDataForCol(1, TargetEncodingFrameHelperTest.ar((String[])new String[]{null, "6", null})).build();
            Frame result = TargetEncoderFrameHelper.filterOutNAsInColumn((Frame)fr, (int)1);
            Scope.track((Frame[])new Frame[]{result});
            Assert.assertEquals((long)1L, (long)result.numRows());
            Assert.assertEquals((double)42.0, (double)result.vec(0).at(0L), (double)1.0E-5);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    @Test
    public void filterByValueTest() {
        Scope.enter();
        try {
            Frame fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"ColA", "ColB"}).withVecTypes(new byte[]{3, 2}).withDataForCol(0, TargetEncodingFrameHelperTest.ard((double[])new double[]{1.0, 42.0, 33.0})).withDataForCol(1, TargetEncodingFrameHelperTest.ar((String[])new String[]{null, "6", null})).build();
            Frame result = TargetEncoderFrameHelper.filterByValue((Frame)fr, (int)0, (double)42.0);
            Scope.track((Frame[])new Frame[]{result});
            Assert.assertEquals((long)1L, (long)result.numRows());
            Assert.assertEquals((Object)"6", (Object)result.vec(1).stringAt(0L));
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    @Test
    public void filterNotByValueTest() {
        Scope.enter();
        try {
            Frame fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"ColA", "ColB"}).withVecTypes(new byte[]{3, 2}).withDataForCol(0, TargetEncodingFrameHelperTest.ard((double[])new double[]{1.0, 42.0, 33.0})).withDataForCol(1, TargetEncodingFrameHelperTest.ar((String[])new String[]{null, "6", null})).build();
            Frame result = TargetEncoderFrameHelper.filterNotByValue((Frame)fr, (int)0, (double)42.0);
            Scope.track((Frame[])new Frame[]{result});
            Assert.assertEquals((long)2L, (long)result.numRows());
            TargetEncodingFrameHelperTest.assertVecEquals((Vec)TargetEncodingFrameHelperTest.vec((int[])new int[]{1, 33}), (Vec)result.vec(0), (double)1.0E-5);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void renameColumnTest() {
        Scope.enter();
        try {
            Frame fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"ColA", "ColB", "ColC", "fold_column"}).withVecTypes(new byte[]{4, 3, 4, 3}).withDataForCol(0, TargetEncodingFrameHelperTest.ar((String[])new String[]{"a", "b"})).withDataForCol(1, TargetEncodingFrameHelperTest.ard((double[])new double[]{1.0, 1.0})).withDataForCol(2, TargetEncodingFrameHelperTest.ar((String[])new String[]{"2", "6"})).withDataForCol(3, TargetEncodingFrameHelperTest.ar((long[])new long[]{1L, 2L})).build();
            int indexOfColumnToRename = 0;
            String newName = "NewColA";
            TargetEncoderFrameHelper.renameColumn((Frame)fr, (int)indexOfColumnToRename, (String)newName);
            Assert.assertEquals((Object)fr.names()[indexOfColumnToRename], (Object)newName);
            String newName2 = "NewColA-2";
            TargetEncoderFrameHelper.renameColumn((Frame)fr, (String)"NewColA", (String)newName2);
            Assert.assertEquals((Object)fr.names()[indexOfColumnToRename], (Object)newName2);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUniqueValuesBy() {
        Scope.enter();
        try {
            Frame fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"column1"}).withVecTypes(new byte[]{3}).withDataForCol(0, TargetEncodingFrameHelperTest.ar((long[])new long[]{1L, 2L, 2L, 3L, 2L})).build();
            Frame uniqueValuesFrame = TargetEncoderFrameHelper.uniqueValuesBy((Frame)fr, (int)0);
            Vec uniqueValuesVec = uniqueValuesFrame.vec(0);
            long numberOfUniqueValues = uniqueValuesVec.length();
            int length = (int)numberOfUniqueValues;
            long[] uniqueValuesArr = new long[length];
            int i = 0;
            while ((long)i < numberOfUniqueValues) {
                uniqueValuesArr[i] = uniqueValuesVec.at8((long)i);
                ++i;
            }
            Arrays.sort(uniqueValuesArr);
            Assert.assertArrayEquals((long[])TargetEncodingFrameHelperTest.ar((long[])new long[]{1L, 2L, 3L}), (long[])uniqueValuesArr);
            Scope.track((Frame[])new Frame[]{uniqueValuesFrame});
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    @Test
    public void testAddKFoldColumn() {
        Scope.enter();
        try {
            Frame fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"ColA"}).withVecTypes(new byte[]{4}).withDataForCol(0, TargetEncodingFrameHelperTest.ar((String[])new String[]{"a", "b", "c", "d"})).build();
            Scope.track((Frame[])new Frame[]{fr});
            int nfolds = 5;
            TargetEncoderFrameHelper.addKFoldColumn((Frame)fr, (String)"fold", (int)nfolds, (long)-1L);
            Assert.assertTrue((fr.vec(1).at(0L) < (double)nfolds ? 1 : 0) != 0);
            Assert.assertTrue((fr.vec(1).at(1L) < (double)nfolds ? 1 : 0) != 0);
            Assert.assertTrue((fr.vec(1).at(2L) < (double)nfolds ? 1 : 0) != 0);
            Assert.assertTrue((fr.vec(1).at(3L) < (double)nfolds ? 1 : 0) != 0);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void registerTest() {
        Scope.enter();
        try {
            Frame fr = new TestFrameBuilder().withName("testFrame").build();
            Scope.track((Frame[])new Frame[]{fr});
            Key keyBefore = fr._key;
            DKV.remove((Key)keyBefore);
            Frame res = TargetEncoderFrameHelper.register((Frame)fr);
            Scope.track((Frame[])new Frame[]{res});
            Assert.assertNotSame((Object)res._key, (Object)keyBefore);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Frame> getTEMapForTitanicDataset(boolean withFoldColumn) {
        String foldColumnNameForTE = "te_fold_column";
        Frame trainFrame = null;
        try {
            IcedHashMapGeneric testEncodingMap;
            trainFrame = TargetEncodingFrameHelperTest.parse_test_file((String)"./smalldata/gbm_test/titanic.csv");
            String responseColumnName = "survived";
            this.asFactor(trainFrame, responseColumnName);
            if (withFoldColumn) {
                int nfolds = 5;
                TargetEncoderFrameHelper.addKFoldColumn((Frame)trainFrame, (String)foldColumnNameForTE, (int)nfolds, (long)1234L);
            }
            String[] teColumns = new String[]{"home.dest", "embarked"};
            TargetEncoder targetEncoder = new TargetEncoder(teColumns);
            IcedHashMapGeneric icedHashMapGeneric = testEncodingMap = targetEncoder.prepareEncodingMap(trainFrame, responseColumnName, withFoldColumn ? foldColumnNameForTE : null);
            return icedHashMapGeneric;
        }
        finally {
            if (trainFrame != null) {
                trainFrame.delete();
            }
        }
    }

    @Ignore
    @Test
    public void conversion_of_frame_into_table_doAll_vs_dfork_performance_test() {
        Map<String, Frame> encodingMap = this.getTEMapForTitanicDataset(false);
        for (int i = 0; i < 10; ++i) {
            encodingMap.put(UUID.randomUUID().toString(), encodingMap.get("home.dest"));
        }
        int numberOfIterations = 50;
        long startTimeDoAll = System.currentTimeMillis();
        for (int i = 0; i < numberOfIterations; ++i) {
            for (Map.Entry<String, Frame> entry : encodingMap.entrySet()) {
                String key = entry.getKey();
                Frame encodingsForParticularColumn = entry.getValue();
                IcedHashMap icedHashMap = ((FrameToTETableTask)((FrameToTETableTask)new FrameToTETableTask().doAll((Frame)encodingsForParticularColumn)).getResult())._table;
            }
        }
        long totalTimeDoAll = System.currentTimeMillis() - startTimeDoAll;
        Log.info((Object[])new Object[]{"Total time doAll:" + totalTimeDoAll});
        long startTimeDFork = System.currentTimeMillis();
        for (int i = 0; i < numberOfIterations; ++i) {
            HashMap<String, FrameToTETableTask> tasks = new HashMap<String, FrameToTETableTask>();
            for (Map.Entry<String, Frame> entry : encodingMap.entrySet()) {
                Frame encodingsForParticularColumn = entry.getValue();
                FrameToTETableTask task = (FrameToTETableTask)new FrameToTETableTask().dfork(encodingsForParticularColumn);
                tasks.put(entry.getKey(), task);
            }
            for (Map.Entry<String, Object> entry : tasks.entrySet()) {
                IcedHashMap icedHashMap = ((FrameToTETableTask)((FrameToTETableTask)entry.getValue()).getResult())._table;
            }
        }
        long totalTimeDFork = System.currentTimeMillis() - startTimeDFork;
        TargetEncoderFrameHelper.encodingMapCleanUp(encodingMap);
        Log.info((Object[])new Object[]{"Total time dfork:" + totalTimeDFork});
        Assert.assertTrue((totalTimeDFork < totalTimeDoAll ? 1 : 0) != 0);
    }
}

