/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.targetencoding;

import ai.h2o.targetencoding.TargetEncoder;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import water.TestUtil;
import water.fvec.Frame;
import water.fvec.TestFrameBuilder;
import water.util.IcedHashMapGeneric;

public class TargetEncodingExceptionsHandlingTest
extends TestUtil {
    private Frame fr = null;

    @BeforeClass
    public static void setup() {
        TargetEncodingExceptionsHandlingTest.stall_till_cloudsize((int)1);
    }

    @Test
    public void exceptionInPrepareEncodingTest() {
        this.fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"ColA", "ColB", "fold_column"}).withVecTypes(new byte[]{4, 4, 3}).withDataForCol(0, TargetEncodingExceptionsHandlingTest.ar((String[])new String[]{"a", "b", "b", "b"})).withDataForCol(1, TargetEncodingExceptionsHandlingTest.ar((String[])new String[]{"2", "6", "6", "6"})).withDataForCol(2, TargetEncodingExceptionsHandlingTest.ar((long[])new long[]{1L, 2L, 2L, 3L})).build();
        String[] teColumns = new String[]{"ColA"};
        String targetColumnName = "ColB";
        String foldColumnName = "fold_column";
        int targetIndex = this.fr.find(targetColumnName);
        TargetEncoder tec = new TargetEncoder(teColumns);
        TargetEncoder tecSpy = (TargetEncoder)Mockito.spy((Object)tec);
        ((TargetEncoder)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalStateException("Fake exception")}).when((Object)tecSpy)).filterOutNAsFromTargetColumn(this.fr, targetIndex);
        IcedHashMapGeneric targetEncodingMap = null;
        try {
            targetEncodingMap = tecSpy.prepareEncodingMap(this.fr, targetColumnName, foldColumnName);
            Assert.fail();
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((Object)"Fake exception", (Object)ex.getMessage());
        }
        if (targetEncodingMap != null) {
            this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
        }
    }

    @Test
    public void exceptionInPrepareEncodingAtTheEndTest() {
        this.fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"ColA", "ColB", "fold_column"}).withVecTypes(new byte[]{4, 4, 3}).withDataForCol(0, TargetEncodingExceptionsHandlingTest.ar((String[])new String[]{"a", "b", "b", "b"})).withDataForCol(1, TargetEncodingExceptionsHandlingTest.ar((String[])new String[]{"2", "6", "6", "6"})).withDataForCol(2, TargetEncodingExceptionsHandlingTest.ar((long[])new long[]{1L, 2L, 2L, 3L})).build();
        String[] teColumns = new String[]{"ColA"};
        String targetColumnName = "ColB";
        String foldColumnName = "fold_column";
        int targetIndex = this.fr.find(targetColumnName);
        TargetEncoder tec = new TargetEncoder(teColumns);
        TargetEncoder tecSpy = (TargetEncoder)Mockito.spy((Object)tec);
        ((TargetEncoder)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalStateException("Fake exception")}).when((Object)tecSpy)).groupThenAggregateForNumeratorAndDenominator((Frame)Mockito.any(Frame.class), (String)Mockito.eq((Object)teColumns[0]), (String)Mockito.eq((Object)foldColumnName), Mockito.eq((int)targetIndex));
        IcedHashMapGeneric targetEncodingMap = null;
        try {
            targetEncodingMap = tecSpy.prepareEncodingMap(this.fr, targetColumnName, foldColumnName);
            Assert.fail();
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((Object)"Fake exception", (Object)ex.getMessage());
        }
        if (targetEncodingMap != null) {
            this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
        }
    }

    @Test
    public void exceptionInApplyEncodingKFOLDInsideCycleTest() {
        this.fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"ColA", "ColB", "fold_column"}).withVecTypes(new byte[]{4, 4, 3}).withDataForCol(0, TargetEncodingExceptionsHandlingTest.ar((String[])new String[]{"a", "b", "b", "b"})).withDataForCol(1, TargetEncodingExceptionsHandlingTest.ar((String[])new String[]{"2", "6", "6", "6"})).withDataForCol(2, TargetEncodingExceptionsHandlingTest.ar((long[])new long[]{1L, 2L, 2L, 3L})).build();
        String[] teColumns = new String[]{"ColA"};
        String targetColumnName = "ColB";
        String foldColumnName = "fold_column";
        TargetEncoder tec = new TargetEncoder(teColumns);
        TargetEncoder tecSpy = (TargetEncoder)Mockito.spy((Object)tec);
        IcedHashMapGeneric targetEncodingMap = tecSpy.prepareEncodingMap(this.fr, targetColumnName, foldColumnName);
        Frame resultWithEncoding = null;
        ((TargetEncoder)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalStateException("Fake exception")}).when((Object)tecSpy)).getOutOfFoldData((Frame)Mockito.any(Frame.class), (String)Mockito.eq((Object)foldColumnName), Mockito.anyLong());
        try {
            resultWithEncoding = tecSpy.applyTargetEncoding(this.fr, targetColumnName, (Map)targetEncodingMap, TargetEncoder.DataLeakageHandlingStrategy.KFold, foldColumnName, false, 0.0, false, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
            Assert.fail();
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((Object)"Fake exception", (Object)ex.getMessage());
        }
        if (resultWithEncoding != null) {
            resultWithEncoding.delete();
        }
        if (targetEncodingMap != null) {
            this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
        }
    }

    @Test
    public void exceptionInApplyEncodingKFOLDTest() {
        this.fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"ColA", "ColB", "fold_column"}).withVecTypes(new byte[]{4, 4, 3}).withDataForCol(0, TargetEncodingExceptionsHandlingTest.ar((String[])new String[]{"a", "b", "b", "b"})).withDataForCol(1, TargetEncodingExceptionsHandlingTest.ar((String[])new String[]{"2", "6", "6", "6"})).withDataForCol(2, TargetEncodingExceptionsHandlingTest.ar((long[])new long[]{1L, 2L, 2L, 3L})).build();
        String[] teColumns = new String[]{"ColA"};
        String targetColumnName = "ColB";
        String foldColumnName = "fold_column";
        TargetEncoder tec = new TargetEncoder(teColumns);
        TargetEncoder tecSpy = (TargetEncoder)Mockito.spy((Object)tec);
        IcedHashMapGeneric targetEncodingMap = tecSpy.prepareEncodingMap(this.fr, targetColumnName, foldColumnName);
        Frame resultWithEncoding = null;
        ((TargetEncoder)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalStateException("Fake exception")}).when((Object)tecSpy)).removeNumeratorAndDenominatorColumns((Frame)Mockito.any(Frame.class));
        try {
            resultWithEncoding = tecSpy.applyTargetEncoding(this.fr, targetColumnName, (Map)targetEncodingMap, TargetEncoder.DataLeakageHandlingStrategy.KFold, foldColumnName, false, 0.0, false, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
            Assert.fail();
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((Object)"Fake exception", (Object)ex.getMessage());
        }
        if (resultWithEncoding != null) {
            resultWithEncoding.delete();
        }
        if (targetEncodingMap != null) {
            this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
        }
    }

    @Test
    public void exceptionIsNotCausingKeysLeakageInApplyEncodingLOOTest() {
        this.fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"ColA", "ColB"}).withVecTypes(new byte[]{4, 4}).withDataForCol(0, TargetEncodingExceptionsHandlingTest.ar((String[])new String[]{"a", "b", "b", "b"})).withDataForCol(1, TargetEncodingExceptionsHandlingTest.ar((String[])new String[]{"2", "6", "6", "6"})).build();
        String[] teColumns = new String[]{"ColA"};
        String targetColumnName = "ColB";
        TargetEncoder tec = new TargetEncoder(teColumns);
        TargetEncoder tecSpy = (TargetEncoder)Mockito.spy((Object)tec);
        IcedHashMapGeneric targetEncodingMap = tecSpy.prepareEncodingMap(this.fr, targetColumnName, null);
        Frame resultWithEncoding = null;
        ((TargetEncoder)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalStateException("Fake exception")}).when((Object)tecSpy)).removeNumeratorAndDenominatorColumns((Frame)Mockito.any(Frame.class));
        try {
            resultWithEncoding = tecSpy.applyTargetEncoding(this.fr, targetColumnName, (Map)targetEncodingMap, TargetEncoder.DataLeakageHandlingStrategy.LeaveOneOut, false, 0.0, false, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
            Assert.fail();
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((Object)"Fake exception", (Object)ex.getMessage());
        }
        if (resultWithEncoding != null) {
            resultWithEncoding.delete();
        }
        if (targetEncodingMap != null) {
            this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
        }
    }

    @Test
    public void exceptionIsNotCausingKeysLeakageInApplyEncodingNoneTest() {
        this.fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"ColA", "ColB"}).withVecTypes(new byte[]{4, 4}).withDataForCol(0, TargetEncodingExceptionsHandlingTest.ar((String[])new String[]{"a", "b", "b", "b"})).withDataForCol(1, TargetEncodingExceptionsHandlingTest.ar((String[])new String[]{"2", "6", "6", "6"})).build();
        String[] teColumns = new String[]{"ColA"};
        String targetColumnName = "ColB";
        TargetEncoder tec = new TargetEncoder(teColumns);
        TargetEncoder tecSpy = (TargetEncoder)Mockito.spy((Object)tec);
        IcedHashMapGeneric targetEncodingMap = tecSpy.prepareEncodingMap(this.fr, targetColumnName, null);
        Frame resultWithEncoding = null;
        ((TargetEncoder)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalStateException("Fake exception")}).when((Object)tecSpy)).removeNumeratorAndDenominatorColumns((Frame)Mockito.any(Frame.class));
        try {
            resultWithEncoding = tecSpy.applyTargetEncoding(this.fr, targetColumnName, (Map)targetEncodingMap, TargetEncoder.DataLeakageHandlingStrategy.None, false, 0.0, false, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
            Assert.fail();
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((Object)"Fake exception", (Object)ex.getMessage());
        }
        if (resultWithEncoding != null) {
            resultWithEncoding.delete();
        }
        if (targetEncodingMap != null) {
            this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
        }
    }

    @After
    public void afterEach() {
        if (this.fr != null) {
            this.fr.delete();
        }
    }

    private void encodingMapCleanUp(Map<String, Frame> encodingMap) {
        for (Map.Entry<String, Frame> map : encodingMap.entrySet()) {
            map.getValue().delete();
        }
    }
}

