/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.targetencoding;

import ai.h2o.targetencoding.BlendingParams;
import ai.h2o.targetencoding.TargetEncoder;
import ai.h2o.targetencoding.TargetEncoderBuilder;
import ai.h2o.targetencoding.TargetEncoderFrameHelper;
import ai.h2o.targetencoding.TargetEncoderModel;
import java.util.Map;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.DKV;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.Scope;
import water.TestUtil;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.TestFrameBuilder;
import water.fvec.Vec;
import water.rapids.Merge;
import water.util.IcedHashMapGeneric;

public class TargetEncoderBuilderTest
extends TestUtil {
    @BeforeClass
    public static void setup() {
        TargetEncoderBuilderTest.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getTargetEncodingMapByTrainingTEBuilder() {
        TargetEncoderModel targetEncoderModel = null;
        IcedHashMapGeneric encodingMapFromTargetEncoder = null;
        IcedHashMapGeneric targetEncodingMapFromBuilder = null;
        Scope.enter();
        try {
            Frame fr = TargetEncoderBuilderTest.parse_test_file((String)"./smalldata/gbm_test/titanic.csv");
            Scope.track((Frame[])new Frame[]{fr});
            String responseColumnName = "survived";
            this.asFactor(fr, responseColumnName);
            BlendingParams params = new BlendingParams(3.0, 1.0);
            Frame.VecSpecifier[] teColumns = new Frame.VecSpecifier[]{new Frame.VecSpecifier(fr._key, "home.dest"), new Frame.VecSpecifier(fr._key, "embarked")};
            TargetEncoderModel.TargetEncoderParameters targetEncoderParameters = new TargetEncoderModel.TargetEncoderParameters();
            targetEncoderParameters._blending = false;
            targetEncoderParameters._response_column = responseColumnName;
            targetEncoderParameters._ignored_columns = TargetEncoderBuilderTest.ignoredColumns((Frame)fr, (String[])new String[]{"home.dest", "embarked", targetEncoderParameters._response_column});
            targetEncoderParameters.setTrain(fr._key);
            TargetEncoderBuilder builder = new TargetEncoderBuilder(targetEncoderParameters);
            targetEncoderModel = (TargetEncoderModel)builder.trainModel().get();
            TargetEncoder tec = new TargetEncoder(Frame.VecSpecifier.vecNames((Frame.VecSpecifier[])teColumns));
            Frame fr2 = TargetEncoderBuilderTest.parse_test_file((String)"./smalldata/gbm_test/titanic.csv");
            this.asFactor(fr2, responseColumnName);
            Scope.track((Frame[])new Frame[]{fr2});
            encodingMapFromTargetEncoder = tec.prepareEncodingMap(fr2, responseColumnName, null);
            targetEncodingMapFromBuilder = ((TargetEncoderModel.TargetEncoderOutput)targetEncoderModel._output)._target_encoding_map;
            this.areEncodingMapsIdentical((Map<String, Frame>)encodingMapFromTargetEncoder, (Map<String, Frame>)targetEncodingMapFromBuilder);
            this.removeEncodingMaps((Map<String, Frame>)encodingMapFromTargetEncoder, (Map<String, Frame>)targetEncodingMapFromBuilder);
        }
        catch (Throwable throwable) {
            this.removeEncodingMaps((Map<String, Frame>)encodingMapFromTargetEncoder, (Map<String, Frame>)targetEncodingMapFromBuilder);
            targetEncoderModel.remove();
            Scope.exit((Key[])new Key[0]);
            throw throwable;
        }
        targetEncoderModel.remove();
        Scope.exit((Key[])new Key[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void teColumnNameToMissingValuesPresenceMapIsComputedCorrectly() {
        TargetEncoderModel targetEncoderModel = null;
        Map<String, Frame> encodingMapFromTargetEncoder = null;
        Map<String, Frame> targetEncodingMapFromBuilder = null;
        Scope.enter();
        try {
            String responseColumnName = "ColB";
            Frame fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"home.dest", "embarked", responseColumnName}).withVecTypes(new byte[]{4, 4, 4}).withDataForCol(0, TargetEncoderBuilderTest.ar((String[])new String[]{"a", "b"})).withDataForCol(1, TargetEncoderBuilderTest.ar((String[])new String[]{"s", null})).withDataForCol(2, TargetEncoderBuilderTest.ar((String[])new String[]{"yes", "no"})).build();
            Frame.VecSpecifier[] teColumns = new Frame.VecSpecifier[]{new Frame.VecSpecifier(fr._key, "home.dest"), new Frame.VecSpecifier(fr._key, "embarked")};
            TargetEncoderModel.TargetEncoderParameters targetEncoderParameters = new TargetEncoderModel.TargetEncoderParameters();
            targetEncoderParameters._blending = false;
            targetEncoderParameters._response_column = responseColumnName;
            targetEncoderParameters._ignored_columns = TargetEncoderBuilderTest.ignoredColumns((Frame)fr, (String[])new String[]{"home.dest", "embarked", targetEncoderParameters._response_column});
            targetEncoderParameters.setTrain(fr._key);
            targetEncoderParameters._ignore_const_cols = false;
            TargetEncoderBuilder builder = new TargetEncoderBuilder(targetEncoderParameters);
            targetEncoderModel = (TargetEncoderModel)builder.trainModel().get();
            IcedHashMapGeneric teColumnNameToMissingValuesPresence = ((TargetEncoderModel.TargetEncoderOutput)targetEncoderModel._output)._column_name_to_missing_val_presence;
            Assert.assertTrue(((Integer)teColumnNameToMissingValuesPresence.get("home.dest") == 0 ? 1 : 0) != 0);
            Assert.assertTrue(((Integer)teColumnNameToMissingValuesPresence.get("embarked") == 1 ? 1 : 0) != 0);
        }
        finally {
            this.removeEncodingMaps(encodingMapFromTargetEncoder, targetEncodingMapFromBuilder);
            if (targetEncoderModel != null) {
                targetEncoderModel.remove();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getTargetEncodingMapByTrainingTEBuilder_KFold_scenario() {
        IcedHashMapGeneric encodingMapFromTargetEncoder = null;
        IcedHashMapGeneric targetEncodingMapFromBuilder = null;
        TargetEncoderModel targetEncoderModel = null;
        Scope.enter();
        try {
            Frame fr = TargetEncoderBuilderTest.parse_test_file((String)"./smalldata/gbm_test/titanic.csv");
            String foldColumnName = "fold_column";
            TargetEncoderFrameHelper.addKFoldColumn((Frame)fr, (String)foldColumnName, (int)5, (long)1234L);
            Scope.track((Frame[])new Frame[]{fr});
            String responseColumnName = "survived";
            this.asFactor(fr, responseColumnName);
            BlendingParams params = new BlendingParams(3.0, 1.0);
            Frame.VecSpecifier[] teColumns = new Frame.VecSpecifier[]{new Frame.VecSpecifier(fr._key, "home.dest"), new Frame.VecSpecifier(fr._key, "embarked")};
            TargetEncoderModel.TargetEncoderParameters targetEncoderParameters = new TargetEncoderModel.TargetEncoderParameters();
            targetEncoderParameters._blending = false;
            targetEncoderParameters._response_column = responseColumnName;
            targetEncoderParameters._fold_column = foldColumnName;
            targetEncoderParameters._ignored_columns = TargetEncoderBuilderTest.ignoredColumns((Frame)fr, (String[])new String[]{"home.dest", "embarked", targetEncoderParameters._response_column, targetEncoderParameters._fold_column});
            targetEncoderParameters.setTrain(fr._key);
            TargetEncoderBuilder builder = new TargetEncoderBuilder(targetEncoderParameters);
            targetEncoderModel = (TargetEncoderModel)builder.trainModel().get();
            TargetEncoder tec = new TargetEncoder(Frame.VecSpecifier.vecNames((Frame.VecSpecifier[])teColumns));
            Frame fr2 = TargetEncoderBuilderTest.parse_test_file((String)"./smalldata/gbm_test/titanic.csv");
            TargetEncoderFrameHelper.addKFoldColumn((Frame)fr2, (String)foldColumnName, (int)5, (long)1234L);
            this.asFactor(fr2, responseColumnName);
            Scope.track((Frame[])new Frame[]{fr2});
            encodingMapFromTargetEncoder = tec.prepareEncodingMap(fr2, responseColumnName, foldColumnName);
            targetEncodingMapFromBuilder = ((TargetEncoderModel.TargetEncoderOutput)targetEncoderModel._output)._target_encoding_map;
            this.areEncodingMapsIdentical((Map<String, Frame>)encodingMapFromTargetEncoder, (Map<String, Frame>)targetEncodingMapFromBuilder);
            this.removeEncodingMaps((Map<String, Frame>)encodingMapFromTargetEncoder, (Map<String, Frame>)targetEncodingMapFromBuilder);
        }
        catch (Throwable throwable) {
            this.removeEncodingMaps((Map<String, Frame>)encodingMapFromTargetEncoder, (Map<String, Frame>)targetEncodingMapFromBuilder);
            targetEncoderModel.remove();
            Scope.exit((Key[])new Key[0]);
            throw throwable;
        }
        targetEncoderModel.remove();
        Scope.exit((Key[])new Key[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void transform_KFold_scenario() {
        IcedHashMapGeneric encodingMapFromTargetEncoder = null;
        IcedHashMapGeneric targetEncodingMapFromBuilder = null;
        TargetEncoderModel targetEncoderModel = null;
        Scope.enter();
        try {
            Frame fr = TargetEncoderBuilderTest.parse_test_file((String)"./smalldata/gbm_test/titanic.csv");
            String foldColumnName = "fold_column";
            TargetEncoderFrameHelper.addKFoldColumn((Frame)fr, (String)foldColumnName, (int)5, (long)1234L);
            Scope.track((Frame[])new Frame[]{fr});
            String responseColumnName = "survived";
            this.asFactor(fr, responseColumnName);
            TargetEncoderModel.TargetEncoderParameters targetEncoderParameters = new TargetEncoderModel.TargetEncoderParameters();
            targetEncoderParameters._blending = false;
            targetEncoderParameters._response_column = responseColumnName;
            targetEncoderParameters._fold_column = foldColumnName;
            targetEncoderParameters._seed = 1234L;
            targetEncoderParameters._ignored_columns = TargetEncoderBuilderTest.ignoredColumns((Frame)fr, (String[])new String[]{"home.dest", "embarked", targetEncoderParameters._response_column, targetEncoderParameters._fold_column});
            targetEncoderParameters._train = fr._key;
            TargetEncoderBuilder builder = new TargetEncoderBuilder(targetEncoderParameters);
            targetEncoderModel = (TargetEncoderModel)builder.trainModel().get();
            Scope.track_generic((Keyed)targetEncoderModel);
            TargetEncoder.DataLeakageHandlingStrategy strategy = TargetEncoder.DataLeakageHandlingStrategy.KFold;
            Frame transformedTrainWithModelFromBuilder = targetEncoderModel.transform(fr, TargetEncoder.DataLeakageHandlingStrategy.KFold.getVal(), false, null, targetEncoderParameters._seed);
            Scope.track((Frame[])new Frame[]{transformedTrainWithModelFromBuilder});
            targetEncodingMapFromBuilder = ((TargetEncoderModel.TargetEncoderOutput)targetEncoderModel._output)._target_encoding_map;
            TargetEncoder tec = new TargetEncoder(new String[]{"embarked", "home.dest"});
            encodingMapFromTargetEncoder = tec.prepareEncodingMap(fr, responseColumnName, foldColumnName, false);
            Frame transformedTrainWithTargetEncoder = tec.applyTargetEncoding(fr, responseColumnName, (Map)encodingMapFromTargetEncoder, strategy, foldColumnName, targetEncoderParameters._blending, false, TargetEncoder.DEFAULT_BLENDING_PARAMS, targetEncoderParameters._seed);
            Scope.track((Frame[])new Frame[]{transformedTrainWithTargetEncoder});
            TargetEncoderBuilderTest.assertBitIdentical((Frame)transformedTrainWithModelFromBuilder, (Frame)transformedTrainWithTargetEncoder);
            this.removeEncodingMaps((Map<String, Frame>)encodingMapFromTargetEncoder, (Map<String, Frame>)targetEncodingMapFromBuilder);
        }
        catch (Throwable throwable) {
            this.removeEncodingMaps((Map<String, Frame>)encodingMapFromTargetEncoder, (Map<String, Frame>)targetEncodingMapFromBuilder);
            Scope.exit((Key[])new Key[0]);
            throw throwable;
        }
        Scope.exit((Key[])new Key[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void columnOrderHasNoEffectWhenNoiseIsZero() {
        try {
            Scope.enter();
            Frame frame = TargetEncoderBuilderTest.parse_test_file((String)"./smalldata/gbm_test/titanic.csv");
            Scope.track((Frame[])new Frame[]{frame});
            this.asFactor(frame, "survived");
            TargetEncoderFrameHelper.addKFoldColumn((Frame)frame, (String)"fold_column", (int)5, (long)1234L);
            RowIndexTask.addRowIndex(frame);
            DKV.put((Keyed)frame);
            TargetEncoder te1 = new TargetEncoder(new String[]{"home.dest", "embarked"});
            IcedHashMapGeneric encodingMap1 = te1.prepareEncodingMap(frame, "survived", "fold_column", false);
            TargetEncoder te2 = new TargetEncoder(new String[]{"embarked", "home.dest"});
            IcedHashMapGeneric encodingMap2 = te2.prepareEncodingMap(frame, "survived", "fold_column", false);
            this.areEncodingMapsIdentical((Map<String, Frame>)encodingMap1, (Map<String, Frame>)encodingMap2);
            Frame te1Result = te1.applyTargetEncoding(frame, "survived", (Map)encodingMap1, TargetEncoder.DataLeakageHandlingStrategy.KFold, "fold_column", false, 0.0, false, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
            Scope.track((Frame[])new Frame[]{te1Result});
            Frame te1ResultSorted = Scope.track((Frame[])new Frame[]{Merge.sort((Frame)te1Result, (int)te1Result.find(RowIndexTask.ROW_INDEX_COL))});
            Frame te2Result = te2.applyTargetEncoding(frame, "survived", (Map)encodingMap2, TargetEncoder.DataLeakageHandlingStrategy.KFold, "fold_column", false, 0.0, false, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
            Scope.track((Frame[])new Frame[]{te2Result});
            Frame te2ResultSorted = Scope.track((Frame[])new Frame[]{Merge.sort((Frame)te2Result, (int)te2Result.find(RowIndexTask.ROW_INDEX_COL))});
            this.removeEncodingMaps((Map<String, Frame>)encodingMap1, (Map<String, Frame>)encodingMap2);
            Frame te2ResultSortedReordered = new Frame(te1ResultSorted.names(), te2ResultSorted.vecs(te1ResultSorted.names()));
            TargetEncoderBuilderTest.assertBitIdentical((Frame)te1ResultSorted, (Frame)te2ResultSortedReordered);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    private void removeEncodingMaps(Map<String, Frame> encodingMapFromTargetEncoder, Map<String, Frame> targetEncodingMapFromBuilder) {
        if (encodingMapFromTargetEncoder != null) {
            TargetEncoderFrameHelper.encodingMapCleanUp(encodingMapFromTargetEncoder);
        }
        if (targetEncodingMapFromBuilder != null) {
            TargetEncoderFrameHelper.encodingMapCleanUp(targetEncodingMapFromBuilder);
        }
    }

    private void areEncodingMapsIdentical(Map<String, Frame> encodingMapFromTargetEncoder, Map<String, Frame> targetEncodingMapFromBuilder) {
        for (Map.Entry<String, Frame> entry : targetEncodingMapFromBuilder.entrySet()) {
            String teColumn = entry.getKey();
            Frame correspondingEncodingFrameFromTargetEncoder = encodingMapFromTargetEncoder.get(teColumn);
            TargetEncoderBuilderTest.assertBitIdentical((Frame)entry.getValue(), (Frame)correspondingEncodingFrameFromTargetEncoder);
        }
    }

    private static class RowIndexTask
    extends MRTask<RowIndexTask> {
        static String ROW_INDEX_COL = "__row_index";

        private RowIndexTask() {
        }

        public void map(Chunk c, NewChunk nc) {
            long start = c.start();
            for (int i = 0; i < c._len; ++i) {
                nc.addNum((double)(start + (long)i));
            }
        }

        private static void addRowIndex(Frame f) {
            Vec indexVec = ((RowIndexTask)new RowIndexTask().doAll((byte)3, new Vec[]{f.anyVec()})).outputFrame().anyVec();
            f.insertVec(0, ROW_INDEX_COL, indexVec);
        }
    }
}

