/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.targetencoding;

import ai.h2o.targetencoding.BlendingParams;
import ai.h2o.targetencoding.TargetEncoderBuilder;
import ai.h2o.targetencoding.TargetEncoderFrameHelper;
import ai.h2o.targetencoding.TargetEncoderModel;
import com.pholser.junit.quickcheck.Property;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.runner.JUnitQuickcheck;
import hex.genmodel.GenModel;
import hex.genmodel.MojoModel;
import hex.genmodel.algos.targetencoder.EncodingMap;
import hex.genmodel.algos.targetencoder.EncodingMaps;
import hex.genmodel.algos.targetencoder.TargetEncoderMojoModel;
import hex.genmodel.easy.EasyPredictModelWrapper;
import hex.genmodel.easy.RowData;
import hex.genmodel.easy.exception.PredictException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Random;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import water.DKV;
import water.Key;
import water.Keyed;
import water.Scope;
import water.TestUtil;
import water.fvec.Frame;
import water.fvec.TestFrameBuilder;
import water.util.ArrayUtils;
import water.util.IcedHashMapGeneric;
import water.util.Log;

@RunWith(value=JUnitQuickcheck.class)
public class TEMojoIntegrationTest
extends TestUtil {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @BeforeClass
    public static void setup() {
        TEMojoIntegrationTest.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void withoutBlending() throws PredictException, IOException {
        String mojoFileName = "mojo_te.zip";
        File mojoFile = this.folder.newFile(mojoFileName);
        TargetEncoderModel targetEncoderModel = null;
        Scope.enter();
        try {
            Frame fr = TEMojoIntegrationTest.parse_test_file((String)"./smalldata/gbm_test/titanic.csv");
            String responseColumnName = "survived";
            this.asFactor(fr, responseColumnName);
            Scope.track((Frame[])new Frame[]{fr});
            TargetEncoderModel.TargetEncoderParameters targetEncoderParameters = new TargetEncoderModel.TargetEncoderParameters();
            targetEncoderParameters._response_column = responseColumnName;
            targetEncoderParameters._ignored_columns = TEMojoIntegrationTest.ignoredColumns((Frame)fr, (String[])new String[]{"home.dest", "embarked", targetEncoderParameters._response_column});
            targetEncoderParameters._ignore_const_cols = false;
            targetEncoderParameters.setTrain(fr._key);
            TargetEncoderBuilder targetEncoderBuilder = new TargetEncoderBuilder(targetEncoderParameters);
            targetEncoderBuilder.trainModel().get();
            targetEncoderModel = targetEncoderBuilder.getTargetEncoderModel();
            Scope.track_generic((Keyed)targetEncoderModel);
            try (FileOutputStream modelOutput = new FileOutputStream(mojoFile);){
                targetEncoderModel.getMojo().writeTo((OutputStream)modelOutput);
                System.out.println("Model has been written down to a file as a mojo: " + mojoFileName);
            }
            TargetEncoderMojoModel loadedMojoModel = (TargetEncoderMojoModel)MojoModel.load((String)mojoFile.getPath());
            EasyPredictModelWrapper teModelWrapper = new EasyPredictModelWrapper((GenModel)loadedMojoModel);
            RowData rowToPredictFor = new RowData();
            String homeDestFactorValue = "Montreal  PQ / Chesterville  ON";
            String embarkedFactorValue = "S";
            rowToPredictFor.put((Object)"home.dest", (Object)homeDestFactorValue);
            rowToPredictFor.put((Object)"sex", (Object)"female");
            rowToPredictFor.put((Object)"age", (Object)"2.0");
            rowToPredictFor.put((Object)"fare", (Object)"151.55");
            rowToPredictFor.put((Object)"cabin", (Object)"C22 C26");
            rowToPredictFor.put((Object)"embarked", (Object)embarkedFactorValue);
            rowToPredictFor.put((Object)"sibsp", (Object)"1");
            rowToPredictFor.put((Object)"parch", (Object)"2");
            rowToPredictFor.put((Object)"name", (Object)"1111");
            rowToPredictFor.put((Object)"ticket", (Object)"12345");
            rowToPredictFor.put((Object)"boat", (Object)"2");
            rowToPredictFor.put((Object)"body", (Object)"123");
            rowToPredictFor.put((Object)"pclass", (Object)"1");
            double[] currentEncodings = teModelWrapper.transformWithTargetEncoding((RowData)rowToPredictFor).transformations;
            EncodingMaps targetEncodingMap = loadedMojoModel._targetEncodingMap;
            double encodingForHomeDest = this.checkEncodingsByFactorValue(fr, homeDestFactorValue, targetEncodingMap, "home.dest");
            double encodingForHomeEmbarked = this.checkEncodingsByFactorValue(fr, embarkedFactorValue, targetEncodingMap, "embarked");
            int currentHomeDestPredIdx = fr.find("home.dest") < fr.find("embarked") ? 0 : 1;
            Assert.assertEquals((double)currentEncodings[currentHomeDestPredIdx], (double)encodingForHomeDest, (double)1.0E-5);
            Assert.assertEquals((double)currentEncodings[currentHomeDestPredIdx == 0 ? 1 : 0], (double)encodingForHomeEmbarked, (double)1.0E-5);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void transformation_consistency_test() throws PredictException, IOException {
        Random rg = new Random();
        double[] encodings = null;
        int homeDestPredIdx = -1;
        String mojoFileName = "mojo_te.zip";
        File mojoFile = null;
        int inconsistencyCounter = 0;
        int numberOfRuns = 50;
        for (int i = 0; i <= numberOfRuns; ++i) {
            TargetEncoderModel targetEncoderModel = null;
            mojoFile = this.folder.newFile(mojoFileName);
            Scope.enter();
            try {
                Frame fr = TEMojoIntegrationTest.parse_test_file((String)"./smalldata/gbm_test/titanic.csv");
                String responseColumnName = "survived";
                this.asFactor(fr, responseColumnName);
                Scope.track((Frame[])new Frame[]{fr});
                int swapIdx1 = rg.nextInt(fr.numCols());
                int swapIdx2 = rg.nextInt(fr.numCols());
                fr.swap(swapIdx1, swapIdx2);
                DKV.put((Keyed)fr);
                Frame.VecSpecifier[] teColumns = new Frame.VecSpecifier[]{new Frame.VecSpecifier(fr._key, "home.dest"), new Frame.VecSpecifier(fr._key, "embarked")};
                TargetEncoderModel.TargetEncoderParameters targetEncoderParameters = new TargetEncoderModel.TargetEncoderParameters();
                targetEncoderParameters._response_column = responseColumnName;
                targetEncoderParameters._ignored_columns = TEMojoIntegrationTest.ignoredColumns((Frame)fr, (String[])new String[]{"home.dest", "embarked", targetEncoderParameters._response_column});
                targetEncoderParameters._ignore_const_cols = false;
                targetEncoderParameters.setTrain(fr._key);
                TargetEncoderBuilder targetEncoderBuilder = new TargetEncoderBuilder(targetEncoderParameters);
                targetEncoderBuilder.trainModel().get();
                targetEncoderModel = targetEncoderBuilder.getTargetEncoderModel();
                Scope.track_generic((Keyed)targetEncoderModel);
                try (FileOutputStream modelOutput = new FileOutputStream(mojoFile);){
                    targetEncoderModel.getMojo().writeTo((OutputStream)modelOutput);
                    System.out.println("Model has been written down to a file as a mojo: " + mojoFileName);
                }
                EasyPredictModelWrapper teModelWrapper = null;
                TargetEncoderMojoModel loadedMojoModel = (TargetEncoderMojoModel)MojoModel.load((String)mojoFile.getPath());
                teModelWrapper = new EasyPredictModelWrapper((GenModel)loadedMojoModel);
                RowData rowToPredictFor = new RowData();
                String homeDestFactorValue = "Montreal  PQ / Chesterville  ON";
                String embarkedFactorValue = "S";
                rowToPredictFor.put((Object)"home.dest", (Object)homeDestFactorValue);
                rowToPredictFor.put((Object)"sex", (Object)"female");
                rowToPredictFor.put((Object)"age", (Object)"2.0");
                rowToPredictFor.put((Object)"fare", (Object)"151.55");
                rowToPredictFor.put((Object)"cabin", (Object)"C22 C26");
                rowToPredictFor.put((Object)"embarked", (Object)embarkedFactorValue);
                rowToPredictFor.put((Object)"sibsp", (Object)"1");
                rowToPredictFor.put((Object)"parch", (Object)"2");
                rowToPredictFor.put((Object)"name", (Object)"1111");
                rowToPredictFor.put((Object)"ticket", (Object)"12345");
                rowToPredictFor.put((Object)"boat", (Object)"2");
                rowToPredictFor.put((Object)"body", (Object)"123");
                rowToPredictFor.put((Object)"pclass", (Object)"1");
                if (encodings == null) {
                    encodings = teModelWrapper.transformWithTargetEncoding((RowData)rowToPredictFor).transformations;
                    homeDestPredIdx = fr.find("home.dest") < fr.find("embarked") ? 0 : 1;
                    continue;
                }
                double[] currentEncodings = teModelWrapper.transformWithTargetEncoding((RowData)rowToPredictFor).transformations;
                int currentHomeDestPredIdx = fr.find("home.dest") < fr.find("embarked") ? 0 : 1;
                inconsistencyCounter += this.isEqualToReferenceValue(encodings, homeDestPredIdx, swapIdx1, swapIdx2, currentEncodings, currentHomeDestPredIdx) != false ? 0 : 1;
                continue;
            }
            finally {
                mojoFile.delete();
                Scope.exit((Key[])new Key[0]);
            }
        }
        Assert.assertEquals((String)("Transformation failed " + inconsistencyCounter + " times out of " + numberOfRuns + " runs"), (long)0L, (long)inconsistencyCounter);
    }

    private double checkEncodingsByFactorValue(Frame fr, String homeDestFactorValue, EncodingMaps targetEncodingMap, String teColumn) {
        int factorIndex = ArrayUtils.find((Object[])fr.vec(teColumn).domain(), (Object)homeDestFactorValue);
        int[] encodingComponents = targetEncodingMap.get(teColumn).get(factorIndex);
        return (double)encodingComponents[0] / (double)encodingComponents[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void without_blending_kfold_scenario() throws PredictException, IOException {
        String mojoFileName = "mojo_te.zip";
        File mojoFile = this.folder.newFile(mojoFileName);
        TargetEncoderModel targetEncoderModel = null;
        Scope.enter();
        try {
            Frame fr = TEMojoIntegrationTest.parse_test_file((String)"./smalldata/gbm_test/titanic.csv");
            String responseColumnName = "survived";
            this.asFactor(fr, responseColumnName);
            String foldColumnName = "fold_column";
            TargetEncoderFrameHelper.addKFoldColumn((Frame)fr, (String)foldColumnName, (int)5, (long)1234L);
            Scope.track((Frame[])new Frame[]{fr});
            Frame.VecSpecifier[] teColumns = new Frame.VecSpecifier[]{new Frame.VecSpecifier(fr._key, "home.dest"), new Frame.VecSpecifier(fr._key, "embarked")};
            TargetEncoderModel.TargetEncoderParameters targetEncoderParameters = new TargetEncoderModel.TargetEncoderParameters();
            targetEncoderParameters._fold_column = foldColumnName;
            targetEncoderParameters._response_column = responseColumnName;
            targetEncoderParameters._ignored_columns = TEMojoIntegrationTest.ignoredColumns((Frame)fr, (String[])new String[]{"home.dest", "embarked", targetEncoderParameters._fold_column, targetEncoderParameters._response_column});
            targetEncoderParameters.setTrain(fr._key);
            targetEncoderParameters._ignore_const_cols = false;
            TargetEncoderBuilder job = new TargetEncoderBuilder(targetEncoderParameters);
            job.trainModel().get();
            targetEncoderModel = job.getTargetEncoderModel();
            Scope.track_generic((Keyed)targetEncoderModel);
            try (FileOutputStream modelOutput = new FileOutputStream(mojoFile);){
                targetEncoderModel.getMojo().writeTo((OutputStream)modelOutput);
                System.out.println("Model has been written down to a file as a mojo: " + mojoFileName);
            }
            EasyPredictModelWrapper teModelWrapper = null;
            TargetEncoderMojoModel loadedMojoModel = (TargetEncoderMojoModel)MojoModel.load((String)mojoFile.getPath());
            teModelWrapper = new EasyPredictModelWrapper((GenModel)loadedMojoModel);
            RowData rowToPredictFor = new RowData();
            String homeDestFactorValue = "Montreal  PQ / Chesterville  ON";
            String embarkedFactorValue = "S";
            rowToPredictFor.put((Object)"home.dest", (Object)homeDestFactorValue);
            rowToPredictFor.put((Object)"sex", (Object)"female");
            rowToPredictFor.put((Object)"age", (Object)"2.0");
            rowToPredictFor.put((Object)"fare", (Object)"151.55");
            rowToPredictFor.put((Object)"cabin", (Object)"C22 C26");
            rowToPredictFor.put((Object)"embarked", (Object)embarkedFactorValue);
            rowToPredictFor.put((Object)"sibsp", (Object)"1");
            rowToPredictFor.put((Object)"parch", (Object)"2");
            rowToPredictFor.put((Object)"name", (Object)"1111");
            rowToPredictFor.put((Object)"ticket", (Object)"12345");
            rowToPredictFor.put((Object)"boat", (Object)"2");
            rowToPredictFor.put((Object)"body", (Object)"123");
            rowToPredictFor.put((Object)"pclass", (Object)"1");
            double[] encodings = teModelWrapper.transformWithTargetEncoding((RowData)rowToPredictFor).transformations;
            EncodingMaps targetEncodingMap = loadedMojoModel._targetEncodingMap;
            double encodingForHomeDest = this.checkEncodingsByFactorValue(fr, homeDestFactorValue, targetEncodingMap, "home.dest");
            double encodingForHomeEmbarked = this.checkEncodingsByFactorValue(fr, embarkedFactorValue, targetEncodingMap, "embarked");
            Assert.assertEquals((double)encodings[1], (double)encodingForHomeDest, (double)1.0E-5);
            Assert.assertEquals((double)encodings[0], (double)encodingForHomeEmbarked, (double)1.0E-5);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void check_that_encoding_map_was_stored_and_loaded_properly_and_blending_was_applied_correctly() throws IOException, PredictException {
        String mojoFileName = "mojo_te.zip";
        File mojoFile = this.folder.newFile(mojoFileName);
        IcedHashMapGeneric testEncodingMap = null;
        TargetEncoderModel targetEncoderModel = null;
        Scope.enter();
        try {
            Frame fr = TEMojoIntegrationTest.parse_test_file((String)"./smalldata/gbm_test/titanic.csv");
            String responseColumnName = "survived";
            this.asFactor(fr, responseColumnName);
            Scope.track((Frame[])new Frame[]{fr});
            Frame.VecSpecifier[] teColumns = new Frame.VecSpecifier[]{new Frame.VecSpecifier(fr._key, "home.dest"), new Frame.VecSpecifier(fr._key, "embarked")};
            TargetEncoderModel.TargetEncoderParameters targetEncoderParameters = new TargetEncoderModel.TargetEncoderParameters();
            targetEncoderParameters._blending = true;
            targetEncoderParameters._response_column = responseColumnName;
            targetEncoderParameters._ignored_columns = TEMojoIntegrationTest.ignoredColumns((Frame)fr, (String[])new String[]{"home.dest", "embarked", targetEncoderParameters._response_column});
            targetEncoderParameters._ignore_const_cols = false;
            targetEncoderParameters.setTrain(fr._key);
            TargetEncoderBuilder job = new TargetEncoderBuilder(targetEncoderParameters);
            job.trainModel().get();
            targetEncoderModel = job.getTargetEncoderModel();
            Scope.track_generic((Keyed)targetEncoderModel);
            testEncodingMap = ((TargetEncoderModel.TargetEncoderOutput)targetEncoderModel._output)._target_encoding_map;
            try (FileOutputStream modelOutput = new FileOutputStream(mojoFile);){
                targetEncoderModel.getMojo().writeTo((OutputStream)modelOutput);
                System.out.println("Model has been written down to a file as a mojo: " + mojoFileName);
            }
            EasyPredictModelWrapper teModelWrapper = null;
            TargetEncoderMojoModel loadedMojoModel = (TargetEncoderMojoModel)MojoModel.load((String)mojoFile.getPath());
            teModelWrapper = new EasyPredictModelWrapper((GenModel)loadedMojoModel);
            RowData rowToPredictFor = new RowData();
            String homeDestFactorValue = "Montreal  PQ / Chesterville  ON";
            String embarkedFactorValue = "S";
            rowToPredictFor.put((Object)"home.dest", (Object)homeDestFactorValue);
            rowToPredictFor.put((Object)"sex", (Object)"female");
            rowToPredictFor.put((Object)"age", (Object)"2.0");
            rowToPredictFor.put((Object)"fare", (Object)"151.55");
            rowToPredictFor.put((Object)"cabin", (Object)"C22 C26");
            rowToPredictFor.put((Object)"embarked", (Object)embarkedFactorValue);
            rowToPredictFor.put((Object)"sibsp", (Object)"1");
            rowToPredictFor.put((Object)"parch", (Object)"2");
            rowToPredictFor.put((Object)"name", (Object)"1111");
            rowToPredictFor.put((Object)"ticket", (Object)"12345");
            rowToPredictFor.put((Object)"boat", (Object)"2");
            rowToPredictFor.put((Object)"body", (Object)"123");
            rowToPredictFor.put((Object)"pclass", (Object)"1");
            double[] encodings = teModelWrapper.transformWithTargetEncoding((RowData)rowToPredictFor).transformations;
            EncodingMaps encodingMapConvertedFromFrame = TargetEncoderFrameHelper.convertEncodingMapFromFrameToMap((Map)testEncodingMap);
            String teColumn = "home.dest";
            EncodingMap homeDestEncodingMap = encodingMapConvertedFromFrame.get(teColumn);
            Assert.assertEquals((double)((TargetEncoderModel.TargetEncoderOutput)targetEncoderModel._output)._prior_mean, (double)loadedMojoModel._priorMean, (double)1.0E-5);
            double expectedPriorMean = loadedMojoModel._priorMean;
            int homeDestIndex = ArrayUtils.find((Object[])fr.vec(teColumn).domain(), (Object)homeDestFactorValue);
            int[] encodingComponentsForHomeDest = homeDestEncodingMap.get(homeDestIndex);
            double posteriorMean = (double)encodingComponentsForHomeDest[0] / (double)encodingComponentsForHomeDest[1];
            double expectedLambda = TargetEncoderMojoModel.computeLambda((int)encodingComponentsForHomeDest[1], (double)targetEncoderParameters._k, (double)targetEncoderParameters._f);
            double expectedBlendedEncodingForHomeDest = TargetEncoderMojoModel.computeBlendedEncoding((double)expectedLambda, (double)posteriorMean, (double)expectedPriorMean);
            Assert.assertEquals((double)expectedBlendedEncodingForHomeDest, (double)encodings[1], (double)1.0E-5);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void check_that_encodings_for_unexpected_values_are_the_same_in_TargetEncoderModel_and_TargetEncoderMojoModel_big_inflection_point() throws IOException, PredictException {
        String mojoFileName = "mojo_te.zip";
        File mojoFile = this.folder.newFile(mojoFileName);
        TargetEncoderModel targetEncoderModel = null;
        Scope.enter();
        try {
            Frame fr = TEMojoIntegrationTest.parse_test_file((String)"./smalldata/gbm_test/titanic.csv");
            String responseColumnName = "survived";
            this.asFactor(fr, responseColumnName);
            Scope.track((Frame[])new Frame[]{fr});
            TargetEncoderModel.TargetEncoderParameters targetEncoderParameters = new TargetEncoderModel.TargetEncoderParameters();
            targetEncoderParameters._response_column = responseColumnName;
            targetEncoderParameters._ignored_columns = TEMojoIntegrationTest.ignoredColumns((Frame)fr, (String[])new String[]{"home.dest", targetEncoderParameters._response_column});
            targetEncoderParameters._blending = true;
            int inflectionPoint = 600;
            targetEncoderParameters._k = inflectionPoint;
            targetEncoderParameters._f = 1.0;
            targetEncoderParameters._ignore_const_cols = false;
            targetEncoderParameters.setTrain(fr._key);
            TargetEncoderBuilder job = new TargetEncoderBuilder(targetEncoderParameters);
            job.trainModel().get();
            targetEncoderModel = job.getTargetEncoderModel();
            Scope.track_generic((Keyed)targetEncoderModel);
            try (FileOutputStream modelOutput = new FileOutputStream(mojoFile);){
                targetEncoderModel.getMojo().writeTo((OutputStream)modelOutput);
                System.out.println("Model has been written down to a file as a mojo: " + mojoFileName);
            }
            EasyPredictModelWrapper teModelWrapper = null;
            TargetEncoderMojoModel loadedMojoModel = (TargetEncoderMojoModel)MojoModel.load((String)mojoFile.getPath());
            teModelWrapper = new EasyPredictModelWrapper((GenModel)loadedMojoModel);
            RowData rowToPredictFor = new RowData();
            rowToPredictFor.put((Object)"home.dest", (Object)Double.NaN);
            double[] encodingsFromMojoModel = teModelWrapper.transformWithTargetEncoding((RowData)rowToPredictFor).transformations;
            byte noneHoldoutStrategy = 2;
            Frame withNullFrame = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"home.dest"}).withVecTypes(new byte[]{4}).withDataForCol(0, TEMojoIntegrationTest.ar((String[])new String[]{null})).build();
            BlendingParams blendingParams = new BlendingParams(targetEncoderParameters._k, targetEncoderParameters._f);
            Frame encodingsFromTargetEncoderModel = targetEncoderModel.transform(withNullFrame, noneHoldoutStrategy, 0.0, true, blendingParams, 1234L);
            Scope.track((Frame[])new Frame[]{encodingsFromTargetEncoderModel});
            Assert.assertEquals((double)encodingsFromMojoModel[0], (double)encodingsFromTargetEncoderModel.vec("home.dest_te").at(0L), (double)1.0E-5);
            Frame withUnseenLevelFrame = new TestFrameBuilder().withName("testFrame2").withColNames(new String[]{"home.dest"}).withVecTypes(new byte[]{4}).withDataForCol(0, TEMojoIntegrationTest.ar((String[])new String[]{"xxx"})).build();
            Frame encodingsFromTEModelForUnseenLevel = targetEncoderModel.transform(withUnseenLevelFrame, noneHoldoutStrategy, 0.0, true, blendingParams, 1234L);
            Scope.track((Frame[])new Frame[]{encodingsFromTEModelForUnseenLevel});
            Assert.assertEquals((double)encodingsFromMojoModel[0], (double)encodingsFromTEModelForUnseenLevel.vec("home.dest_te").at(0L), (double)1.0E-5);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void check_that_encodings_for_unexpected_values_are_the_same_in_TargetEncoderModel_and_TargetEncoderMojoModel_small_inflection_point() throws IOException, PredictException {
        String mojoFileName = "mojo_te.zip";
        File mojoFile = this.folder.newFile(mojoFileName);
        TargetEncoderModel targetEncoderModel = null;
        Scope.enter();
        try {
            Frame fr = TEMojoIntegrationTest.parse_test_file((String)"./smalldata/gbm_test/titanic.csv");
            String responseColumnName = "survived";
            this.asFactor(fr, responseColumnName);
            Scope.track((Frame[])new Frame[]{fr});
            TargetEncoderModel.TargetEncoderParameters targetEncoderParameters = new TargetEncoderModel.TargetEncoderParameters();
            targetEncoderParameters._response_column = responseColumnName;
            targetEncoderParameters._ignored_columns = TEMojoIntegrationTest.ignoredColumns((Frame)fr, (String[])new String[]{"home.dest", targetEncoderParameters._response_column});
            targetEncoderParameters._blending = true;
            int inflectionPoint = 5;
            targetEncoderParameters._k = inflectionPoint;
            targetEncoderParameters._f = 1.0;
            targetEncoderParameters._ignore_const_cols = false;
            targetEncoderParameters.setTrain(fr._key);
            TargetEncoderBuilder job = new TargetEncoderBuilder(targetEncoderParameters);
            job.trainModel().get();
            targetEncoderModel = job.getTargetEncoderModel();
            Scope.track_generic((Keyed)targetEncoderModel);
            try (FileOutputStream modelOutput = new FileOutputStream(mojoFile);){
                targetEncoderModel.getMojo().writeTo((OutputStream)modelOutput);
                System.out.println("Model has been written down to a file as a mojo: " + mojoFileName);
            }
            EasyPredictModelWrapper teModelWrapper = null;
            TargetEncoderMojoModel loadedMojoModel = (TargetEncoderMojoModel)MojoModel.load((String)mojoFile.getPath());
            teModelWrapper = new EasyPredictModelWrapper((GenModel)loadedMojoModel);
            RowData rowToPredictFor = new RowData();
            rowToPredictFor.put((Object)"home.dest", (Object)Double.NaN);
            double[] encodingsFromMojoModel = teModelWrapper.transformWithTargetEncoding((RowData)rowToPredictFor).transformations;
            byte noneHoldoutStrategy = 2;
            Frame withNullFrame = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"home.dest"}).withVecTypes(new byte[]{4}).withDataForCol(0, TEMojoIntegrationTest.ar((String[])new String[]{null})).build();
            BlendingParams blendingParams = new BlendingParams(targetEncoderParameters._k, targetEncoderParameters._f);
            Frame encodingsFromTargetEncoderModel = targetEncoderModel.transform(withNullFrame, noneHoldoutStrategy, 0.0, true, blendingParams, 1234L);
            Scope.track((Frame[])new Frame[]{encodingsFromTargetEncoderModel});
            Assert.assertEquals((double)encodingsFromMojoModel[0], (double)encodingsFromTargetEncoderModel.vec("home.dest_te").at(0L), (double)1.0E-5);
            Frame withUnseenLevelFrame = new TestFrameBuilder().withName("testFrame2").withColNames(new String[]{"home.dest"}).withVecTypes(new byte[]{4}).withDataForCol(0, TEMojoIntegrationTest.ar((String[])new String[]{"xxx"})).build();
            Frame encodingsFromTEModelForUnseenLevel = targetEncoderModel.transform(withUnseenLevelFrame, noneHoldoutStrategy, 0.0, true, blendingParams, 1234L);
            Scope.track((Frame[])new Frame[]{encodingsFromTEModelForUnseenLevel});
            Assert.assertEquals((double)encodingsFromMojoModel[0], (double)encodingsFromTEModelForUnseenLevel.vec("home.dest_te").at(0L), (double)1.0E-5);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Property(trials=5)
    public void check_that_encodings_with_blending_are_the_same_in_TargetEncoderModel_and_TargetEncoderMojoModel(@InRange(minInt=1, maxInt=1000) @InRange(minInt=1, maxInt=1000) int randomInflectionPoint) throws IOException, PredictException {
        String mojoFileName = "mojo_te.zip";
        File mojoFile = this.folder.newFile(mojoFileName);
        TargetEncoderModel targetEncoderModel = null;
        Scope.enter();
        try {
            Frame fr = TEMojoIntegrationTest.parse_test_file((String)"./smalldata/gbm_test/titanic.csv");
            String responseColumnName = "survived";
            this.asFactor(fr, responseColumnName);
            Scope.track((Frame[])new Frame[]{fr});
            TargetEncoderModel.TargetEncoderParameters targetEncoderParameters = new TargetEncoderModel.TargetEncoderParameters();
            targetEncoderParameters._response_column = responseColumnName;
            targetEncoderParameters._ignored_columns = TEMojoIntegrationTest.ignoredColumns((Frame)fr, (String[])new String[]{"home.dest", targetEncoderParameters._response_column});
            targetEncoderParameters._blending = true;
            targetEncoderParameters._k = randomInflectionPoint;
            targetEncoderParameters._f = 1.0;
            targetEncoderParameters._ignore_const_cols = false;
            targetEncoderParameters.setTrain(fr._key);
            TargetEncoderBuilder job = new TargetEncoderBuilder(targetEncoderParameters);
            job.trainModel().get();
            targetEncoderModel = job.getTargetEncoderModel();
            Scope.track_generic((Keyed)targetEncoderModel);
            try (FileOutputStream modelOutput = new FileOutputStream(mojoFile);){
                targetEncoderModel.getMojo().writeTo((OutputStream)modelOutput);
                System.out.println("Model has been written down to a file as a mojo: " + mojoFileName);
            }
            EasyPredictModelWrapper teModelWrapper = null;
            TargetEncoderMojoModel loadedMojoModel = (TargetEncoderMojoModel)MojoModel.load((String)mojoFile.getPath());
            teModelWrapper = new EasyPredictModelWrapper((GenModel)loadedMojoModel);
            RowData rowToPredictFor = new RowData();
            rowToPredictFor.put((Object)"home.dest", (Object)"Southampton");
            double[] encodingsFromMojoModel = teModelWrapper.transformWithTargetEncoding((RowData)rowToPredictFor).transformations;
            byte noneHoldoutStrategy = 2;
            Frame withNullFrame = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"home.dest"}).withVecTypes(new byte[]{4}).withDataForCol(0, TEMojoIntegrationTest.ar((String[])new String[]{"Southampton"})).build();
            BlendingParams blendingParams = new BlendingParams(targetEncoderParameters._k, targetEncoderParameters._f);
            Frame encodingsFromTargetEncoderModel = targetEncoderModel.transform(withNullFrame, noneHoldoutStrategy, 0.0, true, blendingParams, 1234L);
            Scope.track((Frame[])new Frame[]{encodingsFromTargetEncoderModel});
            double predictionFromTEModel = encodingsFromTargetEncoderModel.vec("home.dest_te").at(0L);
            double predictionFromMojo = encodingsFromMojoModel[0];
            Assert.assertEquals((double)predictionFromMojo, (double)predictionFromTEModel, (double)1.0E-5);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void check_that_we_can_remove_model() {
        Scope.enter();
        try {
            Frame fr = TEMojoIntegrationTest.parse_test_file((String)"./smalldata/gbm_test/titanic.csv");
            String responseColumnName = "survived";
            this.asFactor(fr, responseColumnName);
            Scope.track((Frame[])new Frame[]{fr});
            TargetEncoderModel.TargetEncoderParameters targetEncoderParameters = new TargetEncoderModel.TargetEncoderParameters();
            targetEncoderParameters._response_column = responseColumnName;
            targetEncoderParameters._ignored_columns = TEMojoIntegrationTest.ignoredColumns((Frame)fr, (String[])new String[]{"home.dest", "embarked", targetEncoderParameters._response_column});
            targetEncoderParameters._blending = true;
            targetEncoderParameters._k = 5.0;
            targetEncoderParameters._f = 1.0;
            targetEncoderParameters._ignore_const_cols = false;
            targetEncoderParameters.setTrain(fr._key);
            TargetEncoderBuilder targetEncoderBuilder = new TargetEncoderBuilder(targetEncoderParameters);
            targetEncoderBuilder.trainModel().get();
            TargetEncoderModel targetEncoderModel = targetEncoderBuilder.getTargetEncoderModel();
            targetEncoderModel.remove();
            Assert.assertEquals((long)0L, (long)((Frame)((TargetEncoderModel.TargetEncoderOutput)targetEncoderModel._output)._target_encoding_map.get((Object)"embarked")).byteSize());
            Assert.assertEquals((long)0L, (long)((Frame)((TargetEncoderModel.TargetEncoderOutput)targetEncoderModel._output)._target_encoding_map.get((Object)"home.dest")).byteSize());
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void check_that_we_can_transform_dataframe_that_contains_only_columns_for_encoding() throws PredictException, IOException {
        String mojoFileName = "mojo_te.zip";
        File mojoFile = this.folder.newFile(mojoFileName);
        TargetEncoderModel targetEncoderModel = null;
        Scope.enter();
        try {
            Frame fr = TEMojoIntegrationTest.parse_test_file((String)"./smalldata/gbm_test/titanic.csv");
            String responseColumnName = "survived";
            this.asFactor(fr, responseColumnName);
            Scope.track((Frame[])new Frame[]{fr});
            Frame.VecSpecifier[] teColumns = new Frame.VecSpecifier[]{new Frame.VecSpecifier(fr._key, "home.dest"), new Frame.VecSpecifier(fr._key, "embarked")};
            TargetEncoderModel.TargetEncoderParameters targetEncoderParameters = new TargetEncoderModel.TargetEncoderParameters();
            targetEncoderParameters._blending = false;
            targetEncoderParameters._response_column = responseColumnName;
            targetEncoderParameters._ignored_columns = TEMojoIntegrationTest.ignoredColumns((Frame)fr, (String[])new String[]{"home.dest", "embarked", responseColumnName});
            targetEncoderParameters._ignore_const_cols = false;
            targetEncoderParameters.setTrain(fr._key);
            TargetEncoderBuilder targetEncoderBuilder = new TargetEncoderBuilder(targetEncoderParameters);
            targetEncoderBuilder.trainModel().get();
            targetEncoderModel = targetEncoderBuilder.getTargetEncoderModel();
            Scope.track_generic((Keyed)targetEncoderModel);
            try (FileOutputStream modelOutput = new FileOutputStream(mojoFile);){
                targetEncoderModel.getMojo().writeTo((OutputStream)modelOutput);
                System.out.println("Model has been written down to a file as a mojo: " + mojoFileName);
            }
            EasyPredictModelWrapper teModelWrapper = null;
            TargetEncoderMojoModel loadedMojoModel = (TargetEncoderMojoModel)MojoModel.load((String)mojoFile.getPath());
            teModelWrapper = new EasyPredictModelWrapper((GenModel)loadedMojoModel);
            RowData rowToPredictFor = new RowData();
            String homeDestFactorValue = "Montreal  PQ / Chesterville  ON";
            String embarkedFactorValue = "S";
            rowToPredictFor.put((Object)"home.dest", (Object)homeDestFactorValue);
            rowToPredictFor.put((Object)"embarked", (Object)embarkedFactorValue);
            double[] currentEncodings = teModelWrapper.transformWithTargetEncoding((RowData)rowToPredictFor).transformations;
            EncodingMaps targetEncodingMap = loadedMojoModel._targetEncodingMap;
            double encodingForHomeDest = this.checkEncodingsByFactorValue(fr, homeDestFactorValue, targetEncodingMap, "home.dest");
            double encodingForHomeEmbarked = this.checkEncodingsByFactorValue(fr, embarkedFactorValue, targetEncodingMap, "embarked");
            int currentHomeDestPredIdx = fr.find("home.dest") < fr.find("embarked") ? 0 : 1;
            Assert.assertEquals((double)currentEncodings[currentHomeDestPredIdx], (double)encodingForHomeDest, (double)1.0E-5);
            Assert.assertEquals((double)currentEncodings[currentHomeDestPredIdx == 0 ? 1 : 0], (double)encodingForHomeEmbarked, (double)1.0E-5);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    private Boolean isEqualToReferenceValue(double[] encodings, int homeDestPredIdx, int swapIdx1, int swapIdx2, double[] currentEncodings, int currentHomeDestPredIdx) {
        try {
            Assert.assertEquals((double)encodings[homeDestPredIdx], (double)currentEncodings[currentHomeDestPredIdx], (double)1.0E-5);
            Assert.assertEquals((double)encodings[homeDestPredIdx == 0 ? 1 : 0], (double)currentEncodings[currentHomeDestPredIdx == 0 ? 1 : 0], (double)1.0E-5);
            return true;
        }
        catch (AssertionError error) {
            Log.warn((Object[])new Object[]{"Unexpected encodings. Most likely it is due to race conditions in AstGroup (see https://github.com/h2oai/h2o-3/pull/3374 )"});
            Log.warn((Object[])new Object[]{"Swap:" + swapIdx1 + " <-> " + swapIdx2});
            Log.warn((Object[])new Object[]{"encodings[homeDest]:" + encodings[homeDestPredIdx] + " currentEncodings[homeDest]: " + currentEncodings[currentHomeDestPredIdx]});
            Log.warn((Object[])new Object[]{"encodings[embarked]:" + encodings[homeDestPredIdx == 0 ? 1 : 0] + " currentEncodings[embarked]: " + currentEncodings[currentHomeDestPredIdx == 0 ? 1 : 0]});
            return false;
        }
    }
}

