/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.targetencoding;

import ai.h2o.targetencoding.TargetEncoder;
import java.io.File;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import water.Key;
import water.Scope;
import water.TestUtil;
import water.fvec.Frame;
import water.fvec.TestFrameBuilder;
import water.fvec.Vec;

public class TargetEncodingTargetColumnTest
extends TestUtil {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @BeforeClass
    public static void setup() {
        TargetEncodingTargetColumnTest.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void binaryCategoricalTargetColumnWorksTest() throws Exception {
        File fr1ExportFile = this.temporaryFolder.newFile();
        File fr2ExportFile = this.temporaryFolder.newFile();
        try {
            Scope.enter();
            Frame fr = new TestFrameBuilder().withColNames(new String[]{"ColA", "ColB"}).withVecTypes(new byte[]{4, 3}).withDataForCol(0, TargetEncodingTargetColumnTest.ar((String[])new String[]{"NO", "YES", "NO"})).withDataForCol(1, TargetEncodingTargetColumnTest.ar((long[])new long[]{1L, 2L, 3L})).build();
            Scope.track((Frame[])new Frame[]{fr});
            Frame fr2 = new TestFrameBuilder().withColNames(new String[]{"ColA2", "ColB2"}).withVecTypes(new byte[]{4, 3}).withDataForCol(0, TargetEncodingTargetColumnTest.ar((String[])new String[]{"YES", "NO", "NO"})).withDataForCol(1, TargetEncodingTargetColumnTest.ar((long[])new long[]{1L, 2L, 3L})).build();
            Scope.track((Frame[])new Frame[]{fr2});
            Frame.export((Frame)fr, (String)fr1ExportFile.getAbsolutePath(), (String)fr._key.toString(), (boolean)true, (int)1).get();
            Frame.export((Frame)fr2, (String)fr2ExportFile.getAbsolutePath(), (String)fr2._key.toString(), (boolean)true, (int)1).get();
            Frame parsedFrame = TargetEncodingTargetColumnTest.parse_test_file((Key)Key.make(), (String)fr1ExportFile.getAbsolutePath());
            Scope.track((Frame[])new Frame[]{parsedFrame});
            Frame parsedFrame2 = TargetEncodingTargetColumnTest.parse_test_file((Key)Key.make(), (String)fr2ExportFile.getAbsolutePath());
            Scope.track((Frame[])new Frame[]{parsedFrame2});
            Object[] domains = parsedFrame.vec(0).domain();
            Object[] domains2 = parsedFrame2.vec(0).domain();
            Assert.assertArrayEquals((Object[])domains, (Object[])domains2);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void weCanSumTargetColumnTest() throws Exception {
        File frExportFile = this.temporaryFolder.newFile();
        try {
            Scope.enter();
            Frame fr = new TestFrameBuilder().withColNames(new String[]{"ColA", "ColB"}).withVecTypes(new byte[]{4, 3}).withDataForCol(0, TargetEncodingTargetColumnTest.ar((String[])new String[]{"NO", "YES", "NO"})).withDataForCol(1, TargetEncodingTargetColumnTest.ar((long[])new long[]{1L, 2L, 3L})).build();
            Scope.track((Frame[])new Frame[]{fr});
            Frame.export((Frame)fr, (String)frExportFile.getAbsolutePath(), (String)fr._key.toString(), (boolean)true, (int)1).get();
            Frame parsedFrame = TargetEncodingTargetColumnTest.parse_test_file((Key)Key.make(), (String)frExportFile.getAbsolutePath());
            Scope.track((Frame[])new Frame[]{parsedFrame});
            Assert.assertEquals((long)0L, (long)parsedFrame.vec(0).at8(0L));
            Assert.assertEquals((long)1L, (long)parsedFrame.vec(0).at8(1L));
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void groupThenAggregateWithoutFoldsForBinaryTargetTest() throws Exception {
        File frExportFile = this.temporaryFolder.newFile();
        try {
            Scope.enter();
            Frame fr = new TestFrameBuilder().withColNames(new String[]{"ColA", "ColB"}).withVecTypes(new byte[]{4, 4}).withDataForCol(0, TargetEncodingTargetColumnTest.ar((String[])new String[]{"a", "a", "b"})).withDataForCol(1, TargetEncodingTargetColumnTest.ar((String[])new String[]{"NO", "YES", "NO"})).build();
            Frame.export((Frame)fr, (String)frExportFile.getAbsolutePath(), (String)fr._key.toString(), (boolean)true, (int)1).get();
            Frame parsedFrame = this.parse_test_file(Key.make(), frExportFile.getAbsolutePath(), true);
            Scope.track((Frame[])new Frame[]{parsedFrame});
            String[] teColumns = new String[]{"ColA"};
            TargetEncoder tec = new TargetEncoder(teColumns);
            Frame res = tec.groupThenAggregateForNumeratorAndDenominator(parsedFrame, teColumns[0], null, 1);
            Vec expectedSumColumn = TargetEncodingTargetColumnTest.vec((int[])new int[]{1, 0});
            Vec expectedCountColumn = TargetEncodingTargetColumnTest.vec((int[])new int[]{2, 1});
            TargetEncodingTargetColumnTest.assertVecEquals((Vec)expectedSumColumn, (Vec)res.vec(1), (double)1.0E-5);
            TargetEncodingTargetColumnTest.assertVecEquals((Vec)expectedCountColumn, (Vec)res.vec(2), (double)1.0E-5);
            expectedSumColumn.remove();
            expectedCountColumn.remove();
            res.delete();
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    @Test
    public void categoricalTargetHasCardinalityOfTwoTest() {
        String targetColumnName = "ColC";
        try {
            Scope.enter();
            Frame fr = new TestFrameBuilder().withColNames(new String[]{targetColumnName}).withVecTypes(new byte[]{4}).withDataForCol(0, TargetEncodingTargetColumnTest.ar((String[])new String[]{"2", "6", "6", "6", "6", "2"})).build();
            Scope.track((Frame[])new Frame[]{fr});
            Assert.assertEquals((long)2L, (long)fr.vec(0).cardinality());
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }
}

