/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.targetencoding;

import ai.h2o.targetencoding.TargetEncoder;
import java.util.Map;
import org.junit.After;
import org.junit.BeforeClass;
import org.junit.Test;
import water.TestUtil;
import water.fvec.Frame;
import water.fvec.TestFrameBuilder;
import water.fvec.Vec;
import water.util.IcedHashMapGeneric;

public class TargetEncodingNoneStrategyTest
extends TestUtil {
    private Frame fr = null;

    @BeforeClass
    public static void setup() {
        TargetEncodingNoneStrategyTest.stall_till_cloudsize((int)1);
    }

    @Test
    public void targetEncoderNoneHoldoutApplyingTest() {
        String teColumnName = "ColA";
        String targetColumnName = "ColC";
        String foldColumn = "fold_column";
        this.fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{teColumnName, "ColB", targetColumnName, foldColumn}).withVecTypes(new byte[]{4, 3, 4, 3}).withDataForCol(0, TargetEncodingNoneStrategyTest.ar((String[])new String[]{"a", "b", "b", "b", "a"})).withDataForCol(1, TargetEncodingNoneStrategyTest.ard((double[])new double[]{1.0, 1.0, 4.0, 7.0, 4.0})).withDataForCol(2, TargetEncodingNoneStrategyTest.ar((String[])new String[]{"2", "6", "6", "6", "6"})).withDataForCol(3, TargetEncodingNoneStrategyTest.ar((long[])new long[]{1L, 2L, 2L, 3L, 2L})).build();
        String[] teColumns = new String[]{teColumnName};
        TargetEncoder tec = new TargetEncoder(teColumns);
        IcedHashMapGeneric targetEncodingMap = tec.prepareEncodingMap(this.fr, targetColumnName, foldColumn);
        Frame resultWithEncoding = tec.applyTargetEncoding(this.fr, targetColumnName, (Map)targetEncodingMap, TargetEncoder.DataLeakageHandlingStrategy.None, foldColumn, false, 0.0, false, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
        Vec vec = resultWithEncoding.vec(4);
        Vec expected = TargetEncodingNoneStrategyTest.dvec((double[])new double[]{0.5, 0.5, 1.0, 1.0, 1.0});
        TargetEncodingNoneStrategyTest.assertVecEquals((Vec)expected, (Vec)vec, (double)1.0E-5);
        expected.remove();
        this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
        resultWithEncoding.delete();
    }

    @Test
    public void holdoutTypeNoneApplyWithNoiseTest() {
        String teColumnName = "ColA";
        String targetColumnName = "ColC";
        String foldColumn = "fold_column";
        this.fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{teColumnName, "ColB", targetColumnName, foldColumn}).withVecTypes(new byte[]{4, 3, 4, 3}).withDataForCol(0, TargetEncodingNoneStrategyTest.ar((String[])new String[]{"a", "b", "b", "b", "a"})).withDataForCol(1, TargetEncodingNoneStrategyTest.ard((double[])new double[]{1.0, 1.0, 4.0, 7.0, 4.0})).withDataForCol(2, TargetEncodingNoneStrategyTest.ar((String[])new String[]{"2", "6", "6", "6", "6"})).withDataForCol(3, TargetEncodingNoneStrategyTest.ar((long[])new long[]{1L, 2L, 2L, 3L, 2L})).build();
        String[] teColumns = new String[]{teColumnName};
        TargetEncoder tec = new TargetEncoder(teColumns);
        IcedHashMapGeneric targetEncodingMap = tec.prepareEncodingMap(this.fr, targetColumnName, foldColumn);
        TargetEncodingNoneStrategyTest.printOutFrameAsTable((Frame)((Frame)targetEncodingMap.get(teColumnName)));
        Frame resultWithEncoding = tec.applyTargetEncoding(this.fr, targetColumnName, (Map)targetEncodingMap, TargetEncoder.DataLeakageHandlingStrategy.None, foldColumn, false, false, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
        TargetEncodingNoneStrategyTest.printOutFrameAsTable((Frame)resultWithEncoding);
        double expectedDifferenceDueToNoise = 0.01;
        Vec vec = resultWithEncoding.vec(4);
        Vec expected = TargetEncodingNoneStrategyTest.dvec((double[])new double[]{0.5, 0.5, 1.0, 1.0, 1.0});
        TargetEncodingNoneStrategyTest.assertVecEquals((Vec)expected, (Vec)vec, (double)expectedDifferenceDueToNoise);
        expected.remove();
        this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
        resultWithEncoding.delete();
    }

    @Test
    public void endToEndTest() {
        String teColumnName = "ColA";
        String targetColumnName = "ColC";
        Frame training = new TestFrameBuilder().withName("trainingFrame").withColNames(new String[]{teColumnName, targetColumnName}).withVecTypes(new byte[]{4, 4}).withDataForCol(0, TargetEncodingNoneStrategyTest.ar((String[])new String[]{"a", "b", "c", "d", "e", "b", "b"})).withDataForCol(1, TargetEncodingNoneStrategyTest.ar((String[])new String[]{"2", "6", "6", "6", "6", "2", "2"})).build();
        Frame holdout = new TestFrameBuilder().withName("holdoutFrame").withColNames(new String[]{teColumnName, targetColumnName}).withVecTypes(new byte[]{4, 4}).withDataForCol(0, TargetEncodingNoneStrategyTest.ar((String[])new String[]{"a", "b", "b", "b", "a"})).withDataForCol(1, TargetEncodingNoneStrategyTest.ar((String[])new String[]{"2", "6", "6", "6", "6"})).build();
        String[] teColumns = new String[]{teColumnName};
        TargetEncoder tec = new TargetEncoder(teColumns);
        IcedHashMapGeneric targetEncodingMap = tec.prepareEncodingMap(holdout, targetColumnName, null);
        Frame resultWithEncoding = tec.applyTargetEncoding(training, targetColumnName, (Map)targetEncodingMap, TargetEncoder.DataLeakageHandlingStrategy.None, false, 0.0, false, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
        TargetEncodingNoneStrategyTest.printOutFrameAsTable((Frame)resultWithEncoding);
        Vec vec = resultWithEncoding.vec(2);
        Vec expected = TargetEncodingNoneStrategyTest.dvec((double[])new double[]{0.8, 0.8, 0.8, 0.5, 1.0, 1.0, 1.0});
        TargetEncodingNoneStrategyTest.assertVecEquals((Vec)expected, (Vec)vec, (double)1.0E-5);
        training.delete();
        holdout.delete();
        expected.remove();
        this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
        resultWithEncoding.delete();
    }

    @Test
    public void NoneHoldoutMultipleTEColumnsWithFoldColumnTest() {
        String targetColumnName = "ColC";
        String foldColumn = "fold_column";
        this.fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"ColA", "ColB", targetColumnName, foldColumn}).withVecTypes(new byte[]{4, 4, 4, 3}).withDataForCol(0, TargetEncodingNoneStrategyTest.ar((String[])new String[]{"a", "b", "b", "b", "a"})).withDataForCol(1, TargetEncodingNoneStrategyTest.ar((String[])new String[]{"d", "e", "d", "e", "e"})).withDataForCol(2, TargetEncodingNoneStrategyTest.ar((String[])new String[]{"2", "6", "6", "6", "6"})).withDataForCol(3, TargetEncodingNoneStrategyTest.ar((long[])new long[]{1L, 2L, 2L, 3L, 2L})).build();
        String[] teColumns = new String[]{"ColA", "ColB"};
        TargetEncoder tec = new TargetEncoder(teColumns);
        IcedHashMapGeneric targetEncodingMap = tec.prepareEncodingMap(this.fr, targetColumnName, foldColumn);
        Frame resultWithEncoding = tec.applyTargetEncoding(this.fr, targetColumnName, (Map)targetEncodingMap, TargetEncoder.DataLeakageHandlingStrategy.None, foldColumn, false, 0.0, false, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
        Vec expected = TargetEncodingNoneStrategyTest.dvec((double[])new double[]{0.5, 1.0, 0.5, 1.0, 1.0});
        TargetEncodingNoneStrategyTest.assertVecEquals((Vec)expected, (Vec)resultWithEncoding.vec(4), (double)1.0E-5);
        Vec expected2 = TargetEncodingNoneStrategyTest.dvec((double[])new double[]{0.5, 0.5, 1.0, 1.0, 1.0});
        TargetEncodingNoneStrategyTest.assertVecEquals((Vec)expected2, (Vec)resultWithEncoding.vec(5), (double)1.0E-5);
        expected.remove();
        expected2.remove();
        this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
        resultWithEncoding.delete();
    }

    @After
    public void afterEach() {
        if (this.fr != null) {
            this.fr.delete();
        }
    }

    private void encodingMapCleanUp(Map<String, Frame> encodingMap) {
        for (Map.Entry<String, Frame> map : encodingMap.entrySet()) {
            map.getValue().delete();
        }
    }
}

