/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.targetencoding;

import ai.h2o.targetencoding.TargetEncoder;
import java.io.File;
import java.util.Map;
import java.util.UUID;
import org.junit.After;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import water.Key;
import water.TestUtil;
import water.fvec.Frame;
import water.fvec.TestFrameBuilder;
import water.fvec.Vec;
import water.util.IcedHashMapGeneric;

public class TargetEncodingMultiClassTargetTest
extends TestUtil {
    private Frame fr = null;

    @BeforeClass
    public static void setup() {
        TargetEncodingMultiClassTargetTest.stall_till_cloudsize((int)1);
    }

    @Ignore
    @Test
    public void targetEncoderKFoldHoldoutApplyingWithMulticlassTargetColumnTest() {
        String teColumnName = "ColA";
        String targetColumnName = "ColB";
        String foldColumnName = "fold_column";
        this.fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{teColumnName, targetColumnName, foldColumnName}).withVecTypes(new byte[]{4, 3, 3}).withDataForCol(0, TargetEncodingMultiClassTargetTest.ar((String[])new String[]{"a", "b", "b", "b", "a"})).withDataForCol(1, TargetEncodingMultiClassTargetTest.ar((long[])new long[]{1L, 2L, 3L, 4L, 5L})).withDataForCol(2, TargetEncodingMultiClassTargetTest.ar((long[])new long[]{1L, 2L, 2L, 3L, 2L})).build();
        String[] teColumns = new String[]{teColumnName};
        TargetEncoder tec = new TargetEncoder(teColumns);
        IcedHashMapGeneric targetEncodingMap = tec.prepareEncodingMap(this.fr, targetColumnName, foldColumnName);
        Frame resultWithEncoding = tec.applyTargetEncoding(this.fr, targetColumnName, (Map)targetEncodingMap, TargetEncoder.DataLeakageHandlingStrategy.KFold, foldColumnName, false, 0.0, false, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
        Vec expected = TargetEncodingMultiClassTargetTest.dvec((double[])new double[]{5.0, 1.0, 4.0, 4.0, 2.5});
        TargetEncodingMultiClassTargetTest.assertVecEquals((Vec)expected, (Vec)resultWithEncoding.vec("ColA_te"), (double)1.0E-5);
        expected.remove();
        this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
        resultWithEncoding.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void groupThenAggregateWithoutFoldsForMultiClassTargetTest() {
        String tmpName = null;
        Frame parsedFrame = null;
        String targetColumnName = "ColA";
        try {
            this.fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{targetColumnName, "ColB"}).withVecTypes(new byte[]{4, 4}).withDataForCol(0, TargetEncodingMultiClassTargetTest.ar((String[])new String[]{"NO", "YES", "MAYBE"})).withDataForCol(1, TargetEncodingMultiClassTargetTest.ar((String[])new String[]{"a", "a", "b"})).build();
            tmpName = UUID.randomUUID().toString();
            Frame.export((Frame)this.fr, (String)tmpName, (String)this.fr._key.toString(), (boolean)true, (int)1);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            parsedFrame = this.parse_test_file(Key.make((String)"parsed"), tmpName, true);
            this.printOutColumnsMeta(parsedFrame);
            this.asFactor(parsedFrame, targetColumnName);
            String[] teColumns = new String[]{"ColB"};
            TargetEncoder tec = new TargetEncoder(teColumns);
            Frame res = tec.groupThenAggregateForNumeratorAndDenominator(parsedFrame, teColumns[0], null, 0);
            Vec expectedSumColumn = TargetEncodingMultiClassTargetTest.vec((int[])new int[]{0, 1, 0});
            Vec expectedCountColumn = TargetEncodingMultiClassTargetTest.vec((int[])new int[]{1, 1, 1});
            TargetEncodingMultiClassTargetTest.assertVecEquals((Vec)expectedSumColumn, (Vec)res.vec(1), (double)1.0E-5);
            TargetEncodingMultiClassTargetTest.assertVecEquals((Vec)expectedCountColumn, (Vec)res.vec(2), (double)1.0E-5);
            expectedSumColumn.remove();
            expectedCountColumn.remove();
            res.delete();
            new File(tmpName).delete();
        }
        catch (Throwable throwable) {
            new File(tmpName).delete();
            this.fr.delete();
            parsedFrame.delete();
            throw throwable;
        }
        this.fr.delete();
        parsedFrame.delete();
    }

    @After
    public void afterEach() {
        if (this.fr != null) {
            this.fr.delete();
        }
    }

    private void printOutColumnsMeta(Frame fr) {
        for (String header : fr.toTwoDimTable().getColHeaders()) {
            String type = fr.vec(header).get_type_str();
            int cardinality = fr.vec(header).cardinality();
            System.out.println(header + " - " + type + String.format("; Cardinality = %d", cardinality));
        }
    }

    private void encodingMapCleanUp(Map<String, Frame> encodingMap) {
        for (Map.Entry<String, Frame> map : encodingMap.entrySet()) {
            map.getValue().delete();
        }
    }
}

