/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.targetencoding;

import ai.h2o.targetencoding.BlendingParams;
import ai.h2o.targetencoding.TargetEncoder;
import ai.h2o.targetencoding.TargetEncoderFrameHelper;
import java.io.File;
import java.util.Map;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import water.Job;
import water.Key;
import water.Scope;
import water.TestUtil;
import water.fvec.Frame;
import water.fvec.TestFrameBuilder;
import water.fvec.Vec;
import water.util.IcedHashMapGeneric;

public class TargetEncodingLeaveOneOutStrategyTest
extends TestUtil {
    private Frame fr = null;

    @BeforeClass
    public static void setup() {
        TargetEncodingLeaveOneOutStrategyTest.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void calculateAndAppendBlendedTEEncodingDivisionByZeroTest() {
        String tmpName = null;
        Frame reimportedFrame = null;
        String teColumnName = "ColA";
        String targetColumnName = "ColB";
        IcedHashMapGeneric targetEncodingMap = null;
        Frame result = null;
        try {
            this.fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{teColumnName, targetColumnName, "numerator", "denominator"}).withVecTypes(new byte[]{4, 4, 3, 3}).withDataForCol(0, TargetEncodingLeaveOneOutStrategyTest.ar((String[])new String[]{"a", "b", "a"})).withDataForCol(1, TargetEncodingLeaveOneOutStrategyTest.ar((String[])new String[]{"yes", "no", "yes"})).withDataForCol(2, TargetEncodingLeaveOneOutStrategyTest.ar((long[])new long[]{2L, 0L, 2L})).withDataForCol(3, TargetEncodingLeaveOneOutStrategyTest.ar((long[])new long[]{2L, 0L, 2L})).withChunkLayout(new long[]{1L, 2L}).build();
            tmpName = UUID.randomUUID().toString();
            Job export = Frame.export((Frame)this.fr, (String)tmpName, (String)this.fr._key.toString(), (boolean)true, (int)1);
            export.get();
            reimportedFrame = this.parse_test_file(Key.make((String)"parsed"), tmpName, true);
            TargetEncodingLeaveOneOutStrategyTest.printOutFrameAsTable((Frame)reimportedFrame);
            String[] teColumns = new String[]{teColumnName};
            TargetEncoder tec = new TargetEncoder(teColumns);
            targetEncodingMap = tec.prepareEncodingMap(reimportedFrame, targetColumnName, null);
            result = tec.calculateAndAppendBlendedTEEncoding(reimportedFrame, (Frame)targetEncodingMap.get(teColumnName), targetColumnName, TargetEncoder.DEFAULT_BLENDING_PARAMS);
            double globalMean = 0.6666666666666666;
            TargetEncodingLeaveOneOutStrategyTest.printOutFrameAsTable((Frame)result);
            Assert.assertEquals((double)globalMean, (double)result.vec(4).at(1L), (double)1.0E-5);
            Assert.assertFalse((boolean)result.vec(2).isNA(1L));
            this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
        }
        catch (Throwable throwable) {
            this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
            result.delete();
            reimportedFrame.delete();
            new File(tmpName).delete();
            throw throwable;
        }
        result.delete();
        reimportedFrame.delete();
        new File(tmpName).delete();
    }

    @Test
    public void deletionDependsOnTheChunkLayoutTest() {
        this.fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"ColA"}).withVecTypes(new byte[]{4}).withDataForCol(0, TargetEncodingLeaveOneOutStrategyTest.ar((String[])new String[]{"a", "b", "a"})).withChunkLayout(new long[]{1L, 2L}).build();
        Vec zeroVec = Vec.makeZero((long)this.fr.numRows());
        String nameOfAddedColumn = "someName";
        this.fr.add(nameOfAddedColumn, zeroVec);
        zeroVec.remove();
        this.fr.vec(nameOfAddedColumn).at(1L);
    }

    @Test
    public void targetEncoderLOOHoldoutDivisionByZeroTest() {
        String teColumnName = "ColA";
        String targetColumnName = "ColC";
        this.fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{teColumnName, "ColB", targetColumnName}).withVecTypes(new byte[]{4, 3, 4}).withDataForCol(0, TargetEncodingLeaveOneOutStrategyTest.ar((String[])new String[]{"a", "b", "c", "d", "b", "a"})).withDataForCol(1, TargetEncodingLeaveOneOutStrategyTest.ard((double[])new double[]{1.0, 1.0, 4.0, 7.0, 5.0, 4.0})).withDataForCol(2, TargetEncodingLeaveOneOutStrategyTest.ar((String[])new String[]{"2", "6", "6", "2", "6", "6"})).build();
        String[] teColumns = new String[]{teColumnName};
        TargetEncoder tec = new TargetEncoder(teColumns);
        IcedHashMapGeneric targetEncodingMap = tec.prepareEncodingMap(this.fr, targetColumnName, null);
        Frame resultWithEncoding = tec.applyTargetEncoding(this.fr, targetColumnName, (Map)targetEncodingMap, TargetEncoder.DataLeakageHandlingStrategy.LeaveOneOut, false, 0.0, false, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
        Assert.assertEquals((double)0.66666, (double)resultWithEncoding.vec("ColA_te").at(4L), (double)1.0E-5);
        Assert.assertEquals((double)0.66666, (double)resultWithEncoding.vec("ColA_te").at(5L), (double)1.0E-5);
        this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
        resultWithEncoding.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void naValuesWithLOOStrategyTest() {
        block3: {
            Scope.enter();
            IcedHashMapGeneric targetEncodingMap = null;
            try {
                String teColumnName = "ColA";
                String targetColumnName = "ColB";
                Frame fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{teColumnName, targetColumnName}).withVecTypes(new byte[]{4, 4}).withDataForCol(0, TargetEncodingLeaveOneOutStrategyTest.ar((String[])new String[]{"a", "b", null, null, null})).withDataForCol(1, TargetEncodingLeaveOneOutStrategyTest.ar((String[])new String[]{"2", "6", "6", "2", "6"})).withChunkLayout(new long[]{3L, 2L}).build();
                String[] teColumns = new String[]{teColumnName};
                TargetEncoder tec = new TargetEncoder(teColumns);
                targetEncodingMap = tec.prepareEncodingMap(fr, targetColumnName, null);
                Frame resultWithEncodings = tec.applyTargetEncoding(fr, targetColumnName, (Map)targetEncodingMap, TargetEncoder.DataLeakageHandlingStrategy.LeaveOneOut, false, 0.0, true, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
                Scope.track((Frame[])new Frame[]{resultWithEncodings});
                Vec expected = TargetEncodingLeaveOneOutStrategyTest.dvec((double[])new double[]{0.6, 0.6, 0.5, 1.0, 0.5});
                Scope.track((Vec)expected);
                TargetEncodingLeaveOneOutStrategyTest.assertVecEquals((Vec)expected, (Vec)resultWithEncodings.vec("ColA_te"), (double)1.0E-5);
                if (targetEncodingMap == null) break block3;
            }
            catch (Throwable throwable) {
                if (targetEncodingMap != null) {
                    TargetEncoderFrameHelper.encodingMapCleanUp(targetEncodingMap);
                }
                Scope.exit((Key[])new Key[0]);
                throw throwable;
            }
            TargetEncoderFrameHelper.encodingMapCleanUp((Map)targetEncodingMap);
        }
        Scope.exit((Key[])new Key[0]);
    }

    @Test
    public void emptyStringsAndNAsAreTreatedAsDifferentCategoriesTest() {
        String teColumnName = "ColA";
        String targetColumnName = "ColB";
        this.fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{teColumnName, targetColumnName}).withVecTypes(new byte[]{4, 4}).withDataForCol(0, TargetEncodingLeaveOneOutStrategyTest.ar((String[])new String[]{"a", "b", "", "", null})).withDataForCol(1, TargetEncodingLeaveOneOutStrategyTest.ar((String[])new String[]{"2", "6", "6", "2", "6"})).build();
        String[] teColumns = new String[]{teColumnName};
        TargetEncoder tec = new TargetEncoder(teColumns);
        IcedHashMapGeneric targetEncodingMap = tec.prepareEncodingMap(this.fr, targetColumnName, null);
        Frame resultWithEncoding = tec.applyTargetEncoding(this.fr, targetColumnName, (Map)targetEncodingMap, TargetEncoder.DataLeakageHandlingStrategy.LeaveOneOut, false, 0.0, true, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
        TargetEncodingLeaveOneOutStrategyTest.printOutFrameAsTable((Frame)resultWithEncoding);
        this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
        resultWithEncoding.delete();
    }

    @Test
    public void comparisonBetweenNAsAndNonEmptyStringForLOOStrategyTest() {
        String teColumnName = "ColA";
        String targetColumnName = "ColB";
        this.fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{teColumnName, targetColumnName}).withVecTypes(new byte[]{4, 4}).withDataForCol(0, TargetEncodingLeaveOneOutStrategyTest.ar((String[])new String[]{"a", "b", null, null, null})).withDataForCol(1, TargetEncodingLeaveOneOutStrategyTest.ar((String[])new String[]{"2", "6", "6", "2", "6"})).build();
        Frame fr2 = new TestFrameBuilder().withName("testFrame2").withColNames(new String[]{teColumnName, targetColumnName}).withVecTypes(new byte[]{4, 4}).withDataForCol(0, TargetEncodingLeaveOneOutStrategyTest.ar((String[])new String[]{"a", "b", "na", "na", "na"})).withDataForCol(1, TargetEncodingLeaveOneOutStrategyTest.ar((String[])new String[]{"2", "6", "6", "2", "6"})).build();
        String[] teColumns = new String[]{teColumnName};
        TargetEncoder tec = new TargetEncoder(teColumns);
        IcedHashMapGeneric targetEncodingMap = tec.prepareEncodingMap(this.fr, targetColumnName, null);
        Frame resultWithEncoding = tec.applyTargetEncoding(this.fr, targetColumnName, (Map)targetEncodingMap, TargetEncoder.DataLeakageHandlingStrategy.LeaveOneOut, false, 0.0, true, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
        IcedHashMapGeneric targetEncodingMap2 = tec.prepareEncodingMap(fr2, targetColumnName, null);
        Frame resultWithEncoding2 = tec.applyTargetEncoding(fr2, targetColumnName, (Map)targetEncodingMap2, TargetEncoder.DataLeakageHandlingStrategy.LeaveOneOut, false, 0.0, true, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
        Frame sortedResult = resultWithEncoding.sort(new int[]{2}, new int[]{2});
        Frame sortedResult2 = resultWithEncoding2.sort(new int[]{2}, new int[]{2});
        TargetEncodingLeaveOneOutStrategyTest.assertVecEquals((Vec)sortedResult.vec("ColA_te"), (Vec)sortedResult2.vec("ColA_te"), (double)1.0E-5);
        this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
        this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap2);
        fr2.delete();
        sortedResult.delete();
        sortedResult2.delete();
        resultWithEncoding.delete();
        resultWithEncoding2.delete();
    }

    @Test
    public void comparisonBetweenEmptyStringAndNonEmptyStringForLOOStrategyTest() {
        String targetColumnName = "ColB";
        this.fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"ColA", targetColumnName}).withVecTypes(new byte[]{4, 4}).withDataForCol(0, TargetEncodingLeaveOneOutStrategyTest.ar((String[])new String[]{"a", "b", "", "", ""})).withDataForCol(1, TargetEncodingLeaveOneOutStrategyTest.ar((String[])new String[]{"2", "6", "2", "2", "6"})).build();
        Frame fr2 = new TestFrameBuilder().withName("testFrame2").withColNames(new String[]{"ColA", targetColumnName}).withVecTypes(new byte[]{4, 4}).withDataForCol(0, TargetEncodingLeaveOneOutStrategyTest.ar((String[])new String[]{"a", "b", "na", "na", "na"})).withDataForCol(1, TargetEncodingLeaveOneOutStrategyTest.ar((String[])new String[]{"2", "6", "2", "2", "6"})).build();
        BlendingParams params = new BlendingParams(20.0, 10.0);
        String[] teColumns = new String[]{"ColA"};
        TargetEncoder tec = new TargetEncoder(teColumns);
        IcedHashMapGeneric targetEncodingMap = tec.prepareEncodingMap(this.fr, targetColumnName, null);
        Frame resultWithEncoding = tec.applyTargetEncoding(this.fr, targetColumnName, (Map)targetEncodingMap, TargetEncoder.DataLeakageHandlingStrategy.LeaveOneOut, true, 0.0, true, params, 1234L);
        IcedHashMapGeneric targetEncodingMap2 = tec.prepareEncodingMap(fr2, targetColumnName, null);
        Frame resultWithEncoding2 = tec.applyTargetEncoding(fr2, targetColumnName, (Map)targetEncodingMap2, TargetEncoder.DataLeakageHandlingStrategy.LeaveOneOut, true, 0.0, true, params, 1234L);
        TargetEncodingLeaveOneOutStrategyTest.printOutFrameAsTable((Frame)resultWithEncoding);
        TargetEncodingLeaveOneOutStrategyTest.printOutFrameAsTable((Frame)resultWithEncoding2);
        TargetEncodingLeaveOneOutStrategyTest.assertVecEquals((Vec)resultWithEncoding.vec("ColA_te"), (Vec)resultWithEncoding2.vec("ColA_te"), (double)1.0E-5);
        this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
        this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap2);
        fr2.delete();
        resultWithEncoding.delete();
        resultWithEncoding2.delete();
    }

    @Test
    public void targetEncoderLOOHoldoutSubtractCurrentRowTest() {
        this.fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"ColA", "numerator", "denominator", "target"}).withVecTypes(new byte[]{4, 3, 3, 4}).withDataForCol(0, TargetEncodingLeaveOneOutStrategyTest.ar((String[])new String[]{"a", "b", "b", "b", "a", "b"})).withDataForCol(1, TargetEncodingLeaveOneOutStrategyTest.ard((double[])new double[]{1.0, 1.0, 4.0, 7.0, 4.0, 2.0})).withDataForCol(2, TargetEncodingLeaveOneOutStrategyTest.ard((double[])new double[]{1.0, 1.0, 4.0, 7.0, 4.0, 6.0})).withDataForCol(3, TargetEncodingLeaveOneOutStrategyTest.ar((String[])new String[]{"2", "6", "6", "6", "6", null})).build();
        String[] teColumns = new String[]{""};
        TargetEncoder tec = new TargetEncoder(teColumns);
        Frame res = tec.subtractTargetValueForLOO(this.fr, "target");
        Vec vecNotSubtracted = TargetEncodingLeaveOneOutStrategyTest.vec((int[])new int[]{1, 0, 3, 6, 3, 2});
        TargetEncodingLeaveOneOutStrategyTest.assertVecEquals((Vec)vecNotSubtracted, (Vec)res.vec(1), (double)1.0E-5);
        Vec vecSubtracted = TargetEncodingLeaveOneOutStrategyTest.vec((int[])new int[]{0, 0, 3, 6, 3, 6});
        TargetEncodingLeaveOneOutStrategyTest.assertVecEquals((Vec)vecSubtracted, (Vec)res.vec(2), (double)1.0E-5);
        vecNotSubtracted.remove();
        vecSubtracted.remove();
        res.delete();
    }

    @Test
    public void targetEncoderLOOHoldoutApplyingTest() {
        String targetColumn = "ColC";
        this.fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"ColA", "ColB", targetColumn}).withVecTypes(new byte[]{4, 3, 4}).withDataForCol(0, TargetEncodingLeaveOneOutStrategyTest.ar((String[])new String[]{"a", "b", "b", "b", "a"})).withDataForCol(1, TargetEncodingLeaveOneOutStrategyTest.ard((double[])new double[]{1.0, 1.0, 4.0, 7.0, 4.0})).withDataForCol(2, TargetEncodingLeaveOneOutStrategyTest.ar((String[])new String[]{"2", "6", "6", "6", "6"})).build();
        String[] teColumns = new String[]{"ColA"};
        TargetEncoder tec = new TargetEncoder(teColumns);
        IcedHashMapGeneric targetEncodingMap = tec.prepareEncodingMap(this.fr, targetColumn, null);
        Frame resultWithEncoding = tec.applyTargetEncoding(this.fr, targetColumn, (Map)targetEncodingMap, TargetEncoder.DataLeakageHandlingStrategy.LeaveOneOut, false, 0.0, true, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
        Vec expected = TargetEncodingLeaveOneOutStrategyTest.vec((int[])new int[]{1, 0, 1, 1, 1});
        TargetEncodingLeaveOneOutStrategyTest.assertVecEquals((Vec)expected, (Vec)resultWithEncoding.vec(3), (double)1.0E-5);
        expected.remove();
        this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
        resultWithEncoding.delete();
    }

    @Test
    public void targetEncoderLOOHoldoutApplyingWithFoldColumnTest() {
        String targetColumn = "ColC";
        String foldColumnName = "fold_column";
        this.fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"ColA", "ColB", targetColumn, foldColumnName}).withVecTypes(new byte[]{4, 3, 4, 3}).withDataForCol(0, TargetEncodingLeaveOneOutStrategyTest.ar((String[])new String[]{"a", "b", "b", "b", "a"})).withDataForCol(1, TargetEncodingLeaveOneOutStrategyTest.ard((double[])new double[]{1.0, 1.0, 4.0, 7.0, 4.0})).withDataForCol(2, TargetEncodingLeaveOneOutStrategyTest.ar((String[])new String[]{"2", "6", "6", "6", "6"})).withDataForCol(3, TargetEncodingLeaveOneOutStrategyTest.ar((long[])new long[]{1L, 2L, 2L, 3L, 2L})).build();
        String[] teColumns = new String[]{"ColA"};
        TargetEncoder tec = new TargetEncoder(teColumns);
        IcedHashMapGeneric targetEncodingMap = tec.prepareEncodingMap(this.fr, targetColumn, foldColumnName);
        Frame resultWithEncoding = tec.applyTargetEncoding(this.fr, targetColumn, (Map)targetEncodingMap, TargetEncoder.DataLeakageHandlingStrategy.LeaveOneOut, foldColumnName, false, 0.0, true, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
        Vec expected = TargetEncodingLeaveOneOutStrategyTest.vec((int[])new int[]{1, 0, 1, 1, 1});
        TargetEncodingLeaveOneOutStrategyTest.assertVecEquals((Vec)expected, (Vec)resultWithEncoding.vec(4), (double)1.0E-5);
        expected.remove();
        this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
        resultWithEncoding.delete();
    }

    @Test
    public void targetEncoderLOOApplyWithNoiseTest() {
        String targetColumn = "ColC";
        String foldColumnName = "fold_column";
        this.fr = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"ColA", "ColB", targetColumn, foldColumnName}).withVecTypes(new byte[]{4, 3, 4, 3}).withDataForCol(0, TargetEncodingLeaveOneOutStrategyTest.ar((String[])new String[]{"a", "b", "b", "b", "a"})).withDataForCol(1, TargetEncodingLeaveOneOutStrategyTest.ard((double[])new double[]{1.0, 1.0, 4.0, 7.0, 4.0})).withDataForCol(2, TargetEncodingLeaveOneOutStrategyTest.ar((String[])new String[]{"2", "6", "6", "6", "6"})).withDataForCol(3, TargetEncodingLeaveOneOutStrategyTest.ar((long[])new long[]{1L, 2L, 2L, 3L, 2L})).build();
        String[] teColumns = new String[]{"ColA"};
        TargetEncoder tec = new TargetEncoder(teColumns);
        IcedHashMapGeneric targetEncodingMap = tec.prepareEncodingMap(this.fr, targetColumn, foldColumnName);
        Frame resultWithEncoding = tec.applyTargetEncoding(this.fr, targetColumn, (Map)targetEncodingMap, TargetEncoder.DataLeakageHandlingStrategy.LeaveOneOut, foldColumnName, false, true, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
        Vec expected = TargetEncodingLeaveOneOutStrategyTest.vec((int[])new int[]{1, 0, 1, 1, 1});
        double expectedDifferenceDueToNoise = 0.01;
        TargetEncodingLeaveOneOutStrategyTest.assertVecEquals((Vec)expected, (Vec)resultWithEncoding.vec(4), (double)expectedDifferenceDueToNoise);
        expected.remove();
        this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
        resultWithEncoding.delete();
    }

    @Test
    public void LOOHoldoutMultipleTEColumnsWithFoldColumnTest() {
        String targetColumnName = "ColC";
        String foldColumnName = "fold_column";
        TestFrameBuilder frameBuilder = new TestFrameBuilder().withName("testFrame").withColNames(new String[]{"ColA", "ColB", targetColumnName, foldColumnName}).withVecTypes(new byte[]{4, 4, 4, 3}).withDataForCol(0, TargetEncodingLeaveOneOutStrategyTest.ar((String[])new String[]{"a", "b", "b", "b", "a"})).withDataForCol(1, TargetEncodingLeaveOneOutStrategyTest.ar((String[])new String[]{"d", "e", "d", "e", "e"})).withDataForCol(2, TargetEncodingLeaveOneOutStrategyTest.ar((String[])new String[]{"2", "6", "6", "6", "6"})).withDataForCol(3, TargetEncodingLeaveOneOutStrategyTest.ar((long[])new long[]{1L, 2L, 2L, 3L, 2L}));
        this.fr = frameBuilder.withName("testFrame").build();
        String[] teColumns = new String[]{"ColA", "ColB"};
        TargetEncoder tec = new TargetEncoder(teColumns);
        IcedHashMapGeneric targetEncodingMap = tec.prepareEncodingMap(this.fr, targetColumnName, foldColumnName);
        Frame resultWithEncoding = tec.applyTargetEncoding(this.fr, targetColumnName, (Map)targetEncodingMap, TargetEncoder.DataLeakageHandlingStrategy.LeaveOneOut, foldColumnName, false, 0.0, false, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
        Frame sortedBy1 = resultWithEncoding.sort(new int[]{1});
        Vec encodingForColumnA_Multiple = sortedBy1.vec(4);
        Frame sortedBy0 = resultWithEncoding.sort(new int[]{0});
        Vec encodingForColumnB_Multiple = sortedBy0.vec(5);
        Frame frA = frameBuilder.withName("testFrameA").build();
        String[] indexForColumnA = new String[]{"ColA"};
        TargetEncoder tecA = new TargetEncoder(indexForColumnA);
        IcedHashMapGeneric targetEncodingMapForColumn1 = tecA.prepareEncodingMap(frA, targetColumnName, foldColumnName);
        Frame resultWithEncodingForColumn1 = tecA.applyTargetEncoding(frA, targetColumnName, (Map)targetEncodingMapForColumn1, TargetEncoder.DataLeakageHandlingStrategy.LeaveOneOut, foldColumnName, false, 0.0, false, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
        Frame sortedSingleColumn1ByColA = resultWithEncodingForColumn1.sort(new int[]{0});
        Vec encodingForColumnA_Single = sortedSingleColumn1ByColA.vec(4);
        TargetEncodingLeaveOneOutStrategyTest.assertVecEquals((Vec)encodingForColumnA_Single, (Vec)encodingForColumnA_Multiple, (double)1.0E-5);
        Frame frB = frameBuilder.withName("testFrameB").build();
        String[] indexForColumnB = new String[]{"ColB"};
        TargetEncoder tecB = new TargetEncoder(indexForColumnB);
        IcedHashMapGeneric targetEncodingMapForColumn2 = tecB.prepareEncodingMap(frB, targetColumnName, foldColumnName);
        Frame resultWithEncodingForColumn2 = tecB.applyTargetEncoding(frB, targetColumnName, (Map)targetEncodingMapForColumn2, TargetEncoder.DataLeakageHandlingStrategy.LeaveOneOut, foldColumnName, false, 0.0, false, TargetEncoder.DEFAULT_BLENDING_PARAMS, 1234L);
        Frame sortedSingleColumn2ByColA = resultWithEncodingForColumn2.sort(new int[]{0});
        Vec encodingForColumnB_Single = sortedSingleColumn2ByColA.vec(4);
        TargetEncodingLeaveOneOutStrategyTest.assertVecEquals((Vec)encodingForColumnB_Single, (Vec)encodingForColumnB_Multiple, (double)1.0E-5);
        sortedBy0.delete();
        sortedBy1.delete();
        sortedSingleColumn1ByColA.delete();
        sortedSingleColumn2ByColA.delete();
        this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMap);
        this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMapForColumn1);
        this.encodingMapCleanUp((Map<String, Frame>)targetEncodingMapForColumn2);
        frA.delete();
        frB.delete();
        resultWithEncoding.delete();
        resultWithEncodingForColumn1.delete();
        resultWithEncodingForColumn2.delete();
    }

    @After
    public void afterEach() {
        if (this.fr != null) {
            this.fr.delete();
        }
    }

    private void encodingMapCleanUp(Map<String, Frame> encodingMap) {
        for (Map.Entry<String, Frame> map : encodingMap.entrySet()) {
            map.getValue().delete();
        }
    }
}

