/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.targetencoding;

import ai.h2o.targetencoding.TargetEncoderBuilder;
import ai.h2o.targetencoding.TargetEncoderFrameHelper;
import ai.h2o.targetencoding.TargetEncoderModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Map;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import water.Key;
import water.Keyed;
import water.Scope;
import water.TestUtil;
import water.fvec.Frame;

public class TargetEncoderMojoWriterTest
extends TestUtil {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @BeforeClass
    public static void stall() {
        TargetEncoderMojoWriterTest.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void writeModelToZipFile() throws Exception {
        TargetEncoderModel targetEncoderModel = null;
        String fileNameForMojo = "test_mojo_te.zip";
        try {
            Scope.enter();
            Frame trainFrame = TargetEncoderMojoWriterTest.parse_test_file((String)"./smalldata/gbm_test/titanic.csv");
            Scope.track((Frame[])new Frame[]{trainFrame});
            TargetEncoderModel.TargetEncoderParameters p = new TargetEncoderModel.TargetEncoderParameters();
            String responseColumnName = "survived";
            this.asFactor(trainFrame, responseColumnName);
            p._blending = false;
            p._response_column = responseColumnName;
            p._ignored_columns = TargetEncoderMojoWriterTest.ignoredColumns((Frame)trainFrame, (String[])new String[]{"home.dest", "embarked", p._response_column});
            p.setTrain(trainFrame._key);
            TargetEncoderBuilder builder = new TargetEncoderBuilder(p);
            builder.trainModel().get();
            targetEncoderModel = builder.getTargetEncoderModel();
            Scope.track_generic((Keyed)targetEncoderModel);
            File mojoFile = this.folder.newFile(fileNameForMojo);
            try (FileOutputStream modelOutput = new FileOutputStream(mojoFile);){
                Assert.assertEquals((long)0L, (long)mojoFile.length());
                targetEncoderModel.getMojo().writeTo((OutputStream)modelOutput);
                Assert.assertTrue((mojoFile.length() > 0L ? 1 : 0) != 0);
            }
        }
        finally {
            if (targetEncoderModel != null) {
                TargetEncoderFrameHelper.encodingMapCleanUp((Map)((TargetEncoderModel.TargetEncoderOutput)targetEncoderModel._output)._target_encoding_map);
            }
            Scope.exit((Key[])new Key[0]);
        }
    }
}

