/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.targetencoding;

import ai.h2o.targetencoding.BlendingParams;
import ai.h2o.targetencoding.TargetEncoder;
import ai.h2o.targetencoding.TargetEncoderBuilder;
import ai.h2o.targetencoding.TargetEncoderModel;
import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import water.Key;
import water.Keyed;
import water.Scope;
import water.TestUtil;
import water.fvec.Frame;

public class TargetEncoderModelTest
extends TestUtil {
    @Before
    public void setUp() {
        TestUtil.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTargetEncoderModel() {
        try {
            Scope.enter();
            Frame trainingFrame = TargetEncoderModelTest.parse_test_file((String)"./smalldata/testng/airlines_train.csv");
            Scope.track((Frame[])new Frame[]{trainingFrame});
            Frame testFrame = TargetEncoderModelTest.parse_test_file((String)"./smalldata/testng/airlines_test.csv");
            Scope.track((Frame[])new Frame[]{testFrame});
            TargetEncoderModel.TargetEncoderParameters parameters = new TargetEncoderModel.TargetEncoderParameters();
            parameters._data_leakage_handling = TargetEncoder.DataLeakageHandlingStrategy.None;
            parameters._blending_parameters = new BlendingParams(0.3, 0.7);
            parameters._blending = true;
            parameters._response_column = "IsDepDelayed";
            parameters._ignored_columns = TargetEncoderModelTest.ignoredColumns((Frame)trainingFrame, (String[])new String[]{"Origin", parameters._response_column});
            parameters._train = trainingFrame._key;
            parameters._seed = 65261L;
            TargetEncoderBuilder job = new TargetEncoderBuilder(parameters);
            TargetEncoderModel targetEncoderModel = (TargetEncoderModel)job.trainModel().get();
            Scope.track_generic((Keyed)targetEncoderModel);
            Assert.assertNotNull((Object)targetEncoderModel);
            Frame transformedFrame = targetEncoderModel.score(testFrame);
            Scope.track((Frame[])new Frame[]{transformedFrame});
            Assert.assertNotNull((Object)transformedFrame);
            Assert.assertEquals((long)(trainingFrame.numCols() + 1), (long)transformedFrame.numCols());
            int encodedColumnIndex = ArrayUtils.indexOf((Object[])transformedFrame.names(), (Object)"Origin_te");
            Assert.assertNotEquals((long)-1L, (long)encodedColumnIndex);
            Assert.assertTrue((boolean)transformedFrame.vec(encodedColumnIndex).isNumeric());
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTargetEncoderModel_noBlendingParameters() {
        try {
            Scope.enter();
            Frame trainingFrame = TargetEncoderModelTest.parse_test_file((String)"./smalldata/testng/airlines_train.csv");
            Scope.track((Frame[])new Frame[]{trainingFrame});
            Frame testFrame = TargetEncoderModelTest.parse_test_file((String)"./smalldata/testng/airlines_test.csv");
            Scope.track((Frame[])new Frame[]{testFrame});
            TargetEncoderModel.TargetEncoderParameters parameters = new TargetEncoderModel.TargetEncoderParameters();
            parameters._data_leakage_handling = TargetEncoder.DataLeakageHandlingStrategy.None;
            parameters._blending_parameters = null;
            parameters._blending = true;
            parameters._response_column = "IsDepDelayed";
            parameters._ignored_columns = TargetEncoderModelTest.ignoredColumns((Frame)trainingFrame, (String[])new String[]{"Origin", parameters._response_column});
            parameters._train = trainingFrame._key;
            parameters._seed = 65261L;
            TargetEncoderBuilder job = new TargetEncoderBuilder(parameters);
            TargetEncoderModel targetEncoderModel = (TargetEncoderModel)job.trainModel().get();
            Scope.track_generic((Keyed)targetEncoderModel);
            Assert.assertNotNull((Object)targetEncoderModel);
            Frame transformedFrame = targetEncoderModel.score(testFrame);
            Scope.track((Frame[])new Frame[]{transformedFrame});
            Assert.assertNotNull((Object)transformedFrame);
            Assert.assertEquals((long)(trainingFrame.numCols() + (trainingFrame.numCols() - parameters._ignored_columns.length - 1)), (long)transformedFrame.numCols());
            int encodedColumnIndex = ArrayUtils.indexOf((Object[])transformedFrame.names(), (Object)"Origin_te");
            Assert.assertNotEquals((long)-1L, (long)encodedColumnIndex);
            Assert.assertTrue((boolean)transformedFrame.vec(encodedColumnIndex).isNumeric());
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTargetEncoderModel_dropNonCategoricalCols() {
        try {
            Scope.enter();
            Frame trainingFrame = TargetEncoderModelTest.parse_test_file((String)"./smalldata/testng/airlines_train.csv");
            Scope.track((Frame[])new Frame[]{trainingFrame});
            TargetEncoderModel.TargetEncoderParameters parameters = new TargetEncoderModel.TargetEncoderParameters();
            parameters._data_leakage_handling = TargetEncoder.DataLeakageHandlingStrategy.None;
            parameters._response_column = "IsDepDelayed";
            parameters._ignored_columns = null;
            parameters._train = trainingFrame._key;
            parameters._seed = 65261L;
            TargetEncoderBuilder job = new TargetEncoderBuilder(parameters);
            TargetEncoderModel targetEncoderModel = (TargetEncoderModel)job.trainModel().get();
            Scope.track_generic((Keyed)targetEncoderModel);
            Assert.assertArrayEquals((Object[])new String[]{"fYear", "fMonth", "fDayofMonth", "fDayOfWeek", "UniqueCarrier", "Origin", "Dest", "IsDepDelayed"}, (Object[])((TargetEncoderModel.TargetEncoderOutput)targetEncoderModel._output)._names);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }
}

