/*
 * Decompiled with CFR 0.152.
 */
package hex.mojopipeline;

import ai.h2o.mojos.runtime.frame.MojoColumn;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameBuilder;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.frame.MojoRowBuilder;
import au.com.bytecode.opencsv.CSVReader;
import hex.mojopipeline.MojoPipeline;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import water.Key;
import water.Scope;
import water.TestUtil;
import water.fvec.ByteVec;
import water.fvec.Frame;
import water.fvec.NFSFileVec;
import water.fvec.TestFrameBuilder;
import water.fvec.Vec;
import water.parser.ParseSetup;

@RunWith(value=Parameterized.class)
public class MojoPipelineTest
extends TestUtil {
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();
    @Parameterized.Parameter
    public String testCase;
    private String dataFile;
    private String mojoFile;

    @Parameterized.Parameters(name="{0}")
    public static Object[] data() {
        String testDir = System.getenv("MOJO_PIPELINE_TEST_DIR");
        if (testDir == null) {
            return new Object[0];
        }
        return new File(testDir).list();
    }

    @BeforeClass
    public static void stall() {
        MojoPipelineTest.stall_till_cloudsize((int)1);
    }

    @Before
    public void checkLicense() {
        Assume.assumeNotNull((Object[])new Object[]{System.getenv("DRIVERLESS_AI_LICENSE_FILE")});
    }

    @Before
    public void extractData() throws IOException {
        String testDir = System.getenv("MOJO_PIPELINE_TEST_DIR");
        Assume.assumeNotNull((Object[])new Object[]{testDir});
        File source = new File(new File(testDir, this.testCase), "mojo.zip");
        File target = this.tmp.newFolder(this.testCase);
        MojoPipelineTest.extractZip(source, target);
        this.dataFile = new File(new File(target, "mojo-pipeline"), "example.csv").getAbsolutePath();
        this.mojoFile = new File(new File(target, "mojo-pipeline"), "pipeline.mojo").getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void transform() throws Exception {
        try {
            Scope.enter();
            ai.h2o.mojos.runtime.MojoPipeline model = null;
            MojoFrame expected = null;
            try {
                model = ai.h2o.mojos.runtime.MojoPipeline.loadFrom((String)this.mojoFile);
                expected = this.transformDirect(model, this.dataFile);
            }
            catch (Exception e) {
                Assume.assumeNoException((Throwable)e);
            }
            Assert.assertNotNull((Object)model);
            Assert.assertNotNull(expected);
            NFSFileVec mojoData = MojoPipelineTest.makeNfsFileVec((String)this.mojoFile);
            Frame t = Scope.track((Frame[])new Frame[]{this.loadData(model)});
            MojoPipeline mp = new MojoPipeline((ByteVec)mojoData);
            Frame transformed = mp.transform(t, false);
            System.out.println(transformed.toTwoDimTable().toString());
            MojoPipelineTest.assertFrameEquals(transformed, expected);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    private MojoFrame transformDirect(ai.h2o.mojos.runtime.MojoPipeline model, String dataPath) throws Exception {
        String[] labels = model.getInputMeta().getColumnNames();
        String[][] data = this.loadData(dataPath, labels);
        MojoFrameBuilder fb = model.getInputFrameBuilder();
        MojoRowBuilder rb = fb.getMojoRowBuilder();
        for (String[] row : data) {
            for (int i = 0; i < row.length; ++i) {
                rb.setValue(labels[i], row[i]);
            }
            rb = fb.addRow(rb);
        }
        MojoFrame input = fb.toMojoFrame();
        return model.transform(input);
    }

    private Frame loadData(ai.h2o.mojos.runtime.MojoPipeline model) throws Exception {
        MojoFrameMeta meta = model.getInputMeta();
        if ("test_mojo_twosigma_1".equals(this.testCase)) {
            String[] colNames = meta.getColumnNames();
            return MojoPipelineTest.toFrame(this.loadData(this.dataFile, colNames), colNames);
        }
        return MojoPipelineTest.parseCsv(this.dataFile, meta);
    }

    private static Frame parseCsv(String dataFile, final MojoFrameMeta meta) {
        return MojoPipelineTest.parse_test_file((String)dataFile, (TestUtil.ParseSetupTransformer)new TestUtil.ParseSetupTransformer(){

            public ParseSetup transformSetup(ParseSetup guessedSetup) {
                byte[] columnTypes = guessedSetup.getColumnTypes();
                for (int i = 0; i < meta.size(); ++i) {
                    if (columnTypes[i] == 3 && !meta.getColumnType((int)i).isnumeric) {
                        columnTypes[i] = 2;
                    }
                    if (columnTypes[i] != 5 || meta.getColumnType(i) == MojoColumn.Type.Time64) continue;
                    columnTypes[i] = 2;
                }
                return guessedSetup;
            }
        });
    }

    private String[][] loadData(String dataPath, String[] labels) throws Exception {
        String[][] data;
        try (CSVReader reader = new CSVReader((Reader)new FileReader(dataPath));){
            List rows = reader.readAll();
            assert (Arrays.equals(labels, (Object[])rows.get(0)));
            data = (String[][])rows.subList(1, rows.size()).toArray((T[])new String[0][]);
        }
        if ("test_mojo_twosigma_1".equals(this.testCase)) {
            for (int i = 0; i < data.length; ++i) {
                data[i] = MojoPipelineTest.fixRowTwoSigma(data[i], labels.length);
            }
        }
        return data;
    }

    private static String[] fixRowTwoSigma(String[] row, int cols) {
        int i;
        if (row.length == cols) {
            return row;
        }
        String[] fixed = new String[cols];
        int col = 0;
        fixed[col++] = row[0];
        StringBuilder sb = new StringBuilder();
        for (i = 1; i < row.length - cols + 1; ++i) {
            sb.append(row[i]);
            sb.append(",");
        }
        fixed[col++] = sb.deleteCharAt(sb.length() - 1).toString();
        for (i = 2 + row.length - cols; i < row.length; ++i) {
            fixed[col++] = row[i];
        }
        assert (col == cols);
        return fixed;
    }

    private static byte[] rep(byte val, int cnt) {
        byte[] ary = new byte[cnt];
        Arrays.fill(ary, val);
        return ary;
    }

    private static void extractZip(File source, File target) throws IOException {
        try (ZipFile zipFile = new ZipFile(source);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File entryDestination = new File(target, entry.getName());
                if (entry.isDirectory()) {
                    if (entryDestination.mkdirs()) continue;
                    throw new IOException("Failed to create directory: " + entryDestination);
                }
                if (!entryDestination.getParentFile().exists() && !entryDestination.getParentFile().mkdirs()) {
                    throw new IOException("Failed to create directory: " + entryDestination.getParentFile());
                }
                InputStream in = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    FileOutputStream out = new FileOutputStream(entryDestination);
                    Throwable throwable2 = null;
                    try {
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((OutputStream)out).close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
    }

    private static Frame toFrame(String[][] data, String[] colNames) {
        TestFrameBuilder fb = new TestFrameBuilder().withColNames(colNames).withVecTypes(MojoPipelineTest.rep((byte)2, colNames.length));
        for (int i = 0; i < colNames.length; ++i) {
            String[] vals = new String[data.length];
            for (int j = 0; j < vals.length; ++j) {
                vals[j] = data[j][i];
            }
            fb.withDataForCol(i, vals);
        }
        return fb.build();
    }

    private static void assertFrameEquals(Frame actual, MojoFrame expected) {
        Assert.assertArrayEquals((Object[])actual.names(), (Object[])expected.getColumnNames());
        for (int i = 0; i < expected.getNcols(); ++i) {
            double[] vals = (double[])expected.getColumn(i).getData();
            Vec expectedVec = Scope.track((Vec)MojoPipelineTest.dvec((double[])vals));
            MojoPipelineTest.assertVecEquals((Vec)expectedVec, (Vec)actual.vec(i), (double)1.0E-6);
        }
    }
}

