/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.TestUtil;
import water.fvec.Frame;
import water.fvec.Vec;
import water.parser.AvroFileGenerator;
import water.parser.BufferedString;

public class ParseTestAvro
extends TestUtil {
    private static double EPSILON = 1.0E-9;

    @BeforeClass
    public static void setup() {
        TestUtil.stall_till_cloudsize((int)5);
    }

    @Test
    public void testSkippedColumns() {
        try {
            Frame f1 = ParseTestAvro.parse_test_file((String)"smalldata/parser/avro/sequence100k.avro", (int[])new int[]{0, 1});
            Assert.fail((String)"Parser should have thrown an exception but did not!");
        }
        catch (Exception ex) {
            System.out.println("Done, Avro parsers should not specify skipped_columns");
        }
    }

    @Test
    public void testParseSimple() {
        TestUtil.FrameAssertion[] assertions = new TestUtil.FrameAssertion[]{new TestUtil.FrameAssertion("smalldata/parser/avro/sequence100k.avro", TestUtil.ari((int[])new int[]{1, 100000})){

            public void check(Frame f) {
                Vec values = f.vec(0);
                int i = 0;
                while ((long)i < f.numRows()) {
                    Assert.assertEquals((long)i, (long)values.at8((long)i));
                    ++i;
                }
            }
        }, new TestUtil.FrameAssertion("smalldata/parser/avro/episodes.avro", TestUtil.ari((int[])new int[]{3, 8})){}};
        for (int i = 0; i < assertions.length; ++i) {
            ParseTestAvro.assertFrameAssertion((TestUtil.FrameAssertion)assertions[i]);
        }
    }

    @Test
    public void testParsePrimitiveTypes() {
        TestUtil.FrameAssertion[] assertions = new TestUtil.FrameAssertion[]{new TestUtil.GenFrameAssertion("supportedPrimTypes.avro", TestUtil.ari((int[])new int[]{8, 100})){

            protected File prepareFile() throws IOException {
                return AvroFileGenerator.generatePrimitiveTypes(this.file, this.nrows());
            }

            public void check(Frame f) {
                Assert.assertArrayEquals((String)"Column names need to match!", (Object[])TestUtil.ar((String[])new String[]{"CString", "CBytes", "CInt", "CLong", "CFloat", "CDouble", "CBoolean", "CNull"}), (Object[])f.names());
                Assert.assertArrayEquals((String)"Column types need to match!", (byte[])TestUtil.ar((byte[])new byte[]{2, 2, 3, 3, 3, 3, 3, 0}), (byte[])f.types());
                int nrows = this.nrows();
                BufferedString bs = new BufferedString();
                for (int row = 0; row < nrows; ++row) {
                    Assert.assertEquals((String)"Value in column CString", (Object)String.valueOf(row), (Object)f.vec(0).atStr(bs, (long)row).toString());
                    Assert.assertEquals((String)"Value in column CBytes", (Object)String.valueOf(row), (Object)f.vec(1).atStr(bs, (long)row).toString());
                    Assert.assertEquals((String)"Value in column CInt", (long)row, (long)f.vec(2).at8((long)row));
                    Assert.assertEquals((String)"Value in column CLong", (long)row, (long)f.vec(3).at8((long)row));
                    Assert.assertEquals((String)"Value in column CFloat", (double)row, (double)f.vec(4).at((long)row), (double)EPSILON);
                    Assert.assertEquals((String)"Value in column CDouble", (double)row, (double)f.vec(5).at((long)row), (double)EPSILON);
                    Assert.assertEquals((String)"Value in column CBoolean", (Object)((row & 1) == 1 ? 1 : 0), (Object)(((int)f.vec(5).at((long)row) & 1) == 1 ? 1 : 0));
                    Assert.assertTrue((String)"Value in column CNull", (boolean)f.vec(7).isNA((long)row));
                }
            }
        }};
        for (int i = 0; i < assertions.length; ++i) {
            ParseTestAvro.assertFrameAssertion((TestUtil.FrameAssertion)assertions[i]);
        }
    }

    @Test
    public void testParseUnionTypes() {
        TestUtil.FrameAssertion[] assertions = new TestUtil.FrameAssertion[]{new TestUtil.GenFrameAssertion("unionTypes.avro", TestUtil.ari((int[])new int[]{7, 101})){

            protected File prepareFile() throws IOException {
                return AvroFileGenerator.generateUnionTypes(this.file, this.nrows());
            }

            public void check(Frame f) {
                Assert.assertArrayEquals((String)"Column names need to match!", (Object[])TestUtil.ar((String[])new String[]{"CUString", "CUBytes", "CUInt", "CULong", "CUFloat", "CUDouble", "CUBoolean"}), (Object[])f.names());
                Assert.assertArrayEquals((String)"Column types need to match!", (byte[])TestUtil.ar((byte[])new byte[]{2, 2, 3, 3, 3, 3, 3}), (byte[])f.types());
                int nrows = this.nrows();
                BufferedString bs = new BufferedString();
                for (int col = 0; col < this.ncols(); ++col) {
                    Assert.assertTrue((String)("NA should be in first row and col " + col), (boolean)f.vec(col).isNA(0L));
                }
                for (int row = 1; row < nrows; ++row) {
                    Assert.assertEquals((String)"Value in column CString", (Object)String.valueOf(row), (Object)f.vec(0).atStr(bs, (long)row).toString());
                    Assert.assertEquals((String)"Value in column CBytes", (Object)String.valueOf(row), (Object)f.vec(1).atStr(bs, (long)row).toString());
                    Assert.assertEquals((String)"Value in column CInt", (long)row, (long)f.vec(2).at8((long)row));
                    Assert.assertEquals((String)"Value in column CLong", (long)row, (long)f.vec(3).at8((long)row));
                    Assert.assertEquals((String)"Value in column CFloat", (double)row, (double)f.vec(4).at((long)row), (double)EPSILON);
                    Assert.assertEquals((String)"Value in column CDouble", (double)row, (double)f.vec(5).at((long)row), (double)EPSILON);
                    Assert.assertEquals((String)"Value in column CBoolean", (Object)((row & 1) == 1 ? 1 : 0), (Object)(((int)f.vec(5).at((long)row) & 1) == 1 ? 1 : 0));
                }
            }
        }};
        for (int i = 0; i < assertions.length; ++i) {
            ParseTestAvro.assertFrameAssertion((TestUtil.FrameAssertion)assertions[i]);
        }
    }

    @Test
    public void testParseEnumTypes() {
        TestUtil.FrameAssertion[] assertions = new TestUtil.FrameAssertion[]{new TestUtil.GenFrameAssertion("enumTypes.avro", TestUtil.ari((int[])new int[]{2, 100})){
            String[][] categories;
            {
                this.categories = AvroFileGenerator.generateSymbols(TestUtil.ar((String[])new String[]{"CAT_A_", "CAT_B_"}), TestUtil.ari((int[])new int[]{7, 13}));
            }

            protected File prepareFile() throws IOException {
                return AvroFileGenerator.generateEnumTypes(this.file, this.nrows(), this.categories);
            }

            public void check(Frame f) {
                Assert.assertArrayEquals((String)"Column names need to match!", (Object[])TestUtil.ar((String[])new String[]{"CEnum", "CUEnum"}), (Object[])f.names());
                Assert.assertArrayEquals((String)"Column types need to match!", (byte[])TestUtil.ar((byte[])new byte[]{4, 4}), (byte[])f.types());
                Assert.assertArrayEquals((String)"Category names need to match in CEnum!", (Object[])this.categories[0], (Object[])f.vec("CEnum").domain());
                Assert.assertArrayEquals((String)"Category names need to match in CUEnum!", (Object[])this.categories[1], (Object[])f.vec("CUEnum").domain());
                int numOfCategories1 = this.categories[0].length;
                int numOfCategories2 = this.categories[1].length;
                int nrows = this.nrows();
                for (int row = 0; row < nrows; ++row) {
                    Assert.assertEquals((String)"Value in column CEnum", (long)(row % numOfCategories1), (long)((int)f.vec("CEnum").at((long)row)));
                    if (row % (numOfCategories2 + 1) == 0) {
                        Assert.assertTrue((String)("NA should be in row " + row + " and col CUEnum"), (boolean)f.vec("CUEnum").isNA((long)row));
                        continue;
                    }
                    Assert.assertEquals((String)"Value in column CUEnum", (long)(row % numOfCategories2), (long)((int)f.vec("CUEnum").at((long)row)));
                }
            }
        }};
        for (int i = 0; i < assertions.length; ++i) {
            ParseTestAvro.assertFrameAssertion((TestUtil.FrameAssertion)assertions[i]);
        }
    }
}

