/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import water.util.StringUtils;

class AvroFileGenerator {
    AvroFileGenerator() {
    }

    public static void main(String[] args) throws IOException {
        AvroFileGenerator.generatePrimitiveTypes("/tmp/h2o-avro-tests/primitiveTypes.avro", 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File generatePrimitiveTypes(String filename, int nrows) throws IOException {
        File parentDir = Files.createTempDir();
        File f = new File(parentDir, filename);
        GenericDatumWriter w = new GenericDatumWriter();
        Schema schema = (Schema)SchemaBuilder.builder().record("test_primitive_types").fields().name("CString").type("string").noDefault().name("CBytes").type("bytes").noDefault().name("CInt").type("int").noDefault().name("CLong").type("long").noDefault().name("CFloat").type("float").noDefault().name("CDouble").type("double").noDefault().name("CBoolean").type("boolean").noDefault().name("CNull").type("null").noDefault().endRecord();
        try (DataFileWriter dw = new DataFileWriter((DatumWriter)w);){
            dw.create(schema, f);
            for (int i = 0; i < nrows; ++i) {
                GenericData.Record gr = new GenericData.Record(schema);
                gr.put("CString", (Object)String.valueOf(i));
                gr.put("CBytes", (Object)ByteBuffer.wrap(StringUtils.toBytes((Object)i)));
                gr.put("CInt", (Object)i);
                gr.put("CLong", (Object)i);
                gr.put("CFloat", (Object)Float.valueOf(i));
                gr.put("CDouble", (Object)i);
                gr.put("CBoolean", (Object)((i & 1) == 1 ? 1 : 0));
                gr.put("CNull", null);
                dw.append((Object)gr);
            }
            File file = f;
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File generateUnionTypes(String filename, int nrows) throws IOException {
        File parentDir = Files.createTempDir();
        File f = new File(parentDir, filename);
        GenericDatumWriter w = new GenericDatumWriter();
        Schema schema = (Schema)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)SchemaBuilder.builder().record("test_union_types").fields().name("CUString").type().optional().stringType()).name("CUBytes").type().optional().bytesType()).name("CUInt").type().optional().intType()).name("CULong").type().optional().longType()).name("CUFloat").type().optional().floatType()).name("CUDouble").type().optional().doubleType()).name("CUBoolean").type().optional().booleanType()).endRecord();
        try (DataFileWriter dw = new DataFileWriter((DatumWriter)w);){
            dw.create(schema, f);
            for (int i = 0; i < nrows; ++i) {
                GenericData.Record gr = new GenericData.Record(schema);
                gr.put("CUString", (Object)(i == 0 ? null : String.valueOf(i)));
                gr.put("CUBytes", i == 0 ? null : ByteBuffer.wrap(StringUtils.toBytes((Object)i)));
                gr.put("CUInt", (Object)(i == 0 ? null : Integer.valueOf(i)));
                gr.put("CULong", i == 0 ? null : Long.valueOf(i));
                gr.put("CUFloat", i == 0 ? null : Float.valueOf(i));
                gr.put("CUDouble", i == 0 ? null : Double.valueOf(i));
                gr.put("CUBoolean", i == 0 ? null : Boolean.valueOf((i & 1) == 1));
                dw.append((Object)gr);
            }
            File file = f;
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File generateEnumTypes(String filename, int nrows, String[][] categories) throws IOException {
        assert (categories.length == 2) : "Needs only 2 columns";
        File parentDir = Files.createTempDir();
        File f = new File(parentDir, filename);
        GenericDatumWriter w = new GenericDatumWriter();
        DataFileWriter dw = new DataFileWriter((DatumWriter)w);
        Schema enumSchema1 = (Schema)SchemaBuilder.enumeration((String)"CEnum1").symbols(categories[0]);
        Schema enumSchema2 = (Schema)SchemaBuilder.enumeration((String)"CEnum2").symbols(categories[1]);
        Schema schema = (Schema)((SchemaBuilder.FieldAssembler)SchemaBuilder.builder().record("test_enum_types").fields().name("CEnum").type(enumSchema1).noDefault().name("CUEnum").type().optional().type(enumSchema2)).endRecord();
        System.out.println(schema);
        int numOfCategories1 = categories[0].length;
        int numOfCategories2 = categories[1].length;
        try {
            dw.create(schema, f);
            for (int i = 0; i < nrows; ++i) {
                GenericData.Record gr = new GenericData.Record(schema);
                gr.put("CEnum", (Object)new GenericData.EnumSymbol(enumSchema1, categories[0][i % numOfCategories1]));
                gr.put("CUEnum", (Object)(i % (numOfCategories2 + 1) == 0 ? null : new GenericData.EnumSymbol(enumSchema2, categories[1][i % numOfCategories2])));
                dw.append((Object)gr);
            }
            File file = f;
            return file;
        }
        finally {
            dw.close();
        }
    }

    public static String[][] generateSymbols(String[] prefix, int[] num) {
        assert (prefix.length == num.length);
        String[][] symbols = new String[prefix.length][];
        for (int i = 0; i < prefix.length; ++i) {
            symbols[i] = AvroFileGenerator.generateSymbols(prefix[i], num[i]);
        }
        return symbols;
    }

    public static String[] generateSymbols(String prefix, int num) {
        String[] symbols = new String[num];
        for (int i = 0; i < num; ++i) {
            symbols[i] = prefix + i;
        }
        return symbols;
    }
}

