/*
 * Decompiled with CFR 0.152.
 */
package water.test.util;

import hex.tree.gbm.GBMModel;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.Iced;
import water.TestUtil;
import water.api.Schema;
import water.api.SchemaServer;
import water.api.schemas3.FrameV3;
import water.api.schemas3.SchemaV3;
import water.fvec.Frame;
import water.util.PojoUtils;

public class PojoUtilsTest
extends TestUtil {
    @BeforeClass
    public static void setup() {
        PojoUtilsTest.stall_till_cloudsize((int)1);
    }

    @Test
    public void testGetFieldValue() {
        GBMModel.GBMParameters o = new GBMModel.GBMParameters();
        Assert.assertEquals((Object)50, (Object)PojoUtils.getFieldValue((Object)o, (String)"_ntrees", (PojoUtils.FieldNaming)PojoUtils.FieldNaming.CONSISTENT));
    }

    @Test
    public void testVecSpecifierToColSpecifier() {
        SchemaServer.registerAllSchemasIfNecessary((Schema[])new Schema[0]);
        TestIcedPojo fromIced = new TestIcedPojo();
        TestSchemaPojo toSchema = new TestSchemaPojo();
        fromIced.column = new Frame.VecSpecifier();
        fromIced.column._column_name = "see one";
        fromIced.column_array = new Frame.VecSpecifier[2];
        fromIced.column_array[0] = new Frame.VecSpecifier();
        fromIced.column_array[1] = new Frame.VecSpecifier();
        fromIced.column_array[0]._column_name = "C1";
        fromIced.column_array[1]._column_name = "C2";
        PojoUtils.copyProperties((Object)((Object)toSchema), (Object)((Object)fromIced), (PojoUtils.FieldNaming)PojoUtils.FieldNaming.CONSISTENT);
        Assert.assertEquals((Object)fromIced.column._column_name.toString(), (Object)toSchema.column.column_name);
        for (int i = 0; i < fromIced.column_array.length; ++i) {
            Assert.assertEquals((Object)fromIced.column_array[i]._column_name.toString(), (Object)toSchema.column_array[i].column_name);
        }
    }

    @Test
    public void testColSpecifierToVecSpecifier() {
        SchemaServer.registerAllSchemasIfNecessary((Schema[])new Schema[0]);
        TestSchemaPojo fromSchema = new TestSchemaPojo();
        TestIcedPojo toIced = new TestIcedPojo();
        fromSchema.column = new FrameV3.ColSpecifierV3();
        fromSchema.column.column_name = "see one";
        fromSchema.column_array = new FrameV3.ColSpecifierV3[2];
        fromSchema.column_array[0] = new FrameV3.ColSpecifierV3();
        fromSchema.column_array[1] = new FrameV3.ColSpecifierV3();
        fromSchema.column_array[0].column_name = "C1";
        fromSchema.column_array[1].column_name = "C2";
        PojoUtils.copyProperties((Object)((Object)toIced), (Object)((Object)fromSchema), (PojoUtils.FieldNaming)PojoUtils.FieldNaming.CONSISTENT);
        Assert.assertEquals((Object)fromSchema.column.column_name, (Object)toIced.column._column_name.toString());
        for (int i = 0; i < fromSchema.column_array.length; ++i) {
            Assert.assertEquals((Object)fromSchema.column_array[i].column_name, (Object)toIced.column_array[i]._column_name.toString());
        }
    }

    @Test
    public void TestFillFromJson() {
        GBMModel.GBMParameters o = new GBMModel.GBMParameters();
        Assert.assertEquals((long)50L, (long)o._ntrees);
        Assert.assertEquals((long)5L, (long)o._max_depth);
        PojoUtils.fillFromJson((Object)o, (String)"{\"_ntrees\": 17}");
        Assert.assertEquals((long)17L, (long)o._ntrees);
        Assert.assertEquals((long)5L, (long)o._max_depth);
        TestNestedFillFromJson nested = new TestNestedFillFromJson();
        nested.parameters = new GBMModel.GBMParameters();
        Assert.assertEquals((long)50L, (long)nested.parameters._ntrees);
        Assert.assertEquals((long)5L, (long)nested.parameters._max_depth);
        PojoUtils.fillFromJson((Object)((Object)nested), (String)"{\"double_meaning\": 96, \"parameters\": {\"_ntrees\": 17}}");
        Assert.assertEquals((double)96.0, (double)nested.double_meaning, (double)1.0E-5);
        Assert.assertEquals((long)42L, (long)nested.meaning);
        Assert.assertEquals((long)17L, (long)nested.parameters._ntrees);
        Assert.assertEquals((long)5L, (long)nested.parameters._max_depth);
    }

    public static class TestNestedFillFromJson
    extends Iced {
        public int meaning = 42;
        public GBMModel.GBMParameters parameters = null;
        public double double_meaning = 84.0;
    }

    public static class TestSchemaPojo
    extends SchemaV3<TestIcedPojo, TestSchemaPojo> {
        FrameV3.ColSpecifierV3 column;
        FrameV3.ColSpecifierV3[] column_array;
    }

    public static class TestIcedPojo
    extends Iced {
        Frame.VecSpecifier column;
        Frame.VecSpecifier[] column_array;
    }
}

