/*
 * Decompiled with CFR 0.152.
 */
package water;

import hex.Model;
import hex.ModelMetrics;
import hex.glm.GLM;
import hex.glm.GLMModel;
import hex.tree.CompressedTree;
import hex.tree.SharedTreeModel;
import hex.tree.drf.DRF;
import hex.tree.drf.DRFModel;
import hex.tree.gbm.GBM;
import hex.tree.gbm.GBMModel;
import hex.tree.isofor.IsolationForest;
import hex.tree.isofor.IsolationForestModel;
import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.AutoBuffer;
import water.DKV;
import water.Iced;
import water.Key;
import water.TestUtil;
import water.fvec.Frame;
import water.util.Log;

public class ModelSerializationTest
extends TestUtil {
    private static String[] ESA = new String[0];

    @BeforeClass
    public static void setup() {
        ModelSerializationTest.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleModel() throws IOException {
        BlahModel.BlahParameters params = new BlahModel.BlahParameters();
        BlahModel.BlahOutput output = new BlahModel.BlahOutput(false, false, false);
        BlahModel model = new BlahModel(Key.make((String)"BLAHModel"), params, output);
        DKV.put((Key)model._key, (Iced)model);
        BlahModel loadedModel = null;
        try {
            loadedModel = this.saveAndLoad(model);
            ModelSerializationTest.assertModelBinaryEquals(model, loadedModel);
        }
        finally {
            if (loadedModel != null) {
                loadedModel.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGBMModelMultinomial() throws IOException {
        GBMModel loadedModel = null;
        try {
            GBMModel model = this.prepareGBMModel("smalldata/iris/iris.csv", ESA, "C5", true, 5);
            CompressedTree[][] trees = ModelSerializationTest.getTrees((SharedTreeModel)model);
            loadedModel = this.saveAndLoad(model);
            ModelSerializationTest.assertModelBinaryEquals((Model)model, (Model)loadedModel);
            CompressedTree[][] loadedTrees = ModelSerializationTest.getTrees((SharedTreeModel)loadedModel);
            ModelSerializationTest.assertTreeEquals("Trees have to be binary same", trees, loadedTrees);
        }
        finally {
            if (loadedModel != null) {
                loadedModel.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGBMModelBinomial() throws IOException {
        GBMModel loadedModel = null;
        try {
            GBMModel model = this.prepareGBMModel("smalldata/logreg/prostate.csv", ModelSerializationTest.ar((String[])new String[]{"ID"}), "CAPSULE", true, 5);
            CompressedTree[][] trees = ModelSerializationTest.getTrees((SharedTreeModel)model);
            loadedModel = this.saveAndLoad(model);
            ModelSerializationTest.assertModelBinaryEquals((Model)model, (Model)loadedModel);
            CompressedTree[][] loadedTrees = ModelSerializationTest.getTrees((SharedTreeModel)loadedModel);
            ModelSerializationTest.assertTreeEquals("Trees have to be binary same", trees, loadedTrees);
        }
        finally {
            if (loadedModel != null) {
                loadedModel.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDRFModelMultinomial() throws IOException {
        DRFModel loadedModel = null;
        try {
            DRFModel model = this.prepareDRFModel("smalldata/iris/iris.csv", ESA, "C5", true, 5);
            CompressedTree[][] trees = ModelSerializationTest.getTrees((SharedTreeModel)model);
            loadedModel = this.saveAndLoad(model);
            ModelSerializationTest.assertModelBinaryEquals((Model)model, (Model)loadedModel);
            CompressedTree[][] loadedTrees = ModelSerializationTest.getTrees((SharedTreeModel)loadedModel);
            ModelSerializationTest.assertTreeEquals("Trees have to be binary same", trees, loadedTrees);
        }
        finally {
            if (loadedModel != null) {
                loadedModel.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDRFModelBinomial() throws IOException {
        DRFModel model = null;
        DRFModel loadedModel = null;
        try {
            model = this.prepareDRFModel("smalldata/logreg/prostate.csv", ModelSerializationTest.ar((String[])new String[]{"ID"}), "CAPSULE", true, 5);
            CompressedTree[][] trees = ModelSerializationTest.getTrees((SharedTreeModel)model);
            loadedModel = this.saveAndLoad(model);
            ModelSerializationTest.assertModelBinaryEquals((Model)model, (Model)loadedModel);
            CompressedTree[][] loadedTrees = ModelSerializationTest.getTrees((SharedTreeModel)loadedModel);
            ModelSerializationTest.assertTreeEquals("Trees have to be binary same", trees, loadedTrees);
        }
        finally {
            if (model != null) {
                model.delete();
            }
            if (loadedModel != null) {
                loadedModel.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsolationForestModel() throws IOException {
        IsolationForestModel model = null;
        IsolationForestModel loadedModel = null;
        try {
            model = this.prepareIsoForModel("smalldata/logreg/prostate.csv", ModelSerializationTest.ar((String[])new String[]{"ID", "CAPSULE"}), 5);
            CompressedTree[][] trees = ModelSerializationTest.getTrees((SharedTreeModel)model);
            loadedModel = this.saveAndLoad(model);
            ModelSerializationTest.assertModelBinaryEquals((Model)model, (Model)loadedModel);
            CompressedTree[][] loadedTrees = ModelSerializationTest.getTrees((SharedTreeModel)loadedModel);
            ModelSerializationTest.assertTreeEquals("Trees have to be binary same", trees, loadedTrees);
        }
        finally {
            if (model != null) {
                model.delete();
            }
            if (loadedModel != null) {
                loadedModel.delete();
            }
        }
    }

    @Test
    public void testGLMModel() throws IOException {
        GLMModel loadedModel = null;
        try {
            GLMModel model = this.prepareGLMModel("smalldata/junit/cars.csv", ESA, "power (hp)", GLMModel.GLMParameters.Family.poisson);
            loadedModel = this.saveAndLoad(model);
            ModelSerializationTest.assertModelBinaryEquals((Model)model, (Model)loadedModel);
        }
        finally {
            if (loadedModel != null) {
                loadedModel.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GBMModel prepareGBMModel(String dataset, String[] ignoredColumns, String response, boolean classification, int ntrees) {
        Frame f = ModelSerializationTest.parse_test_file((String)dataset);
        try {
            if (classification && !f.vec(response).isCategorical()) {
                f.replace(f.find(response), f.vec(response).toCategoricalVec()).remove();
                DKV.put((Key)f._key, (Iced)f);
            }
            GBMModel.GBMParameters gbmParams = new GBMModel.GBMParameters();
            gbmParams._train = f._key;
            gbmParams._ignored_columns = ignoredColumns;
            gbmParams._response_column = response;
            gbmParams._ntrees = ntrees;
            gbmParams._score_each_iteration = true;
            GBMModel gBMModel = (GBMModel)new GBM(gbmParams).trainModel().get();
            return gBMModel;
        }
        finally {
            if (f != null) {
                f.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DRFModel prepareDRFModel(String dataset, String[] ignoredColumns, String response, boolean classification, int ntrees) {
        Frame f = ModelSerializationTest.parse_test_file((String)dataset);
        try {
            if (classification && !f.vec(response).isCategorical()) {
                f.replace(f.find(response), f.vec(response).toCategoricalVec()).remove();
                DKV.put((Key)f._key, (Iced)f);
            }
            DRFModel.DRFParameters drfParams = new DRFModel.DRFParameters();
            drfParams._train = f._key;
            drfParams._ignored_columns = ignoredColumns;
            drfParams._response_column = response;
            drfParams._ntrees = ntrees;
            drfParams._score_each_iteration = true;
            DRFModel dRFModel = (DRFModel)new DRF(drfParams).trainModel().get();
            return dRFModel;
        }
        finally {
            if (f != null) {
                f.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IsolationForestModel prepareIsoForModel(String dataset, String[] ignoredColumns, int ntrees) {
        Frame f = ModelSerializationTest.parse_test_file((String)dataset);
        try {
            IsolationForestModel.IsolationForestParameters ifParams = new IsolationForestModel.IsolationForestParameters();
            ifParams._train = f._key;
            ifParams._ignored_columns = ignoredColumns;
            ifParams._ntrees = ntrees;
            ifParams._score_each_iteration = true;
            IsolationForestModel isolationForestModel = (IsolationForestModel)new IsolationForest(ifParams).trainModel().get();
            return isolationForestModel;
        }
        finally {
            if (f != null) {
                f.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GLMModel prepareGLMModel(String dataset, String[] ignoredColumns, String response, GLMModel.GLMParameters.Family family) {
        Frame f = ModelSerializationTest.parse_test_file((String)dataset);
        try {
            GLMModel.GLMParameters params = new GLMModel.GLMParameters();
            params._train = f._key;
            params._ignored_columns = ignoredColumns;
            params._response_column = response;
            params._family = family;
            GLMModel gLMModel = (GLMModel)new GLM(params).trainModel().get();
            return gLMModel;
        }
        finally {
            if (f != null) {
                f.delete();
            }
        }
    }

    private <M extends Model> M saveAndLoad(M model) throws IOException {
        return this.saveAndLoad(model, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <M extends Model<?, ?, ?>> M saveAndLoad(M model, boolean deleteModel) throws IOException {
        Model model2;
        block4: {
            File file = File.createTempFile(model.getClass().getSimpleName(), null);
            try {
                String path = file.getAbsolutePath();
                model.exportBinaryModel(path, true);
                if (deleteModel) {
                    model.delete();
                }
                model2 = Model.importBinaryModel((String)path);
                if (file.delete()) break block4;
            }
            catch (Throwable throwable) {
                if (!file.delete()) {
                    Log.err((Object[])new Object[]{"Temporary file " + file + " was not deleted."});
                }
                throw throwable;
            }
            Log.err((Object[])new Object[]{"Temporary file " + file + " was not deleted."});
        }
        return (M)model2;
    }

    public static void assertModelBinaryEquals(Model a, Model b) {
        Assert.assertArrayEquals((String)"The serialized models are not binary same!", (byte[])a.write(new AutoBuffer()).buf(), (byte[])b.write(new AutoBuffer()).buf());
    }

    public static void assertIcedBinaryEquals(String msg, Iced a, Iced b) {
        if (a == null) {
            Assert.assertEquals((String)msg, null, (Object)b);
        } else {
            Assert.assertArrayEquals((String)msg, (byte[])a.write(new AutoBuffer()).buf(), (byte[])b.write(new AutoBuffer()).buf());
        }
    }

    public static void assertTreeEquals(String msg, CompressedTree[][] a, CompressedTree[][] b) {
        ModelSerializationTest.assertTreeEquals(msg, a, b, false);
    }

    public static void assertTreeEquals(String msg, CompressedTree[][] a, CompressedTree[][] b, boolean ignoreKeyField) {
        Assert.assertEquals((String)"Number of trees has to match", (long)a.length, (long)b.length);
        for (int i = 0; i < a.length; ++i) {
            Assert.assertEquals((String)"Number of trees per tree has to match", (long)a[i].length, (long)b[i].length);
            for (int j = 0; j < a[i].length; ++j) {
                Key oldAKey = null;
                Key oldBKey = null;
                if (ignoreKeyField) {
                    if (a[i][j] != null) {
                        oldAKey = a[i][j]._key;
                        a[i][j]._key = null;
                    }
                    if (b[i][j] != null) {
                        oldBKey = b[i][j]._key;
                        b[i][j]._key = null;
                    }
                }
                ModelSerializationTest.assertIcedBinaryEquals(msg, (Iced)a[i][j], (Iced)b[i][j]);
                if (!ignoreKeyField) continue;
                if (a[i][j] != null) {
                    a[i][j]._key = oldAKey;
                }
                if (b[i][j] == null) continue;
                b[i][j]._key = oldBKey;
            }
        }
    }

    public static CompressedTree[][] getTrees(SharedTreeModel tm) {
        SharedTreeModel.SharedTreeOutput tmo = (SharedTreeModel.SharedTreeOutput)tm._output;
        int ntrees = tmo._ntrees;
        int nclasses = tmo.nclasses();
        CompressedTree[][] result = new CompressedTree[ntrees][nclasses];
        for (int i = 0; i < ntrees; ++i) {
            for (int j = 0; j < nclasses; ++j) {
                if (tmo._treeKeys[i][j] == null) continue;
                result[i][j] = tmo.ctree(i, j);
            }
        }
        return result;
    }

    static class BlahModel
    extends Model<BlahModel, BlahParameters, BlahOutput> {
        public BlahModel(Key selfKey, BlahParameters params, BlahOutput output) {
            super(selfKey, (Model.Parameters)params, (Model.Output)output);
        }

        public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
            return null;
        }

        protected double[] score0(double[] data, double[] preds) {
            return new double[0];
        }

        static class BlahOutput
        extends Model.Output {
            public BlahOutput(boolean hasWeights, boolean hasOffset, boolean hasFold) {
                super(hasWeights, hasOffset, hasFold);
            }
        }

        static class BlahParameters
        extends Model.Parameters {
            BlahParameters() {
            }

            public String algoName() {
                return "Blah";
            }

            public String fullName() {
                return "Blah";
            }

            public String javaName() {
                return BlahModel.class.getName();
            }

            public long progressUnits() {
                return 0L;
            }
        }
    }
}

