/*
 * Decompiled with CFR 0.152.
 */
package hex.word2vec;

import hex.word2vec.WordCountTask;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import water.TestUtil;
import water.fvec.Frame;
import water.fvec.TestFrameBuilder;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.util.FileUtils;
import water.util.IcedHashMap;
import water.util.IcedLong;

public class WordCountTaskTest
extends TestUtil {
    @BeforeClass
    public static void setup() {
        WordCountTaskTest.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWordCount() {
        String[] strData = new String[10000];
        for (int i = 0; i < strData.length; ++i) {
            int b = i % 10;
            strData[i] = b < 3 ? "A" : (b < 5 ? "B" : "C");
        }
        Frame fr = new TestFrameBuilder().withName("data").withColNames(new String[]{"Str"}).withVecTypes(new byte[]{2}).withDataForCol(0, strData).withChunkLayout(new long[]{100L, 900L, 5000L, 4000L}).build();
        try {
            IcedHashMap counts = ((WordCountTask)new WordCountTask().doAll((Vec[])new Vec[]{fr.vec((int)0)}))._counts;
            Assert.assertEquals((long)3L, (long)counts.size());
            Assert.assertEquals((long)3000L, (long)((IcedLong)counts.get((Object)new BufferedString((String)"A")))._val);
            Assert.assertEquals((long)2000L, (long)((IcedLong)counts.get((Object)new BufferedString((String)"B")))._val);
            Assert.assertEquals((long)5000L, (long)((IcedLong)counts.get((Object)new BufferedString((String)"C")))._val);
            System.out.println(counts);
        }
        finally {
            fr.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWordCountText8() {
        String fName = "bigdata/laptop/text8.gz";
        Assume.assumeThat((String)"text8 data available", (Object)FileUtils.locateFile((String)fName), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Frame fr = this.parse_test_file(fName, "NA", 0, new byte[]{2});
        try {
            IcedHashMap counts = ((WordCountTask)new WordCountTask().doAll((Vec[])new Vec[]{fr.vec((int)0)}))._counts;
            Assert.assertEquals((long)253854L, (long)counts.size());
            Assert.assertEquals((long)303L, (long)((IcedLong)counts.get((Object)new BufferedString((String)"anarchism")))._val);
            Assert.assertEquals((long)316376L, (long)((IcedLong)counts.get((Object)new BufferedString((String)"to")))._val);
            Assert.assertNotNull((Object)counts);
        }
        finally {
            fr.remove();
        }
    }
}

