/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.isofor;

import hex.tree.isofor.PathTracker;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.Key;
import water.Scope;
import water.TestUtil;
import water.fvec.Chunk;
import water.fvec.Vec;

public class PathTrackerTest
extends TestUtil {
    @BeforeClass
    public static void setup() {
        PathTrackerTest.stall_till_cloudsize((int)1);
    }

    @Test
    public void encodeNewPathLength() {
        try {
            Scope.enter();
            Vec treeVec = Scope.track((Vec)Vec.makeZero((long)2L)).makeVolatileDoubles(1)[0];
            Assert.assertEquals((long)1L, (long)treeVec.nChunks());
            Chunk treeChunk = treeVec.chunkForChunkIdx(0);
            Assert.assertEquals((long)0L, (long)PathTracker.encodeNewPathLength((Chunk)treeChunk, (int)0, (int)0, (boolean)true));
            Assert.assertEquals((long)0L, (long)PathTracker.decodeOOBPathLength((Chunk)treeChunk, (int)0));
            Assert.assertEquals((long)7L, (long)PathTracker.encodeNewPathLength((Chunk)treeChunk, (int)0, (int)7, (boolean)true));
            Assert.assertEquals((long)7L, (long)PathTracker.decodeOOBPathLength((Chunk)treeChunk, (int)0));
            Assert.assertEquals((long)49L, (long)PathTracker.encodeNewPathLength((Chunk)treeChunk, (int)0, (int)42, (boolean)true));
            Assert.assertEquals((long)49L, (long)PathTracker.decodeOOBPathLength((Chunk)treeChunk, (int)0));
            Assert.assertEquals((long)63L, (long)PathTracker.encodeNewPathLength((Chunk)treeChunk, (int)0, (int)14, (boolean)false));
            Assert.assertEquals((long)49L, (long)PathTracker.decodeOOBPathLength((Chunk)treeChunk, (int)0));
            Assert.assertEquals((long)12408L, (long)PathTracker.encodeNewPathLength((Chunk)treeChunk, (int)0, (int)12345, (boolean)false));
            Assert.assertEquals((long)49L, (long)PathTracker.decodeOOBPathLength((Chunk)treeChunk, (int)0));
            Assert.assertEquals((long)66729L, (long)PathTracker.encodeNewPathLength((Chunk)treeChunk, (int)0, (int)54321, (boolean)true));
            Assert.assertEquals((long)54370L, (long)PathTracker.decodeOOBPathLength((Chunk)treeChunk, (int)0));
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void encodeNewPathLength_large() {
        try {
            Scope.enter();
            Vec treeVec = Scope.track((Vec)Vec.makeZero((long)1L)).makeVolatileDoubles(1)[0];
            Assert.assertEquals((long)1L, (long)treeVec.nChunks());
            Chunk treeChunk = treeVec.chunkForChunkIdx(0);
            int total = 0;
            int total_oob = 0;
            for (int i = 0; i < 10000; ++i) {
                boolean wasOOB = i % 3 == 0;
                int depth = 50 + i % 50;
                total += depth;
                if (wasOOB) {
                    total_oob += depth;
                }
                Assert.assertEquals((long)total, (long)PathTracker.encodeNewPathLength((Chunk)treeChunk, (int)0, (int)depth, (boolean)wasOOB));
                Assert.assertEquals((long)total_oob, (long)PathTracker.decodeOOBPathLength((Chunk)treeChunk, (int)0));
            }
            Assert.assertEquals((long)745000L, (long)total);
            Assert.assertEquals((long)248383L, (long)total_oob);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    @Test
    public void addNewPathLength() {
        Assert.assertEquals((long)0L, (long)PathTracker.addNewPathLength((long)0L, (int)0, (boolean)true));
        Assert.assertEquals((long)0x380000000L, (long)PathTracker.addNewPathLength((long)0L, (int)7, (boolean)true));
        Assert.assertEquals((long)0x1880000000L, (long)PathTracker.addNewPathLength((long)0x380000000L, (int)42, (boolean)true));
        Assert.assertEquals((long)105226698766L, (long)PathTracker.addNewPathLength((long)0x1880000000L, (int)14, (boolean)false));
        Assert.assertEquals((long)0L, (long)PathTracker.addNewPathLength((long)0L, (int)0, (boolean)false));
        Assert.assertEquals((long)7L, (long)PathTracker.addNewPathLength((long)0L, (int)7, (boolean)false));
        Assert.assertEquals((long)49L, (long)PathTracker.addNewPathLength((long)7L, (int)42, (boolean)false));
        Assert.assertEquals((long)6442450993L, (long)PathTracker.addNewPathLength((long)49L, (int)3, (boolean)true));
    }

    @Test
    public void decodeOOBPathLength() {
        Assert.assertEquals((long)0L, (long)PathTracker.decodeOOBPathLength((long)0L));
        Assert.assertEquals((long)7L, (long)PathTracker.decodeOOBPathLength((long)0x380000000L));
        Assert.assertEquals((long)49L, (long)PathTracker.decodeOOBPathLength((long)0x1880000000L));
        Assert.assertEquals((long)49L, (long)PathTracker.decodeOOBPathLength((long)105226698766L));
        Assert.assertEquals((long)0L, (long)PathTracker.decodeOOBPathLength((long)14L));
        Assert.assertEquals((long)0L, (long)PathTracker.decodeOOBPathLength((long)Integer.MAX_VALUE));
        Assert.assertEquals((long)1L, (long)PathTracker.decodeOOBPathLength((long)0x80000000L));
    }
}

