/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.isofor;

import hex.genmodel.algos.tree.SharedTreeNode;
import hex.genmodel.algos.tree.SharedTreeSubgraph;
import hex.tree.isofor.IsolationForest;
import hex.tree.isofor.IsolationForestModel;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.Key;
import water.Keyed;
import water.Scope;
import water.TestUtil;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Frame;
import water.util.ArrayUtils;

public class IsolationForestTest
extends TestUtil {
    @BeforeClass
    public static void setup() {
        IsolationForestTest.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasic() {
        try {
            Scope.enter();
            Frame train = Scope.track((Frame[])new Frame[]{IsolationForestTest.parse_test_file((String)"smalldata/anomaly/ecg_discord_train.csv")});
            IsolationForestModel.IsolationForestParameters p = new IsolationForestModel.IsolationForestParameters();
            p._train = train._key;
            p._seed = 912559L;
            p._ntrees = 7;
            p._min_rows = 1.0;
            p._sample_size = 5L;
            IsolationForestModel model = (IsolationForestModel)new IsolationForest(p).trainModel().get();
            Assert.assertNotNull((Object)model);
            Scope.track_generic((Keyed)model);
            Frame preds = Scope.track((Frame[])new Frame[]{model.score(train)});
            Assert.assertArrayEquals((Object[])new String[]{"predict", "mean_length"}, (Object[])preds.names());
            Assert.assertEquals((long)train.numRows(), (long)preds.numRows());
            Assert.assertTrue((boolean)model.testJavaScoring(train, preds, 1.0E-8));
            Assert.assertTrue((((IsolationForestModel.IsolationForestOutput)model._output)._min_path_length < Integer.MAX_VALUE ? 1 : 0) != 0);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEarlyStopping() {
        try {
            Scope.enter();
            Frame train = Scope.track((Frame[])new Frame[]{IsolationForestTest.parse_test_file((String)"smalldata/anomaly/ecg_discord_train.csv")});
            IsolationForestModel.IsolationForestParameters p = new IsolationForestModel.IsolationForestParameters();
            p._train = train._key;
            p._seed = 912559L;
            p._ntrees = 1000;
            p._min_rows = 1.0;
            p._sample_size = 5L;
            p._stopping_rounds = 3;
            p._score_each_iteration = true;
            p._stopping_tolerance = 0.05;
            IsolationForestModel model = (IsolationForestModel)new IsolationForest(p).trainModel().get();
            Assert.assertNotNull((Object)model);
            Scope.track_generic((Keyed)model);
            Assert.assertEquals((float)0.0f, (float)((IsolationForestModel.IsolationForestOutput)model._output)._ntrees, (float)20.0f);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyOOB() {
        try {
            Scope.enter();
            Frame train = Scope.track((Frame[])new Frame[]{IsolationForestTest.parse_test_file((String)"smalldata/anomaly/ecg_discord_train.csv")});
            IsolationForestModel.IsolationForestParameters p = new IsolationForestModel.IsolationForestParameters();
            p._train = train._key;
            p._seed = 912559L;
            p._ntrees = 7;
            p._sample_size = train.numRows();
            IsolationForestModel model = (IsolationForestModel)new IsolationForest(p).trainModel().get();
            Assert.assertNotNull((Object)model);
            Scope.track_generic((Keyed)model);
            Frame preds = Scope.track((Frame[])new Frame[]{model.score(train)});
            Assert.assertArrayEquals((Object[])new String[]{"predict", "mean_length"}, (Object[])preds.names());
            Assert.assertEquals((long)train.numRows(), (long)preds.numRows());
            Assert.assertTrue((boolean)model.testJavaScoring(train, preds, 1.0E-8));
            Assert.assertTrue((((IsolationForestModel.IsolationForestOutput)model._output)._min_path_length < Integer.MAX_VALUE ? 1 : 0) != 0);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPubDev6483() {
        try {
            Scope.enter();
            Frame train = Scope.track((Frame[])new Frame[]{IsolationForestTest.parse_test_file((String)"smalldata/anomaly/ecg_discord_train.csv")});
            IsolationForestModel.IsolationForestParameters p = new IsolationForestModel.IsolationForestParameters();
            p._train = train._key;
            p._seed = 912559L;
            p._ntrees = 7;
            p._mtries = train.numCols();
            IsolationForestModel model = (IsolationForestModel)new IsolationForest(p).trainModel().get();
            Assert.assertNotNull((Object)model);
            Scope.track_generic((Keyed)model);
            IsolationForestModel.IsolationForestParameters p_invalid = new IsolationForestModel.IsolationForestParameters();
            p_invalid._train = train._key;
            p_invalid._seed = 912559L;
            p_invalid._ntrees = 7;
            p_invalid._mtries = train.numCols() + 1;
            try {
                Scope.track_generic((Keyed)new IsolationForest(p_invalid).trainModel().get());
                Assert.fail();
            }
            catch (H2OIllegalArgumentException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("ERRR on field: _mtries: Computed mtries should be -1 or -2 or in interval [1,210] but it is 211"));
            }
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVarSplits() {
        try {
            Scope.enter();
            Frame train = Scope.track((Frame[])new Frame[]{IsolationForestTest.parse_test_file((String)"smalldata/testng/prostate.csv")});
            IsolationForestModel.IsolationForestParameters p = new IsolationForestModel.IsolationForestParameters();
            p._train = train._key;
            p._seed = 912559L;
            p._ntrees = 1;
            IsolationForestModel model = (IsolationForestModel)new IsolationForest(p).trainModel().get();
            Assert.assertNotNull((Object)model);
            Scope.track_generic((Keyed)model);
            IsolationForest.VarSplits splits = ((IsolationForestModel.IsolationForestOutput)model._output)._var_splits;
            SharedTreeSubgraph tree = model.getSharedTreeSubgraph(0, 0);
            int[] expSplitCounts = new int[((IsolationForestModel.IsolationForestOutput)model._output).nfeatures()];
            long[] expDepths = new long[((IsolationForestModel.IsolationForestOutput)model._output).nfeatures()];
            int nSplits = 0;
            for (SharedTreeNode node : tree.nodesArray) {
                if (node.isLeaf()) continue;
                ++nSplits;
                int n = node.getColId();
                expSplitCounts[n] = expSplitCounts[n] + 1;
                int n2 = node.getColId();
                expDepths[n2] = expDepths[n2] + (long)(node.getDepth() + 1);
            }
            Assert.assertEquals((long)nSplits, (long)ArrayUtils.sum((int[])splits._splitCounts));
            Assert.assertArrayEquals((int[])expSplitCounts, (int[])splits._splitCounts);
            Assert.assertArrayEquals((long[])expDepths, (long[])splits._splitDepths);
            for (int i = 0; i < ((IsolationForestModel.IsolationForestOutput)model._output).nfeatures(); ++i) {
                Assert.assertEquals((Object)expSplitCounts[i], (Object)((IsolationForestModel.IsolationForestOutput)model._output)._variable_splits.get(i, 0));
                Assert.assertEquals((Object)expDepths[i], (Object)((IsolationForestModel.IsolationForestOutput)model._output)._variable_splits.get(i, 2));
            }
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }
}

