/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.gbm;

import hex.AUC2;
import hex.CreateFrame;
import hex.KeyValue;
import hex.Model;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsMultinomial;
import hex.ModelMetricsRegression;
import hex.ScoreKeeper;
import hex.SplitFrame;
import hex.genmodel.GenModel;
import hex.genmodel.MojoModel;
import hex.genmodel.algos.gbm.GbmMojoModel;
import hex.genmodel.algos.tree.SharedTreeNode;
import hex.genmodel.algos.tree.SharedTreeSubgraph;
import hex.genmodel.easy.EasyPredictModelWrapper;
import hex.genmodel.easy.RowData;
import hex.genmodel.easy.exception.PredictException;
import hex.genmodel.easy.prediction.BinomialModelPrediction;
import hex.genmodel.easy.prediction.MultinomialModelPrediction;
import hex.genmodel.tools.PredictCsv;
import hex.genmodel.utils.DistributionFamily;
import hex.tree.Constraints;
import hex.tree.SharedTreeModel;
import hex.tree.gbm.GBM;
import hex.tree.gbm.GBMModel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import water.DKV;
import water.H2O;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.Scope;
import water.TestUtil;
import water.api.StreamWriter;
import water.api.StreamingSchema;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Chunk;
import water.fvec.FVecTest;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.RebalanceDataSet;
import water.fvec.TestFrameBuilder;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.parser.ParseDataset;
import water.parser.ParseSetup;
import water.util.ArrayUtils;
import water.util.JCodeGen;
import water.util.Log;
import water.util.MathUtils;
import water.util.Pair;
import water.util.RandomUtils;
import water.util.Triple;

@RunWith(value=Parameterized.class)
public class GBMTest
extends TestUtil {
    @Rule
    public transient ExpectedException expectedException = ExpectedException.none();
    @Rule
    public transient TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Parameterized.Parameter
    public String test_type;
    static final String[] ignored_aircols = new String[]{"DepTime", "ArrTime", "AirTime", "ArrDelay", "DepDelay", "TaxiIn", "TaxiOut", "Cancelled", "CancellationCode", "Diverted", "CarrierDelay", "WeatherDelay", "NASDelay", "SecurityDelay", "LateAircraftDelay", "IsDepDelayed"};
    static double _AUC = 1.0;
    static double _MSE = 0.24850374695598948;
    static double _LogLoss = 0.690155;

    @BeforeClass
    public static void stall() {
        GBMTest.stall_till_cloudsize((int)1);
    }

    @Parameterized.Parameters(name="{index}: gbm({0})")
    public static Iterable<?> data() {
        if (MINCLOUDSIZE > 1) {
            return Collections.singletonList("Default");
        }
        return Arrays.asList("Default", "EmulateConstraints");
    }

    private GBMModel.GBMParameters makeGBMParameters() {
        if ("EmulateConstraints".equals(this.test_type)) {
            return new GBMModel.GBMParameters(){

                Constraints emptyConstraints(Frame f) {
                    if (this._distribution == DistributionFamily.gaussian || this._distribution == DistributionFamily.bernoulli) {
                        return new Constraints(new int[f.numCols()], this._distribution, true);
                    }
                    return null;
                }
            };
        }
        return new GBMModel.GBMParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGBMRegressionGaussian() {
        GBMModel gbm = null;
        Frame fr = null;
        Frame fr2 = null;
        try {
            fr = GBMTest.parse_test_file((String)"./smalldata/gbm_test/Mfgdata_gaussian_GBM_testing.csv");
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = fr._key;
            parms._distribution = DistributionFamily.gaussian;
            parms._response_column = fr._names[1];
            parms._ntrees = 1;
            parms._max_depth = 1;
            parms._min_rows = 1.0;
            parms._nbins = 20;
            parms._ignored_columns = new String[fr.numCols() - 2];
            String[] xcols = parms._ignored_columns;
            xcols[0] = fr._names[0];
            System.arraycopy(fr._names, 3, xcols, 1, fr.numCols() - 3);
            parms._learn_rate = 1.0;
            parms._score_each_iteration = true;
            GBM job = new GBM(parms);
            gbm = (GBMModel)job.trainModel().get();
            Assert.assertTrue((boolean)job.isStopped());
            fr2 = gbm.score(fr);
            double sq_err = ((MathUtils.SquareError)new MathUtils.SquareError().doAll((Vec[])new Vec[]{fr.vecs()[1], fr2.vecs()[0]}))._sum;
            double mse = sq_err / (double)fr2.numRows();
            Assert.assertEquals((double)79152.12337641386, (double)mse, (double)0.1);
            Assert.assertEquals((double)79152.12337641386, (double)((GBMModel.GBMOutput)gbm._output)._scored_train[1]._mse, (double)0.1);
            Assert.assertEquals((double)79152.12337641386, (double)((GBMModel.GBMOutput)gbm._output)._scored_train[1]._mean_residual_deviance, (double)0.1);
        }
        finally {
            if (fr != null) {
                fr.remove();
            }
            if (fr2 != null) {
                fr2.remove();
            }
            if (gbm != null) {
                gbm.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOneHotExplicitWithPOJO() throws Exception {
        try {
            Scope.enter();
            String response = "CAPSULE";
            String testFile = "./smalldata/logreg/prostate.csv";
            Frame fr = GBMTest.parse_test_file((String)"./smalldata/logreg/prostate.csv").toCategoricalCol("RACE").toCategoricalCol("GLEASON").toCategoricalCol("CAPSULE");
            fr.remove("ID").remove();
            fr.vec("RACE").setDomain((String[])ArrayUtils.append((Object[])fr.vec("RACE").domain(), (Object[])new String[]{"3"}));
            Scope.track((Frame[])new Frame[]{fr});
            DKV.put((Keyed)fr);
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = fr._key;
            parms._response_column = "CAPSULE";
            parms._ntrees = 5;
            parms._categorical_encoding = Model.Parameters.CategoricalEncodingScheme.OneHotExplicit;
            GBM job = new GBM(parms);
            GBMModel gbm = (GBMModel)job.trainModel().get();
            Scope.track_generic((Keyed)gbm);
            Frame scored = Scope.track((Frame[])new Frame[]{gbm.score(fr)});
            Assert.assertTrue((boolean)gbm.testJavaScoring(fr, scored, 1.0E-15));
            File pojoScoringOutput = this.temporaryFolder.newFile(gbm._key + "_scored.csv");
            String modelName = JCodeGen.toJavaId((String)gbm._key.toString());
            String pojoSource = gbm.toJava(false, true);
            Class pojoClass = JCodeGen.compile((String)modelName, (String)pojoSource);
            PredictCsv predictor = PredictCsv.make((String[])new String[]{"--embedded", "--input", TestUtil.makeNfsFileVec((String)"./smalldata/logreg/prostate.csv").getPath(), "--output", pojoScoringOutput.getAbsolutePath(), "--decimal"}, (GenModel)((GenModel)pojoClass.newInstance()));
            predictor.run();
            Frame scoredWithMojo = Scope.track((Frame[])new Frame[]{GBMTest.parse_test_file((String)pojoScoringOutput.getAbsolutePath(), (TestUtil.ParseSetupTransformer)new TestUtil.ParseSetupTransformer(){

                public ParseSetup transformSetup(ParseSetup guessedSetup) {
                    return guessedSetup.setCheckHeader(1);
                }
            })});
            scoredWithMojo.setNames(scored.names());
            GBMTest.assertFrameEquals((Frame)scored, (Frame)scoredWithMojo, (double)1.0E-8);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    @Test
    public void testBasicGBM() {
        this.basicGBM("./smalldata/junit/cars.csv", new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("name").remove();
                return ~fr.find("economy (mpg)");
            }
        }, false, DistributionFamily.gaussian);
        this.basicGBM("./smalldata/junit/cars.csv", new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("name").remove();
                return ~fr.find("economy (mpg)");
            }
        }, false, DistributionFamily.poisson);
        this.basicGBM("./smalldata/junit/cars.csv", new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("name").remove();
                return ~fr.find("economy (mpg)");
            }
        }, false, DistributionFamily.gamma);
        this.basicGBM("./smalldata/junit/cars.csv", new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("name").remove();
                return ~fr.find("economy (mpg)");
            }
        }, false, DistributionFamily.tweedie);
        this.basicGBM("./smalldata/junit/test_tree.csv", new PrepData(){

            @Override
            int prep(Frame fr) {
                return 1;
            }
        }, false, DistributionFamily.multinomial);
        this.basicGBM("./smalldata/junit/test_tree_minmax.csv", new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.find("response");
            }
        }, false, DistributionFamily.bernoulli);
        this.basicGBM("./smalldata/logreg/prostate.csv", new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("ID").remove();
                return fr.find("CAPSULE");
            }
        }, false, DistributionFamily.bernoulli);
        this.basicGBM("./smalldata/logreg/prostate.csv", new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("ID").remove();
                return fr.find("CAPSULE");
            }
        }, false, DistributionFamily.multinomial);
        this.basicGBM("./smalldata/junit/cars.csv", new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("name").remove();
                return fr.find("cylinders");
            }
        }, false, DistributionFamily.multinomial);
        this.basicGBM("./smalldata/gbm_test/alphabet_cattest.csv", new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.find("y");
            }
        }, false, DistributionFamily.bernoulli);
        this.basicGBM("./smalldata/airlines/allyears2k_headers.zip", new PrepData(){

            @Override
            int prep(Frame fr) {
                for (String s : ignored_aircols) {
                    fr.remove(s).remove();
                }
                return fr.find("IsArrDelayed");
            }
        }, false, DistributionFamily.bernoulli);
    }

    @Test
    public void testBasicGBMFamily() {
        Scope.enter();
        this.basicGBM("./smalldata/logreg/prostate.csv", new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("ID").remove();
                int ci = fr.find("RACE");
                Scope.track((Vec)fr.replace(ci, fr.vecs()[ci].toCategoricalVec()));
                return fr.find("CAPSULE");
            }
        }, false, DistributionFamily.bernoulli);
        Scope.exit((Key[])new Key[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GBMModel.GBMOutput basicGBM(String fname, PrepData prep, boolean validation, DistributionFamily family) {
        GBMModel gbm = null;
        Frame fr = null;
        Frame fr2 = null;
        Frame vfr = null;
        try {
            Scope.enter();
            fr = GBMTest.parse_test_file((String)fname);
            int idx = prep.prep(fr);
            if (!(family != DistributionFamily.bernoulli && family != DistributionFamily.multinomial && family != DistributionFamily.modified_huber || fr.vecs()[idx].isCategorical())) {
                Scope.track((Vec)fr.replace(idx, fr.vecs()[idx].toCategoricalVec()));
            }
            DKV.put((Keyed)fr);
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            if (idx < 0) {
                idx ^= 0xFFFFFFFF;
            }
            parms._train = fr._key;
            parms._response_column = fr._names[idx];
            parms._ntrees = 5;
            parms._distribution = family;
            parms._max_depth = 4;
            parms._min_rows = 1.0;
            parms._nbins = 50;
            parms._learn_rate = 0.2f;
            parms._score_each_iteration = true;
            if (validation) {
                vfr = new Frame(fr);
                DKV.put((Keyed)vfr);
                parms._valid = vfr._key;
            }
            GBM job = new GBM(parms);
            gbm = (GBMModel)job.trainModel().get();
            fr2 = gbm.score(fr);
            Assert.assertTrue((boolean)gbm.testJavaScoring(fr, fr2, 1.0E-15));
            Assert.assertTrue((boolean)job.isStopped());
            GBMModel.GBMOutput gBMOutput = (GBMModel.GBMOutput)gbm._output;
            return gBMOutput;
        }
        finally {
            if (fr != null) {
                fr.remove();
            }
            if (fr2 != null) {
                fr2.remove();
            }
            if (vfr != null) {
                vfr.remove();
            }
            if (gbm != null) {
                gbm.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGBMTrainTest() {
        GBMModel gbm = null;
        GBMModel.GBMParameters parms = this.makeGBMParameters();
        try {
            Scope.enter();
            parms._valid = GBMTest.parse_test_file((String)"smalldata/gbm_test/ecology_eval.csv")._key;
            Frame train = GBMTest.parse_test_file((String)"smalldata/gbm_test/ecology_model.csv");
            train.remove("Site").remove();
            int ci = train.find("Angaus");
            Scope.track((Vec)train.replace(ci, train.vecs()[ci].toCategoricalVec()));
            DKV.put((Keyed)train);
            parms._train = train._key;
            parms._response_column = "Angaus";
            parms._ntrees = 5;
            parms._max_depth = 5;
            parms._min_rows = 10.0;
            parms._nbins = 100;
            parms._learn_rate = 0.2f;
            parms._distribution = DistributionFamily.multinomial;
            gbm = (GBMModel)new GBM(parms).trainModel().get();
            ModelMetricsBinomial mm = ModelMetricsBinomial.getFromDKV((Model)gbm, (Frame)parms.valid());
            double auc = mm._auc._auc;
            Assert.assertTrue((0.83 <= auc && auc < 0.87 ? 1 : 0) != 0);
            double[][] cm = mm._auc.defaultCM();
            Assert.assertArrayEquals((Object[])GBMTest.ard((double[][])new double[][]{GBMTest.ard((double[])new double[]{349.0, 44.0}), GBMTest.ard((double[])new double[]{43.0, 64.0})}), (Object[])cm);
        }
        finally {
            parms._train.remove();
            parms._valid.remove();
            if (gbm != null) {
                gbm.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGBMPredict() {
        GBMModel gbm = null;
        GBMModel.GBMParameters parms = this.makeGBMParameters();
        Frame pred = null;
        Frame res = null;
        Scope.enter();
        try {
            Frame train = GBMTest.parse_test_file((String)"smalldata/gbm_test/ecology_model.csv");
            train.remove("Site").remove();
            int ci = train.find("Angaus");
            Scope.track((Vec)train.replace(ci, train.vecs()[ci].toCategoricalVec()));
            DKV.put((Keyed)train);
            parms._train = train._key;
            parms._response_column = "Angaus";
            parms._distribution = DistributionFamily.multinomial;
            gbm = (GBMModel)new GBM(parms).trainModel().get();
            pred = GBMTest.parse_test_file((String)"smalldata/gbm_test/ecology_eval.csv");
            pred.remove("Angaus").remove();
            res = gbm.score(pred);
            Assert.assertTrue((boolean)gbm.testJavaScoring(pred, res, 1.0E-15));
        }
        finally {
            parms._train.remove();
            if (gbm != null) {
                gbm.delete();
            }
            if (pred != null) {
                pred.remove();
            }
            if (res != null) {
                res.remove();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGBMPredictWithCalibration() {
        GBMModel gbm = null;
        GBMModel.GBMParameters parms = this.makeGBMParameters();
        Scope.enter();
        try {
            Frame train = GBMTest.parse_test_file((String)"smalldata/gbm_test/ecology_model.csv");
            Frame calib = GBMTest.parse_test_file((String)"smalldata/gbm_test/ecology_eval.csv");
            train.remove("Site").remove();
            Scope.track((Vec)train.vec("Angaus"));
            train.replace(train.find("Angaus"), train.vecs()[train.find("Angaus")].toCategoricalVec());
            Scope.track((Frame[])new Frame[]{train});
            DKV.put((Keyed)train);
            Scope.track((Vec)calib.vec("Angaus"));
            calib.replace(calib.find("Angaus"), calib.vecs()[calib.find("Angaus")].toCategoricalVec());
            Scope.track((Frame[])new Frame[]{calib});
            DKV.put((Keyed)calib);
            parms._train = train._key;
            parms._calibrate_model = true;
            parms._calibration_frame = calib._key;
            parms._response_column = "Angaus";
            parms._distribution = DistributionFamily.multinomial;
            gbm = (GBMModel)new GBM(parms).trainModel().get();
            Frame pred = GBMTest.parse_test_file((String)"smalldata/gbm_test/ecology_eval.csv");
            pred.remove("Angaus").remove();
            Scope.track((Frame[])new Frame[]{pred});
            Frame res = Scope.track((Frame[])new Frame[]{gbm.score(pred)});
            Assert.assertArrayEquals((Object[])new String[]{"predict", "p0", "p1", "cal_p0", "cal_p1"}, (Object[])res._names);
            Assert.assertEquals((double)res.vec("cal_p0").mean(), (double)0.786, (double)1.0E-4);
            Assert.assertEquals((double)res.vec("cal_p1").mean(), (double)0.2139, (double)1.0E-4);
        }
        finally {
            if (gbm != null) {
                gbm.remove();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModelAdaptMultinomial() {
        GBMModel gbm = null;
        GBMModel.GBMParameters parms = this.makeGBMParameters();
        try {
            Scope.enter();
            parms._train = GBMTest.parse_test_file((String)"smalldata/junit/mixcat_train.csv")._key;
            Frame v = GBMTest.parse_test_file((String)"smalldata/junit/mixcat_test.csv");
            parms._valid = v._key;
            parms._response_column = "Response";
            parms._ntrees = 1;
            parms._learn_rate = 1.0;
            parms._min_rows = 1.0;
            parms._distribution = DistributionFamily.multinomial;
            gbm = (GBMModel)new GBM(parms).trainModel().get();
            Frame res = gbm.score(v);
            int[] ps = new int[(int)v.numRows()];
            Vec.Reader vr = new Vec.Reader(res.vecs()[0]);
            for (int i = 0; i < ps.length; ++i) {
                ps[i] = (int)vr.at8((long)i);
            }
            Assert.assertArrayEquals((String)"", (int[])ps, (int[])new int[]{1, 1, 2, 2, 1, 2, 3, 1, 2});
            ModelMetricsMultinomial mm = ModelMetricsMultinomial.getFromDKV((Model)gbm, (Frame)parms.valid());
            Assert.assertTrue((boolean)gbm.testJavaScoring(v, res, 1.0E-15));
            res.remove();
        }
        finally {
            parms._train.remove();
            parms._valid.remove();
            if (gbm != null) {
                gbm.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPredictLeafNodeAssignment() {
        Scope.enter();
        try {
            Key target = Key.make();
            Frame train = Scope.track((Frame[])new Frame[]{GBMTest.parse_test_file((String)"smalldata/gbm_test/ecology_model.csv")});
            train.remove("Site").remove();
            int ci = train.find("Angaus");
            Scope.track((Vec)train.replace(ci, train.vecs()[ci].toCategoricalVec()));
            DKV.put((Keyed)train);
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = train._key;
            parms._response_column = "Angaus";
            parms._distribution = DistributionFamily.multinomial;
            GBMModel gbm = (GBMModel)Scope.track_generic((Keyed)new GBM(parms).trainModel().get());
            Frame pred = Scope.track((Frame[])new Frame[]{GBMTest.parse_test_file((String)"smalldata/gbm_test/ecology_eval.csv")});
            pred.remove("Angaus").remove();
            Frame nodeIds = Scope.track((Frame[])new Frame[]{gbm.scoreLeafNodeAssignment(pred, Model.LeafNodeAssignment.LeafNodeAssignmentType.Node_ID, target)});
            Frame nodePaths = Scope.track((Frame[])new Frame[]{gbm.scoreLeafNodeAssignment(pred, Model.LeafNodeAssignment.LeafNodeAssignmentType.Path, target)});
            Assert.assertArrayEquals((Object[])nodePaths._names, (Object[])nodeIds._names);
            Assert.assertEquals((long)nodePaths.numRows(), (long)nodeIds.numRows());
            for (int i = 0; i < nodePaths.numCols(); ++i) {
                String[] paths = nodePaths.vec(i).domain();
                Vec.Reader pathVecRdr = new Vec.Reader(nodePaths.vec(i));
                Vec.Reader nodeIdVecRdr = new Vec.Reader(nodeIds.vec(i));
                SharedTreeSubgraph tree = gbm.getSharedTreeSubgraph(i, 0);
                for (long j = 0L; j < nodePaths.numRows(); ++j) {
                    String path = paths[(int)pathVecRdr.at8(j)];
                    int nodeId = (int)nodeIdVecRdr.at8(j);
                    SharedTreeNode node = tree.walkNodes(path);
                    Assert.assertEquals((long)node.getNodeNumber(), (long)nodeId);
                }
            }
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPredictStagedProbabilitiesBinomial() {
        Scope.enter();
        try {
            Key target = Key.make();
            Frame train = Scope.track((Frame[])new Frame[]{GBMTest.parse_test_file((String)"smalldata/gbm_test/ecology_model.csv")});
            train.remove("Site").remove();
            int ci = train.find("Angaus");
            Scope.track((Vec)train.replace(ci, train.vecs()[ci].toCategoricalVec()));
            DKV.put((Keyed)train);
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = train._key;
            parms._response_column = "Angaus";
            parms._distribution = DistributionFamily.bernoulli;
            GBMModel gbm = (GBMModel)Scope.track_generic((Keyed)new GBM(parms).trainModel().get());
            Frame stagedProbabilities = Scope.track((Frame[])new Frame[]{gbm.scoreStagedPredictions(train, target)});
            Frame predictions = gbm.score(train);
            try {
                GbmMojoModel mojoModel = (GbmMojoModel)gbm.toMojo();
                EasyPredictModelWrapper model = new EasyPredictModelWrapper(new EasyPredictModelWrapper.Config().setModel((GenModel)mojoModel).setEnableStagedProbabilities(true));
                for (int r = 0; r < 10; ++r) {
                    double[] stagedProbabilitiesRow = new double[stagedProbabilities.numCols()];
                    for (int c = 0; c < stagedProbabilities.numCols(); ++c) {
                        stagedProbabilitiesRow[c] = stagedProbabilities.vec(c).at((long)r);
                    }
                    RowData tmpRow = new RowData();
                    BufferedString bStr = new BufferedString();
                    for (int c = 0; c < train.numCols(); ++c) {
                        if (train.vec(c).isCategorical()) {
                            tmpRow.put((Object)train.names()[c], (Object)train.vec(c).atStr(bStr, (long)r).toString());
                            continue;
                        }
                        tmpRow.put((Object)train.names()[c], (Object)train.vec(c).at((long)r));
                    }
                    BinomialModelPrediction tmpPrediction = model.predictBinomial(tmpRow);
                    double[] mojoStageProbabilitiesRow = tmpPrediction.stageProbabilities;
                    Assert.assertArrayEquals((double[])stagedProbabilitiesRow, (double[])mojoStageProbabilitiesRow, (double)1.0E-15);
                    double final_prediction = predictions.vec(1).at((long)r);
                    Assert.assertEquals((double)final_prediction, (double)stagedProbabilitiesRow[stagedProbabilitiesRow.length - 1], (double)1.0E-15);
                }
            }
            catch (PredictException | IOException ex) {
                Assert.fail((String)ex.toString());
            }
            finally {
                gbm.delete();
                if (stagedProbabilities != null) {
                    stagedProbabilities.delete();
                }
                if (predictions != null) {
                    predictions.delete();
                }
            }
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPredictStagedProbabilitiesMultinomial() {
        Scope.enter();
        try {
            Key target = Key.make();
            Frame train = Scope.track((Frame[])new Frame[]{GBMTest.parse_test_file((String)"./smalldata/logreg/prostate.csv")});
            train.remove("ID").remove();
            int ci = train.find("RACE");
            Scope.track((Vec)train.replace(ci, train.vecs()[ci].toCategoricalVec()));
            DKV.put((Keyed)train);
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = train._key;
            parms._response_column = "RACE";
            parms._distribution = DistributionFamily.multinomial;
            GBMModel gbm = (GBMModel)Scope.track_generic((Keyed)new GBM(parms).trainModel().get());
            Frame stagedProbabilities = Scope.track((Frame[])new Frame[]{gbm.scoreStagedPredictions(train, target)});
            Frame predictions = gbm.score(train);
            try {
                GbmMojoModel mojoModel = (GbmMojoModel)gbm.toMojo();
                EasyPredictModelWrapper model = new EasyPredictModelWrapper(new EasyPredictModelWrapper.Config().setModel((GenModel)mojoModel).setEnableStagedProbabilities(true));
                for (int r = 0; r < 10; ++r) {
                    double[] stagedProbabilitiesRow = new double[stagedProbabilities.numCols()];
                    for (int c = 0; c < stagedProbabilities.numCols(); ++c) {
                        stagedProbabilitiesRow[c] = stagedProbabilities.vec(c).at((long)r);
                    }
                    RowData tmpRow = new RowData();
                    BufferedString bStr = new BufferedString();
                    for (int c = 0; c < train.numCols(); ++c) {
                        if (train.vec(c).isCategorical()) {
                            tmpRow.put((Object)train.names()[c], (Object)train.vec(c).atStr(bStr, (long)r).toString());
                            continue;
                        }
                        tmpRow.put((Object)train.names()[c], (Object)train.vec(c).at((long)r));
                    }
                    MultinomialModelPrediction tmpPrediction = model.predictMultinomial(tmpRow);
                    double[] mojoStageProbabilitiesRow = tmpPrediction.stageProbabilities;
                    Assert.assertArrayEquals((double[])stagedProbabilitiesRow, (double[])mojoStageProbabilitiesRow, (double)1.0E-15);
                    double[] final_prediction = new double[]{predictions.vec(1).at((long)r), predictions.vec(2).at((long)r), predictions.vec(3).at((long)r)};
                    Assert.assertArrayEquals((double[])final_prediction, (double[])Arrays.copyOfRange(stagedProbabilitiesRow, stagedProbabilitiesRow.length - 3, stagedProbabilitiesRow.length), (double)1.0E-15);
                }
            }
            catch (PredictException | IOException ex) {
                Assert.fail((String)ex.toString());
            }
            finally {
                gbm.delete();
                if (stagedProbabilities != null) {
                    stagedProbabilities.delete();
                }
                if (predictions != null) {
                    predictions.delete();
                }
            }
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModelLock() {
        Scope.enter();
        try {
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            Frame fr = Scope.track((Frame[])new Frame[]{GBMTest.parse_test_file((String)"smalldata/gbm_test/ecology_model.csv")});
            fr.remove("Site").remove();
            int ci = fr.find("Angaus");
            Scope.track((Vec)fr.replace(ci, fr.vecs()[ci].toCategoricalVec()));
            DKV.put((Keyed)fr);
            parms._train = fr._key;
            parms._response_column = "Angaus";
            parms._ntrees = 50;
            parms._max_depth = 10;
            parms._min_rows = 1.0;
            parms._learn_rate = 0.2f;
            parms._seed = 42L;
            parms._distribution = DistributionFamily.multinomial;
            GBM gbm = new GBM(parms);
            gbm.trainModel();
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            boolean delete_ok = false;
            try {
                Log.info((Object[])new Object[]{"Trying illegal frame delete."});
                fr.delete();
                delete_ok = true;
                Log.err((Object[])new Object[]{"Frame " + fr._key + " was deleted while it should have been locked!"});
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (RuntimeException re) {
                Assert.assertTrue((boolean)(re.getCause() instanceof IllegalArgumentException));
            }
            Log.info((Object[])new Object[]{"Getting model"});
            Scope.track_generic((Keyed)gbm.get());
            Assert.assertTrue((boolean)gbm.isStopped());
            Assert.assertFalse((String)("Frame " + fr._key + " was deleted while it should have been locked!"), (boolean)delete_ok);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    @Test
    public void testModelScoreKeeperEqualityOnProstateBernoulli() {
        PrepData prostatePrep = new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("ID").remove();
                return fr.find("CAPSULE");
            }
        };
        Object[] scoredWithoutVal = this.basicGBM((String)"./smalldata/logreg/prostate.csv", (PrepData)prostatePrep, (boolean)false, (DistributionFamily)DistributionFamily.bernoulli)._scored_train;
        Object[] scoredWithVal = this.basicGBM((String)"./smalldata/logreg/prostate.csv", (PrepData)prostatePrep, (boolean)true, (DistributionFamily)DistributionFamily.bernoulli)._scored_valid;
        Assert.assertArrayEquals((String)"GBM has to report same list of MSEs for run without/with validation dataset (which is equal to training data)", (Object[])scoredWithoutVal, (Object[])scoredWithVal);
    }

    @Test
    public void testModelScoreKeeperEqualityOnProstateGaussian() {
        PrepData prostatePrep = new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("ID").remove();
                return ~fr.find("CAPSULE");
            }
        };
        Object[] scoredWithoutVal = this.basicGBM((String)"./smalldata/logreg/prostate.csv", (PrepData)prostatePrep, (boolean)false, (DistributionFamily)DistributionFamily.gaussian)._scored_train;
        Object[] scoredWithVal = this.basicGBM((String)"./smalldata/logreg/prostate.csv", (PrepData)prostatePrep, (boolean)true, (DistributionFamily)DistributionFamily.gaussian)._scored_valid;
        Assert.assertArrayEquals((String)"GBM has to report same list of MSEs for run without/with validation dataset (which is equal to training data)", (Object[])scoredWithoutVal, (Object[])scoredWithVal);
    }

    @Test
    public void testModelScoreKeeperEqualityOnProstateQuasibinomial() {
        PrepData prostatePrep = new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("ID").remove();
                return ~fr.find("CAPSULE");
            }
        };
        Object[] scoredWithoutVal = this.basicGBM((String)"./smalldata/logreg/prostate.csv", (PrepData)prostatePrep, (boolean)false, (DistributionFamily)DistributionFamily.quasibinomial)._scored_train;
        Object[] scoredWithVal = this.basicGBM((String)"./smalldata/logreg/prostate.csv", (PrepData)prostatePrep, (boolean)true, (DistributionFamily)DistributionFamily.quasibinomial)._scored_valid;
        Assert.assertArrayEquals((String)"GBM has to report same list of MSEs for run without/with validation dataset (which is equal to training data)", (Object[])scoredWithoutVal, (Object[])scoredWithVal);
    }

    @Test
    public void testModelScoreKeeperEqualityOnProstateMultinomial() {
        PrepData prostatePrep = new PrepData(){

            @Override
            int prep(Frame fr) {
                fr.remove("ID").remove();
                return fr.find("RACE");
            }
        };
        Object[] scoredWithoutVal = this.basicGBM((String)"./smalldata/logreg/prostate.csv", (PrepData)prostatePrep, (boolean)false, (DistributionFamily)DistributionFamily.multinomial)._scored_train;
        Object[] scoredWithVal = this.basicGBM((String)"./smalldata/logreg/prostate.csv", (PrepData)prostatePrep, (boolean)true, (DistributionFamily)DistributionFamily.multinomial)._scored_valid;
        Assert.assertArrayEquals((String)"GBM has to report same list of MSEs for run without/with validation dataset (which is equal to training data)", (Object[])scoredWithoutVal, (Object[])scoredWithVal);
    }

    @Test
    public void testModelScoreKeeperEqualityOnTitanicGaussian() {
        PrepData titanicPrep = new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.find("age");
            }
        };
        Object[] scoredWithoutVal = this.basicGBM((String)"./smalldata/junit/titanic_alt.csv", (PrepData)titanicPrep, (boolean)false, (DistributionFamily)DistributionFamily.gaussian)._scored_train;
        Object[] scoredWithVal = this.basicGBM((String)"./smalldata/junit/titanic_alt.csv", (PrepData)titanicPrep, (boolean)true, (DistributionFamily)DistributionFamily.gaussian)._scored_valid;
        Assert.assertArrayEquals((String)"GBM has to report same list of MSEs for run without/with validation dataset (which is equal to training data)", (Object[])scoredWithoutVal, (Object[])scoredWithVal);
    }

    @Test
    public void testModelScoreKeeperEqualityOnTitanicBernoulli() {
        PrepData titanicPrep = new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.find("survived");
            }
        };
        Object[] scoredWithoutVal = this.basicGBM((String)"./smalldata/junit/titanic_alt.csv", (PrepData)titanicPrep, (boolean)false, (DistributionFamily)DistributionFamily.bernoulli)._scored_train;
        Object[] scoredWithVal = this.basicGBM((String)"./smalldata/junit/titanic_alt.csv", (PrepData)titanicPrep, (boolean)true, (DistributionFamily)DistributionFamily.bernoulli)._scored_valid;
        Assert.assertArrayEquals((String)"GBM has to report same list of MSEs for run without/with validation dataset (which is equal to training data)", (Object[])scoredWithoutVal, (Object[])scoredWithVal);
    }

    @Test
    public void testModelScoreKeeperEqualityOnTitanicQuasibinomial() {
        PrepData titanicPrep = new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.find("survived");
            }
        };
        Object[] scoredWithoutVal = this.basicGBM((String)"./smalldata/junit/titanic_alt.csv", (PrepData)titanicPrep, (boolean)false, (DistributionFamily)DistributionFamily.quasibinomial)._scored_train;
        Object[] scoredWithVal = this.basicGBM((String)"./smalldata/junit/titanic_alt.csv", (PrepData)titanicPrep, (boolean)true, (DistributionFamily)DistributionFamily.quasibinomial)._scored_valid;
        Assert.assertArrayEquals((String)"GBM has to report same list of MSEs for run without/with validation dataset (which is equal to training data)", (Object[])scoredWithoutVal, (Object[])scoredWithVal);
    }

    @Test
    public void testModelScoreKeeperEqualityOnTitanicMultinomial() {
        PrepData titanicPrep = new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.find("survived");
            }
        };
        Object[] scoredWithoutVal = this.basicGBM((String)"./smalldata/junit/titanic_alt.csv", (PrepData)titanicPrep, (boolean)false, (DistributionFamily)DistributionFamily.multinomial)._scored_train;
        Object[] scoredWithVal = this.basicGBM((String)"./smalldata/junit/titanic_alt.csv", (PrepData)titanicPrep, (boolean)true, (DistributionFamily)DistributionFamily.multinomial)._scored_valid;
        Assert.assertArrayEquals((String)"GBM has to report same list of MSEs for run without/with validation dataset (which is equal to training data)", (Object[])scoredWithoutVal, (Object[])scoredWithVal);
    }

    @Test
    public void testBigCat() {
        PrepData prep = new PrepData(){

            @Override
            int prep(Frame fr) {
                return fr.find("y");
            }
        };
        this.basicGBM("./smalldata/gbm_test/50_cattest_test.csv", prep, false, DistributionFamily.bernoulli);
        this.basicGBM("./smalldata/gbm_test/50_cattest_train.csv", prep, false, DistributionFamily.bernoulli);
        this.basicGBM("./smalldata/gbm_test/swpreds_1000x3.csv", prep, false, DistributionFamily.bernoulli);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testKDDTrees() {
        Frame tfr = null;
        Frame vfr = null;
        String[] cols = new String[]{"DOB", "LASTGIFT", "TARGET_D"};
        try {
            Frame inF1 = GBMTest.parse_test_file((String)"bigdata/laptop/usecases/cup98LRN_z.csv");
            Frame inF2 = GBMTest.parse_test_file((String)"bigdata/laptop/usecases/cup98VAL_z.csv");
            tfr = inF1.subframe(cols);
            vfr = inF2.subframe(cols);
            inF1.remove(cols).remove();
            inF2.remove(cols).remove();
            tfr.replace(0, tfr.vec("DOB").toCategoricalVec());
            vfr.replace(0, vfr.vec("DOB").toCategoricalVec());
            DKV.put((Keyed)tfr);
            DKV.put((Keyed)vfr);
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = tfr._key;
            parms._valid = vfr._key;
            parms._response_column = "TARGET_D";
            parms._ntrees = 3;
            parms._distribution = DistributionFamily.gaussian;
            GBM job1 = new GBM(parms);
            GBMModel gbm1 = (GBMModel)job1.trainModel().get();
            Object[] firstScored = ((GBMModel.GBMOutput)gbm1._output)._scored_valid;
            for (int i = 0; i < 10; ++i) {
                int j;
                GBM job2 = new GBM(parms);
                GBMModel gbm2 = (GBMModel)job2.trainModel().get();
                Object[] secondScored = ((GBMModel.GBMOutput)gbm2._output)._scored_valid;
                for (j = 0; j < firstScored.length && firstScored[j] == secondScored[j]; ++j) {
                }
                if (j < firstScored.length) {
                    int t;
                    System.out.println("=== =============== ===");
                    System.out.println("=== ORIGINAL  MODEL ===");
                    for (t = 0; t < parms._ntrees; ++t) {
                        System.out.println(((GBMModel.GBMOutput)gbm1._output).toStringTree(t, 0));
                    }
                    System.out.println("=== DIFFERENT MODEL ===");
                    for (t = 0; t < parms._ntrees; ++t) {
                        System.out.println(((GBMModel.GBMOutput)gbm2._output).toStringTree(t, 0));
                    }
                    System.out.println("=== =============== ===");
                    Assert.assertArrayEquals((String)"GBM should have the exact same MSEs for identical parameters", (Object[])firstScored, (Object[])secondScored);
                }
                gbm2.delete();
            }
            gbm1.delete();
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (vfr != null) {
                vfr.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testMNIST() {
        Frame tfr = null;
        Frame vfr = null;
        Scope.enter();
        try {
            tfr = GBMTest.parse_test_file((String)"bigdata/laptop/mnist/train.csv.gz");
            Scope.track((Vec)tfr.replace(784, tfr.vecs()[784].toCategoricalVec()));
            DKV.put((Keyed)tfr);
            vfr = GBMTest.parse_test_file((String)"bigdata/laptop/mnist/test.csv.gz");
            Scope.track((Vec)vfr.replace(784, vfr.vecs()[784].toCategoricalVec()));
            DKV.put((Keyed)vfr);
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = tfr._key;
            parms._valid = vfr._key;
            parms._response_column = "C785";
            parms._ntrees = 2;
            parms._max_depth = 4;
            parms._distribution = DistributionFamily.multinomial;
            GBMModel gbm = (GBMModel)new GBM(parms).trainModel().get();
            Frame pred = gbm.score(vfr);
            double sq_err = ((MathUtils.SquareError)new MathUtils.SquareError().doAll((Vec[])new Vec[]{vfr.lastVec(), pred.vecs()[0]}))._sum;
            double mse = sq_err / (double)pred.numRows();
            Assert.assertEquals((double)3.0199, (double)mse, (double)1.0E-15);
            gbm.delete();
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (vfr != null) {
                vfr.remove();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReprodubility() {
        Frame tfr = null;
        int N = 5;
        double[] mses = new double[5];
        Scope.enter();
        try {
            tfr = GBMTest.parse_test_file((String)"smalldata/covtype/covtype.20k.data");
            Key dest = Key.make((String)"df.rebalanced.hex");
            RebalanceDataSet rb = new RebalanceDataSet(tfr, dest, 256);
            H2O.submitTask((H2O.H2OCountedCompleter)rb);
            rb.join();
            tfr.delete();
            tfr = (Frame)DKV.get((Key)dest).get();
            for (int i = 0; i < 5; ++i) {
                GBMModel.GBMParameters parms = this.makeGBMParameters();
                parms._train = tfr._key;
                parms._response_column = "C55";
                parms._nbins = 1000;
                parms._ntrees = 5;
                parms._max_depth = 8;
                parms._learn_rate = 0.1f;
                parms._min_rows = 10.0;
                parms._distribution = DistributionFamily.gaussian;
                GBMModel gbm = (GBMModel)new GBM(parms).trainModel().get();
                Assert.assertEquals((long)((GBMModel.GBMOutput)gbm._output)._ntrees, (long)parms._ntrees);
                mses[i] = ((GBMModel.GBMOutput)gbm._output)._scored_train[((GBMModel.GBMOutput)gbm._output)._scored_train.length - 1]._mse;
                gbm.delete();
            }
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
        }
        Scope.exit((Key[])new Key[0]);
        for (double mse : mses) {
            System.out.println(mse);
        }
        for (double mse : mses) {
            Assert.assertEquals((double)mse, (double)mses[0], (double)1.0E-15);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReprodubilityAirline() {
        Frame tfr = null;
        int N = 5;
        double[] mses = new double[5];
        Scope.enter();
        try {
            tfr = GBMTest.parse_test_file((String)"./smalldata/airlines/allyears2k_headers.zip");
            Key dest = Key.make((String)"df.rebalanced.hex");
            RebalanceDataSet rb = new RebalanceDataSet(tfr, dest, 256);
            H2O.submitTask((H2O.H2OCountedCompleter)rb);
            rb.join();
            tfr.delete();
            tfr = (Frame)DKV.get((Key)dest).get();
            for (String s : new String[]{"DepTime", "ArrTime", "ActualElapsedTime", "AirTime", "ArrDelay", "DepDelay", "Cancelled", "CancellationCode", "CarrierDelay", "WeatherDelay", "NASDelay", "SecurityDelay", "LateAircraftDelay", "IsArrDelayed"}) {
                tfr.remove(s).remove();
            }
            DKV.put((Keyed)tfr);
            for (int i = 0; i < 5; ++i) {
                GBMModel.GBMParameters parms = this.makeGBMParameters();
                parms._train = tfr._key;
                parms._response_column = "IsDepDelayed";
                parms._nbins = 10;
                parms._nbins_cats = 500;
                parms._ntrees = 7;
                parms._max_depth = 5;
                parms._min_rows = 10.0;
                parms._distribution = DistributionFamily.bernoulli;
                parms._balance_classes = true;
                parms._seed = 0L;
                GBMModel gbm = (GBMModel)new GBM(parms).trainModel().get();
                Assert.assertEquals((long)((GBMModel.GBMOutput)gbm._output)._ntrees, (long)parms._ntrees);
                mses[i] = ((GBMModel.GBMOutput)gbm._output)._scored_train[((GBMModel.GBMOutput)gbm._output)._scored_train.length - 1]._mse;
                gbm.delete();
            }
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
        }
        Scope.exit((Key[])new Key[0]);
        System.out.println("MSEs start");
        for (double d : mses) {
            System.out.println(d);
        }
        System.out.println("MSEs End");
        System.out.flush();
        for (double mse : mses) {
            Assert.assertEquals((double)0.21694215729861027, (double)mse, (double)1.0E-8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReprodubilityAirlineSingleNode() {
        Frame tfr = null;
        int N = 10;
        double[] mses = new double[10];
        Scope.enter();
        try {
            tfr = GBMTest.parse_test_file((String)"./smalldata/airlines/allyears2k_headers.zip");
            Key dest = Key.make((String)"df.rebalanced.hex");
            RebalanceDataSet rb = new RebalanceDataSet(tfr, dest, 256);
            H2O.submitTask((H2O.H2OCountedCompleter)rb);
            rb.join();
            tfr.delete();
            tfr = (Frame)DKV.get((Key)dest).get();
            for (String s : new String[]{"DepTime", "ArrTime", "ActualElapsedTime", "AirTime", "ArrDelay", "DepDelay", "Cancelled", "CancellationCode", "CarrierDelay", "WeatherDelay", "NASDelay", "SecurityDelay", "LateAircraftDelay", "IsArrDelayed"}) {
                tfr.remove(s).remove();
            }
            DKV.put((Keyed)tfr);
            for (int i = 0; i < 10; ++i) {
                GBMModel.GBMParameters parms = this.makeGBMParameters();
                parms._train = tfr._key;
                parms._response_column = "IsDepDelayed";
                parms._nbins = 10;
                parms._nbins_cats = 500;
                parms._ntrees = 7;
                parms._max_depth = 5;
                parms._min_rows = 10.0;
                parms._distribution = DistributionFamily.bernoulli;
                parms._balance_classes = true;
                parms._seed = 0L;
                parms._build_tree_one_node = true;
                GBMModel gbm = (GBMModel)new GBM(parms).trainModel().get();
                Assert.assertEquals((long)((GBMModel.GBMOutput)gbm._output)._ntrees, (long)parms._ntrees);
                mses[i] = ((GBMModel.GBMOutput)gbm._output)._scored_train[((GBMModel.GBMOutput)gbm._output)._scored_train.length - 1]._mse;
                gbm.delete();
            }
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
        }
        Scope.exit((Key[])new Key[0]);
        System.out.println("MSE");
        for (double d : mses) {
            System.out.println(d);
        }
        for (double mse : mses) {
            Assert.assertEquals((double)0.21694215729861027, (double)mse, (double)1.0E-8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCategorical() {
        Frame tfr = null;
        boolean N = true;
        double[] mses = new double[1];
        Scope.enter();
        try {
            tfr = GBMTest.parse_test_file((String)"smalldata/gbm_test/alphabet_cattest.csv");
            Scope.track((Vec)tfr.replace(1, tfr.vecs()[1].toCategoricalVec()));
            DKV.put((Keyed)tfr);
            for (int i = 0; i < 1; ++i) {
                GBMModel.GBMParameters parms = this.makeGBMParameters();
                parms._train = tfr._key;
                parms._response_column = "y";
                parms._ntrees = 1;
                parms._max_depth = 1;
                parms._learn_rate = 1.0;
                parms._distribution = DistributionFamily.bernoulli;
                GBMModel gbm = (GBMModel)new GBM(parms).trainModel().get();
                Assert.assertEquals((long)((GBMModel.GBMOutput)gbm._output)._ntrees, (long)parms._ntrees);
                ModelMetricsBinomial mm = ModelMetricsBinomial.getFromDKV((Model)gbm, (Frame)parms.train());
                double auc = mm._auc._auc;
                Assert.assertTrue((1.0 == auc ? 1 : 0) != 0);
                mses[i] = ((GBMModel.GBMOutput)gbm._output)._scored_train[((GBMModel.GBMOutput)gbm._output)._scored_train.length - 1]._mse;
                gbm.delete();
            }
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
        }
        Scope.exit((Key[])new Key[0]);
        for (double mse : mses) {
            Assert.assertEquals((double)0.0142093, (double)mse, (double)1.0E-6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testCUST_A() {
        Frame tfr = null;
        Frame vfr = null;
        Frame t_pred = null;
        Frame v_pred = null;
        GBMModel gbm = null;
        Scope.enter();
        try {
            tfr = GBMTest.parse_test_file((String)"./bigdata/covktr.csv");
            vfr = GBMTest.parse_test_file((String)"./bigdata/covkts.csv");
            int idx = tfr.find("V55");
            Scope.track((Vec)tfr.replace(idx, tfr.vecs()[idx].toCategoricalVec()));
            Scope.track((Vec)vfr.replace(idx, vfr.vecs()[idx].toCategoricalVec()));
            DKV.put((Keyed)tfr);
            DKV.put((Keyed)vfr);
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = tfr._key;
            parms._valid = vfr._key;
            parms._response_column = "V55";
            parms._ntrees = 10;
            parms._max_depth = 1;
            parms._nbins = 20;
            parms._min_rows = 10.0;
            parms._learn_rate = 0.01f;
            parms._distribution = DistributionFamily.multinomial;
            gbm = (GBMModel)new GBM(parms).trainModel().get();
            ModelMetricsBinomial tmm = ModelMetricsBinomial.getFromDKV((Model)gbm, (Frame)tfr);
            ModelMetricsBinomial vmm = ModelMetricsBinomial.getFromDKV((Model)gbm, (Frame)vfr);
            double t_auc = tmm._auc._auc;
            double v_auc = vmm._auc._auc;
            System.out.println("train_AUC= " + t_auc + " , validation_AUC= " + v_auc);
            t_pred = gbm.score(tfr);
            v_pred = gbm.score(vfr);
            ModelMetricsBinomial tmm2 = ModelMetricsBinomial.getFromDKV((Model)gbm, (Frame)tfr);
            ModelMetricsBinomial vmm2 = ModelMetricsBinomial.getFromDKV((Model)gbm, (Frame)vfr);
            assert (tmm != tmm2);
            assert (vmm != vmm2);
            double t_auc2 = tmm._auc._auc;
            double v_auc2 = vmm._auc._auc;
            System.out.println("train_AUC2= " + t_auc2 + " , validation_AUC2= " + v_auc2);
            t_pred.remove();
            v_pred.remove();
            double t_auc3 = AUC2.perfectAUC((Vec)t_pred.vecs()[2], (Vec)tfr.vec("V55"));
            double v_auc3 = AUC2.perfectAUC((Vec)v_pred.vecs()[2], (Vec)vfr.vec("V55"));
            System.out.println("train_AUC3= " + t_auc3 + " , validation_AUC3= " + v_auc3);
            Assert.assertEquals((double)t_auc3, (double)t_auc, (double)1.0E-6);
            Assert.assertEquals((double)t_auc3, (double)t_auc2, (double)1.0E-6);
            Assert.assertEquals((double)v_auc3, (double)v_auc, (double)1.0E-6);
            Assert.assertEquals((double)v_auc3, (double)v_auc2, (double)1.0E-6);
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (vfr != null) {
                vfr.remove();
            }
            if (t_pred != null) {
                t_pred.remove();
            }
            if (v_pred != null) {
                v_pred.remove();
            }
            if (gbm != null) {
                gbm.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoRowWeights() {
        Frame tfr = null;
        Object vfr = null;
        GBMModel gbm = null;
        Scope.enter();
        try {
            tfr = GBMTest.parse_test_file((String)"smalldata/junit/no_weights.csv");
            DKV.put((Keyed)tfr);
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = tfr._key;
            parms._response_column = "response";
            parms._seed = 912559L;
            parms._min_rows = 1.0;
            parms._ntrees = 3;
            parms._learn_rate = 0.001f;
            gbm = (GBMModel)new GBM(parms).trainModel().get();
            ModelMetricsBinomial mm = (ModelMetricsBinomial)((GBMModel.GBMOutput)gbm._output)._training_metrics;
            Assert.assertEquals((double)_AUC, (double)mm.auc_obj()._auc, (double)1.0E-8);
            Assert.assertEquals((double)_MSE, (double)mm.mse(), (double)1.0E-8);
            Assert.assertEquals((double)_LogLoss, (double)mm.logloss(), (double)1.0E-6);
            Frame pred = gbm.score(parms.train());
            ModelMetricsBinomial mm2 = ModelMetricsBinomial.getFromDKV((Model)gbm, (Frame)parms.train());
            Assert.assertEquals((double)_AUC, (double)mm2.auc_obj()._auc, (double)1.0E-8);
            Assert.assertEquals((double)_MSE, (double)mm2.mse(), (double)1.0E-8);
            Assert.assertEquals((double)_LogLoss, (double)mm2.logloss(), (double)1.0E-6);
            pred.remove();
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (vfr != null) {
                vfr.remove();
            }
            if (gbm != null) {
                gbm.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowWeightsOne() {
        Frame tfr = null;
        Object vfr = null;
        Scope.enter();
        GBMModel gbm = null;
        try {
            tfr = GBMTest.parse_test_file((String)"smalldata/junit/weights_all_ones.csv");
            DKV.put((Keyed)tfr);
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = tfr._key;
            parms._response_column = "response";
            parms._weights_column = "weight";
            parms._seed = 912559L;
            parms._min_rows = 1.0;
            parms._max_depth = 2;
            parms._ntrees = 3;
            parms._learn_rate = 0.001f;
            gbm = (GBMModel)new GBM(parms).trainModel().get();
            ModelMetricsBinomial mm = (ModelMetricsBinomial)((GBMModel.GBMOutput)gbm._output)._training_metrics;
            Assert.assertEquals((double)_AUC, (double)mm.auc_obj()._auc, (double)1.0E-8);
            Assert.assertEquals((double)_MSE, (double)mm.mse(), (double)1.0E-8);
            Assert.assertEquals((double)_LogLoss, (double)mm.logloss(), (double)1.0E-6);
            Frame pred = gbm.score(parms.train());
            ModelMetricsBinomial mm2 = ModelMetricsBinomial.getFromDKV((Model)gbm, (Frame)parms.train());
            Assert.assertEquals((double)_AUC, (double)mm2.auc_obj()._auc, (double)1.0E-8);
            Assert.assertEquals((double)_MSE, (double)mm2.mse(), (double)1.0E-8);
            Assert.assertEquals((double)_LogLoss, (double)mm2.logloss(), (double)1.0E-6);
            pred.remove();
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (vfr != null) {
                vfr.remove();
            }
            if (gbm != null) {
                gbm.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowWeightsTwo() {
        Frame tfr = null;
        Object vfr = null;
        Scope.enter();
        GBMModel gbm = null;
        try {
            tfr = GBMTest.parse_test_file((String)"smalldata/junit/weights_all_twos.csv");
            DKV.put((Keyed)tfr);
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = tfr._key;
            parms._response_column = "response";
            parms._weights_column = "weight";
            parms._seed = 912559L;
            parms._min_rows = 2.0;
            parms._max_depth = 2;
            parms._ntrees = 3;
            parms._learn_rate = 0.001f;
            gbm = (GBMModel)new GBM(parms).trainModel().get();
            ModelMetricsBinomial mm = (ModelMetricsBinomial)((GBMModel.GBMOutput)gbm._output)._training_metrics;
            Assert.assertEquals((double)_AUC, (double)mm.auc_obj()._auc, (double)1.0E-8);
            Assert.assertEquals((double)_MSE, (double)mm.mse(), (double)1.0E-8);
            Assert.assertEquals((double)_LogLoss, (double)mm.logloss(), (double)1.0E-6);
            Frame pred = gbm.score(parms.train());
            ModelMetricsBinomial mm2 = ModelMetricsBinomial.getFromDKV((Model)gbm, (Frame)parms.train());
            Assert.assertEquals((double)_AUC, (double)mm2.auc_obj()._auc, (double)1.0E-8);
            Assert.assertEquals((double)_MSE, (double)mm2.mse(), (double)1.0E-8);
            Assert.assertEquals((double)_LogLoss, (double)mm2.logloss(), (double)1.0E-6);
            pred.remove();
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (vfr != null) {
                vfr.remove();
            }
            if (gbm != null) {
                gbm.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowWeightsTiny() {
        Frame tfr = null;
        Object vfr = null;
        Scope.enter();
        GBMModel gbm = null;
        try {
            tfr = GBMTest.parse_test_file((String)"smalldata/junit/weights_all_tiny.csv");
            DKV.put((Keyed)tfr);
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = tfr._key;
            parms._response_column = "response";
            parms._weights_column = "weight";
            parms._seed = 912559L;
            parms._min_rows = 0.01242;
            parms._max_depth = 2;
            parms._ntrees = 3;
            parms._learn_rate = 0.001f;
            gbm = (GBMModel)new GBM(parms).trainModel().get();
            ModelMetricsBinomial mm = (ModelMetricsBinomial)((GBMModel.GBMOutput)gbm._output)._training_metrics;
            Assert.assertEquals((double)_AUC, (double)mm.auc_obj()._auc, (double)1.0E-8);
            Assert.assertEquals((double)_MSE, (double)mm.mse(), (double)1.0E-8);
            Assert.assertEquals((double)_LogLoss, (double)mm.logloss(), (double)1.0E-6);
            Frame pred = gbm.score(parms.train());
            ModelMetricsBinomial mm2 = ModelMetricsBinomial.getFromDKV((Model)gbm, (Frame)parms.train());
            Assert.assertEquals((double)_AUC, (double)mm2.auc_obj()._auc, (double)1.0E-8);
            Assert.assertEquals((double)_MSE, (double)mm2.mse(), (double)1.0E-8);
            Assert.assertEquals((double)_LogLoss, (double)mm2.logloss(), (double)1.0E-6);
            pred.remove();
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (vfr != null) {
                vfr.remove();
            }
            if (gbm != null) {
                gbm.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoRowWeightsShuffled() {
        Frame tfr = null;
        Object vfr = null;
        GBMModel gbm = null;
        Scope.enter();
        try {
            tfr = GBMTest.parse_test_file((String)"smalldata/junit/no_weights_shuffled.csv");
            DKV.put((Keyed)tfr);
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = tfr._key;
            parms._response_column = "response";
            parms._seed = 912559L;
            parms._min_rows = 1.0;
            parms._max_depth = 2;
            parms._ntrees = 3;
            parms._learn_rate = 0.001f;
            gbm = (GBMModel)new GBM(parms).trainModel().get();
            ModelMetricsBinomial mm = (ModelMetricsBinomial)((GBMModel.GBMOutput)gbm._output)._training_metrics;
            Assert.assertEquals((double)_AUC, (double)mm.auc_obj()._auc, (double)1.0E-8);
            Assert.assertEquals((double)_MSE, (double)mm.mse(), (double)1.0E-8);
            Assert.assertEquals((double)_LogLoss, (double)mm.logloss(), (double)1.0E-6);
            Frame pred = gbm.score(parms.train());
            ModelMetricsBinomial mm2 = ModelMetricsBinomial.getFromDKV((Model)gbm, (Frame)parms.train());
            Assert.assertEquals((double)_AUC, (double)mm2.auc_obj()._auc, (double)1.0E-8);
            Assert.assertEquals((double)_MSE, (double)mm2.mse(), (double)1.0E-8);
            Assert.assertEquals((double)_LogLoss, (double)mm2.logloss(), (double)1.0E-6);
            pred.remove();
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (vfr != null) {
                vfr.remove();
            }
            if (gbm != null) {
                gbm.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowWeights() {
        Frame tfr = null;
        Object vfr = null;
        GBMModel gbm = null;
        Scope.enter();
        try {
            tfr = GBMTest.parse_test_file((String)"smalldata/junit/weights.csv");
            DKV.put((Keyed)tfr);
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = tfr._key;
            parms._response_column = "response";
            parms._weights_column = "weight";
            parms._seed = 912559L;
            parms._min_rows = 1.0;
            parms._max_depth = 2;
            parms._ntrees = 3;
            parms._learn_rate = 0.001f;
            gbm = (GBMModel)new GBM(parms).trainModel().get();
            ModelMetricsBinomial mm = (ModelMetricsBinomial)((GBMModel.GBMOutput)gbm._output)._training_metrics;
            Assert.assertEquals((double)_AUC, (double)mm.auc_obj()._auc, (double)1.0E-8);
            Assert.assertEquals((double)_MSE, (double)mm.mse(), (double)1.0E-8);
            Assert.assertEquals((double)_LogLoss, (double)mm.logloss(), (double)1.0E-6);
            Frame pred = gbm.score(parms.train());
            ModelMetricsBinomial mm2 = ModelMetricsBinomial.getFromDKV((Model)gbm, (Frame)parms.train());
            Assert.assertEquals((double)_AUC, (double)mm2.auc_obj()._auc, (double)1.0E-8);
            Assert.assertEquals((double)_MSE, (double)mm2.mse(), (double)1.0E-8);
            Assert.assertEquals((double)_LogLoss, (double)mm2.logloss(), (double)1.0E-6);
            pred.remove();
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (vfr != null) {
                vfr.remove();
            }
            if (gbm != null) {
                gbm.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNFold() {
        Frame tfr = null;
        Object vfr = null;
        GBMModel gbm = null;
        Scope.enter();
        try {
            tfr = GBMTest.parse_test_file((String)"smalldata/junit/weights.csv");
            DKV.put((Keyed)tfr);
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = tfr._key;
            parms._response_column = "response";
            parms._weights_column = "weight";
            parms._seed = 123L;
            parms._min_rows = 1.0;
            parms._max_depth = 2;
            parms._nfolds = 2;
            parms._ntrees = 3;
            parms._learn_rate = 0.001f;
            parms._keep_cross_validation_predictions = true;
            gbm = (GBMModel)new GBM(parms).trainModel().get();
            ModelMetricsBinomial mm = (ModelMetricsBinomial)((GBMModel.GBMOutput)gbm._output)._cross_validation_metrics;
            Assert.assertEquals((double)0.6296296296296297, (double)mm.auc_obj()._auc, (double)1.0E-8);
            Assert.assertEquals((double)0.28640022521234304, (double)mm.mse(), (double)1.0E-8);
            Assert.assertEquals((double)0.7674117059335286, (double)mm.logloss(), (double)1.0E-6);
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (vfr != null) {
                vfr.remove();
            }
            if (gbm != null) {
                gbm.deleteCrossValidationModels();
                gbm.delete();
                for (Key k : ((GBMModel.GBMOutput)gbm._output)._cross_validation_predictions) {
                    k.remove();
                }
                ((GBMModel.GBMOutput)gbm._output)._cross_validation_holdout_predictions_frame_id.remove();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNfoldsOneVsRest() {
        Frame tfr = null;
        GBMModel gbm1 = null;
        GBMModel gbm2 = null;
        Scope.enter();
        try {
            tfr = GBMTest.parse_test_file((String)"smalldata/junit/weights.csv");
            DKV.put((Keyed)tfr);
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = tfr._key;
            parms._response_column = "response";
            parms._min_rows = 1.0;
            parms._max_depth = 2;
            parms._nfolds = (int)tfr.numRows();
            parms._fold_assignment = Model.Parameters.FoldAssignmentScheme.Modulo;
            parms._ntrees = 3;
            parms._seed = 12345L;
            parms._learn_rate = 0.001f;
            gbm1 = (GBMModel)new GBM(parms).trainModel().get();
            gbm2 = (GBMModel)new GBM(parms).trainModel().get();
            ModelMetricsBinomial mm1 = (ModelMetricsBinomial)((GBMModel.GBMOutput)gbm1._output)._cross_validation_metrics;
            ModelMetricsBinomial mm2 = (ModelMetricsBinomial)((GBMModel.GBMOutput)gbm2._output)._cross_validation_metrics;
            Assert.assertEquals((double)mm1.auc_obj()._auc, (double)mm2.auc_obj()._auc, (double)1.0E-12);
            Assert.assertEquals((double)mm1.mse(), (double)mm2.mse(), (double)1.0E-12);
            Assert.assertEquals((double)mm1.logloss(), (double)mm2.logloss(), (double)1.0E-12);
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (gbm1 != null) {
                gbm1.deleteCrossValidationModels();
                gbm1.delete();
            }
            if (gbm2 != null) {
                gbm2.deleteCrossValidationModels();
                gbm2.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNfoldsInvalidValues() {
        Frame tfr = null;
        GBMModel gbm1 = null;
        GBMModel gbm2 = null;
        GBMModel gbm3 = null;
        Scope.enter();
        try {
            tfr = GBMTest.parse_test_file((String)"smalldata/junit/weights.csv");
            DKV.put((Keyed)tfr);
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = tfr._key;
            parms._response_column = "response";
            parms._min_rows = 1.0;
            parms._seed = 12345L;
            parms._max_depth = 2;
            parms._ntrees = 3;
            parms._learn_rate = 0.001f;
            parms._nfolds = 0;
            gbm1 = (GBMModel)new GBM(parms).trainModel().get();
            parms._nfolds = 1;
            try {
                Log.info((Object[])new Object[]{"Trying nfolds==1."});
                gbm2 = (GBMModel)new GBM(parms).trainModel().get();
                Assert.fail((String)"Should toss H2OModelBuilderIllegalArgumentException instead of reaching here");
            }
            catch (H2OModelBuilderIllegalArgumentException h2OModelBuilderIllegalArgumentException) {
                // empty catch block
            }
            parms._nfolds = -99;
            try {
                Log.info((Object[])new Object[]{"Trying nfolds==-99."});
                gbm3 = (GBMModel)new GBM(parms).trainModel().get();
                Assert.fail((String)"Should toss H2OModelBuilderIllegalArgumentException instead of reaching here");
            }
            catch (H2OModelBuilderIllegalArgumentException h2OModelBuilderIllegalArgumentException) {
                // empty catch block
            }
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (gbm1 != null) {
                gbm1.delete();
            }
            if (gbm2 != null) {
                gbm2.delete();
            }
            if (gbm3 != null) {
                gbm3.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNfoldsCVAndValidation() {
        Frame tfr = null;
        Frame vfr = null;
        GBMModel gbm = null;
        Scope.enter();
        try {
            tfr = GBMTest.parse_test_file((String)"smalldata/junit/weights.csv");
            vfr = GBMTest.parse_test_file((String)"smalldata/junit/weights.csv");
            DKV.put((Keyed)tfr);
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = tfr._key;
            parms._valid = vfr._key;
            parms._response_column = "response";
            parms._seed = 12345L;
            parms._min_rows = 1.0;
            parms._max_depth = 2;
            parms._nfolds = 3;
            parms._ntrees = 3;
            parms._learn_rate = 0.001f;
            try {
                Log.info((Object[])new Object[]{"Trying N-fold cross-validation AND Validation dataset provided."});
                gbm = (GBMModel)new GBM(parms).trainModel().get();
            }
            catch (H2OModelBuilderIllegalArgumentException e) {
                Assert.fail((String)"Should not toss H2OModelBuilderIllegalArgumentException.");
            }
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (vfr != null) {
                vfr.remove();
            }
            if (gbm != null) {
                gbm.deleteCrossValidationModels();
                gbm.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNfoldsConsecutiveModelsSame() {
        Frame tfr = null;
        Vec old = null;
        GBMModel gbm1 = null;
        GBMModel gbm2 = null;
        Scope.enter();
        try {
            tfr = GBMTest.parse_test_file((String)"smalldata/junit/cars_20mpg.csv");
            tfr.remove("name").remove();
            tfr.remove("economy").remove();
            old = tfr.remove("economy_20mpg");
            tfr.add("economy_20mpg", old.toCategoricalVec());
            DKV.put((Keyed)tfr);
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = tfr._key;
            parms._response_column = "economy_20mpg";
            parms._min_rows = 1.0;
            parms._seed = 12345L;
            parms._max_depth = 2;
            parms._nfolds = 3;
            parms._ntrees = 3;
            parms._learn_rate = 0.001f;
            gbm1 = (GBMModel)new GBM(parms).trainModel().get();
            gbm2 = (GBMModel)new GBM(parms).trainModel().get();
            ModelMetricsBinomial mm1 = (ModelMetricsBinomial)((GBMModel.GBMOutput)gbm1._output)._cross_validation_metrics;
            ModelMetricsBinomial mm2 = (ModelMetricsBinomial)((GBMModel.GBMOutput)gbm2._output)._cross_validation_metrics;
            Assert.assertEquals((double)mm1.auc_obj()._auc, (double)mm2.auc_obj()._auc, (double)1.0E-12);
            Assert.assertEquals((double)mm1.mse(), (double)mm2.mse(), (double)1.0E-12);
            Assert.assertEquals((double)mm1.logloss(), (double)mm2.logloss(), (double)1.0E-12);
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (old != null) {
                old.remove();
            }
            if (gbm1 != null) {
                gbm1.deleteCrossValidationModels();
                gbm1.delete();
            }
            if (gbm2 != null) {
                gbm2.deleteCrossValidationModels();
                gbm2.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNfoldsColumn() {
        Frame tfr = null;
        GBMModel gbm1 = null;
        try {
            tfr = GBMTest.parse_test_file((String)"smalldata/junit/cars_20mpg.csv");
            tfr.remove("name").remove();
            DKV.put((Keyed)tfr);
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = tfr._key;
            parms._response_column = "economy_20mpg";
            parms._fold_column = "cylinders";
            Vec old = tfr.remove("cylinders");
            tfr.add("cylinders", old.toCategoricalVec());
            DKV.put((Keyed)tfr);
            parms._ntrees = 10;
            parms._keep_cross_validation_fold_assignment = true;
            parms._keep_cross_validation_models = true;
            GBM job1 = new GBM(parms);
            gbm1 = (GBMModel)job1.trainModel().get();
            Assert.assertTrue((((GBMModel.GBMOutput)gbm1._output)._cross_validation_models.length == 5 ? 1 : 0) != 0);
            old.remove();
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (gbm1 != null) {
                gbm1.deleteCrossValidationModels();
                gbm1.delete();
                ((GBMModel.GBMOutput)gbm1._output)._cross_validation_fold_assignment_frame_id.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNfoldsColumnNumbersFrom0() {
        Frame tfr = null;
        Object old = null;
        GBMModel gbm1 = null;
        try {
            tfr = GBMTest.parse_test_file((String)"smalldata/junit/cars_20mpg.csv");
            tfr.remove("name").remove();
            new MRTask(){

                public void map(Chunk c) {
                    for (int i = 0; i < c.len(); ++i) {
                        if (c.at8(i) == 3L) {
                            c.set(i, 0L);
                        }
                        if (c.at8(i) == 4L) {
                            c.set(i, 1L);
                        }
                        if (c.at8(i) == 5L) {
                            c.set(i, 2L);
                        }
                        if (c.at8(i) == 6L) {
                            c.set(i, 3L);
                        }
                        if (c.at8(i) != 8L) continue;
                        c.set(i, 4L);
                    }
                }
            }.doAll(new Vec[]{tfr.vec("cylinders")});
            DKV.put((Keyed)tfr);
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = tfr._key;
            parms._response_column = "economy_20mpg";
            parms._fold_column = "cylinders";
            parms._ntrees = 10;
            parms._keep_cross_validation_models = true;
            GBM job1 = new GBM(parms);
            gbm1 = (GBMModel)job1.trainModel().get();
            Assert.assertTrue((((GBMModel.GBMOutput)gbm1._output)._cross_validation_models.length == 5 ? 1 : 0) != 0);
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (old != null) {
                old.remove();
            }
            if (gbm1 != null) {
                gbm1.deleteCrossValidationModels();
                gbm1.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNfoldsColumnCategorical() {
        Frame tfr = null;
        Vec old = null;
        GBMModel gbm1 = null;
        try {
            tfr = GBMTest.parse_test_file((String)"smalldata/junit/cars_20mpg.csv");
            tfr.remove("name").remove();
            old = tfr.remove("cylinders");
            tfr.add("folds", old.toCategoricalVec());
            old.remove();
            DKV.put((Keyed)tfr);
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = tfr._key;
            parms._response_column = "economy_20mpg";
            parms._fold_column = "folds";
            parms._ntrees = 10;
            parms._keep_cross_validation_models = true;
            GBM job1 = new GBM(parms);
            gbm1 = (GBMModel)job1.trainModel().get();
            Assert.assertTrue((((GBMModel.GBMOutput)gbm1._output)._cross_validation_models.length == 5 ? 1 : 0) != 0);
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (old != null) {
                old.remove();
            }
            if (gbm1 != null) {
                gbm1.deleteCrossValidationModels();
                gbm1.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNFoldAirline() {
        Frame tfr = null;
        Object vfr = null;
        GBMModel gbm = null;
        Scope.enter();
        try {
            tfr = GBMTest.parse_test_file((String)"./smalldata/airlines/allyears2k_headers.zip");
            for (String s : new String[]{"DepTime", "ArrTime", "ActualElapsedTime", "AirTime", "ArrDelay", "DepDelay", "Cancelled", "CancellationCode", "CarrierDelay", "WeatherDelay", "NASDelay", "SecurityDelay", "LateAircraftDelay", "IsArrDelayed"}) {
                tfr.remove(s).remove();
            }
            DKV.put((Keyed)tfr);
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = tfr._key;
            parms._response_column = "IsDepDelayed";
            parms._seed = 234L;
            parms._min_rows = 2.0;
            parms._nfolds = 3;
            parms._max_depth = 5;
            parms._ntrees = 5;
            gbm = (GBMModel)new GBM(parms).trainModel().get();
            ModelMetricsBinomial mm = (ModelMetricsBinomial)((GBMModel.GBMOutput)gbm._output)._cross_validation_metrics;
            Assert.assertEquals((double)0.7309795467719639, (double)mm.auc_obj()._auc, (double)1.0E-4);
            Assert.assertEquals((double)0.22511756378273942, (double)mm.mse(), (double)1.0E-4);
            Assert.assertEquals((double)0.6425515048581261, (double)mm.logloss(), (double)1.0E-4);
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (vfr != null) {
                vfr.remove();
            }
            if (gbm != null) {
                gbm.deleteCrossValidationModels();
                gbm.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDistributions() throws Exception {
        Frame tfr = null;
        Frame vfr = null;
        Frame res = null;
        GBMModel gbm = null;
        for (DistributionFamily dist : new DistributionFamily[]{DistributionFamily.AUTO, DistributionFamily.gaussian, DistributionFamily.poisson, DistributionFamily.gamma, DistributionFamily.tweedie}) {
            Scope.enter();
            try {
                tfr = GBMTest.parse_test_file((String)"smalldata/glm_test/cancar_logIn.csv");
                vfr = GBMTest.parse_test_file((String)"smalldata/glm_test/cancar_logIn.csv");
                for (String s : new String[]{"Merit", "Class"}) {
                    Scope.track((Vec)tfr.replace(tfr.find(s), tfr.vec(s).toCategoricalVec()));
                    Scope.track((Vec)vfr.replace(vfr.find(s), vfr.vec(s).toCategoricalVec()));
                }
                DKV.put((Keyed)tfr);
                DKV.put((Keyed)vfr);
                GBMModel.GBMParameters parms = this.makeGBMParameters();
                parms._train = tfr._key;
                parms._response_column = "Cost";
                parms._seed = 912559L;
                parms._distribution = dist;
                parms._min_rows = 1.0;
                parms._ntrees = 30;
                parms._offset_column = "logInsured";
                parms._learn_rate = 0.001f;
                gbm = (GBMModel)new GBM(parms).trainModel().get();
                Assert.assertEquals((Object)"logInsured", (Object)gbm.toMojo().getOffsetName());
                res = gbm.score(vfr);
                Assert.assertTrue((boolean)gbm.testJavaScoring(vfr, res, 1.0E-15));
                res.remove();
                ModelMetricsRegression modelMetricsRegression = (ModelMetricsRegression)((GBMModel.GBMOutput)gbm._output)._training_metrics;
            }
            finally {
                if (tfr != null) {
                    tfr.remove();
                }
                if (vfr != null) {
                    vfr.remove();
                }
                if (res != null) {
                    res.remove();
                }
                if (gbm != null) {
                    gbm.delete();
                }
                Scope.exit((Key[])new Key[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStochasticGBM() {
        Frame tfr = null;
        Object vfr = null;
        GBMModel gbm = null;
        float[] sample_rates = new float[]{0.2f, 0.4f, 0.6f, 0.8f, 1.0f};
        float[] col_sample_rates = new float[]{0.2f, 0.4f, 0.6f, 0.8f, 1.0f};
        TreeMap<Double, Pair> hm = new TreeMap<Double, Pair>();
        for (float sample_rate : sample_rates) {
            for (float col_sample_rate : col_sample_rates) {
                Scope.enter();
                try {
                    tfr = GBMTest.parse_test_file((String)"./smalldata/gbm_test/ecology_model.csv");
                    DKV.put((Keyed)tfr);
                    GBMModel.GBMParameters parms = this.makeGBMParameters();
                    parms._train = tfr._key;
                    parms._response_column = "Angaus";
                    parms._seed = 123L;
                    parms._min_rows = 2.0;
                    parms._max_depth = 10;
                    parms._ntrees = 2;
                    parms._col_sample_rate = col_sample_rate;
                    parms._sample_rate = sample_rate;
                    gbm = (GBMModel)new GBM(parms).trainModel().get();
                    ModelMetricsRegression mm = (ModelMetricsRegression)((GBMModel.GBMOutput)gbm._output)._training_metrics;
                    hm.put(mm.mse(), new Pair((Object)Float.valueOf(sample_rate), (Object)Float.valueOf(col_sample_rate)));
                }
                finally {
                    if (tfr != null) {
                        tfr.remove();
                    }
                    if (vfr != null) {
                        vfr.remove();
                    }
                    if (gbm != null) {
                        gbm.delete();
                    }
                    Scope.exit((Key[])new Key[0]);
                }
            }
        }
        double fullDataMSE = (Double)hm.entrySet().iterator().next().getKey();
        int i = 0;
        Pair last = null;
        for (Map.Entry n : hm.entrySet()) {
            if (i > 0) {
                Assert.assertTrue(((Double)n.getKey() > fullDataMSE ? 1 : 0) != 0);
            }
            Log.info((Object[])new Object[]{"MSE: " + n.getKey() + ", , row sample: " + ((Pair)n.getValue())._1() + ", col sample: " + ((Pair)n.getValue())._2()});
            last = (Pair)n.getValue();
            ++i;
        }
        Assert.assertTrue((((Float)last._1()).floatValue() == sample_rates[0] ? 1 : 0) != 0);
        Assert.assertTrue((((Float)last._2()).floatValue() == col_sample_rates[0] ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStochasticGBMHoldout() {
        Frame tfr = null;
        Key[] ksplits = new Key[]{};
        try {
            tfr = GBMTest.parse_test_file((String)"./smalldata/gbm_test/ecology_model.csv");
            SplitFrame sf = new SplitFrame(tfr, new double[]{0.5, 0.5}, new Key[]{Key.make((String)"train.hex"), Key.make((String)"test.hex")});
            sf.exec().get();
            ksplits = sf._destination_frames;
            GBMModel gbm = null;
            float[] sample_rates = new float[]{0.2f, 0.4f, 0.8f, 1.0f};
            float[] col_sample_rates = new float[]{0.4f, 0.8f, 1.0f};
            float[] col_sample_rates_per_tree = new float[]{0.4f, 0.6f, 1.0f};
            TreeMap<Double, Triple> hm = new TreeMap<Double, Triple>();
            for (float sample_rate : sample_rates) {
                for (float col_sample_rate : col_sample_rates) {
                    for (float col_sample_rate_per_tree : col_sample_rates_per_tree) {
                        Scope.enter();
                        try {
                            GBMModel.GBMParameters parms = this.makeGBMParameters();
                            parms._train = ksplits[0];
                            parms._valid = ksplits[1];
                            parms._response_column = "Angaus";
                            parms._seed = 42L;
                            parms._min_rows = 2.0;
                            parms._max_depth = 12;
                            parms._ntrees = 6;
                            parms._col_sample_rate = col_sample_rate;
                            parms._col_sample_rate_per_tree = col_sample_rate_per_tree;
                            parms._sample_rate = sample_rate;
                            gbm = (GBMModel)new GBM(parms).trainModel().get();
                            ModelMetricsRegression mm = (ModelMetricsRegression)((GBMModel.GBMOutput)gbm._output)._validation_metrics;
                            hm.put(mm.mse(), new Triple((Object)Float.valueOf(sample_rate), (Object)Float.valueOf(col_sample_rate), (Object)Float.valueOf(col_sample_rate_per_tree)));
                        }
                        finally {
                            if (gbm != null) {
                                gbm.delete();
                            }
                            Scope.exit((Key[])new Key[0]);
                        }
                    }
                }
            }
            Triple last = null;
            for (Map.Entry n : hm.entrySet()) {
                Log.info((Object[])new Object[]{"MSE: " + n.getKey() + ", row sample: " + ((Triple)n.getValue()).v1 + ", col sample: " + ((Triple)n.getValue()).v2 + ", col sample per tree: " + ((Triple)n.getValue()).v3});
                last = (Triple)n.getValue();
            }
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            for (Key k : ksplits) {
                if (k == null) continue;
                k.remove();
            }
        }
    }

    @Test
    public void testChunks() {
        int i;
        int[] chunks = new int[]{1, 2, 2, 39, 39, 500};
        int N = chunks.length;
        double[] mses = new double[N];
        for (i = 0; i < N; ++i) {
            Scope.enter();
            Frame tfr = GBMTest.parse_test_file((String)"smalldata/covtype/covtype.20k.data");
            Key dest = Key.make((String)"df.rebalanced.hex");
            RebalanceDataSet rb = new RebalanceDataSet(tfr, dest, chunks[i]);
            H2O.submitTask((H2O.H2OCountedCompleter)rb);
            rb.join();
            tfr.delete();
            tfr = (Frame)DKV.get((Key)dest).get();
            Assert.assertEquals((long)tfr.vec(0).nChunks(), (long)chunks[i]);
            DKV.put((Keyed)tfr);
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = tfr._key;
            parms._response_column = "C55";
            parms._seed = 1234L;
            parms._auto_rebalance = false;
            parms._col_sample_rate_per_tree = 0.5;
            parms._col_sample_rate = 0.3f;
            parms._ntrees = 5;
            parms._max_depth = 5;
            GBM job = new GBM(parms);
            GBMModel drf = (GBMModel)job.trainModel().get();
            Assert.assertEquals((long)((GBMModel.GBMOutput)drf._output)._ntrees, (long)parms._ntrees);
            mses[i] = ((GBMModel.GBMOutput)drf._output)._scored_train[((GBMModel.GBMOutput)drf._output)._scored_train.length - 1]._mse;
            drf.delete();
            if (tfr != null) {
                tfr.remove();
            }
            Scope.exit((Key[])new Key[0]);
        }
        for (i = 0; i < mses.length; ++i) {
            Log.info((Object[])new Object[]{"trial: " + i + " -> MSE: " + mses[i]});
        }
        for (double mse : mses) {
            Assert.assertEquals((double)mse, (double)mses[0], (double)1.0E-10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLaplace2() {
        GBMModel gbm = null;
        GBMModel.GBMParameters parms = this.makeGBMParameters();
        Frame pred = null;
        Frame res = null;
        Scope.enter();
        try {
            Frame train = GBMTest.parse_test_file((String)"smalldata/gbm_test/ecology_model.csv");
            train.remove("Site").remove();
            train.remove("Method").remove();
            DKV.put((Keyed)train);
            parms._train = train._key;
            parms._response_column = "DSDist";
            parms._distribution = DistributionFamily.laplace;
            parms._sample_rate = 0.6f;
            parms._col_sample_rate = 0.8f;
            parms._col_sample_rate_per_tree = 0.8f;
            parms._seed = 1234L;
            GBM job = new GBM(parms);
            gbm = (GBMModel)job.trainModel().get();
            pred = GBMTest.parse_test_file((String)"smalldata/gbm_test/ecology_eval.csv");
            res = gbm.score(pred);
            Assert.assertTrue((boolean)gbm.testJavaScoring(pred, res, 1.0E-15));
            Assert.assertTrue((Math.abs(((ModelMetricsRegression)((GBMModel.GBMOutput)gbm._output)._training_metrics)._mean_residual_deviance - 23.05805) < 1.0E-4 ? 1 : 0) != 0);
        }
        finally {
            parms._train.remove();
            if (gbm != null) {
                gbm.delete();
            }
            if (pred != null) {
                pred.remove();
            }
            if (res != null) {
                res.remove();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQuantileRegression() {
        GBMModel gbm = null;
        GBMModel.GBMParameters parms = this.makeGBMParameters();
        Frame pred = null;
        Frame res = null;
        Scope.enter();
        try {
            Frame train = GBMTest.parse_test_file((String)"smalldata/gbm_test/ecology_model.csv");
            train.remove("Site").remove();
            train.remove("Method").remove();
            DKV.put((Keyed)train);
            parms._train = train._key;
            parms._response_column = "DSDist";
            parms._distribution = DistributionFamily.quantile;
            parms._quantile_alpha = 0.4;
            parms._sample_rate = 0.6f;
            parms._col_sample_rate = 0.8f;
            parms._col_sample_rate_per_tree = 0.8f;
            parms._seed = 1234L;
            GBM job = new GBM(parms);
            gbm = (GBMModel)job.trainModel().get();
            pred = GBMTest.parse_test_file((String)"smalldata/gbm_test/ecology_eval.csv");
            res = gbm.score(pred);
            Assert.assertTrue((boolean)gbm.testJavaScoring(pred, res, 1.0E-15));
            Assert.assertEquals((double)10.69611, (double)((ModelMetricsRegression)((GBMModel.GBMOutput)gbm._output)._training_metrics)._mean_residual_deviance, (double)0.1);
        }
        finally {
            parms._train.remove();
            if (gbm != null) {
                gbm.delete();
            }
            if (pred != null) {
                pred.remove();
            }
            if (res != null) {
                res.remove();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void missingAndUnseenValues() {
        GBMModel gbm = null;
        GBMModel.GBMParameters parms = this.makeGBMParameters();
        Frame train = null;
        Frame test = null;
        Frame train_preds = null;
        Frame test_preds = null;
        Scope.enter();
        try {
            CreateFrame cf = new CreateFrame();
            cf.rows = 100L;
            cf.cols = 10;
            cf.integer_range = 1000L;
            cf.categorical_fraction = 1.0;
            cf.integer_fraction = 0.0;
            cf.binary_fraction = 0.0;
            cf.time_fraction = 0.0;
            cf.string_fraction = 0.0;
            cf.binary_ones_fraction = 0.0;
            cf.missing_fraction = 0.2;
            cf.factors = 3;
            cf.response_factors = 2;
            cf.positive_response = false;
            cf.has_response = true;
            cf.seed = 1235L;
            cf.seed_for_column_types = 1234L;
            train = (Frame)cf.execImpl().get();
            cf = new CreateFrame();
            cf.rows = 100L;
            cf.cols = 10;
            cf.integer_range = 1000L;
            cf.categorical_fraction = 1.0;
            cf.integer_fraction = 0.0;
            cf.binary_fraction = 0.0;
            cf.time_fraction = 0.0;
            cf.string_fraction = 0.0;
            cf.binary_ones_fraction = 0.0;
            cf.missing_fraction = 0.2;
            cf.factors = 3;
            cf.response_factors = 2;
            cf.positive_response = false;
            cf.has_response = true;
            cf.seed = 4321L;
            cf.seed_for_column_types = 1234L;
            test = (Frame)cf.execImpl().get();
            parms._train = train._key;
            parms._response_column = "response";
            parms._distribution = DistributionFamily.multinomial;
            parms._max_depth = 20;
            parms._min_rows = 1.0;
            parms._ntrees = 5;
            parms._seed = 1L;
            GBM job = new GBM(parms);
            gbm = (GBMModel)job.trainModel().get();
            train_preds = gbm.score(train);
            test_preds = gbm.score(test);
            Assert.assertTrue((boolean)gbm.testJavaScoring(train, train_preds, 1.0E-15));
            Key old = gbm._key;
            gbm._key = Key.make((String)(gbm._key + "ha"));
            Assert.assertTrue((boolean)gbm.testJavaScoring(test, test_preds, 1.0E-15));
            DKV.remove((Key)old);
        }
        finally {
            if (gbm != null) {
                gbm.delete();
            }
            if (train != null) {
                train.remove();
            }
            if (test != null) {
                test.remove();
            }
            if (train_preds != null) {
                train_preds.remove();
            }
            if (test_preds != null) {
                test_preds.remove();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void minSplitImprovement() {
        Frame tfr = null;
        Key[] ksplits = null;
        GBMModel gbm = null;
        try {
            int i;
            Scope.enter();
            tfr = GBMTest.parse_test_file((String)"smalldata/covtype/covtype.20k.data");
            int resp = 54;
            Scope.track((Vec)tfr.replace(resp, tfr.vecs()[resp].toCategoricalVec()));
            DKV.put((Keyed)tfr);
            SplitFrame sf = new SplitFrame(tfr, new double[]{0.5, 0.5}, new Key[]{Key.make((String)"train.hex"), Key.make((String)"valid.hex")});
            sf.exec().get();
            ksplits = sf._destination_frames;
            double[] msi = new double[]{0.0, 0.1};
            int N = msi.length;
            double[] loglosses = new double[N];
            for (i = 0; i < N; ++i) {
                GBMModel.GBMParameters parms = this.makeGBMParameters();
                parms._train = ksplits[0];
                parms._valid = ksplits[1];
                parms._response_column = tfr.names()[resp];
                parms._learn_rate = 0.05f;
                parms._min_split_improvement = msi[i];
                parms._score_tree_interval = parms._ntrees = 10;
                parms._max_depth = 5;
                GBM job = new GBM(parms);
                gbm = (GBMModel)job.trainModel().get();
                loglosses[i] = ((GBMModel.GBMOutput)gbm._output)._scored_valid[((GBMModel.GBMOutput)gbm._output)._scored_valid.length - 1]._logloss;
                if (gbm == null) continue;
                gbm.delete();
            }
            for (i = 0; i < msi.length; ++i) {
                Log.info((Object[])new Object[]{"min_split_improvement: " + msi[i] + " -> validation logloss: " + loglosses[i]});
            }
            int idx = ArrayUtils.minIndex((double[])loglosses);
            Log.info((Object[])new Object[]{"Optimal min_split_improvement: " + msi[idx]});
            Assert.assertTrue((0 == idx ? 1 : 0) != 0);
        }
        finally {
            if (gbm != null) {
                gbm.delete();
            }
            if (tfr != null) {
                tfr.delete();
            }
            if (ksplits[0] != null) {
                ksplits[0].remove();
            }
            if (ksplits[1] != null) {
                ksplits[1].remove();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void histoTypes() {
        Frame tfr = null;
        Key[] ksplits = null;
        GBMModel gbm = null;
        try {
            int i;
            Scope.enter();
            tfr = GBMTest.parse_test_file((String)"smalldata/covtype/covtype.20k.data");
            int resp = 54;
            Scope.track((Vec)tfr.replace(resp, tfr.vecs()[resp].toCategoricalVec()));
            DKV.put((Keyed)tfr);
            SplitFrame sf = new SplitFrame(tfr, new double[]{0.5, 0.5}, new Key[]{Key.make((String)"train.hex"), Key.make((String)"valid.hex")});
            sf.exec().get();
            ksplits = sf._destination_frames;
            SharedTreeModel.SharedTreeParameters.HistogramType[] histoType = SharedTreeModel.SharedTreeParameters.HistogramType.values();
            int N = histoType.length;
            double[] loglosses = new double[N];
            for (i = 0; i < N; ++i) {
                GBMModel.GBMParameters parms = this.makeGBMParameters();
                parms._train = ksplits[0];
                parms._valid = ksplits[1];
                parms._response_column = tfr.names()[resp];
                parms._learn_rate = 0.05f;
                parms._histogram_type = histoType[i];
                parms._score_tree_interval = parms._ntrees = 10;
                parms._max_depth = 5;
                parms._seed = -557121554L;
                GBM job = new GBM(parms);
                gbm = (GBMModel)job.trainModel().get();
                loglosses[i] = ((GBMModel.GBMOutput)gbm._output)._scored_valid[((GBMModel.GBMOutput)gbm._output)._scored_valid.length - 1]._logloss;
                if (gbm == null) continue;
                gbm.delete();
            }
            for (i = 0; i < histoType.length; ++i) {
                Log.info((Object[])new Object[]{"histoType: " + histoType[i] + " -> validation logloss: " + loglosses[i]});
            }
            int idx = ArrayUtils.minIndex((double[])loglosses);
            Log.info((Object[])new Object[]{"Optimal randomization: " + histoType[idx]});
            Assert.assertTrue((4 == idx ? 1 : 0) != 0);
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (ksplits[0] != null) {
                ksplits[0].remove();
            }
            if (ksplits[1] != null) {
                ksplits[1].remove();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void sampleRatePerClass() {
        Frame tfr = null;
        Key[] ksplits = null;
        GBMModel gbm = null;
        try {
            Scope.enter();
            tfr = GBMTest.parse_test_file((String)"smalldata/covtype/covtype.20k.data");
            int resp = 54;
            Scope.track((Vec)tfr.replace(resp, tfr.vecs()[resp].toCategoricalVec()));
            DKV.put((Keyed)tfr);
            SplitFrame sf = new SplitFrame(tfr, new double[]{0.5, 0.5}, new Key[]{Key.make((String)"train.hex"), Key.make((String)"valid.hex")});
            sf.exec().get();
            ksplits = sf._destination_frames;
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = ksplits[0];
            parms._valid = ksplits[1];
            parms._response_column = tfr.names()[resp];
            parms._learn_rate = 0.05f;
            parms._min_split_improvement = 1.0E-5;
            parms._score_tree_interval = parms._ntrees = 10;
            parms._max_depth = 5;
            parms._sample_rate_per_class = new double[]{0.1f, 0.1f, 0.2f, 0.4f, 1.0, 0.3f, 0.2f};
            GBM job = new GBM(parms);
            gbm = (GBMModel)job.trainModel().get();
            if (gbm != null) {
                gbm.delete();
            }
        }
        finally {
            if (gbm != null) {
                gbm.delete();
            }
            if (tfr != null) {
                tfr.delete();
            }
            if (ksplits[0] != null) {
                ksplits[0].remove();
            }
            if (ksplits[1] != null) {
                ksplits[1].remove();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    @Test
    public void testNA() {
        String xy = ",0\n1,0\n2,0\n3,0\n4,-10\n,0";
        Key tr = Key.make((String)"train");
        Frame df = ParseDataset.parse((Key)tr, (Key[])new Key[]{FVecTest.makeByteVec((Key)Key.make((String)"xy"), (String[])new String[]{xy})});
        GBMModel.GBMParameters parms = this.makeGBMParameters();
        parms._train = tr;
        parms._response_column = "C2";
        parms._min_rows = 1.0;
        parms._learn_rate = 1.0;
        parms._ntrees = 1;
        GBM job = new GBM(parms);
        GBMModel gbm = (GBMModel)job.trainModel().get();
        Frame preds = gbm.score(df);
        Log.info((Object[])new Object[]{df});
        Log.info((Object[])new Object[]{preds});
        Assert.assertTrue((boolean)gbm.testJavaScoring(df, preds, 1.0E-15));
        Assert.assertTrue((Math.abs(preds.vec(0).at(0L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(1L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(2L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(3L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(4L) - -10.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(5L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        preds.remove();
        gbm.remove();
        df.remove();
    }

    @Test
    public void testNARight() {
        String xy = ",10\n1,0\n2,0\n3,0\n4,10\n,10";
        Key tr = Key.make((String)"train");
        Frame df = ParseDataset.parse((Key)tr, (Key[])new Key[]{FVecTest.makeByteVec((Key)Key.make((String)"xy"), (String[])new String[]{xy})});
        GBMModel.GBMParameters parms = this.makeGBMParameters();
        parms._train = tr;
        parms._response_column = "C2";
        parms._min_rows = 1.0;
        parms._learn_rate = 1.0;
        parms._ntrees = 1;
        GBM job = new GBM(parms);
        GBMModel gbm = (GBMModel)job.trainModel().get();
        Frame preds = gbm.score(df);
        Log.info((Object[])new Object[]{df});
        Log.info((Object[])new Object[]{preds});
        Assert.assertTrue((boolean)gbm.testJavaScoring(df, preds, 1.0E-15));
        Assert.assertTrue((preds.vec(0).at(0L) == 10.0 ? 1 : 0) != 0);
        Assert.assertTrue((preds.vec(0).at(1L) == 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((preds.vec(0).at(2L) == 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((preds.vec(0).at(3L) == 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((preds.vec(0).at(4L) == 10.0 ? 1 : 0) != 0);
        Assert.assertTrue((preds.vec(0).at(5L) == 10.0 ? 1 : 0) != 0);
        preds.remove();
        gbm.remove();
        df.remove();
    }

    @Test
    public void testNALeft() {
        String xy = ",0\n1,0\n2,0\n3,0\n4,10\n,0";
        Key tr = Key.make((String)"train");
        Frame df = ParseDataset.parse((Key)tr, (Key[])new Key[]{FVecTest.makeByteVec((Key)Key.make((String)"xy"), (String[])new String[]{xy})});
        GBMModel.GBMParameters parms = this.makeGBMParameters();
        parms._train = tr;
        parms._response_column = "C2";
        parms._min_rows = 1.0;
        parms._learn_rate = 1.0;
        parms._ntrees = 1;
        GBM job = new GBM(parms);
        GBMModel gbm = (GBMModel)job.trainModel().get();
        Frame preds = gbm.score(df);
        Log.info((Object[])new Object[]{df});
        Log.info((Object[])new Object[]{preds});
        Assert.assertTrue((boolean)gbm.testJavaScoring(df, preds, 1.0E-15));
        Assert.assertTrue((Math.abs(preds.vec(0).at(0L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(1L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(2L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(3L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(4L) - 10.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(5L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        preds.remove();
        gbm.remove();
        df.remove();
    }

    @Test
    public void testNAvsRest() {
        String xy = ",5\n1,0\n2,0\n3,0\n4,0\n,3";
        Key tr = Key.make((String)"train");
        Frame df = ParseDataset.parse((Key)tr, (Key[])new Key[]{FVecTest.makeByteVec((Key)Key.make((String)"xy"), (String[])new String[]{xy})});
        GBMModel.GBMParameters parms = this.makeGBMParameters();
        parms._train = tr;
        parms._response_column = "C2";
        parms._min_rows = 1.0;
        parms._learn_rate = 1.0;
        parms._ntrees = 1;
        GBM job = new GBM(parms);
        GBMModel gbm = (GBMModel)job.trainModel().get();
        Frame preds = gbm.score(df);
        Log.info((Object[])new Object[]{df});
        Log.info((Object[])new Object[]{preds});
        Assert.assertTrue((boolean)gbm.testJavaScoring(df, preds, 1.0E-15));
        Assert.assertTrue((Math.abs(preds.vec(0).at(0L) - 4.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(1L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(2L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(3L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(4L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(5L) - 4.0) < 1.0E-6 ? 1 : 0) != 0);
        preds.remove();
        gbm.remove();
        df.remove();
    }

    @Test
    public void testOnevsRest() {
        String xy = "-9,5\n1,0\n2,0\n3,0\n4,0\n-9,3";
        Key tr = Key.make((String)"train");
        Frame df = ParseDataset.parse((Key)tr, (Key[])new Key[]{FVecTest.makeByteVec((Key)Key.make((String)"xy"), (String[])new String[]{xy})});
        GBMModel.GBMParameters parms = this.makeGBMParameters();
        parms._train = tr;
        parms._response_column = "C2";
        parms._min_rows = 1.0;
        parms._learn_rate = 1.0;
        parms._ntrees = 1;
        GBM job = new GBM(parms);
        GBMModel gbm = (GBMModel)job.trainModel().get();
        Frame preds = gbm.score(df);
        Log.info((Object[])new Object[]{df});
        Log.info((Object[])new Object[]{preds});
        Assert.assertTrue((boolean)gbm.testJavaScoring(df, preds, 1.0E-15));
        Assert.assertTrue((Math.abs(preds.vec(0).at(0L) - 4.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(1L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(2L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(3L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(4L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(5L) - 4.0) < 1.0E-6 ? 1 : 0) != 0);
        preds.remove();
        gbm.remove();
        df.remove();
    }

    @Test
    public void testNACategorical() {
        String xy = ",0\nA,0\nB,0\nA,0\nD,-10\n,0";
        Key tr = Key.make((String)"train");
        Frame df = ParseDataset.parse((Key)tr, (Key[])new Key[]{FVecTest.makeByteVec((Key)Key.make((String)"xy"), (String[])new String[]{xy})});
        GBMModel.GBMParameters parms = this.makeGBMParameters();
        parms._train = tr;
        parms._response_column = "C2";
        parms._min_rows = 1.0;
        parms._learn_rate = 1.0;
        parms._ntrees = 1;
        GBM job = new GBM(parms);
        GBMModel gbm = (GBMModel)job.trainModel().get();
        Log.info((Object[])new Object[]{df.toTwoDimTable()});
        Frame preds = gbm.score(df);
        Log.info((Object[])new Object[]{preds.toTwoDimTable()});
        Assert.assertTrue((boolean)gbm.testJavaScoring(df, preds, 1.0E-15));
        Assert.assertTrue((Math.abs(preds.vec(0).at(0L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(1L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(2L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(3L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(4L) - -10.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(5L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        preds.remove();
        gbm.remove();
        df.remove();
    }

    @Test
    public void testNARightCategorical() {
        String xy = ",10\nA,0\nB,0\nA,0\n4,10\n,10";
        Key tr = Key.make((String)"train");
        Frame df = ParseDataset.parse((Key)tr, (Key[])new Key[]{FVecTest.makeByteVec((Key)Key.make((String)"xy"), (String[])new String[]{xy})});
        GBMModel.GBMParameters parms = this.makeGBMParameters();
        parms._train = tr;
        parms._response_column = "C2";
        parms._min_rows = 1.0;
        parms._learn_rate = 1.0;
        parms._ntrees = 1;
        GBM job = new GBM(parms);
        GBMModel gbm = (GBMModel)job.trainModel().get();
        Frame preds = gbm.score(df);
        Log.info((Object[])new Object[]{df});
        Log.info((Object[])new Object[]{preds});
        Assert.assertTrue((boolean)gbm.testJavaScoring(df, preds, 1.0E-15));
        Assert.assertTrue((preds.vec(0).at(0L) == 10.0 ? 1 : 0) != 0);
        Assert.assertTrue((preds.vec(0).at(1L) == 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((preds.vec(0).at(2L) == 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((preds.vec(0).at(3L) == 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((preds.vec(0).at(4L) == 10.0 ? 1 : 0) != 0);
        Assert.assertTrue((preds.vec(0).at(5L) == 10.0 ? 1 : 0) != 0);
        preds.remove();
        gbm.remove();
        df.remove();
    }

    @Test
    public void testNALeftCategorical() {
        String xy = ",0\nA,0\nB,0\nA,0\nD,10\n,0";
        Key tr = Key.make((String)"train");
        Frame df = ParseDataset.parse((Key)tr, (Key[])new Key[]{FVecTest.makeByteVec((Key)Key.make((String)"xy"), (String[])new String[]{xy})});
        GBMModel.GBMParameters parms = this.makeGBMParameters();
        parms._train = tr;
        parms._response_column = "C2";
        parms._min_rows = 1.0;
        parms._learn_rate = 1.0;
        parms._ntrees = 1;
        GBM job = new GBM(parms);
        GBMModel gbm = (GBMModel)job.trainModel().get();
        Frame preds = gbm.score(df);
        Log.info((Object[])new Object[]{df});
        Log.info((Object[])new Object[]{preds});
        Assert.assertTrue((boolean)gbm.testJavaScoring(df, preds, 1.0E-15));
        Assert.assertTrue((Math.abs(preds.vec(0).at(0L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(1L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(2L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(3L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(4L) - 10.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(5L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        preds.remove();
        gbm.remove();
        df.remove();
    }

    @Test
    public void testNAvsRestCategorical() {
        String xy = ",5\nA,0\nB,0\nA,0\nD,0\n,3";
        Key tr = Key.make((String)"train");
        Frame df = ParseDataset.parse((Key)tr, (Key[])new Key[]{FVecTest.makeByteVec((Key)Key.make((String)"xy"), (String[])new String[]{xy})});
        GBMModel.GBMParameters parms = this.makeGBMParameters();
        parms._train = tr;
        parms._response_column = "C2";
        parms._min_rows = 1.0;
        parms._learn_rate = 1.0;
        parms._ntrees = 1;
        GBM job = new GBM(parms);
        GBMModel gbm = (GBMModel)job.trainModel().get();
        Frame preds = gbm.score(df);
        Log.info((Object[])new Object[]{df});
        Log.info((Object[])new Object[]{preds});
        Assert.assertTrue((boolean)gbm.testJavaScoring(df, preds, 1.0E-15));
        Assert.assertTrue((Math.abs(preds.vec(0).at(0L) - 4.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(1L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(2L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(3L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(4L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(5L) - 4.0) < 1.0E-6 ? 1 : 0) != 0);
        preds.remove();
        gbm.remove();
        df.remove();
    }

    @Test
    public void testUnseenNACategorical() {
        String xy = "B,-5\nA,0\nB,0\nA,0\nD,0\nA,3";
        Key tr = Key.make((String)"train");
        Frame df = ParseDataset.parse((Key)tr, (Key[])new Key[]{FVecTest.makeByteVec((Key)Key.make((String)"xy"), (String[])new String[]{xy})});
        String test = ",5\n,0\nB,0\n,0\nE,0\n,3";
        Key te = Key.make((String)"test");
        Frame df2 = ParseDataset.parse((Key)te, (Key[])new Key[]{FVecTest.makeByteVec((Key)Key.make((String)"te"), (String[])new String[]{test})});
        GBMModel.GBMParameters parms = this.makeGBMParameters();
        parms._train = tr;
        parms._response_column = "C2";
        parms._min_rows = 1.0;
        parms._learn_rate = 1.0;
        parms._ntrees = 1;
        GBM job = new GBM(parms);
        GBMModel gbm = (GBMModel)job.trainModel().get();
        Scope.enter();
        Frame preds = gbm.score(df);
        Frame preds2 = gbm.score(df2);
        Log.info((Object[])new Object[]{df});
        Log.info((Object[])new Object[]{preds});
        Log.info((Object[])new Object[]{df2});
        Log.info((Object[])new Object[]{preds2});
        Assert.assertTrue((boolean)gbm.testJavaScoring(df, preds, 1.0E-15));
        Assert.assertTrue((boolean)gbm.testJavaScoring(df2, preds2, 1.0E-15));
        Assert.assertTrue((Math.abs(preds.vec(0).at(0L) - -2.5) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(1L) - 1.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(2L) - -2.5) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(3L) - 1.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(4L) - 0.0) < 1.0E-6 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(preds.vec(0).at(5L) - 1.0) < 1.0E-6 ? 1 : 0) != 0);
        preds.remove();
        preds2.remove();
        gbm.remove();
        df.remove();
        df2.remove();
        Scope.exit((Key[])new Key[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void unseenMissing() {
        GBMModel gbm = null;
        GBMModel.GBMParameters parms = this.makeGBMParameters();
        Frame train = null;
        Frame test = null;
        Frame train_preds = null;
        Frame test_preds = null;
        Scope.enter();
        try {
            CreateFrame cf = new CreateFrame();
            cf.rows = 100L;
            cf.cols = 10;
            cf.integer_range = 1000L;
            cf.categorical_fraction = 1.0;
            cf.integer_fraction = 0.0;
            cf.binary_fraction = 0.0;
            cf.time_fraction = 0.0;
            cf.string_fraction = 0.0;
            cf.binary_ones_fraction = 0.0;
            cf.missing_fraction = 0.0;
            cf.factors = 3;
            cf.response_factors = 2;
            cf.positive_response = false;
            cf.has_response = true;
            cf.seed = 1235L;
            cf.seed_for_column_types = 1234L;
            train = (Frame)cf.execImpl().get();
            cf = new CreateFrame();
            cf.rows = 100L;
            cf.cols = 10;
            cf.integer_range = 1000L;
            cf.categorical_fraction = 1.0;
            cf.integer_fraction = 0.0;
            cf.binary_fraction = 0.0;
            cf.time_fraction = 0.0;
            cf.string_fraction = 0.0;
            cf.binary_ones_fraction = 0.0;
            cf.missing_fraction = 0.8;
            cf.factors = 3;
            cf.response_factors = 2;
            cf.positive_response = false;
            cf.has_response = true;
            cf.seed = 4321L;
            cf.seed_for_column_types = 1234L;
            test = (Frame)cf.execImpl().get();
            parms._train = train._key;
            parms._response_column = "response";
            parms._distribution = DistributionFamily.multinomial;
            parms._max_depth = 20;
            parms._min_rows = 1.0;
            parms._ntrees = 5;
            parms._seed = 1L;
            GBM job = new GBM(parms);
            gbm = (GBMModel)job.trainModel().get();
            train_preds = gbm.score(train);
            test_preds = gbm.score(test);
            Assert.assertTrue((boolean)gbm.testJavaScoring(train, train_preds, 1.0E-15));
            Key old = gbm._key;
            gbm._key = Key.make((String)(gbm._key + "ha"));
            Assert.assertTrue((boolean)gbm.testJavaScoring(test, test_preds, 1.0E-15));
            DKV.remove((Key)old);
        }
        finally {
            if (gbm != null) {
                gbm.delete();
            }
            if (train != null) {
                train.remove();
            }
            if (test != null) {
                test.remove();
            }
            if (train_preds != null) {
                train_preds.remove();
            }
            if (test_preds != null) {
                test_preds.remove();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAnnealingStop() {
        Frame tfr = null;
        boolean N = true;
        Scope.enter();
        try {
            tfr = GBMTest.parse_test_file((String)"./smalldata/airlines/allyears2k_headers.zip");
            for (String s : new String[]{"DepTime", "ArrTime", "ActualElapsedTime", "AirTime", "ArrDelay", "DepDelay", "Cancelled", "CancellationCode", "CarrierDelay", "WeatherDelay", "NASDelay", "SecurityDelay", "LateAircraftDelay", "IsArrDelayed"}) {
                tfr.remove(s).remove();
            }
            DKV.put((Keyed)tfr);
            for (int i = 0; i < 1; ++i) {
                GBMModel.GBMParameters parms = this.makeGBMParameters();
                parms._train = tfr._key;
                parms._response_column = "IsDepDelayed";
                parms._nbins = 10;
                parms._nbins_cats = 500;
                parms._ntrees = 100;
                parms._learn_rate_annealing = 0.5;
                parms._max_depth = 5;
                parms._min_rows = 10.0;
                parms._distribution = DistributionFamily.bernoulli;
                parms._balance_classes = true;
                parms._seed = 0L;
                GBMModel gbm = (GBMModel)new GBM(parms).trainModel().get();
                Assert.assertNotEquals((long)((GBMModel.GBMOutput)gbm._output)._ntrees, (long)parms._ntrees);
                gbm.delete();
            }
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
        }
        Scope.exit((Key[])new Key[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    public void testModifiedHuber() {
        Frame tfr = null;
        Object vfr = null;
        GBMModel gbm = null;
        Scope.enter();
        try {
            tfr = GBMTest.parse_test_file((String)"./smalldata/airlines/allyears2k_headers.zip");
            for (String s : new String[]{"DepTime", "ArrTime", "ActualElapsedTime", "AirTime", "ArrDelay", "DepDelay", "Cancelled", "CancellationCode", "CarrierDelay", "WeatherDelay", "NASDelay", "SecurityDelay", "LateAircraftDelay", "IsArrDelayed"}) {
                tfr.remove(s).remove();
            }
            DKV.put((Keyed)tfr);
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = tfr._key;
            parms._response_column = "IsDepDelayed";
            parms._seed = 1234L;
            parms._distribution = DistributionFamily.modified_huber;
            parms._min_rows = 1.0;
            parms._learn_rate = 0.1;
            parms._max_depth = 5;
            parms._ntrees = 10;
            gbm = (GBMModel)new GBM(parms).trainModel().get();
            Frame train_preds = gbm.score(tfr);
            Assert.assertTrue((boolean)gbm.testJavaScoring(tfr, train_preds, 1.0E-15));
            train_preds.remove();
            ModelMetricsBinomial modelMetricsBinomial = (ModelMetricsBinomial)((GBMModel.GBMOutput)gbm._output)._training_metrics;
        }
        finally {
            if (tfr != null) {
                tfr.remove();
            }
            if (vfr != null) {
                vfr.remove();
            }
            if (gbm != null) {
                gbm.deleteCrossValidationModels();
                gbm.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    @Ignore
    public void testModifiedHuberStability() {
        String xy = "A,Y\nB,N\nA,N\nB,N\nA,Y\nA,Y";
        Key tr = Key.make((String)"train");
        Frame df = ParseDataset.parse((Key)tr, (Key[])new Key[]{FVecTest.makeByteVec((Key)Key.make((String)"xy"), (String[])new String[]{xy})});
        String test = "A,Y\nB,N\nA,N\nB,N\nA,Y\nA,Y";
        Key te = Key.make((String)"test");
        Frame df2 = ParseDataset.parse((Key)te, (Key[])new Key[]{FVecTest.makeByteVec((Key)Key.make((String)"te"), (String[])new String[]{test})});
        GBMModel.GBMParameters parms = this.makeGBMParameters();
        parms._train = tr;
        parms._response_column = "C2";
        parms._min_rows = 1.0;
        parms._learn_rate = 1.0;
        parms._distribution = DistributionFamily.modified_huber;
        parms._ntrees = 1;
        GBM job = new GBM(parms);
        GBMModel gbm = (GBMModel)job.trainModel().get();
        Scope.enter();
        Frame preds = gbm.score(df);
        Frame preds2 = gbm.score(df2);
        Log.info((Object[])new Object[]{df});
        Log.info((Object[])new Object[]{preds});
        Log.info((Object[])new Object[]{df2});
        Log.info((Object[])new Object[]{preds2});
        Assert.assertTrue((boolean)gbm.testJavaScoring(df, preds, 1.0E-15));
        Assert.assertTrue((boolean)gbm.testJavaScoring(df2, preds2, 1.0E-15));
        preds.remove();
        preds2.remove();
        gbm.remove();
        df.remove();
        df2.remove();
        Scope.exit((Key[])new Key[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHuber2() {
        GBMModel gbm = null;
        GBMModel.GBMParameters parms = this.makeGBMParameters();
        Frame pred = null;
        Frame res = null;
        Scope.enter();
        try {
            Frame train = GBMTest.parse_test_file((String)"smalldata/gbm_test/ecology_model.csv");
            train.remove("Site").remove();
            train.remove("Method").remove();
            DKV.put((Keyed)train);
            parms._train = train._key;
            parms._response_column = "DSDist";
            parms._distribution = DistributionFamily.huber;
            parms._huber_alpha = 0.5;
            parms._sample_rate = 0.6f;
            parms._col_sample_rate = 0.8f;
            parms._col_sample_rate_per_tree = 0.8f;
            parms._seed = 1234L;
            GBM job = new GBM(parms);
            gbm = (GBMModel)job.trainModel().get();
            pred = GBMTest.parse_test_file((String)"smalldata/gbm_test/ecology_eval.csv");
            res = gbm.score(pred);
            Assert.assertTrue((boolean)gbm.testJavaScoring(pred, res, 1.0E-15));
            Assert.assertEquals((double)1485.0, (double)((ModelMetricsRegression)((GBMModel.GBMOutput)gbm._output)._training_metrics)._MSE, (double)50.0);
            Assert.assertTrue((Math.abs(((ModelMetricsRegression)((GBMModel.GBMOutput)gbm._output)._training_metrics)._mean_residual_deviance - 256.88) < 1.0 ? 1 : 0) != 0);
        }
        finally {
            parms._train.remove();
            if (gbm != null) {
                gbm.delete();
            }
            if (pred != null) {
                pred.remove();
            }
            if (res != null) {
                res.remove();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLaplace() {
        Frame tfr = null;
        GBMModel gbm = null;
        try {
            tfr = GBMTest.parse_test_file((String)"./smalldata/gbm_test/BostonHousing.csv");
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = tfr._key;
            parms._response_column = tfr.lastVecName();
            parms._seed = 912559L;
            parms._distribution = DistributionFamily.laplace;
            gbm = (GBMModel)new GBM(parms).trainModel().get();
            Assert.assertEquals((double)8.05716257, (double)((ModelMetricsRegression)((GBMModel.GBMOutput)gbm._output)._training_metrics)._MSE, (double)1.0E-5);
            Assert.assertEquals((double)1.42298, (double)((ModelMetricsRegression)((GBMModel.GBMOutput)gbm._output)._training_metrics)._mean_residual_deviance, (double)1.0E-5);
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (gbm != null) {
                gbm.deleteCrossValidationModels();
            }
            if (gbm != null) {
                gbm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGaussian() {
        Frame tfr = null;
        GBMModel gbm = null;
        try {
            tfr = GBMTest.parse_test_file((String)"./smalldata/gbm_test/BostonHousing.csv");
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = tfr._key;
            parms._response_column = tfr.lastVecName();
            parms._seed = 912559L;
            parms._distribution = DistributionFamily.gaussian;
            gbm = (GBMModel)new GBM(parms).trainModel().get();
            if ("Default".equals(this.test_type)) {
                Assert.assertEquals((double)2.9423857564, (double)((ModelMetricsRegression)((GBMModel.GBMOutput)gbm._output)._training_metrics)._MSE, (double)1.0E-5);
                Assert.assertEquals((double)2.9423857564, (double)((ModelMetricsRegression)((GBMModel.GBMOutput)gbm._output)._training_metrics)._mean_residual_deviance, (double)1.0E-5);
            } else if ("EmulateConstraints".equals(this.test_type)) {
                Assert.assertEquals((double)2.9422145249, (double)((ModelMetricsRegression)((GBMModel.GBMOutput)gbm._output)._training_metrics)._MSE, (double)1.0E-5);
                Assert.assertEquals((double)2.9422145249, (double)((ModelMetricsRegression)((GBMModel.GBMOutput)gbm._output)._training_metrics)._mean_residual_deviance, (double)1.0E-5);
            } else {
                Assert.fail();
            }
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (gbm != null) {
                gbm.deleteCrossValidationModels();
            }
            if (gbm != null) {
                gbm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHuberDeltaLarge() {
        Frame tfr = null;
        GBMModel gbm = null;
        try {
            tfr = GBMTest.parse_test_file((String)"./smalldata/gbm_test/BostonHousing.csv");
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = tfr._key;
            parms._response_column = tfr.lastVecName();
            parms._seed = 912559L;
            parms._distribution = DistributionFamily.huber;
            parms._huber_alpha = 1.0;
            gbm = (GBMModel)new GBM(parms).trainModel().get();
            Assert.assertEquals((double)2.9423857564, (double)((ModelMetricsRegression)((GBMModel.GBMOutput)gbm._output)._training_metrics)._MSE, (double)0.01);
            Assert.assertEquals((double)2.9423857564, (double)((ModelMetricsRegression)((GBMModel.GBMOutput)gbm._output)._training_metrics)._mean_residual_deviance, (double)0.01);
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (gbm != null) {
                gbm.deleteCrossValidationModels();
            }
            if (gbm != null) {
                gbm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHuberDeltaTiny() {
        Frame tfr = null;
        GBMModel gbm = null;
        try {
            tfr = GBMTest.parse_test_file((String)"./smalldata/gbm_test/BostonHousing.csv");
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = tfr._key;
            parms._response_column = tfr.lastVecName();
            parms._seed = 912559L;
            parms._distribution = DistributionFamily.huber;
            parms._huber_alpha = 0.01;
            gbm = (GBMModel)new GBM(parms).trainModel().get();
            Assert.assertEquals((double)8.05716257, (double)((ModelMetricsRegression)((GBMModel.GBMOutput)gbm._output)._training_metrics)._MSE, (double)0.3);
            double delta = 0.0047234;
            double MAE = 1.42298;
            Assert.assertEquals((double)((2.0 * MAE - delta) * delta), (double)((ModelMetricsRegression)((GBMModel.GBMOutput)gbm._output)._training_metrics)._mean_residual_deviance, (double)0.1);
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (gbm != null) {
                gbm.deleteCrossValidationModels();
            }
            if (gbm != null) {
                gbm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHuber() {
        Frame tfr = null;
        GBMModel gbm = null;
        try {
            tfr = GBMTest.parse_test_file((String)"./smalldata/gbm_test/BostonHousing.csv");
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = tfr._key;
            parms._response_column = tfr.lastVecName();
            parms._seed = 912559L;
            parms._distribution = DistributionFamily.huber;
            parms._huber_alpha = 0.9;
            gbm = (GBMModel)new GBM(parms).trainModel().get();
            Assert.assertEquals((double)4.447062185, (double)((ModelMetricsRegression)((GBMModel.GBMOutput)gbm._output)._training_metrics)._MSE, (double)1.0E-5);
            Assert.assertEquals((double)1.962926332, (double)((ModelMetricsRegression)((GBMModel.GBMOutput)gbm._output)._training_metrics)._mean_residual_deviance, (double)1.0E-4);
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (gbm != null) {
                gbm.deleteCrossValidationModels();
            }
            if (gbm != null) {
                gbm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHuberNoise() {
        Frame tfr = null;
        GBMModel gbm = null;
        try {
            tfr = GBMTest.parse_test_file((String)"./smalldata/gbm_test/BostonHousing.csv");
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = tfr._key;
            parms._response_column = tfr.lastVecName();
            parms._seed = 912559L;
            parms._distribution = DistributionFamily.huber;
            parms._huber_alpha = 0.9;
            parms._pred_noise_bandwidth = 0.2;
            gbm = (GBMModel)new GBM(parms).trainModel().get();
            Assert.assertEquals((double)4.8056900203, (double)((ModelMetricsRegression)((GBMModel.GBMOutput)gbm._output)._training_metrics)._MSE, (double)1.0E-5);
            Assert.assertEquals((double)2.0080997, (double)((ModelMetricsRegression)((GBMModel.GBMOutput)gbm._output)._training_metrics)._mean_residual_deviance, (double)1.0E-4);
        }
        finally {
            if (tfr != null) {
                tfr.delete();
            }
            if (gbm != null) {
                gbm.deleteCrossValidationModels();
            }
            if (gbm != null) {
                gbm.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeviances() {
        for (DistributionFamily dist : DistributionFamily.values()) {
            if (dist == DistributionFamily.modified_huber || dist == DistributionFamily.quasibinomial || dist == DistributionFamily.ordinal || dist == DistributionFamily.custom) continue;
            Frame tfr = null;
            Frame res = null;
            Frame preds = null;
            GBMModel gbm = null;
            try {
                tfr = GBMTest.parse_test_file((String)"./smalldata/gbm_test/BostonHousing.csv");
                GBMModel.GBMParameters parms = this.makeGBMParameters();
                parms._train = tfr._key;
                String resp = tfr.lastVecName();
                if (dist == DistributionFamily.modified_huber || dist == DistributionFamily.bernoulli || dist == DistributionFamily.multinomial) {
                    resp = dist == DistributionFamily.multinomial ? "rad" : "chas";
                    Vec v = tfr.remove(resp);
                    tfr.add(resp, v.toCategoricalVec());
                    v.remove();
                    DKV.put((Keyed)tfr);
                }
                parms._response_column = resp;
                parms._distribution = dist;
                gbm = (GBMModel)new GBM(parms).trainModel().get();
                preds = gbm.score(tfr);
                res = gbm.computeDeviances(tfr, preds, "myDeviances");
                double meanDeviance = res.anyVec().mean();
                if (((GBMModel.GBMOutput)gbm._output).nclasses() == 2) {
                    Assert.assertEquals((double)meanDeviance, (double)((ModelMetricsBinomial)((GBMModel.GBMOutput)gbm._output)._training_metrics)._logloss, (double)(1.0E-6 * Math.abs(meanDeviance)));
                    continue;
                }
                if (((GBMModel.GBMOutput)gbm._output).nclasses() > 2) {
                    Assert.assertEquals((double)meanDeviance, (double)((ModelMetricsMultinomial)((GBMModel.GBMOutput)gbm._output)._training_metrics)._logloss, (double)(1.0E-6 * Math.abs(meanDeviance)));
                    continue;
                }
                Assert.assertEquals((double)meanDeviance, (double)((ModelMetricsRegression)((GBMModel.GBMOutput)gbm._output)._training_metrics)._mean_residual_deviance, (double)(1.0E-6 * Math.abs(meanDeviance)));
            }
            finally {
                if (tfr != null) {
                    tfr.delete();
                }
                if (res != null) {
                    res.delete();
                }
                if (preds != null) {
                    preds.delete();
                }
                if (gbm != null) {
                    gbm.delete();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCatEncoding() {
        for (Model.Parameters.CategoricalEncodingScheme c : Model.Parameters.CategoricalEncodingScheme.values()) {
            if (c != Model.Parameters.CategoricalEncodingScheme.AUTO) continue;
            Frame tfr = null;
            GBMModel gbm = null;
            Frame fr2 = null;
            try {
                tfr = GBMTest.parse_test_file((String)"./smalldata/junit/weather.csv");
                GBMModel.GBMParameters parms = this.makeGBMParameters();
                parms._train = tfr._key;
                parms._response_column = tfr.lastVecName();
                parms._ntrees = 5;
                parms._categorical_encoding = c;
                gbm = (GBMModel)new GBM(parms).trainModel().get();
                fr2 = gbm.score(tfr);
                Assert.assertTrue((boolean)gbm.testJavaScoring(tfr, fr2, 1.0E-15));
            }
            finally {
                if (tfr != null) {
                    tfr.delete();
                }
                if (fr2 != null) {
                    fr2.delete();
                }
                if (gbm != null) {
                    gbm.deleteCrossValidationModels();
                }
                if (gbm != null) {
                    gbm.delete();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCatEncodingCV() {
        for (Model.Parameters.CategoricalEncodingScheme c : Model.Parameters.CategoricalEncodingScheme.values()) {
            if (c != Model.Parameters.CategoricalEncodingScheme.AUTO) continue;
            Frame tfr = null;
            GBMModel gbm = null;
            try {
                tfr = GBMTest.parse_test_file((String)"./smalldata/junit/weather.csv");
                GBMModel.GBMParameters parms = this.makeGBMParameters();
                parms._train = tfr._key;
                parms._response_column = tfr.lastVecName();
                parms._ntrees = 5;
                parms._categorical_encoding = c;
                parms._nfolds = 3;
                gbm = (GBMModel)new GBM(parms).trainModel().get();
            }
            finally {
                if (tfr != null) {
                    tfr.delete();
                }
                if (gbm != null) {
                    gbm.deleteCrossValidationModels();
                }
                if (gbm != null) {
                    gbm.delete();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCategoricalSplits() throws FileNotFoundException {
        Frame fr = null;
        GBMModel model = null;
        Scope.enter();
        try {
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            fr = GBMTest.parse_test_file((String)"smalldata/gbm_test/ecology_model.csv");
            fr.remove("Site").remove();
            fr.remove("SegSumT").remove();
            fr.remove("SegTSeas").remove();
            fr.remove("SegLowFlow").remove();
            fr.remove("DSDist").remove();
            fr.remove("DSMaxSlope").remove();
            fr.remove("USAvgT").remove();
            fr.remove("USRainDays").remove();
            fr.remove("USSlope").remove();
            fr.remove("DSDam").remove();
            fr.remove("Method").remove();
            int ci = fr.find("Angaus");
            Scope.track((Vec)fr.replace(ci, fr.vecs()[ci].toCategoricalVec()));
            DKV.put((Keyed)fr);
            parms._train = fr._key;
            parms._response_column = "Angaus";
            parms._ntrees = 1;
            parms._min_rows = 10.0;
            parms._max_depth = 13;
            parms._distribution = DistributionFamily.multinomial;
            model = (GBMModel)new GBM(parms).trainModel().get();
        }
        finally {
            if (model != null) {
                model.delete();
            }
            if (fr != null) {
                fr.remove();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCategoricalSplits2() throws FileNotFoundException {
        Frame fr = null;
        GBMModel model = null;
        Scope.enter();
        try {
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            fr = GBMTest.parse_test_file((String)"smalldata/airlines/allyears2k_headers.zip");
            Frame fr2 = new Frame(Key.make(), new String[]{"C", "R"}, new Vec[]{fr.vec("Origin"), fr.vec("IsDepDelayed")});
            int ci = fr2.find("R");
            Scope.track((Vec)fr2.replace(ci, fr2.vecs()[ci].toCategoricalVec()));
            DKV.put((Keyed)fr2);
            parms._train = fr2._key;
            parms._response_column = "R";
            parms._ntrees = 1;
            parms._min_rows = 1000.0;
            parms._max_depth = 4;
            parms._distribution = DistributionFamily.bernoulli;
            model = (GBMModel)new GBM(parms).trainModel().get();
            DKV.remove((Key)fr2._key);
        }
        finally {
            if (model != null) {
                model.delete();
            }
            if (fr != null) {
                fr.remove();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    @Test
    public void highCardinalityLowNbinsCats() {
        this.highCardinality(2000);
    }

    @Test
    public void highCardinalityHighNbinsCats() {
        this.highCardinality(6000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void highCardinality(int nbins_cats) {
        GBMModel gbm = null;
        GBMModel.GBMParameters parms = this.makeGBMParameters();
        Frame train = null;
        Frame test = null;
        Frame train_preds = null;
        Frame test_preds = null;
        Scope.enter();
        try {
            CreateFrame cf = new CreateFrame();
            cf.rows = 10000L;
            cf.cols = 10;
            cf.integer_range = 1000L;
            cf.categorical_fraction = 1.0;
            cf.integer_fraction = 0.0;
            cf.binary_fraction = 0.0;
            cf.time_fraction = 0.0;
            cf.string_fraction = 0.0;
            cf.binary_ones_fraction = 0.0;
            cf.missing_fraction = 0.2;
            cf.factors = 3000;
            cf.response_factors = 2;
            cf.positive_response = false;
            cf.has_response = true;
            cf.seed = 1235L;
            cf.seed_for_column_types = 1234L;
            train = (Frame)cf.execImpl().get();
            cf = new CreateFrame();
            cf.rows = 10000L;
            cf.cols = 10;
            cf.integer_range = 1000L;
            cf.categorical_fraction = 1.0;
            cf.integer_fraction = 0.0;
            cf.binary_fraction = 0.0;
            cf.time_fraction = 0.0;
            cf.string_fraction = 0.0;
            cf.binary_ones_fraction = 0.0;
            cf.missing_fraction = 0.2;
            cf.factors = 5000;
            cf.response_factors = 2;
            cf.positive_response = false;
            cf.has_response = true;
            cf.seed = 5321L;
            cf.seed_for_column_types = 1234L;
            test = (Frame)cf.execImpl().get();
            parms._train = train._key;
            parms._response_column = "response";
            parms._max_depth = 20;
            parms._min_rows = 1.0;
            parms._ntrees = 1;
            parms._nbins_cats = nbins_cats;
            parms._seed = 42156596L;
            GBM job = new GBM(parms);
            gbm = (GBMModel)job.trainModel().get();
            train_preds = gbm.score(train);
            test_preds = gbm.score(test);
            new MRTask(){

                public void map(Chunk c) {
                    for (int i = 0; i < c._len; ++i) {
                        if (!c.isNA(i)) continue;
                        c.set(i, 0.5);
                    }
                }
            }.doAll(new Vec[]{train.vec("response")});
            new MRTask(){

                public void map(Chunk c) {
                    for (int i = 0; i < c._len; ++i) {
                        if (!c.isNA(i)) continue;
                        c.set(i, 0.5);
                    }
                }
            }.doAll(new Vec[]{test.vec("response")});
            Log.info((Object[])new Object[]{"Train AUC: " + ModelMetricsBinomial.make((Vec)train_preds.vec(2), (Vec)train.vec("response")).auc()});
            Log.info((Object[])new Object[]{"Test AUC: " + ModelMetricsBinomial.make((Vec)test_preds.vec(2), (Vec)test.vec("response")).auc()});
            Assert.assertTrue((boolean)gbm.testJavaScoring(train, train_preds, 1.0E-15));
            Key old = gbm._key;
            gbm._key = Key.make((String)(gbm._key + "ha"));
            Assert.assertTrue((boolean)gbm.testJavaScoring(test, test_preds, 1.0E-15));
            DKV.remove((Key)old);
        }
        finally {
            if (gbm != null) {
                gbm.delete();
            }
            if (train != null) {
                train.remove();
            }
            if (test != null) {
                test.remove();
            }
            if (train_preds != null) {
                train_preds.remove();
            }
            if (test_preds != null) {
                test_preds.remove();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void lowCardinality() throws IOException {
        for (boolean sort_cats : new boolean[]{true, false}) {
            int[] vals = new int[]{2, 10, 20, 25, 26, 27, 100};
            double[] maes = new double[vals.length];
            int i = 0;
            for (int nbins_cats : vals) {
                GBMModel model = null;
                GBMModel.GBMParameters parms = this.makeGBMParameters();
                Frame train_preds = null;
                Scope.enter();
                Frame train = GBMTest.parse_test_file((String)"smalldata/gbm_test/alphabet_cattest.csv");
                try {
                    parms._train = train._key;
                    parms._response_column = "y";
                    parms._max_depth = 2;
                    parms._min_rows = 1.0;
                    parms._ntrees = 1;
                    parms._learn_rate = 1.0;
                    parms._nbins_cats = nbins_cats;
                    if (sort_cats) {
                        parms._categorical_encoding = Model.Parameters.CategoricalEncodingScheme.SortByResponse;
                    }
                    GBM job = new GBM(parms);
                    model = (GBMModel)job.trainModel().get();
                    StreamingSchema ss = new StreamingSchema((StreamWriter)model.getMojo(), "model.zip");
                    FileOutputStream fos = new FileOutputStream("model.zip");
                    ss.getStreamWriter().writeTo((OutputStream)fos);
                    train_preds = model.score(train);
                    Assert.assertTrue((boolean)model.testJavaScoring(train, train_preds, 1.0E-15));
                    double mae = ModelMetricsRegression.make((Vec)train_preds.vec(0), (Vec)train.vec("y"), (DistributionFamily)DistributionFamily.gaussian).mae();
                    Log.info((Object[])new Object[]{"Train MAE: " + mae});
                    maes[i++] = mae;
                    if (nbins_cats >= 25 || sort_cats) {
                        Assert.assertEquals((double)0.0, (double)mae, (double)1.0E-8);
                        continue;
                    }
                    Assert.assertTrue((mae > 0.0 ? 1 : 0) != 0);
                }
                finally {
                    if (model != null) {
                        model.delete();
                    }
                    if (train != null) {
                        train.remove();
                    }
                    if (train_preds != null) {
                        train_preds.remove();
                    }
                    new File("model.zip").delete();
                    Scope.exit((Key[])new Key[0]);
                }
            }
            Log.info((Object[])new Object[]{Arrays.toString(vals)});
            Log.info((Object[])new Object[]{Arrays.toString(maes)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void RegressionCars() {
        Frame tfr = null;
        Frame trainFrame = null;
        Frame testFrame = null;
        Frame preds = null;
        GBMModel model = null;
        Scope.enter();
        try {
            tfr = GBMTest.parse_test_file((String)"./smalldata/junit/cars.csv");
            DKV.put((Keyed)tfr);
            SplitFrame sf = new SplitFrame(tfr, new double[]{0.7, 0.3}, null);
            sf.exec().get();
            Key[] ksplits = sf._destination_frames;
            trainFrame = (Frame)ksplits[0].get();
            testFrame = (Frame)ksplits[1].get();
            String response = "economy (mpg)";
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._train = trainFrame._key;
            parms._valid = testFrame._key;
            parms._response_column = response;
            parms._ignored_columns = new String[]{"name"};
            model = (GBMModel)new GBM(parms).trainModel().get();
            Log.info((Object[])new Object[]{model});
            preds = model.score(testFrame);
            Assert.assertTrue((boolean)model.testJavaScoring(testFrame, preds, 1.0E-6));
            Assert.assertEquals((double)((ModelMetricsRegression)((GBMModel.GBMOutput)model._output)._validation_metrics).mae(), (double)ModelMetricsRegression.make((Vec)preds.anyVec(), (Vec)testFrame.vec(response), (DistributionFamily)DistributionFamily.gaussian).mae(), (double)1.0E-5);
            Assert.assertTrue((preds.anyVec().sigma() > 0.0 ? 1 : 0) != 0);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
            if (trainFrame != null) {
                trainFrame.remove();
            }
            if (testFrame != null) {
                testFrame.remove();
            }
            if (tfr != null) {
                tfr.remove();
            }
            if (preds != null) {
                preds.remove();
            }
            if (model != null) {
                model.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomEarlyStoppingValidation() {
        try {
            ScoreKeeper.StoppingMetric[] customStoppingMetrics;
            Scope.enter();
            Frame training = Scope.track((Frame[])new Frame[]{GBMTest.parse_test_file((String)"./smalldata/junit/cars.csv")});
            String response = "economy (mpg)";
            for (ScoreKeeper.StoppingMetric stoppingMetric : customStoppingMetrics = new ScoreKeeper.StoppingMetric[]{ScoreKeeper.StoppingMetric.custom, ScoreKeeper.StoppingMetric.custom_increasing}) {
                GBMModel model = null;
                try {
                    GBMModel.GBMParameters parms = this.makeGBMParameters();
                    parms._train = training._key;
                    parms._response_column = response;
                    parms._ignored_columns = new String[]{"name"};
                    parms._stopping_rounds = 2;
                    parms._stopping_metric = stoppingMetric;
                    model = (GBMModel)new GBM(parms).trainModel().get();
                    Assert.fail((String)"Custom stopping  shouldn't work without a custom metric");
                }
                catch (H2OModelBuilderIllegalArgumentException e) {
                    if (e.getMessage() != null && e.getMessage().contains("ERRR on field: _stopping_metric: Custom metric function needs to be defined in order to use it for early stopping.")) continue;
                    throw e;
                }
                finally {
                    if (model != null) {
                        model.delete();
                    }
                }
            }
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQuasibinomial() {
        Scope.enter();
        GBMModel model = null;
        GBMModel model2 = null;
        GBMModel model3 = null;
        Frame fr = GBMTest.parse_test_file((String)"smalldata/glm_test/prostate_cat_replaced.csv");
        Frame preds = null;
        Frame preds2 = null;
        Frame preds3 = null;
        Vec r = fr.vec("CAPSULE").toCategoricalVec();
        fr.remove("CAPSULE").remove();
        fr.add("CAPSULE", r);
        DKV.put((Keyed)fr);
        Frame fr2 = GBMTest.parse_test_file((String)"smalldata/glm_test/prostate_cat_replaced.csv");
        Frame fr3 = GBMTest.parse_test_file((String)"smalldata/glm_test/prostate_cat_replaced.csv");
        new MRTask(){

            public void map(Chunk[] cs) {
                for (int i = 0; i < cs[0]._len; ++i) {
                    cs[1].set(i, cs[1].at8(i) == 1L ? 2L : 0L);
                }
            }
        }.doAll(fr3);
        try {
            GBMModel.GBMParameters params = new GBMModel.GBMParameters();
            params._response_column = "CAPSULE";
            params._ignored_columns = new String[]{"ID"};
            params._seed = 5L;
            params._ntrees = 500;
            params._nfolds = 3;
            params._learn_rate = 0.01;
            params._min_rows = 1.0;
            params._min_split_improvement = 0.0;
            params._stopping_rounds = 10;
            params._stopping_tolerance = 0.0;
            params._train = fr._key;
            params._distribution = DistributionFamily.bernoulli;
            GBM gbm = new GBM(params);
            model = (GBMModel)gbm.trainModel().get();
            preds = model.score(fr);
            params._distribution = DistributionFamily.quasibinomial;
            params._train = fr2._key;
            GBM gbm2 = new GBM(params);
            model2 = (GBMModel)gbm2.trainModel().get();
            preds2 = model2.score(fr2);
            params._distribution = DistributionFamily.quasibinomial;
            params._train = fr3._key;
            GBM gbm3 = new GBM(params);
            model3 = (GBMModel)gbm3.trainModel().get();
            preds3 = model3.score(fr3);
            if (preds != null) {
                Log.info((Object[])new Object[]{preds.toTwoDimTable()});
            }
            if (preds2 != null) {
                Log.info((Object[])new Object[]{preds2.toTwoDimTable()});
            }
            if (preds3 != null) {
                Log.info((Object[])new Object[]{preds3.toTwoDimTable()});
            }
            if (model != null && model2 != null) {
                Assert.assertEquals((double)((ModelMetricsBinomial)((GBMModel.GBMOutput)model._output)._training_metrics).logloss(), (double)((ModelMetricsBinomial)((GBMModel.GBMOutput)model2._output)._training_metrics).logloss(), (double)0.002);
                Assert.assertEquals((double)((ModelMetricsBinomial)((GBMModel.GBMOutput)model._output)._cross_validation_metrics).logloss(), (double)((ModelMetricsBinomial)((GBMModel.GBMOutput)model2._output)._cross_validation_metrics).logloss(), (double)0.001);
            }
            if (model2 != null) {
                Assert.assertTrue((boolean)model2.testJavaScoring(fr2, preds2, 1.0E-15));
            }
            if (model3 != null) {
                Assert.assertTrue((boolean)model3.testJavaScoring(fr3, preds3, 1.0E-15));
            }
            if (preds != null && preds2 != null) {
                preds.remove(0);
                preds2.remove(0);
                GBMTest.assertIdenticalUpToRelTolerance((Frame)preds, (Frame)preds2, (double)0.01);
            }
        }
        finally {
            if (preds != null) {
                preds.delete();
            }
            if (preds2 != null) {
                preds2.delete();
            }
            if (preds3 != null) {
                preds3.delete();
            }
            if (fr != null) {
                fr.delete();
            }
            if (fr2 != null) {
                fr2.delete();
            }
            if (fr3 != null) {
                fr3.delete();
            }
            if (model != null) {
                model.deleteCrossValidationModels();
                model.delete();
            }
            if (model2 != null) {
                model2.deleteCrossValidationModels();
                model2.delete();
            }
            if (model3 != null) {
                model3.deleteCrossValidationModels();
                model3.delete();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMonotoneConstraintsInverse() {
        Scope.enter();
        try {
            String response = "power (hp)";
            Frame f = GBMTest.parse_test_file((String)"smalldata/junit/cars.csv");
            f.replace(f.find("power (hp)"), f.vecs()[f.find("cylinders")].toNumericVec()).remove();
            DKV.put((Keyed)Scope.track((Frame[])new Frame[]{f}));
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._response_column = "power (hp)";
            parms._train = f._key;
            parms._ignored_columns = new String[]{"name"};
            parms._seed = 42L;
            GBMModel.GBMParameters noConstrParams = (GBMModel.GBMParameters)parms.clone();
            GBMModel noConstrModel = (GBMModel)new GBM(noConstrParams).trainModel().get();
            Scope.track_generic((Keyed)noConstrModel);
            Assert.assertTrue((((Float)((GBMModel.GBMOutput)noConstrModel._output)._varimp.toMap().get("cylinders")).floatValue() > 0.0f ? 1 : 0) != 0);
            GBMModel.GBMParameters constrParams = (GBMModel.GBMParameters)parms.clone();
            constrParams._monotone_constraints = new KeyValue[]{new KeyValue("cylinders", -1.0)};
            GBMModel constrModel = (GBMModel)new GBM(constrParams).trainModel().get();
            Scope.track_generic((Keyed)constrModel);
            Assert.assertEquals((float)((Float)((GBMModel.GBMOutput)constrModel._output)._varimp.toMap().get("cylinders")).floatValue(), (float)0.0f, (float)0.0f);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMonotoneConstraintsProstate() {
        try {
            Scope.enter();
            Frame f = Scope.track((Frame[])new Frame[]{GBMTest.parse_test_file((String)"smalldata/logreg/prostate.csv")});
            f.replace(f.find("CAPSULE"), f.vec("CAPSULE").toNumericVec());
            DKV.put((Keyed)f);
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._response_column = "CAPSULE";
            parms._train = f._key;
            parms._monotone_constraints = new KeyValue[]{new KeyValue("AGE", 1.0)};
            parms._ignored_columns = new String[]{"ID"};
            parms._ntrees = 50;
            parms._seed = 42L;
            String[] uniqueAges = Scope.track((Vec)f.vec("AGE").toCategoricalVec()).domain();
            GBMModel model = (GBMModel)new GBM(parms).trainModel().get();
            Scope.track_generic((Keyed)model);
            Vec lastPreds = null;
            for (String ageStr : uniqueAges) {
                final int age = Integer.parseInt(ageStr);
                new MRTask(){

                    public void map(Chunk c) {
                        for (int i = 0; i < c._len; ++i) {
                            c.set(i, (long)age);
                        }
                    }
                }.doAll(new Vec[]{f.vec("AGE")});
                Assert.assertEquals((double)age, (double)f.vec("AGE").min(), (double)0.0);
                Assert.assertEquals((double)age, (double)f.vec("AGE").max(), (double)0.0);
                Vec currentPreds = Scope.track((Frame[])new Frame[]{model.score(f)}).anyVec();
                if (lastPreds != null) {
                    int i = 0;
                    while ((long)i < lastPreds.length()) {
                        Assert.assertTrue((String)("age=" + age + ", id=" + f.vec("ID").at8((long)i)), (lastPreds.at((long)i) <= currentPreds.at((long)i) ? 1 : 0) != 0);
                        ++i;
                    }
                }
                lastPreds = currentPreds;
            }
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMonotoneConstraintsUnsupported() {
        try {
            Scope.enter();
            Frame f = Scope.track((Frame[])new Frame[]{GBMTest.parse_test_file((String)"smalldata/logreg/prostate.csv")});
            f.replace(f.find("CAPSULE"), f.vec("CAPSULE").toNumericVec());
            DKV.put((Keyed)f);
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._response_column = "CAPSULE";
            parms._train = f._key;
            parms._monotone_constraints = new KeyValue[]{new KeyValue("AGE", 1.0)};
            parms._distribution = DistributionFamily.tweedie;
            this.expectedException.expectMessage("ERRR on field: _monotone_constraints: Monotone constraints are only supported for Gaussian and Bernoulli distributions, your distribution: tweedie.");
            GBMModel model = (GBMModel)new GBM(parms).trainModel().get();
            Scope.track_generic((Keyed)model);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    @Test
    public void testMonotoneConstraintSingleSplit() {
        this.checkMonotonic(2);
    }

    @Test
    public void testMonotoneConstraintMultiSplit() {
        this.checkMonotonic(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMonotonic(int depth) {
        try {
            Scope.enter();
            int len = 10000;
            Frame train = GBMTest.makeSinFrame(len);
            GBMModel.GBMParameters parms = this.makeGBMParameters();
            parms._response_column = "y";
            parms._train = train._key;
            parms._seed = 42L;
            parms._max_depth = depth;
            parms._monotone_constraints = new KeyValue[]{new KeyValue("x", 1.0)};
            GBMModel gbm = (GBMModel)new GBM(parms).trainModel().get();
            Scope.track_generic((Keyed)gbm);
            Frame scored = Scope.track((Frame[])new Frame[]{gbm.score(train)});
            double last = -1.0;
            for (int i = 0; i < len; ++i) {
                double pred = scored.vec(0).at((long)i);
                Assert.assertTrue((String)("pred = " + pred + " > " + last), (pred >= last ? 1 : 0) != 0);
                last = pred;
            }
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    private static Frame makeSinFrame(final int len) {
        Vec blueprint = Scope.track((Vec)Vec.makeZero((long)len));
        Frame train = new MRTask(){

            public void map(Chunk c, NewChunk ncX, NewChunk ncY) {
                for (int i = 0; i < c._len; ++i) {
                    Random r = RandomUtils.getRNG((long[])new long[]{c.start() + (long)i});
                    double x = (double)(c.start() + (long)i) / (double)len * Math.PI / 2.0;
                    double noise = Math.abs(r.nextDouble()) * 0.1;
                    double y = Math.sin(x) + noise;
                    ncX.addNum(x);
                    ncY.addNum(y);
                }
            }
        }.doAll(new byte[]{3, 3}, new Vec[]{blueprint}).outputFrame(Key.make(), new String[]{"x", "y"}, (String[][])null);
        Scope.track((Frame[])new Frame[]{train});
        return train;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void demonstratePubDev6356() {
        try {
            Scope.enter();
            int N = 1000;
            double[] columnData = new double[1000];
            double[] responseData = new double[1000];
            Arrays.fill(responseData, Double.NaN);
            int cnt = 100;
            for (int i = 0; i < cnt; ++i) {
                columnData[i] = 1.0;
                responseData[i] = 1.0;
                columnData[i + cnt] = 2.0;
                responseData[i + cnt] = 2.0;
            }
            TestFrameBuilder builder_noNA = new TestFrameBuilder().withName("testFrame_noNA").withColNames(new String[]{"x", "y"}).withVecTypes(new byte[]{3, 3}).withDataForCol(0, Arrays.copyOf(columnData, cnt * 2)).withDataForCol(1, Arrays.copyOf(responseData, cnt * 2));
            Frame train_noNA = Scope.track((Frame[])new Frame[]{builder_noNA.build()});
            GBMModel.GBMParameters parms_noNA = new GBMModel.GBMParameters();
            parms_noNA._response_column = "y";
            parms_noNA._train = train_noNA._key;
            parms_noNA._seed = 42L;
            parms_noNA._max_depth = 2;
            parms_noNA._ntrees = 1;
            parms_noNA._learn_rate = 1.0;
            GBMModel gbm_noNA = (GBMModel)new GBM(parms_noNA).trainModel().get();
            Scope.track_generic((Keyed)gbm_noNA);
            Assert.assertEquals((double)1.0, (double)gbm_noNA.score(GBMTest.ard((double[])new double[]{1.0})), (double)0.0);
            Assert.assertEquals((double)2.0, (double)gbm_noNA.score(GBMTest.ard((double[])new double[]{2.0})), (double)0.0);
            Assert.assertEquals((double)1.0, (double)gbm_noNA.score(GBMTest.ard((double[])new double[]{0.0})), (double)0.0);
            TestFrameBuilder builder_NA = new TestFrameBuilder().withName("testFrame_NA").withColNames(new String[]{"x", "y"}).withVecTypes(new byte[]{3, 3}).withDataForCol(0, columnData).withDataForCol(1, responseData);
            Frame train_NA = Scope.track((Frame[])new Frame[]{builder_NA.build()});
            GBMModel.GBMParameters parms_NA = new GBMModel.GBMParameters();
            parms_NA._response_column = "y";
            parms_NA._train = train_NA._key;
            parms_NA._seed = 42L;
            parms_NA._max_depth = 2;
            parms_NA._ntrees = 1;
            parms_NA._learn_rate = 1.0;
            GBMModel gbm_NA = (GBMModel)new GBM(parms_NA).trainModel().get();
            Scope.track_generic((Keyed)gbm_NA);
            Assert.assertEquals((double)1.0, (double)gbm_NA.score(GBMTest.ard((double[])new double[]{1.0})), (double)0.0);
            Assert.assertEquals((double)2.0, (double)gbm_NA.score(GBMTest.ard((double[])new double[]{2.0})), (double)0.0);
            Assert.assertEquals((double)1.5, (double)gbm_NA.score(GBMTest.ard((double[])new double[]{0.0})), (double)0.0);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFeatureNames() throws Exception {
        GBMModel gbm = null;
        try {
            Scope.enter();
            Frame frame = new TestFrameBuilder().withName("getFeatureNamesTestFrame").withColNames(new String[]{"Fold", "ColA", "Response", "ColB", "Weight", "Offset", "ColC"}).withVecTypes(new byte[]{3, 3, 3, 2, 3, 3, 4}).withDataForCol(0, GBMTest.ard((double[])new double[]{0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0})).withDataForCol(1, GBMTest.ard((double[])new double[]{Double.NaN, 1.0, 2.0, 3.0, 4.0, 5.6, 7.0})).withDataForCol(2, GBMTest.ard((double[])new double[]{1.0, 2.0, 3.0, 4.0, 1.0, 2.0, 3.0})).withDataForCol(3, GBMTest.ar((String[])new String[]{"A", "B", "C", "E", "F", "I", "J"})).withDataForCol(4, GBMTest.ard((double[])new double[]{0.25, 0.25, 0.5, 0.5, 0.5, 0.75, 0.75})).withDataForCol(5, GBMTest.ard((double[])new double[]{0.1, 0.1, 0.1, 0.1, 0.2, 0.2, 0.2})).withDataForCol(6, GBMTest.ar((String[])new String[]{"A", "B,", "A", "C", "A", "B", "A"})).build();
            GBMModel.GBMParameters parms = new GBMModel.GBMParameters();
            parms._train = frame._key;
            parms._response_column = "Response";
            parms._fold_column = "Fold";
            parms._weights_column = "Weight";
            parms._offset_column = "Offset";
            parms._ntrees = 1;
            parms._min_rows = 0.1;
            gbm = (GBMModel)new GBM(parms).trainModel().get();
            Scope.track_generic((Keyed)gbm);
            Object[] expectedFeatures = new String[]{"ColA", "ColC"};
            Assert.assertArrayEquals((Object[])expectedFeatures, (Object[])((GBMModel.GBMOutput)gbm._output).features());
            Assert.assertArrayEquals((Object[])expectedFeatures, (Object[])gbm.modelDescriptor().features());
            MojoModel mojo = gbm.toMojo();
            Assert.assertArrayEquals((Object[])expectedFeatures, (Object[])mojo.features());
        }
        finally {
            if (gbm != null) {
                gbm.deleteCrossValidationModels();
                gbm.deleteCrossValidationPreds();
            }
            Scope.exit((Key[])new Key[0]);
        }
    }

    private abstract class PrepData {
        private PrepData() {
        }

        abstract int prep(Frame var1);
    }
}

