/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.gbm;

import hex.FrameSplitter;
import hex.ModelMetricsBinomial;
import hex.tree.gbm.GBM;
import hex.tree.gbm.GBMModel;
import java.util.Arrays;
import java.util.TreeMap;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.DKV;
import water.H2O;
import water.Iced;
import water.Key;
import water.Keyed;
import water.Scope;
import water.TestUtil;
import water.fvec.Frame;
import water.fvec.NFSFileVec;
import water.fvec.Vec;
import water.parser.ParseDataset;
import water.util.FrameUtils;
import water.util.Log;

public class GBMMissingTest
extends TestUtil {
    @BeforeClass
    public static void setup() {
        GBMMissingTest.stall_till_cloudsize((int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void run() {
        long seed = 1234L;
        GBMModel mymodel = null;
        Frame train = null;
        Frame test = null;
        Frame data = null;
        Log.info((Object[])new Object[]{""});
        Log.info((Object[])new Object[]{"STARTING."});
        Log.info((Object[])new Object[]{"Using seed " + seed});
        StringBuilder sb = new StringBuilder();
        double sumerr = 0.0;
        TreeMap<Double, Double> map = new TreeMap<Double, Double>();
        for (double missing_fraction : new double[]{0.0, 0.05, 0.1, 0.25, 0.5, 0.75, 0.9, 0.99}) {
            double err = 0.0;
            try {
                Scope.enter();
                NFSFileVec nfs = TestUtil.makeNfsFileVec((String)"smalldata/junit/weather.csv");
                data = ParseDataset.parse((Key)Key.make((String)"data.hex"), (Key[])new Key[]{nfs._key});
                Log.info((Object[])new Object[]{"FrameSplitting"});
                FrameSplitter fs = new FrameSplitter(data, new double[]{0.75}, FrameUtils.generateNumKeys((Key)data._key, (int)2), null);
                H2O.submitTask((H2O.H2OCountedCompleter)fs);
                Frame[] train_test = fs.getResult();
                train = train_test[0];
                test = train_test[1];
                Log.info((Object[])new Object[]{"Done..."});
                if (missing_fraction > 0.0) {
                    Frame frtmp = new Frame(Key.make(), train.names(), train.vecs());
                    frtmp.remove(frtmp.numCols() - 1);
                    DKV.put((Key)frtmp._key, (Iced)frtmp);
                    FrameUtils.MissingInserter j = new FrameUtils.MissingInserter(frtmp._key, seed, missing_fraction);
                    j.execImpl().get();
                    DKV.remove((Key)frtmp._key);
                }
                GBMModel.GBMParameters p = new GBMModel.GBMParameters();
                p._train = train._key;
                p._valid = test._key;
                p._response_column = train._names[train.numCols() - 1];
                p._ignored_columns = new String[]{train._names[1], train._names[22]};
                p._seed = seed;
                int ri = train.numCols() - 1;
                int ci = test.find(p._response_column);
                Scope.track((Vec)train.replace(ri, train.vecs()[ri].toCategoricalVec()));
                Scope.track((Vec)test.replace(ci, test.vecs()[ci].toCategoricalVec()));
                DKV.put((Keyed)train);
                DKV.put((Keyed)test);
                GBM gbm = new GBM(p);
                Log.info((Object[])new Object[]{"Starting with " + missing_fraction * 100.0 + "% missing values added."});
                mymodel = (GBMModel)gbm.trainModel().get();
                err = ((ModelMetricsBinomial)((GBMModel.GBMOutput)mymodel._output)._validation_metrics).logloss();
                Frame train_preds = mymodel.score(train);
                Assert.assertTrue((boolean)mymodel.testJavaScoring(train, train_preds, 1.0E-15));
                train_preds.remove();
                Log.info((Object[])new Object[]{"Missing " + missing_fraction * 100.0 + "% -> logloss: " + err});
            }
            catch (Throwable t) {
                t.printStackTrace();
                err = 100.0;
            }
            finally {
                Scope.exit((Key[])new Key[0]);
                if (mymodel != null) {
                    mymodel.delete();
                }
                if (train != null) {
                    train.delete();
                }
                if (test != null) {
                    test.delete();
                }
                if (data != null) {
                    data.delete();
                }
            }
            map.put(missing_fraction, err);
            sumerr += err;
        }
        sb.append("missing fraction --> Error\n");
        for (String s : Arrays.toString(map.entrySet().toArray()).split(",")) {
            sb.append(s.replace("=", " --> ")).append("\n");
        }
        sb.append('\n');
        sb.append("Sum Err: ").append(sumerr).append("\n");
        Log.info((Object[])new Object[]{sb.toString()});
    }
}

